/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.util;

import com.sygate.scm.util.XPathElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;

public class XPath {
    public static final String ATTRIBUTE_DELIMITER = "@";
    public static final String PATH_DELIMITER = "/";
    public static final String RECURSIVE_PATH_DELIMITER = "//";
    private List<XPathElement> unmodifiablePathList;
    private String xpathString = null;
    private boolean gotoRoot = false;

    public XPath(String xpath) {
        this.xpathString = xpath;
        if (xpath.indexOf(PATH_DELIMITER) == 0) {
            this.gotoRoot = true;
        }
        ArrayList<XPathElement> pathList = new ArrayList<XPathElement>();
        StringTokenizer tokenizer = new StringTokenizer(xpath, PATH_DELIMITER, true);
        while (tokenizer.hasMoreTokens()) {
            boolean recurse = false;
            String pathElement = tokenizer.nextToken();
            if (PATH_DELIMITER.equals(pathElement) && PATH_DELIMITER.equals(pathElement = tokenizer.nextToken())) {
                recurse = true;
                pathElement = tokenizer.nextToken();
            }
            XPathElement xpathElement = new XPathElement(pathElement, recurse);
            pathList.add(xpathElement);
        }
        this.unmodifiablePathList = Collections.unmodifiableList(pathList);
    }

    public List<XPathElement> getXPathElements() {
        return this.unmodifiablePathList;
    }

    public XPathElement getXPathElement(int index) {
        return this.unmodifiablePathList.get(index);
    }

    public int size() {
        return this.unmodifiablePathList.size();
    }

    public String toString() {
        return this.xpathString;
    }

    public boolean gotoRoot() {
        return this.gotoRoot;
    }
}

