/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.util;

import com.sygate.scm.util.LoggerUtilities;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.prefs.Preferences;

public class WinRegistry {
    public static final int HKEY_CLASS_ROOT = Integer.MIN_VALUE;
    public static final int HKEY_CURRENT_USER = -2147483647;
    public static final int HKEY_LOCAL_MACHINE = -2147483646;
    public static final int HKEY_USERS = -2147483645;
    public static final int REG_SUCCESS = 0;
    public static final int REG_NOTFOUND = 2;
    public static final int REG_ACCESSDENIED = 5;
    private static final int KEY_ALL_ACCESS = 983103;
    private static final int KEY_READ = 131097;
    private static Preferences userRoot = Preferences.userRoot();
    private static Preferences systemRoot = Preferences.systemRoot();
    private static Class<? extends Preferences> userClass = userRoot.getClass();
    private static Method regOpenKey = null;
    private static Method regCloseKey = null;
    private static Method regQueryValueEx = null;
    private static Method regEnumValue = null;
    private static Method regQueryInfoKey = null;
    private static Method regEnumKeyEx = null;
    private static Method regCreateKeyEx = null;
    private static Method regSetValueEx = null;
    private static Method regDeleteKey = null;
    private static Method regDeleteValue = null;
    private static final RegistryRoot[] regRootArray = new RegistryRoot[]{new RegistryRoot(systemRoot, -2147483645, new String[]{"HKU", "HKEY_USERS"}), new RegistryRoot(systemRoot, -2147483646, new String[]{"HKLM", "HKEY_LOCAL_MACHINE"}), new RegistryRoot(systemRoot, Integer.MIN_VALUE, new String[]{"HKCR", "HKEY_CLASSES_ROOT"}), new RegistryRoot(userRoot, -2147483647, new String[]{"HKCU", "HKEY_CURRENT_USER"})};

    private WinRegistry() {
    }

    public static boolean isKeyExist(String keyPath) {
        int slashPos = keyPath.indexOf(92);
        if (slashPos <= 0 || slashPos >= keyPath.length() - 1) {
            throw new IllegalArgumentException("Invalid registry key path is provided.");
        }
        String root = keyPath.substring(0, slashPos);
        String key = keyPath.substring(slashPos + 1);
        RegistryRoot regRoot = WinRegistry.getRegRootByName(root);
        try {
            return WinRegistry.isKeyExist(regRoot.getPref(), regRoot.getHkey(), key);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new RuntimeException("Unexpected error occurred while reading registry");
        }
    }

    public static String readString(int hkey, String key, String valueName) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        RegistryRoot regRoot = WinRegistry.getRegRootByHkey(hkey);
        return WinRegistry.readString(regRoot.getPref(), hkey, key, valueName);
    }

    public static Map<String, String> readStringValues(int hkey, String key) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        RegistryRoot regRoot = WinRegistry.getRegRootByHkey(hkey);
        return WinRegistry.readStringValues(regRoot.getPref(), hkey, key);
    }

    public static List<String> readStringSubKeys(int hkey, String key) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        RegistryRoot regRoot = WinRegistry.getRegRootByHkey(hkey);
        return WinRegistry.readStringSubKeys(regRoot.getPref(), hkey, key);
    }

    public static void createKey(int hkey, String key) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        RegistryRoot regRoot = WinRegistry.getRegRootByHkey(hkey);
        int[] ret = WinRegistry.createKey(regRoot.getPref(), hkey, key);
        regCloseKey.invoke((Object)regRoot.getPref(), ret[0]);
        if (ret[1] != 0) {
            throw new IllegalArgumentException("rc=" + ret[1] + "  key=" + key);
        }
    }

    public static void writeStringValue(int hkey, String key, String valueName, String value) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        RegistryRoot regRoot = WinRegistry.getRegRootByHkey(hkey);
        WinRegistry.writeStringValue(regRoot.getPref(), hkey, key, valueName, value);
    }

    public static void deleteKey(int hkey, String key) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        RegistryRoot regRoot = WinRegistry.getRegRootByHkey(hkey);
        int rc = WinRegistry.deleteKey(regRoot.getPref(), hkey, key);
        if (rc != 0) {
            throw new IllegalArgumentException("rc=" + rc + "  key=" + key);
        }
    }

    public static void deleteValue(int hkey, String key, String value) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        RegistryRoot regRoot = WinRegistry.getRegRootByHkey(hkey);
        int rc = WinRegistry.deleteValue(regRoot.getPref(), hkey, key, value);
        if (rc != 0) {
            throw new IllegalArgumentException("rc=" + rc + "  key=" + key + "  value=" + value);
        }
    }

    private static int deleteValue(Preferences root, int hkey, String key, String value) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        long[] handles = (long[])regOpenKey.invoke((Object)root, hkey, WinRegistry.toCstr(key), 983103);
        if (handles[1] != 0L) {
            return (int)handles[1];
        }
        int rc = (Integer)regDeleteValue.invoke((Object)root, handles[0], WinRegistry.toCstr(value));
        regCloseKey.invoke((Object)root, handles[0]);
        return rc;
    }

    private static int deleteKey(Preferences root, int hkey, String key) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        int rc = (Integer)regDeleteKey.invoke((Object)root, hkey, WinRegistry.toCstr(key));
        return rc;
    }

    private static String readString(Preferences root, int hkey, String key, String value) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        long[] handles = (long[])regOpenKey.invoke((Object)root, hkey, WinRegistry.toCstr(key), 131097);
        if (handles[1] != 0L) {
            return null;
        }
        byte[] valb = (byte[])regQueryValueEx.invoke((Object)root, handles[0], WinRegistry.toCstr(value));
        regCloseKey.invoke((Object)root, handles[0]);
        try {
            return valb != null ? new String(valb, "UTF-8").trim() : null;
        }
        catch (UnsupportedEncodingException e) {
            LoggerUtilities.logException(e);
            throw new IllegalStateException("UTF-8 not supported", e);
        }
    }

    private static Map<String, String> readStringValues(Preferences root, int hkey, String key) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        HashMap<String, String> results = new HashMap<String, String>();
        long[] handles = (long[])regOpenKey.invoke((Object)root, hkey, WinRegistry.toCstr(key), 131097);
        if (handles[1] != 0L) {
            return null;
        }
        long[] info = (long[])regQueryInfoKey.invoke((Object)root, handles[0]);
        int count = (int)info[0];
        int maxlen = (int)info[3];
        for (int index = 0; index < count; ++index) {
            byte[] name = (byte[])regEnumValue.invoke((Object)root, handles[0], index, maxlen + 1);
            try {
                String value = WinRegistry.readString(hkey, key, new String(name, "UTF-8"));
                results.put(new String(name, "UTF-8").trim(), value);
                continue;
            }
            catch (UnsupportedEncodingException e) {
                LoggerUtilities.logException(e);
                throw new IllegalStateException("UTF-8 not supported", e);
            }
        }
        regCloseKey.invoke((Object)root, handles[0]);
        return results;
    }

    private static List<String> readStringSubKeys(Preferences root, int hkey, String key) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        ArrayList<String> results = new ArrayList<String>();
        long[] handles = (long[])regOpenKey.invoke((Object)root, hkey, WinRegistry.toCstr(key), 131097);
        if (handles[1] != 0L) {
            return null;
        }
        long[] info = (long[])regQueryInfoKey.invoke((Object)root, handles[0]);
        int count = (int)info[0];
        int maxlen = (int)info[3];
        for (int index = 0; index < count; ++index) {
            byte[] name = (byte[])regEnumKeyEx.invoke((Object)root, handles[0], index, maxlen + 1);
            try {
                results.add(new String(name, "UTF-8").trim());
                continue;
            }
            catch (UnsupportedEncodingException e) {
                LoggerUtilities.logException(e);
                throw new IllegalStateException("UTF-8 not supported", e);
            }
        }
        regCloseKey.invoke((Object)root, handles[0]);
        return results;
    }

    private static int[] createKey(Preferences root, int hkey, String key) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        return (int[])regCreateKeyEx.invoke((Object)root, hkey, WinRegistry.toCstr(key));
    }

    private static void writeStringValue(Preferences root, int hkey, String key, String valueName, String value) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        long[] handles = (long[])regOpenKey.invoke((Object)root, hkey, WinRegistry.toCstr(key), 983103);
        regSetValueEx.invoke((Object)root, handles[0], WinRegistry.toCstr(valueName), WinRegistry.toCstr(value));
        regCloseKey.invoke((Object)root, handles[0]);
    }

    private static boolean isKeyExist(Preferences root, int hkey, String key) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        long[] handles = (long[])regOpenKey.invoke((Object)root, hkey, WinRegistry.toCstr(key), 131097);
        if (handles[1] != 0L) {
            return false;
        }
        regCloseKey.invoke((Object)root, handles[0]);
        return true;
    }

    private static byte[] toCstr(String str) {
        byte[] result = new byte[str.length() + 1];
        for (int i = 0; i < str.length(); ++i) {
            result[i] = (byte)str.charAt(i);
        }
        result[str.length()] = 0;
        return result;
    }

    private static RegistryRoot getRegRootByHkey(int hkey) {
        for (RegistryRoot regRoot : regRootArray) {
            if (hkey != regRoot.getHkey()) continue;
            return regRoot;
        }
        throw new IllegalArgumentException("Invalid hkey value : " + hkey);
    }

    private static RegistryRoot getRegRootByName(String name) {
        name = name.toUpperCase();
        for (RegistryRoot regRoot : regRootArray) {
            for (String rootName : regRoot.getNames()) {
                if (!name.equals(rootName)) continue;
                return regRoot;
            }
        }
        throw new IllegalArgumentException("Invalid registry root name : " + name);
    }

    static {
        try {
            regOpenKey = userClass.getDeclaredMethod("WindowsRegOpenKey", Long.TYPE, byte[].class, Integer.TYPE);
            regOpenKey.setAccessible(true);
            regCloseKey = userClass.getDeclaredMethod("WindowsRegCloseKey", Long.TYPE);
            regCloseKey.setAccessible(true);
            regQueryValueEx = userClass.getDeclaredMethod("WindowsRegQueryValueEx", Long.TYPE, byte[].class);
            regQueryValueEx.setAccessible(true);
            regEnumValue = userClass.getDeclaredMethod("WindowsRegEnumValue", Long.TYPE, Integer.TYPE, Integer.TYPE);
            regEnumValue.setAccessible(true);
            regQueryInfoKey = userClass.getDeclaredMethod("WindowsRegQueryInfoKey1", Long.TYPE);
            regQueryInfoKey.setAccessible(true);
            regEnumKeyEx = userClass.getDeclaredMethod("WindowsRegEnumKeyEx", Long.TYPE, Integer.TYPE, Integer.TYPE);
            regEnumKeyEx.setAccessible(true);
            regCreateKeyEx = userClass.getDeclaredMethod("WindowsRegCreateKeyEx", Long.TYPE, byte[].class);
            regCreateKeyEx.setAccessible(true);
            regSetValueEx = userClass.getDeclaredMethod("WindowsRegSetValueEx", Long.TYPE, byte[].class, byte[].class);
            regSetValueEx.setAccessible(true);
            regDeleteValue = userClass.getDeclaredMethod("WindowsRegDeleteValue", Long.TYPE, byte[].class);
            regDeleteValue.setAccessible(true);
            regDeleteKey = userClass.getDeclaredMethod("WindowsRegDeleteKey", Long.TYPE, byte[].class);
            regDeleteKey.setAccessible(true);
        }
        catch (RuntimeException e) {
            LoggerUtilities.logException(e);
        }
        catch (Exception e) {
            LoggerUtilities.logException(e);
        }
    }

    static class RegistryRoot {
        private final Preferences pref;
        private final int hkey;
        private final String[] names;

        public RegistryRoot(Preferences pref, int hkey, String[] names) {
            this.pref = pref;
            this.hkey = hkey;
            this.names = names;
        }

        public String[] getNames() {
            return this.names;
        }

        public Preferences getPref() {
            return this.pref;
        }

        public int getHkey() {
            return this.hkey;
        }
    }
}

