/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.util;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.TopLevelObject;
import com.sygate.scm.common.configobject.schema.ObjReference;
import com.sygate.scm.util.GUIDGenerator;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

public class WashIdHelper {
    public static Map<String, String> washIdList(ConfigObject appPolicy, Map<String, AbstractSchema> objMap) {
        HashMap<String, String> changedIdMap = new HashMap<String, String>();
        WashIdHelper.washId(appPolicy, objMap, changedIdMap);
        return changedIdMap;
    }

    private static void washId(ConfigObject obj, Map<String, AbstractSchema> objMap, Map<String, String> changedIdMap) {
        obj.init();
        try {
            Method method = obj.getClass().getMethod("getId", new Class[0]);
            String oldID = (String)method.invoke((Object)obj, new Object[0]);
            String string = changedIdMap.get(oldID);
            if (string != null) {
                return;
            }
            method = obj.getClass().getMethod("setId", String.class);
            String string2 = new GUIDGenerator().getGUIDString();
            method.invoke((Object)obj, string2);
            changedIdMap.put(oldID, string2);
        }
        catch (NoSuchMethodException method) {
        }
        catch (IllegalArgumentException method) {
        }
        catch (IllegalAccessException method) {
        }
        catch (InvocationTargetException method) {
            // empty catch block
        }
        if (obj instanceof ObjReference) {
            ObjReference ref = (ObjReference)obj;
            String curId = ref.getTargetId();
            String string = changedIdMap.get(curId);
            if (string != null) {
                ref.setTargetId(string);
            } else {
                TopLevelObject subObj = (TopLevelObject)objMap.get(curId);
                if (subObj != null) {
                    WashIdHelper.washId(subObj, objMap, changedIdMap);
                    changedIdMap.put(curId, subObj.getId());
                    ref.setTargetId(subObj.getId());
                }
            }
        }
        Vector<AbstractSchema> childrean = obj.getChildren();
        for (ConfigObject configObject : childrean) {
            WashIdHelper.washId(configObject, objMap, changedIdMap);
        }
    }
}

