/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.util;

import com.sygate.scm.common.action.ActionConstants;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.SchemaContainer;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import com.sygate.scm.common.configobject.rpc.NameValuePair;
import com.sygate.scm.common.configobject.rpc.RpcData;
import com.sygate.scm.common.configobject.rpc.SqlParameter;
import com.sygate.scm.common.configobject.schema.LuCategories;
import com.sygate.scm.common.configobject.schema.LuCategory;
import com.sygate.scm.common.configobject.schema.LuConfig;
import com.sygate.scm.common.configobject.schema.LuContentCategory;
import com.sygate.scm.common.configobject.schema.LuContentCategoryGroup;
import com.sygate.scm.common.configobject.schema.LuContentSizeSelection;
import com.sygate.scm.common.configobject.schema.LuContentSizeSelections;
import com.sygate.scm.common.configobject.schema.LuContentSourceInfo;
import com.sygate.scm.common.configobject.schema.LuDownloadSchedule;
import com.sygate.scm.common.configobject.schema.LuFtpProxy;
import com.sygate.scm.common.configobject.schema.LuHttpProxy;
import com.sygate.scm.common.configobject.schema.LuSesmContentCatalog;
import com.sygate.scm.common.configobject.schema.LuSupportLanguage;
import com.sygate.scm.common.configobject.schema.LuSupportedClientPlatform;
import com.sygate.scm.common.configobject.schema.LuSupportedClientPlatforms;
import com.sygate.scm.common.configobject.schema.PackageLuInfo;
import com.sygate.scm.common.configobject.schema.SemClientGroup;
import com.sygate.scm.common.configobject.schema.SoftwarePackage;
import com.sygate.scm.common.i18n.GenerateLocalLUCC;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.i18n.MessageResourcesFile;
import com.sygate.scm.common.util.CommonUtilities;
import com.sygate.scm.util.Base64Util;
import com.sygate.scm.util.DeterministicIdWasher;
import com.sygate.scm.util.FiltersUtility;
import com.sygate.scm.util.GUIDGenerator;
import com.sygate.scm.util.IOUtilities;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.NetworkUtils;
import com.sygate.scm.util.PackageUtil;
import com.sygate.scm.util.RunCommandHandler;
import com.sygate.scm.util.ScmLicense;
import com.sygate.scm.util.StringUtilities;
import com.sygate.scm.util.SymantecCipher;
import com.sygate.scm.util.SymantecMessageDigest;
import com.sygate.scm.util.URLUtility;
import com.sygate.scm.util.XmlParser;
import com.sygate.scm.util.ZipUtil;
import com.sygate.scm.util.ini.IniProperty;
import com.sygate.scm.util.ini.IniSection;
import com.sygate.scm.util.template.Template;
import com.sygate.scm.util.template.TemplateManager;
import java.awt.Desktop;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.DigestInputStream;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.UUID;
import java.util.Vector;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.apache.commons.validator.routines.InetAddressValidator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class Utility {
    private static final String HEX_PREFIX = "0x";
    public static final String AVMAN_FILE_NAME_GROUP_KEYS = "-AGENTID-";
    public static final String VERSION_SEPARATOR = ".";
    public static final String AES_128_PREFIX = "{V01}";
    private static final String OS_NAME_PROPERTY_KEY = "os.name";
    public static final String WINDOWS_OS_NAME_PREFIX = "Windows";
    private static volatile String[] days_of_week = null;
    private static Object lockDayOfWeek = new Object();
    private static SecureRandom random = null;
    private static final Pattern versionPattern = Pattern.compile("(\\d+\\.\\d+\\.\\d+\\.\\d+)");
    private static final int SEED_LENGTH = 20;
    public static final int SECURE_KEY_LENGTH = 32;
    private static final String RANDOM_TRANSFORMATION = "SHA1PRNG";
    private static final String SERVER_MODE = " server ";
    private static final String CDWTOUR_EE = "SEPEE_CDWTour";
    private static final String CDWTOUR_SBE = "SEPSBE_CDWTour";
    private static final Object outLockObj = new Object();
    private static final Object inLockObj = new Object();
    private static final Object readFileLockObj = new Object();
    private static final int DEFAULT_SALT_LENGTH = 32;
    private static final byte MARKER_SHA256_SALT256 = 1;
    private static final int MARKER_CHAR_LENGTH = 2;
    public static final int PKDBF2_SALT_LENGTH_STRING_LENGTH = 3;
    public static final int PKDBF2_WORKFACTOR_LENGTH_STRING_LENGTH = 1;
    private static final int PKDBF2_DEFAULT_KEY_LENGTH_IN_BITS = 512;
    public static final int DEFAULT_PKDBF2_WORKFACTOR = 20000;
    public static final int DEFAULT_PKDBF2_SALTLENGHTH_INBYTES = 16;
    public static final int MARKER_LENGTH = 2;
    public static final String MARKER_SHA1_SEED = "01";
    public static final String MARKER_MD5_SEED = "02";
    public static final String MARKER_PLAINTEXT_SEED = "03";
    public static final int MD5_LENGTH = 32;
    public static final int SHA256_LENGTH = 64;
    public static final int SHA1_LENGTH = 40;
    private static final boolean isX64WindowsOS = Utility.initIsX64WindowsOS();
    private static final String TEREDO_ADDRESS_PREFIX = "2001:0:";
    public static final String OPENING_SQUARE_BRACKET = "[";
    public static final String CLOSING_SQUARE_BRACKET = "]";
    private static final String IPV4_DELIMITER = ".";
    public static final String IPV6_DELIMITER = ":";
    public static final int USERNAME_MINLENGTH = 6;
    public static final int USERNAME_MAXLENGTH = 64;
    public static final int PASSWORD_MINLENGTH_SQL_SERVER_2008 = 8;
    public static final int PASSWORD_MINLENGTH = 8;
    public static final int PASSWORD_MAXLENGTH = 1024;
    public static final int DEFAULT_PASSWORD_AGE_DAYS = 90;
    public static final int DEFALUT_EE_PASSWORD_AGE_DAYS = 60;
    public static final int NOT_AUTHORIZED = 1;
    public static final int FULL_AUTHORIZED = 0;
    public static final int CUSTOM_AUTHORIZED = 2;
    public static final int NO_ACCESS = 1;
    public static final int READ_ONLY = 2;
    public static final int FULL_ACCESS = 0;
    public static final long DURATION_FOR_LINK_EXPIRE = 3600000L;
    public static final int RETRY_TIMES_WITIN_TIMEOUT_INTERVAL = 3;
    public static final long DURATION_FOR_RETRY = 600000L;
    private static final String SYSTEM_INSTALLTION_PROPERTY = "installation";
    private static final String SYSTEM_UPGRADE_PROPERTY = "upgrade";
    public static final String INVALID_CHARACTERS_IN_COMPUTER_NAME = "`~!@#$^&()[]{}\\*+=|:;\"'/?<>,. ";
    public static final String INVALID_CHARACTERS_IN_COMPUTER_NAME_WITHOUT_WILDCARD = "`~!@#$^&()[]{}\\+=|:;\"'/<>,";
    public static final String VALID_HOSTNAME_IPV4_IPV6_CHARSET = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789-.:";
    private static final char[] HEX_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final byte[] HEX_BYTES = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70};
    private static final char ENVIRONMENT_CHAR = '%';
    private static final char REGISTRY_CHAR = '#';
    public static final String EXE_MAKESFX = "MakeSFX.exe";
    public static final String EXE_ENCRYPTOR = "encrypt.exe";
    public static final String EXE_REG = "reg.exe";
    public static final String EXE_EXTENSION = ".exe";
    public static final String ZIP_EXTENSION = ".zip";
    public static final long oneKB = 1024L;
    public static final long oneMB = 0x100000L;
    public static final long oneGB = 0x40000000L;
    public static final long mbPerOneGB = 1024L;
    private static Logger logger = Logger.getLogger(Utility.class.getName());
    private static TimeZone LOCAL_TIMEZONE = null;
    public static final String VALID_INTEGER_NUMBERS = "1234567890";
    public static final Charset UTF_8_CharSet = StandardCharsets.UTF_8;
    public static final String UTILITY_ERROR = "Utility.error";
    public static final long TIME_IN_SECOND_PER_MINUTE = 60L;
    public static final long TIME_IN_MILLISEC_PER_ONE_SECOND = 1000L;
    public static final long TIME_IN_MILLISEC_PER_ONE_MINUTE = 60000L;
    public static final long TIME_IN_MILLISEC_PER_ONE_HOUR = 3600000L;
    public static final long TIME_IN_MILLISEC_PER_ONE_DAY = 86400000L;
    public static final long TIME_IN_SEC_PER_ONE_DAY = 86400L;
    public static final long TIME_IN_MILLISEC_PER_ONE_MONTH = 2592000000L;
    public static final long TIME_IN_MILLISEC_PER_ONE_YEAR = 31104000000L;
    public static final String URL_CHARS_RESERVED = ";/?:@=&";
    public static final String URL_CHARS_SPECIAL = "$-_.+!*'(),";
    public static final String URL_CHARS_UNSAFE = " <>#%{}|\\^~[]`";
    private static String[] regKeys = new String[]{"HKEY_CLASSES_ROOT", "HKEY_CURRENT_USER", "HKEY_LOCAL_MACHINE", "HKEY_USERS", "HKEY_CURRENT_CONFIG", "HKCR", "HKCU", "HKLM", "HKU", "HKCC"};

    public static String getPerformanceLog(String logModule, String logKey, boolean isBegin) {
        StringBuffer strBuffer = new StringBuffer();
        strBuffer.append("Performance Timer ");
        strBuffer.append(OPENING_SQUARE_BRACKET + (isBegin ? "Begin" : "End") + "] ");
        strBuffer.append("{" + logModule + " - " + logKey + "},");
        strBuffer.append("time=" + System.currentTimeMillis());
        return strBuffer.toString();
    }

    public static String toHexString(byte[] block) {
        if (block == null) {
            return null;
        }
        char[] buf = new char[block.length * 2];
        for (int i = 0; i < block.length; ++i) {
            int high = (block[i] & 0xF0) >> 4;
            int low = block[i] & 0xF;
            buf[i * 2] = HEX_CHARS[high];
            buf[i * 2 + 1] = HEX_CHARS[low];
        }
        return new String(buf);
    }

    public static byte[] fromHexString(String str) {
        int len = str.length();
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(str.charAt(i), 16) << 4) + Character.digit(str.charAt(i + 1), 16));
        }
        return data;
    }

    public static String toHexString(byte[] block, int offset, int length) {
        if (block == null) {
            return null;
        }
        char[] buf = new char[length * 2];
        for (int i = offset; i < offset + length; ++i) {
            int high = (block[i] & 0xF0) >> 4;
            int low = block[i] & 0xF;
            buf[(i - offset) * 2] = HEX_CHARS[high];
            buf[(i - offset) * 2 + 1] = HEX_CHARS[low];
        }
        return new String(buf);
    }

    public static byte[] getNumberBytes(long number) {
        Object sre = String.valueOf(number);
        while (((String)sre).length() < 19) {
            sre = "0" + (String)sre;
        }
        return ((String)sre).getBytes(Charset.defaultCharset());
    }

    public static byte[] toHexBytes(byte[] block, int offset, int length) {
        if (block == null) {
            return null;
        }
        byte[] buf = new byte[length * 2];
        for (int i = offset; i < offset + length; ++i) {
            int high = (block[i] & 0xF0) >> 4;
            int low = block[i] & 0xF;
            buf[(i - offset) * 2] = HEX_BYTES[high];
            buf[(i - offset) * 2 + 1] = HEX_BYTES[low];
        }
        return buf;
    }

    public static String hexToAsciiString(String hexString) {
        int len = hexString.length();
        if (len % 2 != 0) {
            throw new RuntimeException("String not comprised of HEX digit paris.");
        }
        char[] hexChars = new char[len];
        char[] asciiChars = new char[len / 2];
        hexString.getChars(0, len, hexChars, 0);
        for (int i = 0; i < len; i += 2) {
            String hexToken = new String(hexChars, i, 2);
            asciiChars[i / 2] = (char)Integer.parseInt(hexToken, 16);
        }
        return new String(asciiChars);
    }

    public static int readInt(byte[] buf, int offset) {
        return ((buf[offset] & 0xFF) << 24) + ((buf[offset + 1] & 0xFF) << 16) + ((buf[offset + 2] & 0xFF) << 8) + ((buf[offset + 3] & 0xFF) << 0);
    }

    public static void writeInt(int intToWrite, byte[] buf, int offset) {
        buf[offset++] = (byte)(intToWrite >>> 24 & 0xFF);
        buf[offset++] = (byte)(intToWrite >>> 16 & 0xFF);
        buf[offset++] = (byte)(intToWrite >>> 8 & 0xFF);
        buf[offset] = (byte)(intToWrite & 0xFF);
    }

    public static byte[] toByteArray(String str) {
        int len = str.length();
        if (len % 2 != 0) {
            throw new NumberFormatException("Invalid Hex String:" + str);
        }
        byte[] ret = new byte[len / 2];
        int i = 0;
        int j = 0;
        while (i < len / 2) {
            int temp = Character.digit(str.charAt(j), 16);
            if (temp < 0) {
                throw new NumberFormatException("Invalid Hex String:" + str);
            }
            int n = i;
            ret[n] = (byte)(ret[n] | temp << 4);
            temp = Character.digit(str.charAt(j + 1), 16);
            if (temp < 0) {
                throw new NumberFormatException("Invalid Hex String:" + str);
            }
            int n2 = i++;
            ret[n2] = (byte)(ret[n2] | temp);
            j = i << 1;
        }
        return ret;
    }

    public static boolean bytesCompare(byte[] data1, byte[] data2) {
        if (data1 == null || data2 == null || data1.length != data2.length) {
            return false;
        }
        for (int i = 0; i < data1.length; ++i) {
            if (data1[i] == data2[i]) continue;
            return false;
        }
        return true;
    }

    public static String calculateHash(byte[] bytes) {
        String hashString = null;
        try {
            hashString = Utility.toHexString(SymantecMessageDigest.getInstance().digest(bytes));
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException ex) {
            LoggerUtilities.logException(ex);
        }
        return hashString;
    }

    public static String calculateHash(String originalText) {
        String hashString = null;
        try {
            hashString = Utility.calculateHash(originalText.getBytes(StandardCharsets.UTF_8));
        }
        catch (Exception ex) {
            LoggerUtilities.logException(ex);
        }
        return hashString;
    }

    public static boolean isValidName(String name) {
        if (name == null || name.length() == 0) {
            return false;
        }
        char[] chararray = name.toCharArray();
        if (Character.isUnicodeIdentifierStart(chararray[0])) {
            for (int i = 1; i < chararray.length - 1; ++i) {
                if (Character.isUnicodeIdentifierPart(chararray[i]) || Character.isWhitespace(chararray[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean isValidNumber(String str) {
        if (str == null || str.length() == 0) {
            return false;
        }
        for (int i = 0; i < str.length(); ++i) {
            if (Character.isDigit(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static void sortFileByAgentAndTime(File[] files, boolean isTimeDesc) {
        if (files == null || files.length == 0) {
            return;
        }
        Arrays.sort(files, (file1, file2) -> {
            int compAgentId;
            int index2;
            if (file1 == null && file2 == null) {
                return 0;
            }
            if (file1 == null) {
                return -1;
            }
            if (file2 == null) {
                return 1;
            }
            String agentId1 = "";
            String agentId2 = "";
            int index1 = file1.getName().indexOf(AVMAN_FILE_NAME_GROUP_KEYS);
            if (index1 >= 0) {
                agentId1 = file1.getName().substring(0, index1);
            }
            if ((index2 = file2.getName().indexOf(AVMAN_FILE_NAME_GROUP_KEYS)) >= 0) {
                agentId2 = file2.getName().substring(0, index2);
            }
            if ((compAgentId = agentId1.compareTo(agentId2)) < 0) {
                return -1;
            }
            if (compAgentId > 0) {
                return 1;
            }
            long v1 = file1.lastModified();
            long v2 = file2.lastModified();
            return Utility.compareTime(v1, v2, isTimeDesc);
        });
    }

    public static void sortFileByTime(File[] files) {
        if (files == null || files.length == 0) {
            return;
        }
        Arrays.sort(files, (file1, file2) -> {
            if (file1 == null && file2 == null) {
                return 0;
            }
            if (file1 == null) {
                return -1;
            }
            if (file2 == null) {
                return 1;
            }
            long v1 = file1.lastModified();
            long v2 = file2.lastModified();
            return Utility.compareTime(v1, v2, false);
        });
    }

    public static void sortFileByTimeDesc(File[] files) {
        if (files == null || files.length == 0) {
            return;
        }
        Arrays.sort(files, (file1, file2) -> {
            if (file1 == null && file2 == null) {
                return 0;
            }
            if (file1 == null) {
                return -1;
            }
            if (file2 == null) {
                return 1;
            }
            long v1 = file1.lastModified();
            long v2 = file2.lastModified();
            return Utility.compareTime(v1, v2, true);
        });
    }

    public static int compareTime(long time1, long time2, boolean timeIsDesc) {
        if (timeIsDesc) {
            return Long.compare(time2, time1);
        }
        return Long.compare(time1, time2);
    }

    private static long getIpLong(long[] longs) {
        return (longs[0] << 24 & 0xFFFFFFFFFF000000L) + (longs[1] << 16 & 0xFF0000L) + (longs[2] << 8 & 0xFF00L) + (longs[3] & 0xFFL);
    }

    public static long getIpLong(String ipAddress) {
        if (!Utility.isValidIPAddress(ipAddress)) {
            throw new NumberFormatException("This is not an valid IP address.");
        }
        long[] ip = new long[4];
        StringTokenizer stnz = new StringTokenizer(ipAddress, ".");
        for (int i = 0; i < 4; ++i) {
            ip[i] = Long.parseLong((String)stnz.nextElement());
        }
        return Utility.getIpLong(ip);
    }

    public static String getIPString(byte[] ip) {
        StringBuilder buf = new StringBuilder();
        buf.append("").append(ip[0] & 0xFF);
        for (int i = 1; i < 4; ++i) {
            buf.append(".");
            buf.append("").append(ip[i] & 0xFF);
        }
        return buf.toString();
    }

    public static String getIPStringEx(Long ip) {
        if (ip == null) {
            return "";
        }
        long ipLongValue = ip;
        if (ipLongValue == 0L) {
            return "";
        }
        return Utility.getIPString(ipLongValue);
    }

    public static String getIPString(long ip) {
        byte[] buf = new byte[]{(byte)(ip >>> 24 & 0xFFL), (byte)(ip >>> 16 & 0xFFL), (byte)(ip >>> 8 & 0xFFL), (byte)(ip & 0xFFL)};
        return Utility.getIPString(buf);
    }

    public static boolean isSameSubnet(String ipAddress, String netAddress, String netMask) {
        String allBitZeroInHex = "0000000000000000";
        if (ipAddress.contains(IPV6_DELIMITER)) {
            ipAddress = Utility.getDecompressedIpv6Addr(ipAddress);
            netAddress = Utility.getDecompressedIpv6Addr(netAddress);
            netMask = Utility.getDecompressedIpv6Addr(netMask);
            String[] netAddrOctects = netAddress.split(IPV6_DELIMITER);
            String[] netMaskOctects = netMask.split(IPV6_DELIMITER);
            String[] ipAddrOctects = ipAddress.split(IPV6_DELIMITER);
            for (int i = 0; i < 8; ++i) {
                if (netMaskOctects[i].equals(allBitZeroInHex)) {
                    return true;
                }
                byte[] netAddrOctect = Utility.fromHexString(netAddrOctects[i]);
                byte[] netMaskOctect = Utility.fromHexString(netMaskOctects[i]);
                byte[] ipAddrOctect = Utility.fromHexString(ipAddrOctects[i]);
                byte[] disabledSubnetOctect = new byte[netAddrOctect.length];
                byte[] currentSubnetOctect = new byte[netAddrOctect.length];
                for (int k = 0; k < netAddrOctect.length; ++k) {
                    disabledSubnetOctect[k] = (byte)(netMaskOctect[k] & netAddrOctect[k]);
                    currentSubnetOctect[k] = (byte)(netMaskOctect[k] & ipAddrOctect[k]);
                }
                if (!Arrays.equals(disabledSubnetOctect, currentSubnetOctect)) {
                    return false;
                }
                if (i != 7) continue;
                return true;
            }
        } else {
            long sourceIP = Utility.getIpLong(ipAddress);
            long targetIP = Utility.getIpLong(netAddress);
            long maskIP = Utility.getIpLong(netMask);
            return (maskIP & targetIP) == (maskIP & sourceIP);
        }
        return false;
    }

    public static String getDecompressedIpv6Addr(String ipv6ShortAddress) {
        if (ipv6ShortAddress == null) {
            return ipv6ShortAddress;
        }
        if (ipv6ShortAddress.contains(".") && !ipv6ShortAddress.contains(IPV6_DELIMITER)) {
            return ipv6ShortAddress;
        }
        StringBuilder longIpv6Addr = new StringBuilder();
        int isMixedMode = 0;
        if (ipv6ShortAddress.contains("::")) {
            String[] addressParts = ipv6ShortAddress.split("::");
            int firstPartLength = 0;
            if (!addressParts[0].isEmpty()) {
                String[] firstPart = addressParts[0].split(IPV6_DELIMITER);
                firstPartLength = firstPart.length;
                for (int i = 0; i < firstPartLength; ++i) {
                    if (firstPart[i].length() != 4) {
                        firstPart[i] = Utility.addZeroAsPrefix(firstPart[i]);
                    }
                    longIpv6Addr.append(IPV6_DELIMITER).append(firstPart[i]);
                }
            }
            StringBuilder lastPartLongIpv6 = new StringBuilder();
            int lastPartLength = 0;
            if (addressParts.length == 2) {
                if (addressParts[1].contains(IPV6_DELIMITER) || addressParts[1].contains(".")) {
                    String[] lastPart = addressParts[1].split(IPV6_DELIMITER);
                    lastPartLength = lastPart.length;
                    for (int i = 0; i < lastPartLength; ++i) {
                        if (i == lastPartLength - 1 && lastPart[i].contains(".")) {
                            try {
                                Inet6Address inetAddress = (Inet6Address)InetAddress.getByName("::" + lastPart[i]);
                                String[] mixedModeLast2BytesArray = inetAddress.toString().split(IPV6_DELIMITER);
                                lastPart[i] = Utility.addZeroAsPrefix(mixedModeLast2BytesArray[6]) + IPV6_DELIMITER + Utility.addZeroAsPrefix(mixedModeLast2BytesArray[7]);
                                isMixedMode = 1;
                            }
                            catch (UnknownHostException ex) {
                                logger.log(Level.SEVERE, "Utility >> getDecompressedIpv6Addr: Invalid IP address-> " + ex.getMessage());
                            }
                        } else if (lastPart[i].length() != 4) {
                            lastPart[i] = Utility.addZeroAsPrefix(lastPart[i]);
                        }
                        lastPartLongIpv6.append(IPV6_DELIMITER).append(lastPart[i]);
                    }
                } else {
                    lastPartLength = 1;
                    lastPartLongIpv6.append(IPV6_DELIMITER).append(Utility.addZeroAsPrefix(addressParts[1]));
                }
            }
            int middlePartlength = 8 - (firstPartLength + lastPartLength + isMixedMode);
            for (int i = 0; i < middlePartlength; ++i) {
                longIpv6Addr.append(IPV6_DELIMITER).append(Utility.addZeroAsPrefix(""));
            }
            longIpv6Addr.append((CharSequence)lastPartLongIpv6);
        } else {
            String[] eachHexateBlockArray;
            for (String eachHexateBlock : eachHexateBlockArray = ipv6ShortAddress.split(IPV6_DELIMITER)) {
                if (eachHexateBlock.length() != 4) {
                    eachHexateBlock = Utility.addZeroAsPrefix(eachHexateBlock);
                }
                longIpv6Addr.append(IPV6_DELIMITER).append(eachHexateBlock);
            }
        }
        String longIpv6AddrStr = longIpv6Addr.toString();
        if (longIpv6AddrStr.startsWith(IPV6_DELIMITER)) {
            longIpv6AddrStr = longIpv6AddrStr.replaceFirst(IPV6_DELIMITER, "");
        }
        return longIpv6AddrStr;
    }

    public static String addZeroAsPrefix(String eachHexaSubAddr) {
        switch (((String)eachHexaSubAddr).length()) {
            case 0: {
                eachHexaSubAddr = "0000";
                break;
            }
            case 1: {
                eachHexaSubAddr = "000" + (String)eachHexaSubAddr;
                break;
            }
            case 2: {
                eachHexaSubAddr = "00" + (String)eachHexaSubAddr;
                break;
            }
            case 3: {
                eachHexaSubAddr = "0" + (String)eachHexaSubAddr;
                break;
            }
        }
        return eachHexaSubAddr;
    }

    public static boolean isLoopbackAddress(String ipAddreee) throws UnknownHostException {
        return NetworkUtils.isLoopbackAddress(ipAddreee);
    }

    public static String getCDWTourType(boolean isSBE) {
        return isSBE ? CDWTOUR_SBE : CDWTOUR_EE;
    }

    public static boolean isValidIPAddress(String address) {
        if (address == null || address.length() == 0) {
            return false;
        }
        int count = 0;
        boolean isAddressPartOk = true;
        address = address.trim();
        StringTokenizer tokens = new StringTokenizer(address, ".");
        while (tokens.hasMoreTokens() && isAddressPartOk) {
            ++count;
            String token = tokens.nextToken();
            if (token.length() == 0 || token.length() > 3) {
                isAddressPartOk = false;
                continue;
            }
            int tokenAsInt = -1;
            try {
                tokenAsInt = Integer.parseInt(token);
                isAddressPartOk &= tokenAsInt >= 0 && tokenAsInt <= 255;
            }
            catch (Exception ex) {
                isAddressPartOk = false;
                break;
            }
        }
        return isAddressPartOk && count == 4;
    }

    public static boolean isValidIPAddressEx(String address) {
        if (!Utility.isValidIPAddress(address)) {
            return false;
        }
        int count = 0;
        boolean isAddressPartOK = true;
        boolean isAll255 = true;
        StringTokenizer tokens = new StringTokenizer(address, ".");
        while (tokens.hasMoreTokens() && isAddressPartOK && isAll255) {
            String token = tokens.nextToken().trim();
            if (++count == 1 && token.equalsIgnoreCase("0")) {
                isAddressPartOK = false;
                continue;
            }
            isAll255 &= token.equalsIgnoreCase("255");
        }
        return isAddressPartOK && !isAll255;
    }

    public static boolean isValidateHostName(String address) {
        return Utility.isValidateHostName(address, false);
    }

    public static boolean isValidateHostName(String address, boolean wildcardsAllowed) {
        if (address == null || address.length() == 0 || address.length() > 255) {
            return false;
        }
        address = address.trim();
        Object disallowCharacters = INVALID_CHARACTERS_IN_COMPUTER_NAME_WITHOUT_WILDCARD;
        if (!wildcardsAllowed) {
            disallowCharacters = (String)disallowCharacters + "%*?";
        }
        if (Utility.containsAny(address, (String)disallowCharacters)) {
            return false;
        }
        return !Utility.isNumber(address);
    }

    public static boolean isNumber(String str) {
        for (int i = 0; i < str.length(); ++i) {
            char chr = str.charAt(i);
            if (chr >= '0' && chr <= '9') continue;
            return false;
        }
        return true;
    }

    public static boolean containsAny(String str, String searchChars) {
        if (str == null || str.length() == 0 || searchChars == null || searchChars.length() == 0) {
            return false;
        }
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            for (int j = 0; j < searchChars.length(); ++j) {
                if (searchChars.charAt(j) != ch) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isLocalIPAddress(String address) {
        try {
            InetAddress inetAddress = InetAddress.getByName(address);
            if (inetAddress.isLoopbackAddress()) {
                return true;
            }
            Enumeration<NetworkInterface> netInterfaces = NetworkInterface.getNetworkInterfaces();
            while (netInterfaces != null && netInterfaces.hasMoreElements()) {
                NetworkInterface ni = netInterfaces.nextElement();
                Enumeration<InetAddress> ips = ni.getInetAddresses();
                while (ips.hasMoreElements()) {
                    InetAddress ip = ips.nextElement();
                    if (!ip.equals(inetAddress)) continue;
                    return true;
                }
            }
        }
        catch (UnknownHostException unknownHostException) {
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        return false;
    }

    public static boolean isValidIPAddressOrHostName(String address) {
        return Utility.isValidIPAddressOrHostName(address, false);
    }

    public static boolean isValidIPAddressOrHostName(String address, boolean wildcardsAllowed) {
        if (address == null || address.length() == 0) {
            return false;
        }
        if ((address = Utility.checkAndRemoveBrackets(address)).indexOf(IPV6_DELIMITER) != -1) {
            return InetAddressValidator.getInstance().isValidInet6Address(address);
        }
        if (address.indexOf(".") >= 0) {
            if (InetAddressValidator.getInstance().isValidInet4Address(address)) {
                return true;
            }
            return Utility.isValidateHostName(address, wildcardsAllowed);
        }
        return Utility.isValidateHostName(address, wildcardsAllowed) && !Utility.isNumber(address);
    }

    public static boolean isValidIPAddr(String address) {
        if (address == null || address.length() == 0) {
            return false;
        }
        if (address.indexOf(IPV6_DELIMITER) != -1) {
            return InetAddressValidator.getInstance().isValidInet6Address(address);
        }
        if (address.indexOf(".") >= 0) {
            return InetAddressValidator.getInstance().isValidInet4Address(address);
        }
        return false;
    }

    public static int convertHourTo_H_Pattern(int hour, String hourPattern, int ampm) {
        if (hourPattern.equals("h")) {
            if (hour < 12 && ampm == 1) {
                hour += 12;
            } else if (hour == 12 && ampm == 0) {
                hour = 0;
            }
        } else if (hourPattern.equals("k")) {
            if (hour == 24) {
                hour = 0;
            }
        } else if (hourPattern.equals("K") && ampm == 1) {
            hour += 12;
        }
        return hour;
    }

    public static String getHourPatterFromTimePattern(String timePattern) {
        String token = null;
        String hourPattern = "h";
        if (!StringUtilities.isEmpty(timePattern)) {
            StringTokenizer tokens = new StringTokenizer(timePattern, ": ");
            while (tokens.hasMoreTokens()) {
                token = tokens.nextToken();
                if (token.indexOf("H") == -1 && token.indexOf("K") == -1 && token.indexOf("h") == -1 && token.indexOf("k") == -1) continue;
                hourPattern = token.substring(0, 1);
                break;
            }
        }
        return hourPattern;
    }

    public static int convertHourFrom_H_Pattern(int hour, String hourPattern) {
        hour %= 24;
        if (hourPattern.equals("h")) {
            if (hour == 0) {
                hour = 12;
            } else if (hour > 12) {
                hour -= 12;
            }
        } else if (hourPattern.equals("k")) {
            if (hour == 0) {
                hour = 24;
            }
        } else if (hourPattern.equals("K") && hour > 11) {
            hour -= 12;
        }
        return hour;
    }

    public static int getAmpmFrom_H_Pattern(int hour, String hourPattern) {
        int amPm = 0;
        if (hourPattern.equals("h") && (hour %= 24) >= 12 || hourPattern.equals("K") && hour > 11) {
            amPm = 1;
        }
        return amPm;
    }

    public static String getMidnightHour(int minute) {
        Calendar local = Utility.getCalendarInstance();
        local.set(11, 0);
        local.set(12, minute);
        Calendar timezone = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        timezone.setTime(local.getTime());
        int hourOfDay = timezone.get(11);
        return String.valueOf(hourOfDay);
    }

    public static int getMidnightMinute(int minute) {
        Calendar local = Utility.getCalendarInstance();
        local.set(11, 0);
        local.set(12, minute);
        Calendar timezone = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        timezone.setTime(local.getTime());
        return timezone.get(12);
    }

    public static String generateRandomStr(int cch) {
        int cb = (cch + 3) / 4 * 3;
        byte[] ab = new byte[cb];
        new SecureRandom().nextBytes(ab);
        return Base64Util.encodeString(ab);
    }

    public static String generateSHA256Hash(String input) throws NoSuchAlgorithmException {
        MessageDigest md = SymantecMessageDigest.getInstance("SHA-256");
        md.reset();
        byte[] buffer = input.getBytes(Charset.defaultCharset());
        md.update(buffer);
        byte[] digest = md.digest();
        StringBuilder hexStrBuffer = new StringBuilder();
        for (byte b : digest) {
            hexStrBuffer.append(Integer.toString((b & 0xFF) + 256, 16).substring(1));
        }
        return hexStrBuffer.toString();
    }

    public static String getEndHourInGMT() {
        Calendar local = Utility.getCalendarInstance();
        local.set(11, 23);
        local.set(12, 0);
        Calendar timezone = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        timezone.setTime(local.getTime());
        int h1 = timezone.get(11);
        return String.valueOf(h1);
    }

    public static long getDatePortion(long fullDateTime) {
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        calendar.setTimeInMillis(fullDateTime);
        calendar.set(10, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        calendar.set(9, 0);
        return calendar.getTimeInMillis();
    }

    public static long getTimePortion(long fullDateTime) {
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        calendar.setTimeInMillis(fullDateTime);
        return calendar.getTimeInMillis() - Utility.getDatePortion(fullDateTime);
    }

    public static String getDateTimeString(long longTimeStamp, String strFormat, String strTimeZone) {
        TimeZone timeZone = Utility.getLocalTimeZone();
        if (strTimeZone != null && strTimeZone.length() > 0) {
            timeZone = TimeZone.getTimeZone(strTimeZone);
        }
        return Utility.getDateTimeString(new Date(longTimeStamp), strFormat, timeZone);
    }

    public static String getDateTimeString(String strDate, String strFormat, String strTimeZone) {
        String szFormat = "yyyy-MM-dd HH:mm:ss";
        if (strFormat != null && strFormat.length() > 0) {
            szFormat = strFormat;
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat(szFormat);
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        Date date = new Date(0L);
        try {
            date = dateFormat.parse(strDate);
        }
        catch (ParseException ex) {
            logger.log(Level.SEVERE, "getDateTimeString: Date parse error-> " + strDate);
        }
        return Utility.getDateTimeString(date.getTime(), strFormat, strTimeZone);
    }

    public static String getTimeDisplayStringFromConfigObject(long time) {
        if (time < 1L) {
            return "";
        }
        return Utility.getLongDateTimeString(time, null);
    }

    public static String getLongDateTimeString(long longTimeStamp, String strTimeZone) {
        TimeZone timeZone = Utility.getLocalTimeZone();
        if (strTimeZone != null && strTimeZone.length() > 0) {
            timeZone = TimeZone.getTimeZone(strTimeZone);
        }
        return Utility.getLongDateTimeString(new Date(longTimeStamp), timeZone);
    }

    public static String getFullDateLongTimeString(long longTimeStamp, String strTimeZone) {
        TimeZone timeZone = Utility.getLocalTimeZone();
        if (strTimeZone != null && strTimeZone.length() > 0) {
            timeZone = TimeZone.getTimeZone(strTimeZone);
        }
        return Utility.getFullDateLongTimeString(new Date(longTimeStamp), timeZone);
    }

    public static String getDateTimeString(long longDateStamp, long longTimeStamp, boolean hasTimeZone) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("MM/dd/yyyy");
        SimpleDateFormat dateTimeWithoutZoneFormat = new SimpleDateFormat("MM/dd/yyyy HH:mm");
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        dateTimeWithoutZoneFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        if (longTimeStamp == -1L) {
            return dateFormat.format(longDateStamp);
        }
        if (!hasTimeZone) {
            return dateTimeWithoutZoneFormat.format(longDateStamp + longTimeStamp);
        }
        return dateTimeWithoutZoneFormat.format(longDateStamp + longTimeStamp) + " +0000";
    }

    public static String getDateTimeString(long longDateStamp, long longTimeStamp, String strTimeZone) {
        TimeZone timeZone = Utility.getLocalTimeZone();
        if (strTimeZone != null && strTimeZone.length() > 0) {
            timeZone = TimeZone.getTimeZone(strTimeZone);
        }
        String dateTimeStamp = Utility.getDateTimeString(new Date(longDateStamp + longTimeStamp), "MM/dd/yyyy HH:mm Z", timeZone);
        return dateTimeStamp;
    }

    public static String getDateTimeString(Date date, String strFormat, TimeZone timeZone) {
        String szFormat = "yyyy-MM-dd HH:mm:ss";
        if (strFormat != null && strFormat.length() > 0) {
            szFormat = strFormat;
        }
        SimpleDateFormat sdf = new SimpleDateFormat(szFormat);
        if (timeZone == null) {
            sdf.setTimeZone(Utility.getLocalTimeZone());
        } else {
            sdf.setTimeZone(timeZone);
        }
        return sdf.format(date);
    }

    public static String getLongDateTimeString(Date date, TimeZone timeZone) {
        DateFormat sdf = DateFormat.getDateTimeInstance(1, 1, Locale.getDefault());
        if (timeZone == null) {
            sdf.setTimeZone(Utility.getLocalTimeZone());
        } else {
            sdf.setTimeZone(timeZone);
        }
        return sdf.format(date);
    }

    public static String getFullDateLongTimeString(Date date, TimeZone timeZone) {
        DateFormat sdf = DateFormat.getDateTimeInstance(0, 1, Locale.getDefault());
        if (timeZone == null) {
            sdf.setTimeZone(Utility.getLocalTimeZone());
        } else {
            sdf.setTimeZone(timeZone);
        }
        return sdf.format(date);
    }

    public static String getTimeDurationString(long timestamp) {
        long seconds;
        long minutes;
        long hours;
        long days;
        long months;
        StringBuffer buf = new StringBuffer();
        long years = timestamp / 31104000000L;
        if (years > 0L) {
            if (years == 1L) {
                buf.append(years + MessageResources.getInstance().getString("com.sygate.scm.util.util", "Utility.utilYear"));
            } else {
                buf.append(years + MessageResources.getInstance().getString("com.sygate.scm.util.util", "Utility.utilYears"));
            }
        }
        if ((months = (timestamp %= 31104000000L) / 2592000000L) > 0L) {
            if (buf.length() > 0) {
                buf.append(" ");
            }
            if (months == 1L) {
                buf.append(months + MessageResources.getInstance().getString("com.sygate.scm.util.util", "Utility.utilMonth"));
            } else {
                buf.append(months + MessageResources.getInstance().getString("com.sygate.scm.util.util", "Utility.utilMonths"));
            }
        }
        if ((days = (timestamp %= 2592000000L) / 86400000L) > 0L) {
            if (buf.length() > 0) {
                buf.append(" ");
            }
            if (days == 1L) {
                buf.append(days + MessageResources.getInstance().getString("com.sygate.scm.util.util", "Utility.utilDay"));
            } else {
                buf.append(days + MessageResources.getInstance().getString("com.sygate.scm.util.util", "Utility.utilDays"));
            }
        }
        if ((hours = (timestamp %= 86400000L) / 3600000L) > 0L) {
            if (buf.length() > 0) {
                buf.append(" ");
            }
            if (hours == 1L) {
                buf.append(hours + MessageResources.getInstance().getString("com.sygate.scm.util.util", "Utility.utilHour"));
            } else {
                buf.append(hours + MessageResources.getInstance().getString("com.sygate.scm.util.util", "Utility.utilHours"));
            }
        }
        if ((minutes = (timestamp %= 3600000L) / 60000L) > 0L) {
            if (buf.length() > 0) {
                buf.append(" ");
            }
            if (minutes == 1L) {
                buf.append(minutes + MessageResources.getInstance().getString("com.sygate.scm.util.util", "Utility.utilMinute"));
            } else {
                buf.append(minutes + MessageResources.getInstance().getString("com.sygate.scm.util.util", "Utility.utilMinutes"));
            }
        }
        if ((seconds = (timestamp %= 60000L) / 1000L) > 0L) {
            if (buf.length() > 0) {
                buf.append(" ");
            }
            if (seconds == 1L) {
                buf.append(seconds + MessageResources.getInstance().getString("com.sygate.scm.util.util", "Utility.utilSecond"));
            } else {
                buf.append(seconds + MessageResources.getInstance().getString("com.sygate.scm.util.util", "Utility.utilSeconds"));
            }
        }
        return buf.toString();
    }

    public static void setLocalTimeZone(TimeZone tz) {
        LOCAL_TIMEZONE = tz;
    }

    public static TimeZone getLocalTimeZone() {
        if (LOCAL_TIMEZONE != null) {
            return LOCAL_TIMEZONE;
        }
        return TimeZone.getDefault();
    }

    public static Calendar getCalendarInstance() {
        if (LOCAL_TIMEZONE != null) {
            return Calendar.getInstance(Utility.getLocalTimeZone());
        }
        return Calendar.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] getDayOfWeek() {
        if (days_of_week == null) {
            Object object = lockDayOfWeek;
            synchronized (object) {
                if (days_of_week == null) {
                    String[] daysOfWeek = new String[]{MessageResources.getInstance().getString("com.sygate.scm.util.util", "Utility.sunday"), MessageResources.getInstance().getString("com.sygate.scm.util.util", "Utility.monday"), MessageResources.getInstance().getString("com.sygate.scm.util.util", "Utility.tuesday"), MessageResources.getInstance().getString("com.sygate.scm.util.util", "Utility.wednesday"), MessageResources.getInstance().getString("com.sygate.scm.util.util", "Utility.thursday"), MessageResources.getInstance().getString("com.sygate.scm.util.util", "Utility.friday"), MessageResources.getInstance().getString("com.sygate.scm.util.util", "Utility.saturday")};
                    String[] tempDays = new String[7];
                    int ifirstDay = Utility.getCalendarInstance().getFirstDayOfWeek() - 1;
                    for (int i = 0; i < 7; ++i) {
                        tempDays[i] = daysOfWeek[(i + ifirstDay) % 7];
                    }
                    days_of_week = tempDays;
                }
            }
        }
        return (String[])days_of_week.clone();
    }

    public static long getMaxMinute(boolean isSecondUnit) {
        return isSecondUnit ? 0x222222222222222L : 153722867280912L;
    }

    public static long getMaxHour(boolean isSecondUnit) {
        return Utility.getMaxMinute(isSecondUnit) / 60L;
    }

    public static long getMaxDay(boolean isSecondUnit) {
        return isSecondUnit ? 106751991167300L : 106751991167L;
    }

    public static long getMaxWeek(boolean isSecondUnit) {
        return Utility.getMaxDay(isSecondUnit) / 7L;
    }

    public static String escapeRegexString(String str) {
        if (str == null || str.length() < 1) {
            return str;
        }
        String regex_chars = "|@#$_~!^{}*()&+?\\";
        StringBuilder buf = new StringBuilder(str.length() * 2);
        for (int i = 0; i < str.length(); ++i) {
            char charAtI = str.charAt(i);
            if ("|@#$_~!^{}*()&+?\\".indexOf(charAtI) > -1) {
                buf.append("\\");
            }
            buf.append(charAtI);
        }
        return buf.toString();
    }

    public static String escapeSqlString(String str) {
        return Utility.escapeSqlString(str, false);
    }

    public static String escapeSqlString(String str, boolean isLike) {
        if (str == null || str.length() < 1) {
            return str;
        }
        String regex_chars = isLike ? "'[%" : "'";
        StringBuilder buf = new StringBuilder(str.length() * 2);
        for (int i = 0; i < str.length(); ++i) {
            char charAtI = str.charAt(i);
            if (regex_chars.indexOf(charAtI) > -1) {
                switch (charAtI) {
                    case '%': 
                    case '\'': {
                        buf.append(charAtI);
                        buf.append(charAtI);
                        break;
                    }
                    case '[': {
                        buf.append("[[]");
                        break;
                    }
                }
                continue;
            }
            buf.append(charAtI);
        }
        return buf.toString();
    }

    public static String bytesToBase64String(byte[] bytes) {
        if (bytes == null || bytes.length < 1) {
            return null;
        }
        String output = Base64Util.encodeString(bytes);
        return output;
    }

    public static boolean deleteDir(String dirName) {
        boolean result = false;
        File dir = new File(dirName);
        result = dir.exists() ? Utility.deleteDir(dir) : true;
        return result;
    }

    public static boolean deleteFile(String fileName) {
        return Utility.deleteFile(Path.of(fileName, new String[0]));
    }

    public static boolean deleteFile(File file) {
        return Utility.deleteFile(file.toPath());
    }

    public static boolean deleteFile(Path path) {
        boolean result = true;
        if (path.toFile().exists()) {
            result = path.toFile().delete();
            logger.log(Level.INFO, "Deleting file: {0}, Result: {1}.", new Object[]{path, result});
        }
        return result;
    }

    public static boolean deleteFile(File file, int retryCount, long retryInterval) {
        boolean isFileDeleted = false;
        for (int index = 1; index <= retryCount && !(isFileDeleted = Utility.deleteFile(file)); ++index) {
            try {
                Thread.sleep(retryInterval);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (index != retryCount) continue;
            StringBuffer buffer = new StringBuffer("Deletion of file failed with retry count of ");
            buffer.append(retryCount).append(" with an interval of ").append(retryInterval).append(". File:").append(file.getAbsolutePath());
            System.out.println(buffer.toString());
        }
        return isFileDeleted;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static String getFileContent(File file) {
        try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(file.getCanonicalPath()), StandardCharsets.UTF_8);){
            String string;
            try (StringWriter writer = new StringWriter();){
                int count;
                while ((count = reader.read()) != -1) {
                    writer.write(count);
                }
                string = writer.toString();
            }
            return string;
        }
        catch (IOException ex) {
            LoggerUtilities.logException(ex);
            return "";
        }
    }

    public static void writeContentToFile(File file, String content) {
        try {
            Utility.writeContentToFileEx(file, content);
        }
        catch (Exception ex) {
            LoggerUtilities.logException(ex);
        }
    }

    public static void writeContentToFileEx(File file, String content) throws IOException {
        Files.writeString(file.toPath(), (CharSequence)content, new OpenOption[0]);
    }

    public static long getFileSize(String fileName) {
        long l;
        RandomAccessFile raf = new RandomAccessFile(fileName, "r");
        try {
            l = raf.length();
        }
        catch (Throwable throwable) {
            try {
                try {
                    raf.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Throwable throwable3) {
                return 0L;
            }
        }
        raf.close();
        return l;
    }

    public static long getLargestFileSize(String folderName) {
        long length = 0L;
        File file = new File(folderName);
        File[] files = file.listFiles();
        if (null == files) {
            return 0L;
        }
        for (File subFile : files) {
            long size = 0L;
            size = subFile.isDirectory() ? Utility.getLargestFileSize(subFile.getAbsolutePath()) : Utility.getFileSize(subFile.getAbsolutePath());
            length = size > length ? size : length;
        }
        return length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getDirectorySize(String dir) {
        File file = new File(dir);
        if (!file.isDirectory()) {
            logger.log(Level.WARNING, "getDirectorySize: Error-> it is NOT a dir: " + file.getAbsolutePath());
            return 0L;
        }
        long size = 0L;
        RandomAccessFile raf = null;
        String[] strFiles = file.list();
        if (null == strFiles) {
            logger.log(Level.WARNING, "getDirectorySize: Error-> unable to get list of files: " + file.getAbsolutePath());
            return 0L;
        }
        for (String strFile : strFiles) {
            File ff = new File(file.getAbsolutePath(), strFile);
            if (ff.isDirectory()) {
                size += Utility.getDirectorySize(ff.getAbsolutePath());
                continue;
            }
            if (!ff.isFile()) continue;
            try {
                raf = new RandomAccessFile(ff.getAbsolutePath(), "r");
                size += raf.length();
            }
            catch (IOException ex) {
                logger.log(Level.FINE, "getDirectorySize: Warning-> Failed to get Size: " + file.getAbsolutePath());
            }
            finally {
                try {
                    raf.close();
                }
                catch (IOException ex) {
                    logger.log(Level.FINE, "getDirectorySize: Warning-> Failed to close random access file: " + file.getAbsolutePath());
                }
            }
        }
        return size;
    }

    public static int checkIfDirEmpty(String strDir) {
        File file = new File(strDir);
        if (!file.exists()) {
            logger.log(Level.FINE, "isDirEmpty: Warning, no dir-> " + file.getAbsolutePath());
            return -1;
        }
        if (!file.isDirectory()) {
            logger.log(Level.WARNING, "isDirEmpty: Error, it is NOT a dir-> " + file.getAbsolutePath());
            return -2;
        }
        String[] files = file.list();
        if (files == null) {
            return -2;
        }
        return files.length < 1 ? 0 : 1;
    }

    public static boolean emptyDir(String strDir, boolean deleteItself) {
        return Utility.emptyDir(strDir, deleteItself, false);
    }

    public static boolean emptyDir(String strDir, boolean deleteItself, boolean continueOnError) {
        File file = new File(strDir);
        if (!file.exists()) {
            logger.log(Level.WARNING, "emptyDir: Warning, no dir-> " + file.getAbsolutePath());
            return true;
        }
        if (!file.isDirectory()) {
            logger.log(Level.WARNING, "emptyDir: Error, it is NOT a dir-> " + file.getAbsolutePath());
            return false;
        }
        String[] strFiles = file.list();
        if (null == strFiles) {
            logger.log(Level.WARNING, "emptyDir: Error, not able to get file list-> " + file.getAbsolutePath());
            return false;
        }
        boolean result = true;
        for (String strFile : strFiles) {
            File ff = new File(file.getAbsolutePath(), strFile);
            if (ff.isDirectory()) {
                if (Utility.emptyDir(ff.getAbsolutePath(), true, continueOnError)) continue;
                logger.log(Level.WARNING, "emptyDir: Error, Can NOT delete -> " + ff.getAbsolutePath());
                if (!continueOnError) {
                    return false;
                }
                result = false;
                continue;
            }
            if (!ff.isFile() || ff.delete()) continue;
            logger.log(Level.WARNING, "emptyDir: Error, Can NOT delete -> " + ff.getAbsolutePath());
            if (!continueOnError) {
                return false;
            }
            result = false;
        }
        if (deleteItself && !file.delete()) {
            logger.log(Level.WARNING, "emptyDir: Error, Can NOT delete -> " + file.getAbsolutePath());
            return false;
        }
        return result;
    }

    public static boolean deleteAllSubfolders(String strDir) {
        File curFolder = new File(strDir);
        if (!curFolder.exists()) {
            logger.log(Level.FINE, "emptyDir: Warning, no dir-> " + curFolder.getAbsolutePath());
            return true;
        }
        if (!curFolder.isDirectory()) {
            logger.log(Level.WARNING, "emptyDir: Error, it is NOT a dir-> " + curFolder.getAbsolutePath());
            return false;
        }
        File[] allSubs = curFolder.listFiles();
        if (null == allSubs) {
            logger.log(Level.WARNING, "emptyDir: Error, cannot get list of files-> " + curFolder.getAbsolutePath());
            return false;
        }
        for (File allSub : allSubs) {
            if (!allSub.isDirectory()) continue;
            Utility.emptyDir(allSub.getAbsolutePath(), true);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readFile(String fileName) {
        if (fileName == null || fileName.length() < 1) {
            logger.log(Level.SEVERE, "readFile: Error-> file name is invalid!");
            return null;
        }
        File file = new File(fileName);
        if (!file.exists()) {
            logger.log(Level.SEVERE, "readFile: Error-> File does NOT exist! file=" + file.getAbsolutePath());
            return null;
        }
        if (!file.canRead()) {
            logger.log(Level.SEVERE, "readFile: Error-> File is NOT readable! file=" + file.getAbsolutePath());
            return null;
        }
        long sizFile = Utility.getFileSize(file.getAbsolutePath());
        BufferedInputStream fis = null;
        ByteArrayOutputStream bos = null;
        try {
            fis = new BufferedInputStream(new FileInputStream(file));
            bos = new ByteArrayOutputStream((int)sizFile);
            Object object = readFileLockObj;
            synchronized (object) {
                int len;
                int bufferSize = 1024;
                byte[] temp = new byte[bufferSize];
                do {
                    if ((len = ((InputStream)fis).read(temp)) == -1) continue;
                    bos.write(temp, 0, len);
                } while (len >= bufferSize);
            }
        }
        catch (Exception ex) {
            try {
                logger.log(Level.FINE, "readFile: Exception...");
                LoggerUtilities.logException(ex);
            }
            catch (Throwable throwable) {
                IOUtilities.closeInputStream(fis);
                IOUtilities.closeOutputStream(bos);
                throw throwable;
            }
            IOUtilities.closeInputStream(fis);
            IOUtilities.closeOutputStream(bos);
        }
        IOUtilities.closeInputStream(fis);
        IOUtilities.closeOutputStream(bos);
        if (bos != null) {
            return bos.toByteArray();
        }
        logger.log(Level.SEVERE, "readFile: Error-> Failed to read file: " + file.getAbsolutePath());
        return null;
    }

    public static String generateTempFileName() {
        return Long.toString(System.currentTimeMillis());
    }

    public static String generateTempFileName(String dir, String prefixFileName, String suffixFileName, String ext) {
        StringBuffer buf = new StringBuffer();
        if (dir != null && dir.length() > 0) {
            buf.append(dir);
            buf.append(System.getProperty("file.separator"));
        }
        if (prefixFileName != null && prefixFileName.length() > 0) {
            buf.append(prefixFileName);
        }
        buf.append(Utility.generateTempFileName());
        if (suffixFileName != null && suffixFileName.length() > 0) {
            buf.append(suffixFileName);
        }
        if (ext != null && ext.length() > 0) {
            buf.append(".");
            buf.append(ext);
        }
        return buf.toString();
    }

    public static boolean isValidUrl(String url) {
        if (url == null || url.length() < 1) {
            return false;
        }
        return url.startsWith("http://") || url.startsWith("https://");
    }

    public static boolean isValidUrl(String url, String requiredExtension) {
        boolean isValid = Utility.isValidUrl(url);
        if (isValid && !StringUtilities.isEmpty(requiredExtension)) {
            String extensionLower;
            String urlLower = url.toLowerCase(Locale.ENGLISH);
            isValid = urlLower.endsWith(extensionLower = requiredExtension.toLowerCase(Locale.ENGLISH));
        }
        return isValid;
    }

    public static boolean copyFile(String sourceFile, String targetFile) {
        File fs = new File(sourceFile);
        File ft = new File(targetFile);
        return Utility.copyFile(fs, ft);
    }

    public static boolean copyFileNIOTransfer(String sourceFile, String targetFile) {
        File fs = new File(sourceFile);
        File ft = new File(targetFile);
        return Utility.copyFileNIOTransfer(fs, ft);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public static boolean copyFileNIOTransfer(File source, File target) {
        if (source == null || target == null) {
            Utility.logger.log(Level.WARNING, "Utility> copyFileNIOTransfer>> Error-> source or target is NULL!");
            return false;
        }
        if (!source.isFile()) {
            srcPath = "";
            try {
                srcPath = source.getCanonicalPath();
            }
            catch (IOException ex) {
                LoggerUtilities.logException(ex);
            }
            Utility.logger.log(Level.SEVERE, "Utility> copyFileNIOTransfer>> Error, source '" + srcPath + "' is NOT a file!");
            return false;
        }
        bresult = false;
        in = null;
        out = null;
        inStream = null;
        outStream = null;
        try {
            inStream = new FileInputStream(source.getAbsolutePath());
            outStream = new FileOutputStream(target.getAbsolutePath());
            in = inStream.getChannel();
            out = outStream.getChannel();
            maxCount = 67076096;
            size = in.size();
            for (position = 0L; position < size; position += in.transferTo(position, maxCount, (WritableByteChannel)out)) {
            }
            bresult = true;
        }
        catch (IOException ex) {
            try {
                Utility.logger.log(Level.WARNING, ex.getMessage());
                Utility.logger.log(Level.WARNING, "copyFileNIOTransfer: Failed copy " + source.getAbsolutePath() + " to " + target.getAbsolutePath() + " using NIO approach, we will try normal copy approach.");
            }
            catch (Throwable var12_17) {
                IOUtilities.closeInputStream(inStream);
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (Exception var13_18) {
                        // empty catch block
                    }
                }
                IOUtilities.closeOutputStream(outStream);
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (Exception var13_19) {
                        // empty catch block
                    }
                }
                throw var12_17;
            }
            IOUtilities.closeInputStream(inStream);
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception var7_13) {
                    // empty catch block
                }
            }
            IOUtilities.closeOutputStream(outStream);
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception var7_14) {}
            } else {
                ** GOTO lbl76
            }
        }
        IOUtilities.closeInputStream(inStream);
        if (in != null) {
            try {
                in.close();
            }
            catch (Exception maxCount) {
                // empty catch block
            }
        }
        IOUtilities.closeOutputStream(outStream);
        if (out != null) {
            try {
                out.close();
            }
            catch (Exception maxCount) {}
        }
        if (!bresult) {
            Utility.logger.log(Level.INFO, "copyFileNIOTransfer: Use normal copy approach to copy " + source.getAbsolutePath() + ".");
            return Utility.copyFile(source, target);
        }
        return bresult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copyFile(File fsource, File ftarget) {
        if (fsource == null || ftarget == null) {
            logger.log(Level.WARNING, "Utility> copyFile>> Error-> source or target is NULL!");
            return false;
        }
        if (!fsource.isFile()) {
            String srcPath = "";
            try {
                fsource.getCanonicalPath();
            }
            catch (IOException ex) {
                LoggerUtilities.logException(ex);
            }
            logger.log(Level.SEVERE, "Utility> copyFile>> Error, source '" + srcPath + "' is NOT a file!");
            return false;
        }
        boolean bresult = false;
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(fsource.getAbsolutePath()));
             BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(ftarget.getAbsolutePath()));){
            int ibufferSize = 8192;
            byte[] buffer = new byte[ibufferSize];
            int bytesRead = -1;
            Object object = inLockObj;
            synchronized (object) {
                Object object2 = outLockObj;
                synchronized (object2) {
                    while ((bytesRead = ((InputStream)in).read(buffer, 0, ibufferSize)) != -1) {
                        ((OutputStream)out).write(buffer, 0, bytesRead);
                    }
                    ((OutputStream)out).flush();
                }
            }
            bresult = true;
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, "copyFile: Error, copy " + fsource.getAbsolutePath() + " to " + ftarget.getAbsolutePath());
            LoggerUtilities.logException(ex);
            bresult = false;
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "copyFile: Error, copy " + fsource.getAbsolutePath() + " to " + ftarget.getAbsolutePath());
            LoggerUtilities.logException(ex);
            bresult = false;
        }
        return bresult;
    }

    public static boolean copyDir(String sourceDir, String targetDir, boolean createTargetDir) {
        File fileTarget = new File(targetDir);
        File fileSource = new File(sourceDir);
        return Utility.copyDir(fileSource, fileTarget, createTargetDir);
    }

    public static boolean copyDir(File fileSource, File fileTarget, boolean createTargetDir) {
        if (!fileSource.isDirectory()) {
            logger.log(Level.SEVERE, "copyDir: Error-> Source is NOT a dir: " + fileSource.getAbsolutePath());
            return false;
        }
        if (fileTarget.exists()) {
            if (!fileTarget.isDirectory()) {
                logger.log(Level.SEVERE, "copyDir: Error, target is not a dir-> " + fileTarget.getAbsolutePath());
                return false;
            }
        } else if (createTargetDir && !fileTarget.exists() && !fileTarget.mkdirs()) {
            logger.log(Level.SEVERE, "copyDir: Error-> no dir-> " + fileTarget.getAbsolutePath());
            return false;
        }
        boolean result = true;
        String[] strFiles = fileSource.list();
        if (null == strFiles) {
            return true;
        }
        for (String strFile : strFiles) {
            File source = new File(fileSource.getAbsolutePath(), strFile);
            File target = new File(fileTarget.getAbsolutePath() + File.separator + source.getName());
            if (source.isDirectory()) {
                if (!target.exists() && !target.mkdirs()) {
                    logger.log(Level.SEVERE, "copyDir: Error-> no dir / dir cannot be created -> " + target.getAbsolutePath());
                    result = false;
                    break;
                }
                if (Utility.copyDir(source, target, false)) continue;
                result = false;
                break;
            }
            if (Utility.copyFileNIOTransfer(source, target)) continue;
            result = false;
            break;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean moveDir(String sourceDir, String targetDir) {
        File source = new File(sourceDir);
        File target = new File(targetDir);
        if (source.compareTo(target) == 0) {
            return true;
        }
        boolean result = false;
        try {
            result = Utility.copyDir(sourceDir, targetDir, true);
        }
        finally {
            try {
                result = Utility.deleteDir(sourceDir);
            }
            catch (Exception ex) {
                logger.log(Level.WARNING, StringUtilities.join("Fail to delete dir: ", sourceDir, ", ", ex.getMessage()));
                result = false;
            }
        }
        return result;
    }

    public static long convertWindowsFileTime(long javaTime) {
        Calendar cal = Utility.getCalendarInstance();
        cal.setTimeInMillis(javaTime);
        int yearDiff = 369;
        cal.add(1, yearDiff);
        return cal.getTimeInMillis() * 10000L;
    }

    public static String getFileExtension(File file) {
        String filename;
        int index;
        if (file != null && (index = (filename = file.getName()).lastIndexOf(46)) > 0 && index < filename.length() - 1) {
            return filename.substring(index + 1).toLowerCase(Locale.ENGLISH);
        }
        return null;
    }

    public static String getFileNameWithoutExt(String nameWithExt) {
        String fileName = nameWithExt;
        if (nameWithExt != null && nameWithExt.length() > 0) {
            int index = nameWithExt.lastIndexOf(46);
            if (index == 0) {
                fileName = "";
            } else if (index > 0 && index <= nameWithExt.length() - 1) {
                fileName = nameWithExt.substring(0, index);
            }
        }
        return fileName;
    }

    public static String getQuotedFilePath(String filePath) {
        return filePath;
    }

    public static boolean createFile(byte[] data, String filePath, boolean ignoreEmptyData) {
        boolean emptyData = false;
        if (data == null || data.length < 1) {
            emptyData = true;
            if (!ignoreEmptyData) {
                return false;
            }
        }
        boolean result = false;
        try (BufferedOutputStream fos = new BufferedOutputStream(new FileOutputStream(filePath));){
            if (!emptyData) {
                ((OutputStream)fos).write(data);
                ((OutputStream)fos).flush();
            }
            result = true;
        }
        catch (Exception ex) {
            LoggerUtilities.logException(ex);
        }
        return result;
    }

    public static String getOsName(long osType) {
        return "" + osType;
    }

    public static boolean getBooleanValue(Boolean value, Boolean defaultValue) {
        if (value != null) {
            return value;
        }
        if (defaultValue != null) {
            return defaultValue;
        }
        return false;
    }

    public static String xor(String str) {
        if (str == null || str.length() < 1) {
            return "";
        }
        int key = 136;
        StringBuilder buffer = new StringBuilder(str.length());
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            int e = c ^ key;
            buffer.append((char)e);
        }
        return buffer.toString();
    }

    public static String encodeCharForURL(char c, boolean encodeUrlChar) {
        if (!(encodeUrlChar || URL_CHARS_RESERVED.indexOf(c) < 0 && URL_CHARS_SPECIAL.indexOf(c) < 0)) {
            return String.valueOf(c);
        }
        if (c < '\u0010') {
            return "%0" + Integer.toString(c, 16);
        }
        if (c < ' ' || c > '\u007f' || URL_CHARS_UNSAFE.indexOf(c) >= 0) {
            return "%" + Integer.toString(c, 16);
        }
        return String.valueOf(c);
    }

    public static String encodeStringForURL(String str, boolean encodeUrlSyntaxChar) {
        StringBuffer strBuffer = new StringBuffer();
        for (int i = 0; i < str.length(); ++i) {
            char c = (char)(str.charAt(i) & 0xFF);
            strBuffer.append(Utility.encodeCharForURL(c, encodeUrlSyntaxChar));
        }
        return strBuffer.toString();
    }

    public static int createDir(String strDir) {
        File f;
        int iResult = -2;
        if (strDir == null || strDir.length() <= 0) {
            return -1;
        }
        if (strDir.endsWith(File.separator)) {
            strDir = strDir.substring(0, strDir.length() - 1);
        }
        if ((f = new File(strDir)).exists()) {
            iResult = f.isDirectory() ? 0 : 1;
        } else {
            int i;
            Vector<String> vParents = new Vector<String>();
            vParents.addElement(strDir);
            File tempFile = new File(strDir);
            String strParent = tempFile.getParent();
            while (strParent != null) {
                tempFile = new File(strParent);
                if (tempFile.exists()) {
                    strParent = tempFile.getAbsolutePath();
                    break;
                }
                vParents.addElement(strParent);
                strParent = tempFile.getParent();
            }
            for (i = vParents.size() - 1; i > -1; --i) {
                tempFile = new File((String)vParents.elementAt(i));
                if (tempFile.mkdir()) continue;
                logger.log(Level.SEVERE, "createDir: Error-> Failed to create " + tempFile.getAbsolutePath());
                strParent = (String)vParents.elementAt(i);
                iResult = 10;
                ++i;
                break;
            }
            if (iResult == 10) {
                for (i = 0; i < vParents.size(); ++i) {
                    Utility.delete((String)vParents.elementAt(i));
                }
            } else {
                iResult = f.exists() ? (f.isDirectory() ? 0 : 1) : -2;
            }
        }
        return iResult;
    }

    public static boolean isValidDir(String path, int validType) {
        boolean isValid = true;
        String tempDirPart = Utility.getTempDir();
        String timePart = Long.toString(new Date().getTime());
        String pathPredix = tempDirPart + File.separator + timePart;
        int len = ((String)path).length();
        if (validType == 0 || validType == 2) {
            if (((String)path).matches("^[a-zA-Z]:\\\\.*")) {
                if (len > 3) {
                    if (Utility.createDir((String)(path = pathPredix + File.separator + ((String)path).substring(3))) != 0) {
                        isValid = false;
                    } else {
                        Utility.emptyDir(pathPredix, true);
                    }
                }
            } else {
                isValid = false;
            }
        }
        if (validType == 1 || validType == 2) {
            if (((String)path).matches("^/.*")) {
                if (Utility.createDir((String)(path = pathPredix + File.separator + (String)path)) != 0) {
                    isValid = false;
                } else {
                    Utility.emptyDir(pathPredix, true);
                }
            } else {
                isValid = false;
            }
        }
        return isValid;
    }

    public static int compareVersion(String productVersion1, String productVersion2) {
        String version1 = Utility.formatVersion(productVersion1);
        String version2 = Utility.formatVersion(productVersion2);
        if (version1 == null && version2 == null) {
            return 0;
        }
        if (version1 == null && version2 != null) {
            return -1;
        }
        if (version1 != null && version2 == null) {
            return 1;
        }
        StringTokenizer st1 = new StringTokenizer(version1, ".");
        StringTokenizer st2 = new StringTokenizer(version2, ".");
        while (st1.hasMoreTokens() && st2.hasMoreTokens()) {
            int ret;
            int v1 = 0;
            int v2 = 0;
            try {
                v1 = Integer.parseInt(st1.nextToken());
            }
            catch (Exception ex) {
                LoggerUtilities.logException(ex);
            }
            try {
                v2 = Integer.parseInt(st2.nextToken());
            }
            catch (Exception ex) {
                LoggerUtilities.logException(ex);
            }
            if ((ret = v1 > v2 ? 1 : (v1 < v2 ? -1 : 0)) == 0) continue;
            return ret;
        }
        if (st1.hasMoreTokens()) {
            return 1;
        }
        if (st2.hasMoreTokens()) {
            return -1;
        }
        return 0;
    }

    public static int compareVersion(String version1, String version2, boolean ignoreBuildNumber) {
        if (ignoreBuildNumber) {
            return Utility.compareVersion(Utility.stripBuildNumber(version1), Utility.stripBuildNumber(version2));
        }
        return Utility.compareVersion(version1, version2);
    }

    public static String stripBuildNumber(String productVersion) {
        String version = Utility.formatVersion(productVersion);
        if (StringUtilities.isEmpty(version)) {
            return version;
        }
        int index = version.lastIndexOf(".");
        if (Utility.splitVersion(version).length == 4 && index != -1) {
            return version.substring(0, index);
        }
        return version;
    }

    public static String formatVersion(String productVersion) {
        if (StringUtilities.isEmpty(productVersion)) {
            return productVersion;
        }
        String version = productVersion.trim();
        if (version.matches("\\d\\d\\.\\d\\.\\d\\.\\d")) {
            return version;
        }
        String[] versionParts = Utility.splitVersion(version);
        if (versionParts.length == 4) {
            StringBuilder sbuff = new StringBuilder(versionParts[0]);
            sbuff.append(".").append(versionParts[1]);
            int part3 = 0;
            try {
                part3 = Integer.parseInt(versionParts[2]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (version.startsWith("12.1") && part3 < 5000) {
                sbuff.append(".").append(versionParts[2]);
                sbuff.append(".").append(versionParts[3]);
            } else {
                sbuff.append(".").append(versionParts[3]);
                sbuff.append(".").append(versionParts[2]);
            }
            version = sbuff.toString();
        }
        return version;
    }

    static String[] splitVersion(String productVersion) {
        return productVersion == null ? new String[]{} : productVersion.split("\\.");
    }

    public static String getFeatureSetVersion(String productVersion) {
        String featureSetVersion = Utility.compareVersion(productVersion, "14.3.0.5000", true) >= 0 ? "14.3.5000.0" : (Utility.compareVersion(productVersion, "14.3.0.4000", true) >= 0 ? "14.3.4000.0" : (Utility.compareVersion(productVersion, "14.2.0.1000", true) >= 0 ? "14.2.1000.0" : (Utility.compareVersion(productVersion, "14.2.0.0", true) >= 0 ? "14.2.0000.0" : (Utility.compareVersion(productVersion, "12.1.1925.0") >= 0 ? "12.1.2000.0" : (Utility.compareVersion(productVersion, "12.1.0.0") >= 0 ? "12.1.0.0" : (Utility.compareVersion(productVersion, "12.0.0.0") >= 0 ? "12.0.0.0" : (Utility.compareVersion(productVersion, "11.0.0.0") >= 0 ? "11.0.0.0" : "14.3.5000.0")))))));
        return featureSetVersion;
    }

    public static String getShortString(String version, int i) {
        String major = null;
        String minor = null;
        String maintenance = null;
        String build = null;
        StringTokenizer tokenizer = new StringTokenizer(version, ".");
        if (tokenizer.hasMoreTokens()) {
            major = tokenizer.nextToken();
        }
        if (tokenizer.hasMoreTokens()) {
            minor = tokenizer.nextToken();
        }
        if (tokenizer.hasMoreTokens()) {
            maintenance = tokenizer.nextToken();
        }
        if (tokenizer.hasMoreTokens()) {
            build = tokenizer.nextToken();
        }
        switch (i) {
            case 1: {
                return major;
            }
            case 2: {
                return major + "." + minor;
            }
            case 3: {
                return major + "." + minor + "." + maintenance;
            }
            case 4: {
                return major + "." + minor + "." + maintenance + "." + build;
            }
        }
        return null;
    }

    public static String getClassName(Object o, boolean full) {
        if (o == null) {
            return "";
        }
        return full ? o.getClass().getName() : o.getClass().getName().substring(o.getClass().getName().lastIndexOf("."));
    }

    public static boolean isValidEnvVariableOrRegValueInput(String conditionStr, boolean onlyCheckEnv) {
        if (conditionStr == null || conditionStr.length() == 0) {
            return true;
        }
        int envCount = 0;
        int regCount = 0;
        for (int i = 0; i < conditionStr.length(); ++i) {
            envCount += conditionStr.charAt(i) == '%' ? 1 : 0;
            if (onlyCheckEnv) continue;
            regCount += conditionStr.charAt(i) == '#' ? 1 : 0;
        }
        if (regCount % 2 != 0 || envCount % 2 != 0) {
            return false;
        }
        if (onlyCheckEnv) {
            return envCount % 2 == 0;
        }
        if (regCount == 0) {
            return envCount % 2 == 0;
        }
        StringTokenizer tokens = new StringTokenizer(conditionStr, String.valueOf('#'));
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken();
            envCount = 0;
            for (int i = 0; i < token.length(); ++i) {
                envCount += token.charAt(i) == '%' ? 1 : 0;
            }
            if (envCount % 2 == 0) continue;
            return false;
        }
        return true;
    }

    public static boolean isValidRegistryKey(String regKey) {
        if (regKey == null || regKey.length() < 1) {
            return false;
        }
        String key = regKey.toUpperCase(Locale.ENGLISH);
        for (String regKey2 : regKeys) {
            if (!key.startsWith(regKey2)) continue;
            return true;
        }
        return false;
    }

    public static String getGUIDString() {
        GUIDGenerator generator = GUIDGenerator.getInstance();
        return generator.getGUIDString();
    }

    public static boolean isValidGUID(String candidate) {
        return candidate != null && candidate.length() == 32 && candidate.matches("[A-Fa-f0-9]+");
    }

    private static byte[] getDefaultKey() {
        return new byte[]{-95, 18, 119, 66, 71, -6, 101, -87};
    }

    private static byte[] getDefaultKey128() {
        return new byte[]{-95, 18, 119, 66, 71, -6, 101, -87, -79, 19, 120, 82, 72, -22, 104, -71};
    }

    public static byte[] getMachineAndUserSpecificKey() throws Exception {
        String hostName = null;
        String loggedInUser = null;
        try {
            hostName = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception ex) {
            LoggerUtilities.logException(ex);
        }
        if (hostName == null) {
            hostName = "";
        }
        if ((loggedInUser = System.getProperty("user.name")) == null) {
            loggedInUser = "";
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append(new String(Utility.getDefaultKey(), "UTF-8"));
        buffer.append(hostName);
        buffer.append(loggedInUser);
        while (buffer.length() < 8) {
            buffer.append("*");
        }
        MessageDigest md = SymantecMessageDigest.getInstance();
        md.update(buffer.toString().getBytes(Charset.defaultCharset()));
        return md.digest();
    }

    public static String getAdminAndDomainSpecificKey(String adminName, String domainName) throws Exception {
        StringBuffer buffer = new StringBuffer();
        buffer.append(new String(Utility.getDefaultKey(), "UTF-8"));
        if (adminName == null) {
            adminName = "";
        }
        buffer.append(adminName);
        if (domainName != null) {
            buffer.append(domainName);
        }
        while (buffer.length() < 8) {
            buffer.append("*");
        }
        MessageDigest md = SymantecMessageDigest.getInstance();
        md.update(buffer.toString().getBytes(Charset.defaultCharset()));
        return Utility.toHexString(md.digest());
    }

    public static String encrypt(String value) throws GeneralSecurityException, IOException {
        String latest = Utility.encryptLatest(value);
        return AES_128_PREFIX + latest;
    }

    private static byte[] getKeyHash(byte[] key) {
        MessageDigest digest = null;
        try {
            digest = SymantecMessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException nsae) {
            LoggerUtilities.logException(nsae);
        }
        return digest == null ? null : digest.digest(key);
    }

    public static byte[] getProfileKey6() {
        return new byte[]{76, 42, 75, 69, 49, 109, 89, 48, 37, 82, 70, 43, 72, 114};
    }

    public static byte[] getProfileKey(byte[] byKey1, byte[] byKey2) {
        int i;
        int seed = 32571;
        short[] key = new short[]{513, 1027, 1541, 2055, 2569, 3083, 3597, 4111};
        byte[] finalkey = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16};
        for (i = 0; (i < byKey1.length || i < byKey2.length) && i < key.length; ++i) {
            byte k1 = i < byKey1.length ? byKey1[i] : (byte)0;
            byte k2 = i < byKey2.length ? byKey2[i] : (byte)0;
            seed = (short)(seed ^ ((k1 | k2 << 8) ^ 0x6B2C));
            int idx = i % 4 == 1 ? 2 + i / 4 * 4 : (i % 4 == 2 ? 1 + i / 4 * 4 : i % 4 + i / 4 * 4);
            int n = idx;
            key[n] = (short)(key[n] ^ seed);
        }
        for (i = 0; i < key.length; ++i) {
            finalkey[i * 2] = (byte)key[i];
            finalkey[i * 2 + 1] = (byte)(key[i] >>> 8);
        }
        return finalkey;
    }

    public static String encryptProfileValue(String value, byte[] key, String initVector) throws GeneralSecurityException, IOException {
        if (value == null) {
            return null;
        }
        Cipher cipher = SymantecCipher.getInstance("AES/CBC/PKCS5Padding");
        byte[] keyhash = Utility.getKeyHash(key);
        SecretKeySpec aesKey = new SecretKeySpec(keyhash, 0, 16, "AES");
        IvParameterSpec oIV = new IvParameterSpec(initVector.getBytes(Charset.defaultCharset()), 0, 16);
        cipher.init(1, (Key)aesKey, oIV);
        byte[] data = cipher.doFinal(value.getBytes(StandardCharsets.UTF_8));
        byte[] iv = oIV.getIV();
        byte[] final_bytes = new byte[data.length + iv.length];
        System.arraycopy(data, 0, final_bytes, 0, data.length);
        System.arraycopy(iv, 0, final_bytes, data.length, iv.length);
        return Base64Util.encodeString(final_bytes);
    }

    public static String encryptLatest(char[] input, byte[] raw) {
        try {
            if (input == null) {
                return null;
            }
            if (raw == null) {
                return null;
            }
            if (raw.length != 16) {
                return null;
            }
            SecretKeySpec skeySpec = new SecretKeySpec(raw, "AES");
            Cipher cipher = SymantecCipher.getInstance("AES/ECB/PKCS5Padding");
            cipher.init(1, skeySpec);
            byte[] tobeEncrypted = Utility.charToBytes(input);
            byte[] encrypted = cipher.doFinal(tobeEncrypted);
            String encryptedString = Utility.toHexString(encrypted);
            return encryptedString;
        }
        catch (Exception ex) {
            System.out.println("Exception while encrypting input:" + ex.hashCode());
            return null;
        }
    }

    public static String encryptLatest(char[] input) {
        return Utility.encryptLatest(input, Utility.getDefaultKey128());
    }

    public static String encryptLatest(String input) {
        if (input != null) {
            return Utility.encryptLatest(input.toCharArray());
        }
        return null;
    }

    public static String encryptLatestForDB(char[] input) {
        if (input == null) {
            return null;
        }
        String encryptedPwd = Utility.encryptLatest(input);
        if (encryptedPwd == null) {
            return null;
        }
        return AES_128_PREFIX + encryptedPwd;
    }

    public static String decryptLatestForDB(String value) {
        String decryptedPassword = null;
        try {
            if (!StringUtilities.isEmpty(value) && value.startsWith(AES_128_PREFIX)) {
                value = value.substring(5);
                decryptedPassword = Utility.decryptLatest(value);
            }
        }
        catch (Exception e1) {
            System.out.println("decryptLatestForDB >> Exception while decrypting input");
            decryptedPassword = null;
        }
        return decryptedPassword;
    }

    public static String decryptLatest(String input, byte[] raw) {
        if (StringUtilities.isEmpty(input) || input.equalsIgnoreCase("null")) {
            return null;
        }
        if (raw == null) {
            return null;
        }
        if (raw.length != 16) {
            return null;
        }
        try {
            SecretKeySpec skeySpec = new SecretKeySpec(raw, "AES");
            Cipher cipher = SymantecCipher.getInstance("AES/ECB/PKCS5Padding");
            cipher.init(2, skeySpec);
            byte[] original = cipher.doFinal(Utility.fromHexString(input));
            String originalString = new String(original, UTF_8_CharSet);
            return originalString;
        }
        catch (Exception e1) {
            System.out.println("Exception while decrypting input:" + e1.getMessage());
            LoggerUtilities.logException(e1);
            return null;
        }
    }

    public static char[] decryptLatestasChar(String input, byte[] raw) {
        if (input == null) {
            return null;
        }
        if (raw == null) {
            return null;
        }
        if (raw.length != 16) {
            return null;
        }
        try {
            SecretKeySpec skeySpec = new SecretKeySpec(raw, "AES");
            Cipher cipher = SymantecCipher.getInstance("AES/ECB/PKCS5Padding");
            cipher.init(2, skeySpec);
            byte[] original = cipher.doFinal(Utility.fromHexString(input));
            char[] output = Utility.byteToChar(original);
            return output;
        }
        catch (Exception e1) {
            System.out.println("Exception while decrypting input:" + e1.hashCode());
            return null;
        }
    }

    public static String decryptLatest(String value) {
        return Utility.decryptLatest(value, Utility.getDefaultKey128());
    }

    public static String decryptLatestForBackwardCompatibility(String value) {
        String returnVal = null;
        if (value != null) {
            if (value.startsWith("{DES}")) {
                try {
                    returnVal = Utility.decrypt(value);
                }
                catch (GeneralSecurityException e1) {
                    System.out.println("Utility> decryptLatestForBackwardCompatibility>> a general security exception has occurred");
                }
                catch (IOException e1) {
                    System.out.println("Utility> decryptLatestForBackwardCompatibility>> an io security exception has occurred");
                }
            } else {
                if (value.startsWith(AES_128_PREFIX)) {
                    value = value.substring(AES_128_PREFIX.length());
                }
                returnVal = Utility.decryptLatest(value, Utility.getDefaultKey128());
            }
        }
        return returnVal;
    }

    public static char[] decryptLatestasChar(String input) {
        return Utility.decryptLatestasChar(input, Utility.getDefaultKey128());
    }

    public static String encryptWithoutFormatString(String value, byte[] key) throws GeneralSecurityException, IOException {
        if (value == null) {
            return null;
        }
        String enCryptedString = Utility.encryptLatest(value.toCharArray(), key);
        return enCryptedString;
    }

    public static String decryptWithoutFormatString(String value, byte[] key) throws GeneralSecurityException, IOException {
        return Utility.decryptLatest(value, key);
    }

    public static String decrypt(String value) throws GeneralSecurityException, IOException {
        if (value != null && value.startsWith(AES_128_PREFIX)) {
            return Utility.decryptLatestForDB(value);
        }
        return Utility.decryptDES(value, Utility.getDefaultKey());
    }

    public static String decryptDBPassword(String value) throws GeneralSecurityException, IOException {
        if (value != null) {
            if (value.startsWith("{DES}")) {
                return Utility.decrypt(value);
            }
            if (value.startsWith(AES_128_PREFIX)) {
                return Utility.decryptLatestForDB(value);
            }
        }
        return null;
    }

    public static String decryptDES(String value, byte[] key) throws GeneralSecurityException, IOException {
        if (value == null) {
            return null;
        }
        if (!value.startsWith("{DES}")) {
            return value;
        }
        value = value.substring(5);
        Cipher cipher = SymantecCipher.getInstance("DES");
        DESKeySpec desKeySpec = new DESKeySpec(key);
        SecretKey desKey = SecretKeyFactory.getInstance("DES").generateSecret(desKeySpec);
        cipher.init(2, desKey);
        byte[] data = Base64Util.decode(value);
        byte[] password = cipher.doFinal(data);
        return new String(password, StandardCharsets.UTF_8);
    }

    public static boolean deleteIETemporaryInternetFiles() {
        String[] cmd = new String[]{"RunDll32.exe", "InetCpl.cpl,ClearMyTracksByProcess", "8"};
        return Utility.runAndWaitCommand(cmd);
    }

    public static void removeCommunicationSettings(String xml) {
        XmlParser parser = new XmlParser();
        if (!parser.readXmlFile(xml)) {
            System.out.println("Utility> removeCommunicationSettings>> Read xml failed:" + xml);
        }
        ArrayList<String> listPath = new ArrayList<String>();
        Document doc = parser.getDocument();
        listPath.add("Profile");
        listPath.add("GlobalGroups");
        listPath.add("CommunicationSettingZone");
        Element comSettingsZone = XmlParser.getElementByPath(listPath, doc);
        if (comSettingsZone != null && comSettingsZone.getParentNode() != null) {
            comSettingsZone.getParentNode().removeChild(comSettingsZone);
            System.out.println("Utility> removeCommunicationSettings>> CommunicationSettingZone was removed!");
        }
        listPath.clear();
        listPath.add("Profile");
        listPath.add("Locations");
        Element locations = XmlParser.getElementByPath(listPath, doc);
        listPath.clear();
        listPath.add("Location");
        ArrayList<Element> listLocations = XmlParser.getChildElementsByPath(listPath, locations);
        for (int iLoc = 0; listLocations != null && iLoc < listLocations.size(); ++iLoc) {
            Element location = listLocations.get(iLoc);
            String name = location.getAttribute("Name");
            listPath.clear();
            listPath.add("CommunicationSettingLink");
            ArrayList<Element> listComLinks = XmlParser.getChildElementsByPath(listPath, location);
            if (listComLinks == null) continue;
            for (int iLink = listComLinks.size() - 1; iLink >= 0; --iLink) {
                Element comLink = listComLinks.get(iLink);
                comLink.getParentNode().removeChild(comLink);
                System.out.println("Utility> removeCommunicationSettings>> CommunicationSettingLink was removed from " + name);
            }
        }
        if (!parser.saveXml(xml)) {
            System.out.println("Utility> removeCommunicationSettings>> Save xml failed: " + xml);
        }
    }

    public static void updatePreferredModeAndGroup(String xml, int preferredMode, String preferredGroup) {
        XmlParser parser = new XmlParser();
        if (!parser.readXmlFile(xml)) {
            logger.log(Level.INFO, "Utility> updatePreferredModeAndGroup>> Info-> read xml failed:" + xml);
        }
        ArrayList<String> listPath = new ArrayList<String>();
        Document doc = parser.getDocument();
        listPath.add("Profile");
        listPath.add("GlobalGroups");
        listPath.add("CommunicationSettingZone");
        Element elementcomSettingsZone = XmlParser.getElementByPath(listPath, doc);
        listPath.clear();
        listPath.add("CommunicationSetting");
        ArrayList<Element> elementcomSettings = XmlParser.getChildElementsByPath(listPath, elementcomSettingsZone);
        if (elementcomSettings != null) {
            for (int i = 0; i < elementcomSettings.size(); ++i) {
                Element elementcomSetting = elementcomSettings.get(i);
                listPath.clear();
                listPath.add("ServerSettings");
                Element elementServerSetting = XmlParser.getChildElementByPath(listPath, elementcomSetting);
                listPath.clear();
                listPath.add("CommConf");
                Element elementCommConf = XmlParser.getChildElementByPath(listPath, elementServerSetting);
                listPath.clear();
                listPath.add("RegisterClient");
                logger.log(Level.INFO, "Utility> updatePreferredModeAndGroup>> Info-> get elementRegisterClient");
                Element elementRegisterClient = XmlParser.getChildElementByPath(listPath, elementCommConf);
                if (elementRegisterClient == null) {
                    logger.log(Level.INFO, "Utility> updatePreferredModeAndGroup>> Info-> add elementRegisterClient");
                    elementRegisterClient = doc.createElement("RegisterClient");
                    elementCommConf.appendChild(elementRegisterClient);
                }
                logger.log(Level.INFO, "Utility> updatePreferredModeAndGroup>> Info-> preferredGroup != null" + (preferredGroup != null));
                if (preferredGroup != null && preferredGroup.length() > 0) {
                    elementRegisterClient.setAttribute("PreferredGroup", preferredGroup);
                }
                elementRegisterClient.setAttribute("PreferredMode", String.valueOf(preferredMode));
            }
        }
        if (!parser.saveXml(xml)) {
            logger.log(Level.INFO, "Utility> updatePreferredModeAndGroup>> Info-> save xml failed: " + xml);
        }
    }

    public static boolean runEncryptor(String commandDir, String inputFilePath, String outputFilePath, boolean deleteInputFileIfSuccess) {
        Utility.delete(outputFilePath);
        File outputFile = new File(outputFilePath);
        String exePath = commandDir + File.separator + EXE_ENCRYPTOR;
        String[] command = new String[]{"\"" + exePath + "\"", "1", "\"" + inputFilePath + "\"", "\"" + outputFilePath + "\""};
        try {
            if (RunCommandHandler.runCommandLine(command) != 0) {
                logger.log(Level.SEVERE, "Utility> runEncryptor>> Error-> Failed to run encryptor!!");
                return false;
            }
        }
        catch (IOException e1) {
            LoggerUtilities.logException(e1);
            return false;
        }
        catch (InterruptedException e1) {
            LoggerUtilities.logException(e1);
            return false;
        }
        if (!outputFile.exists()) {
            logger.log(Level.SEVERE, "Utility> runEncryptor>> Error-> no file is generated! target=" + outputFile.getAbsolutePath());
            return false;
        }
        if (deleteInputFileIfSuccess) {
            File inputFile = new File(inputFilePath);
            if (Utility.delete(inputFilePath)) {
                logger.log(Level.INFO, "Utility> runEncryptor>> deleted source=" + inputFile.getAbsolutePath());
            }
        }
        logger.log(Level.INFO, "Utility> runEncryptor>> OK! target=" + outputFile.getAbsolutePath());
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean runAndWaitCommand(String[] fullCommandLine) {
        StringBuilder arg = new StringBuilder();
        for (String cmd : fullCommandLine) {
            arg.append(cmd + " ");
        }
        logger.log(Level.INFO, arg.toString());
        Process process = null;
        try {
            process = RunCommandHandler.getInstance().getProcess(fullCommandLine);
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "runAndWaitCommand: Error-> Failed to launch: " + Arrays.toString(fullCommandLine));
            LoggerUtilities.logException(ex);
            return false;
        }
        try {
            InputStream is = process.getInputStream();
            byte[] buf = new byte[1024];
            int read = 0;
            while ((read = is.read(buf)) > 0) {
                System.out.print(new String(buf, 0, read, "ISO-8859-1"));
            }
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "runAndWaitCommand: Error-> Failed to read the input stream of process!");
            LoggerUtilities.logException(ex);
        }
        try {
            process.waitFor();
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "runAndWaitCommand: Error-> Failed to wait for the prcoess!");
            LoggerUtilities.logException(ex);
        }
        finally {
            RunCommandHandler.getInstance().closeProcess(process);
        }
        return true;
    }

    public static boolean createAgentFormatProfile(byte[] data, String newFilePath) {
        XmlParser parser = new XmlParser();
        if (!parser.readXmlByets(data)) {
            logger.log(Level.SEVERE, "createAgentFormatProfile: Error-> failed to read data!");
            return false;
        }
        Element elementProfile = parser.getRootElement();
        XmlParser parserAgent = new XmlParser();
        Document doc = parserAgent.newDocument();
        Element elementTridentConfig = doc.createElement("TridentConfig");
        Element cloneProfile = XMLHelper.cloneElement(doc, elementProfile);
        elementTridentConfig.appendChild(cloneProfile);
        doc.appendChild(elementTridentConfig);
        if (!parserAgent.saveXml(newFilePath)) {
            logger.log(Level.SEVERE, "createAgentFormatProfile: Error-> failed to save file:" + newFilePath);
            return false;
        }
        return true;
    }

    public static boolean createLinuxAgentFormatProfile(byte[] data, String newFilePath) {
        XmlParser parser = new XmlParser();
        if (!parser.readXmlByets(data)) {
            logger.log(Level.SEVERE, "createLinuxAgentFormatProfile: Error-> failed to read data!");
            return false;
        }
        Element elementProfile = parser.getRootElement();
        XmlParser parserAgent = new XmlParser();
        Document doc = parserAgent.newDocument();
        Element cloneProfile = XMLHelper.cloneElement(doc, elementProfile);
        doc.appendChild(cloneProfile);
        if (!parserAgent.saveXml(newFilePath)) {
            logger.log(Level.SEVERE, "createLinuxAgentFormatProfile: Error-> failed to save file:" + newFilePath);
            return false;
        }
        return true;
    }

    public static String getDriveLetter(String dirName) {
        String[] components;
        String driveLetter = null;
        if (dirName != null && dirName.length() > 0 && (components = dirName.split(IPV6_DELIMITER)).length >= 1) {
            driveLetter = components[0];
        }
        return driveLetter;
    }

    public static String getSizeOnDisk(long size) {
        String sizeOnDisk = null;
        MessageResources MR = MessageResources.getInstance();
        if (size > 0L && size < 1024L) {
            sizeOnDisk = size + " " + MR.getString("com.sygate.scm.console.ui.client.client", "PackageWorker.bytes");
        } else if (size > 1024L && size < 0x100000L) {
            sizeOnDisk = size / 1024L + " " + MR.getString("com.sygate.scm.console.ui.client.client", "PackageWorker.KB");
        } else if (size > 0x100000L && size < 0x40000000L) {
            sizeOnDisk = size / 0x100000L + " " + MR.getString("com.sygate.scm.console.ui.client.client", "PackageWorker.MB");
        } else if (size > 0x40000000L) {
            sizeOnDisk = size / 0x40000000L + " " + MR.getString("com.sygate.scm.console.ui.client.client", "PackageWorker.GB");
        }
        return sizeOnDisk;
    }

    public static String getTempDir() {
        String temp = System.getProperty("java.io.tmpdir");
        if (temp.endsWith("\\") || temp.endsWith("/")) {
            temp = temp.substring(0, temp.length() - 1);
        }
        return temp;
    }

    public static String getCatalinaHomeBinDir() {
        String temp = System.getProperty("catalina.home");
        if (temp.endsWith("\\") || temp.endsWith("/")) {
            temp = temp.substring(0, temp.length() - 1);
        }
        return temp + File.separator + "bin";
    }

    public static Path getAPPDATADir() {
        String osName = System.getProperty(OS_NAME_PROPERTY_KEY);
        Path appDataDir = osName.startsWith(WINDOWS_OS_NAME_PREFIX) ? Path.of(System.getenv("APPDATA"), "Symantec", "Symantec Endpoint Protection Manager") : (osName.startsWith("Mac") ? Path.of(System.getenv("HOME"), "Library", "Application Support", "SEPM") : Path.of(System.getenv("HOME"), ".SEPM"));
        return appDataDir;
    }

    public static boolean isMac() {
        return System.getProperty(OS_NAME_PROPERTY_KEY).startsWith("Mac");
    }

    public static boolean isWindows() {
        return System.getProperty(OS_NAME_PROPERTY_KEY).startsWith(WINDOWS_OS_NAME_PREFIX);
    }

    public static String getUniqueName(String newName, List<String> curNameList) {
        Object nameCandi = newName;
        int i = 2;
        while (curNameList.contains(nameCandi)) {
            nameCandi = newName + i++;
        }
        return nameCandi;
    }

    public static boolean isPackageHasFeature(int featureType) {
        return featureType == 105;
    }

    public static String getLuDownloadedContentArrayId() {
        return Utility.calculateHash("B655E64D0A320801000000E164041B79LuDownloadedContentArray");
    }

    public static String getWinHiReqTemplateLibraryId() {
        return Utility.calculateHash("B655E64D0A320801000000E164041B79HiReqTemplateLibrary");
    }

    public static String getMacHiReqTemplateLibraryId() {
        return Utility.calculateHash("B655E64D0A320801000000E164041B79MacHiReqTemplateLibrary");
    }

    public static void washIds(ConfigObject cObj) {
        cObj.init();
        for (ConfigObject configObject : cObj.getChildren()) {
            Utility.washIds(configObject);
        }
    }

    public static String getMrVersion(String luVersion) {
        if (luVersion == null) {
            return null;
        }
        String[] parts = luVersion.split("\\.");
        if (parts.length >= 3) {
            return parts[2];
        }
        return parts[parts.length - 1];
    }

    public static String getMajorVersion(String luVersion) {
        if (luVersion == null) {
            return null;
        }
        String[] parts = luVersion.split("\\.");
        if (parts.length >= 2) {
            return parts[0] + "." + parts[1];
        }
        return luVersion;
    }

    public static boolean saveFile(InputStream in, String fileName) throws IOException {
        if (in == null || fileName == null || fileName.length() == 0) {
            return false;
        }
        File file = new File(fileName);
        if (!file.getParentFile().exists() && !file.getParentFile().mkdirs()) {
            return false;
        }
        byte[] buff = new byte[1024];
        int len = -1;
        try (BufferedOutputStream outStream = new BufferedOutputStream(new FileOutputStream(fileName));){
            while ((len = in.read(buff, 0, 1024)) != -1) {
                ((OutputStream)outStream).write(buff, 0, len);
            }
            ((OutputStream)outStream).flush();
        }
        return true;
    }

    public static String generateBinaryFileID(SoftwarePackage sp) {
        String id = null;
        if (sp != null) {
            PackageLuInfo packageLuInfo = sp.getPackageInfo().getOptPackageLuInfo();
            id = Utility.calculateHash(packageLuInfo.getClientMoniker() + packageLuInfo.getSequenceNumber());
        }
        return id;
    }

    public static LuSesmContentCatalog createLuSesmContentCatalogFromTemplate() {
        try {
            InputStream luCategoryIS = TemplateManager.class.getResourceAsStream("LuSesmContentCatalog.xml");
            Template luCategoryTmpl = TemplateManager.getTemplate(luCategoryIS);
            IOUtilities.closeInputStream(luCategoryIS);
            String luCatalogXml = luCategoryTmpl.getXML();
            Object resPath = null;
            String pkgPath = TemplateManager.class.getPackage().getName();
            pkgPath = pkgPath != null && (long)pkgPath.indexOf(46) != -1L ? pkgPath.replace('.', '/') : "";
            URL location = TemplateManager.class.getResource("LuSesmContentCatalog_en.properties");
            if (location == null) {
                location = TemplateManager.class.getResource("LuSesmContentCatalog.properties");
            }
            if (location == null) {
                String language = Locale.getDefault().getLanguage();
                location = TemplateManager.class.getResource("LuSesmContentCatalog_" + language + ".properties");
            }
            if (location == null) {
                logger.log(Level.SEVERE, "Error occurs in method <createLuSesmContentCatalog>. property file can't be found!");
                return null;
            }
            LuSesmContentCatalog luCatGroupList = null;
            if ("jar".equals(location.getProtocol())) {
                String path = location.getPath();
                path = path.substring(5, path.lastIndexOf(33));
                path = URLDecoder.decode(path, "UTF-8");
                String tmpdir = System.getProperty("java.io.tmpdir") + File.separator + "lusesmtemp";
                ZipUtil.unzipFile(path, tmpdir);
                resPath = tmpdir + File.separator + pkgPath;
                luCatGroupList = GenerateLocalLUCC.resolveI18nTagsFromXml(luCatalogXml, (String)resPath);
                ZipUtil.deleteFolder(tmpdir);
            } else {
                resPath = new File(location.toURI()).getParent();
                luCatGroupList = GenerateLocalLUCC.resolveI18nTagsFromXml(luCatalogXml, (String)resPath);
            }
            DeterministicIdWasher.resetLuSesmContentCatalogIDs(luCatGroupList);
            return luCatGroupList;
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "Error occurs in method <createLuSesmContentCatalog>.");
            LoggerUtilities.logException(ex);
            return null;
        }
    }

    public static void setDefaultSupportClientPlatformsForLuConfig(LuConfig luConfig) {
        LuSupportedClientPlatforms luplatforms = new LuSupportedClientPlatforms();
        luConfig.setOptLuSupportedClientPlatforms(luplatforms);
        LuSupportedClientPlatform platform = new LuSupportedClientPlatform();
        platform.setContent("Win32");
        luplatforms.addLuSupportedClientPlatform(platform);
        platform = new LuSupportedClientPlatform();
        platform.setContent("Win64");
        luplatforms.addLuSupportedClientPlatform(platform);
        platform = new LuSupportedClientPlatform();
        platform.setContent("Mac");
        luplatforms.addLuSupportedClientPlatform(platform);
        platform = new LuSupportedClientPlatform();
        platform.setContent("Linux");
        luplatforms.addLuSupportedClientPlatform(platform);
        platform = new LuSupportedClientPlatform();
        platform.setContent("Linux-ARM64");
        luplatforms.addLuSupportedClientPlatform(platform);
    }

    public static void setDefaultContentSizesForLuConfig(LuConfig luConfig) {
        LuContentSizeSelections luContentSizeSelections = new LuContentSizeSelections();
        luConfig.setOptLuContentSizeSelections(luContentSizeSelections);
        LuContentSizeSelection contentSize = new LuContentSizeSelection();
        contentSize.setOptCategoryName("AV_DEFS");
        contentSize.setOptDownloadSize(3);
        luContentSizeSelections.addLuContentSizeSelection(contentSize);
    }

    public static LuConfig createDefaultSiteLuConfig(LuSesmContentCatalog luCatalog, ScmLicense license) {
        if (luCatalog == null) {
            luCatalog = Utility.createLuSesmContentCatalogFromTemplate();
        }
        LuConfig luConfig = new LuConfig();
        Utility.setDefaultSupportClientPlatformsForLuConfig(luConfig);
        Utility.setDefaultContentSizesForLuConfig(luConfig);
        LuDownloadSchedule schedule = new LuDownloadSchedule();
        schedule.setOptAllowRetry(schedule.getDefAllowRetry());
        schedule.setOptSpecifyTimeRange(Boolean.FALSE);
        schedule.setOptRetryInterval(schedule.getDefRetryInterval());
        schedule.setOptRetryWindow(schedule.getDefRetryWindow());
        schedule.setOptStartTime(0L);
        schedule.setOptEndTime(86340L);
        luConfig.setOptLuDownloadSchedule(schedule);
        LuCategories luCategories = luConfig.getOptLuCategories();
        if (luCategories == null) {
            luCategories = new LuCategories();
            luConfig.setOptLuCategories(luCategories);
        }
        for (int i = 0; i < luCatalog.getLuContentCategoryGroupCount(); ++i) {
            LuContentCategoryGroup group = luCatalog.getLuContentCategoryGroup(i);
            for (int j = 0; j < group.getLuContentCategoryCount(); ++j) {
                LuContentCategory category = group.getLuContentCategory(j);
                if (license == null || !category.getName().equals("SESM_CONTENT_CATALOG") && !category.getName().equals("SEPM_LIVEUPDATE_DATABASE") && !license.isQualifiedLuContentCategory(category.getName())) continue;
                LuCategory luCategory = new LuCategory();
                luCategory.setCategoryName(category.getName());
                luCategory.setOptFilters(FiltersUtility.getFilters(category.getName()));
                luCategories.addLuCategory(luCategory);
            }
        }
        LuSupportLanguage language = new LuSupportLanguage();
        language.setContent("English");
        luConfig.addLuSupportLanguage(language);
        LuContentSourceInfo sourceInfo = new LuContentSourceInfo();
        luConfig.setOptLuContentSourceInfo(sourceInfo);
        LuHttpProxy http = new LuHttpProxy();
        http.setMode(LuHttpProxy.SYSTEM);
        sourceInfo.setOptLuHttpProxy(http);
        LuFtpProxy ftp = new LuFtpProxy();
        ftp.setMode(LuFtpProxy.SYSTEM);
        sourceInfo.setOptLuFtpProxy(ftp);
        return luConfig;
    }

    public static void setProperty(String name, String value, IniSection section) {
        IniProperty prop = section.getPropertyByName(name);
        if (prop == null && (prop = section.addProperty(name, "", true)) == null) {
            logger.log(Level.SEVERE, "modifySetAidIni: Error-> Failed to retrieve <" + name + ">");
        }
        if (prop != null) {
            prop.setValue(value);
        }
    }

    public static String getProperty(String name, IniSection section) {
        String value = null;
        IniProperty prop = section.getPropertyByName(name);
        if (prop != null) {
            value = prop.getValue();
        }
        return value;
    }

    public static boolean isValidPassword(JFrame parent, char[] pwd, char[] cfmpwd) {
        return Utility.isValidPassword(parent, MessageResources.getInstance().getString("com.sygate.scm.util.util", "Utility.DefaultPassword"), pwd, cfmpwd, 8);
    }

    public static boolean isValidPassword(JFrame parent, char[] pwd, char[] cfmpwd, int minPwdLength) {
        return Utility.isValidPassword(parent, MessageResources.getInstance().getString("com.sygate.scm.util.util", "Utility.DefaultPassword"), pwd, cfmpwd, minPwdLength);
    }

    public static boolean isValidPassword(JFrame parent, String passwordName, char[] pwd, char[] cfmpwd) {
        return Utility.isValidPassword(parent, passwordName, pwd, cfmpwd, 8);
    }

    public static boolean checkPasswdDefaultLength(char[] pwd) {
        return pwd != null && pwd.length >= 8 && pwd.length <= 1024;
    }

    public static boolean isValidPassword(JFrame parent, String passwordName, char[] pwd, char[] cfmpwd, int minPwdLength) {
        String obj = Integer.toString(minPwdLength);
        String str = MessageResources.getInstance().getString("com.sygate.scm.util.util", "Utility.pwdMustLongerThan_Msg");
        String fm = MessageFormat.format(str, obj, passwordName);
        if (pwd.length < minPwdLength) {
            if (parent != null) {
                JOptionPane.showMessageDialog(parent, fm, MessageResources.getInstance().getString("com.sygate.scm.util.util", UTILITY_ERROR), 0);
            }
            return false;
        }
        str = MessageResources.getInstance().getString("com.sygate.scm.util.util", "Utility.pwdMustLessThan_Msg");
        fm = MessageFormat.format(str, Integer.toString(1025), passwordName);
        if (pwd.length > 1024) {
            if (parent != null) {
                JOptionPane.showMessageDialog(parent, fm, MessageResources.getInstance().getString("com.sygate.scm.util.util", UTILITY_ERROR), 0);
            }
            return false;
        }
        fm = MessageFormat.format(MessageResources.getInstance().getString("com.sygate.scm.util.util", "Utility.pwdNotMatchMsg"), passwordName);
        if (!Arrays.equals(pwd, cfmpwd)) {
            if (parent != null) {
                JOptionPane.showMessageDialog(parent, fm, MessageResources.getInstance().getString("com.sygate.scm.util.util", UTILITY_ERROR), 0);
            }
            return false;
        }
        return true;
    }

    public static boolean isValidClientPassword(JFrame parent, String passwordName, char[] pwd, char[] cfmpwd) {
        String str = MessageResources.getInstance().getString("com.sygate.scm.util.util", "Utility.pwdLengthRequirement_Msg");
        String fm = MessageFormat.format(str, Integer.toString(8), Integer.toString(1024), passwordName.strip());
        if (pwd.length < 8 || pwd.length > 1024) {
            if (parent != null) {
                JOptionPane.showMessageDialog(parent, fm, MessageResources.getInstance().getString("com.sygate.scm.util.util", UTILITY_ERROR), 0);
            }
            return false;
        }
        fm = MessageFormat.format(MessageResources.getInstance().getString("com.sygate.scm.util.util", "Utility.pwdNotMatchMsg"), passwordName);
        if (!Arrays.equals(pwd, cfmpwd)) {
            if (parent != null) {
                JOptionPane.showMessageDialog(parent, fm, MessageResources.getInstance().getString("com.sygate.scm.util.util", UTILITY_ERROR), 0);
            }
            return false;
        }
        return true;
    }

    public static boolean passwordHasInvalidChars(char[] password, String allowedChars) {
        if (allowedChars == null || allowedChars.length() == 0) {
            return true;
        }
        for (char element : password) {
            if (allowedChars.indexOf(element) != -1) continue;
            return true;
        }
        return false;
    }

    public static boolean isPasswordCharAllowedForEmbeddedDBA_Popup(JFrame parent, char[] pwd, String username) {
        if (pwd == null) {
            return false;
        }
        if (parent != null && username != null && Utility.passwordHasInvalidChars(pwd, "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789~~`#$%-_+=\\:./'^|&<>[]{}(),?*!@")) {
            String msg = MessageFormat.format(MessageResources.getInstance().getString("com.sygate.scm.util.util", "Utility.pwdCharNotAllowedForEmbeddedDBA"), username);
            CommonUtilities.showErrorMessage(parent, MessageResources.getInstance().getString("com.sygate.scm.util.util", UTILITY_ERROR), msg);
            return false;
        }
        return true;
    }

    public static boolean isPasswordCharAllowedForClientPassword(JFrame parent, char[] pwd) {
        if (pwd == null) {
            return false;
        }
        String strPwd = String.valueOf(pwd);
        if (!strPwd.matches("\\A\\p{ASCII}*\\z")) {
            if (parent != null) {
                CommonUtilities.showErrorMessage(parent, MessageResources.getInstance().getString("com.sygate.scm.util.util", UTILITY_ERROR), MessageResources.getInstance().getString("com.sygate.scm.util.util", "Utility.pwdCharMustBeAscii"));
            }
            return false;
        }
        return true;
    }

    public static boolean isPasswordCharDisallowed(JFrame parent, char[] pwd, String disallowed, String username) {
        String message = MessageResources.getInstance().getString("com.sygate.scm.util.util", "Utility.pwdCharNotAllowed");
        String msg = MessageFormat.format(message, username, disallowed);
        return Utility.isCharDisallowed(parent, pwd, disallowed, username, msg);
    }

    public static boolean isCharDisallowed(JFrame parent, char[] content, String disallowed, String name, String message) {
        if (StringUtilities.isEmpty(disallowed)) {
            return false;
        }
        if (content == null) {
            return false;
        }
        for (char element : content) {
            if (disallowed.indexOf(element) == -1) continue;
            if (parent != null && name != null && message != null) {
                JOptionPane.showMessageDialog(parent, message, MessageResources.getInstance().getString("com.sygate.scm.util.util", UTILITY_ERROR), 0);
            }
            return true;
        }
        return false;
    }

    public static boolean isStrongPassword(String pwd, String specialStr) {
        if (pwd == null || pwd.length() == 0) {
            return false;
        }
        if (pwd.length() < 8) {
            return false;
        }
        int matchTimes = 0;
        Object regExp = null;
        Pattern pattern = null;
        Matcher matcher = null;
        for (int i = 0; i < 4; ++i) {
            switch (i) {
                case 0: {
                    regExp = "([a-z]+)";
                    break;
                }
                case 1: {
                    regExp = "([A-Z]+)";
                    break;
                }
                case 2: {
                    regExp = "([0-9]+)";
                    break;
                }
                default: {
                    regExp = "([" + specialStr.replaceAll("[\\<\\(\\[\\{\\\\\\^\\-\\=\\$\\!\\|\\]\\}\\)\\?\\*\\+\\.\\>]", "\\\\$0") + "]+)";
                }
            }
            pattern = Pattern.compile((String)regExp);
            matcher = pattern.matcher(pwd);
            if (!matcher.find()) continue;
            ++matchTimes;
        }
        return matchTimes >= 3;
    }

    public static SchemaContainer readXML(InputStream is) throws IOException, SAXException, ValidationException {
        Document doc = XMLHelper.parse(is);
        Element e = doc.getDocumentElement();
        if (e != null) {
            SchemaContainer sc = new SchemaContainer();
            sc.importFromElement(e);
            return sc;
        }
        throw new ValidationException("No Valid Element!");
    }

    public static boolean isTrialVersion() {
        return Boolean.parseBoolean(MessageResources.getInstance().getString("com.sygate.scm.util.util", "is.trialware"));
    }

    public static void getAllGroupIds(SemClientGroup aGroup, List<String> groupList) {
        groupList.add(aGroup.getId());
        for (int i = 0; i < aGroup.getSemClientGroupCount(); ++i) {
            Utility.getAllGroupIds(aGroup.getSemClientGroup(i), groupList);
        }
    }

    public static String getValueFromRpcData(RpcData rpcData, String name) {
        if (null == rpcData) {
            return null;
        }
        for (int i = 0; i < rpcData.getNameValuePairCount(); ++i) {
            NameValuePair pair = rpcData.getNameValuePair(i);
            if (!name.equals(pair.getName())) continue;
            return pair.getOptValue();
        }
        return null;
    }

    public static void addPairToRpcData(RpcData rpcData, String name, String value) {
        NameValuePair pair = new NameValuePair();
        pair.setName(name);
        pair.setOptValue(value);
        rpcData.addNameValuePair(pair);
    }

    public static void addSqlParameterToRpcData(RpcData rpcData, String name, String value) {
        if (name.equals("INTEGER") || name.equals("INTEGER_1") || name.equals("INTEGER_2") || name.equals("INTEGER_LIST") || name.equals("PIN_INTEGER")) {
            Utility.addSqlParameterToRpcData(rpcData, name, 13, null, null, value);
        } else if (name.equals("LONG") || name.equals("LONG_1")) {
            Utility.addSqlParameterToRpcData(rpcData, name, 14, null, null, value);
        } else {
            Utility.addSqlParameterToRpcData(rpcData, name, 24, null, null, value);
        }
    }

    public static void addSqlParameterToRpcData(RpcData rpcData, String name, Integer type, String operator, String value) {
        Utility.addSqlParameterToRpcData(rpcData, name, type, null, operator, value);
    }

    public static void addSqlParameterToRpcData(RpcData rpcData, String name, Integer type, String criteria, String operator, String value) {
        SqlParameter para = Utility.createSqlParameter(name, type, criteria, operator, value);
        rpcData.addSqlParameter(para);
    }

    public static SqlParameter createSqlParameter(String name, Integer type, String operator, String value) {
        return Utility.createSqlParameter(name, type, null, operator, value);
    }

    public static SqlParameter createSqlParameter(String name, Integer type, String criteria, String operator, String value) {
        SqlParameter para = new SqlParameter();
        para.setName(name);
        para.setType(type);
        if (criteria != null) {
            para.setOptTableColumnName(criteria);
        }
        if (operator != null) {
            para.setOptOpeartor(operator);
        }
        if (value != null) {
            para.setOptValue(value);
        }
        return para;
    }

    public static String getTimeZoneByOffset(int itimeZoneOffset) {
        Object strTimeZone = "GMT";
        if (itimeZoneOffset != 0) {
            int itimeZoneHour = Math.abs(itimeZoneOffset) / 60;
            Object strTimeZoneHour = itimeZoneOffset > 0 ? "-" : "+";
            strTimeZoneHour = (String)strTimeZoneHour + (itimeZoneHour < 10 ? "0" : "") + Integer.toString(itimeZoneHour);
            int itimeZoneMin = Math.abs(itimeZoneOffset) - itimeZoneHour * 60;
            strTimeZoneHour = (String)strTimeZoneHour + IPV6_DELIMITER + (itimeZoneMin < 10 ? "0" : "");
            strTimeZoneHour = (String)strTimeZoneHour + (itimeZoneMin == 0 ? "0" : Integer.toString(itimeZoneMin));
            strTimeZone = (String)strTimeZone + (String)strTimeZoneHour;
        }
        return strTimeZone;
    }

    public static void moveDirectory(String srcDir, String tgtDir) {
        File srcFolder = new File(srcDir);
        if (!srcFolder.isDirectory()) {
            return;
        }
        File tgtFolder = new File(tgtDir);
        Utility.createDir(tgtDir);
        String[] files = srcFolder.list();
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                String filename = files[i];
                File srcFile = new File(srcFolder + File.separator + filename);
                File tgtFile = new File(tgtFolder + File.separator + filename);
                if (srcFile.isDirectory()) {
                    Utility.moveDirectory(srcFile.getAbsolutePath(), tgtFile.getAbsolutePath());
                    continue;
                }
                Utility.moveFile(srcDir, tgtDir, filename);
            }
            files = srcFolder.list();
            if (files == null || files.length == 0) {
                Utility.deleteDir(srcDir);
            }
        }
    }

    public static boolean moveFile(String srcDir, String tgtDir, String filename) {
        File srcFile = new File(srcDir + File.separator + filename);
        if (!srcFile.exists()) {
            return false;
        }
        Utility.createDir(tgtDir);
        File tgtFile = new File(tgtDir + File.separator + filename);
        if (tgtFile.exists()) {
            if (tgtFile.isDirectory()) {
                Utility.deleteDir(tgtFile.getAbsolutePath());
            } else {
                Utility.deleteFile(tgtFile);
            }
        }
        return srcFile.renameTo(tgtFile);
    }

    public static boolean renameFile(String srcFile, String dstFile) {
        boolean deleteResult;
        boolean result = false;
        if (srcFile == null || srcFile.length() == 0 || dstFile == null || dstFile.length() == 0) {
            return false;
        }
        File srcF = new File(srcFile);
        if (!srcF.exists()) {
            return result;
        }
        File dstF = new File(dstFile);
        if (dstF.exists() && !(deleteResult = dstF.delete())) {
            logger.log(Level.WARNING, "Rename file: while renaming file " + srcFile + ", failed to delete the existing target file " + dstFile);
        }
        result = srcF.renameTo(dstF);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean replaceOrAddALineInsideABlock(File file, String startBlock, String endBlock, String lineToBeReplaced, String replacementOrAddString, boolean replaceOnlyIfFound) throws IOException {
        boolean lineReplacedOrAdded = false;
        if (file.exists()) {
            if (!file.canWrite()) {
                file.setWritable(true);
            }
            BufferedReader fileReader = null;
            BufferedWriter fileWriter = null;
            try {
                fileReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file.getCanonicalPath()), "UTF-8"));
                String currentLineTextFromFile = "";
                boolean blockStarted = false;
                boolean blockEndReached = false;
                StringBuilder buffer = new StringBuilder();
                while ((currentLineTextFromFile = fileReader.readLine()) != null) {
                    String linetext = currentLineTextFromFile.trim();
                    if (!blockStarted || !blockEndReached) {
                        boolean bl = blockStarted = blockStarted ? blockStarted : linetext.contains(startBlock);
                        boolean bl2 = blockEndReached ? blockEndReached : (blockEndReached = blockStarted && linetext.contains(endBlock));
                        if (blockStarted && !blockEndReached && !StringUtilities.isEmpty(lineToBeReplaced) && !linetext.equals("") && !linetext.startsWith("#") && currentLineTextFromFile.contains(lineToBeReplaced)) {
                            currentLineTextFromFile = replacementOrAddString;
                            lineReplacedOrAdded = true;
                        }
                        if (blockStarted && blockEndReached && !lineReplacedOrAdded && !replaceOnlyIfFound) {
                            currentLineTextFromFile = StringUtilities.isEmpty(replacementOrAddString) ? currentLineTextFromFile : replacementOrAddString + System.getProperty("line.separator") + currentLineTextFromFile;
                            lineReplacedOrAdded = true;
                        }
                    }
                    buffer.append(currentLineTextFromFile);
                    buffer.append("\r\n");
                }
                fileWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));
                fileWriter.write(buffer.toString());
                fileWriter.flush();
            }
            catch (Throwable throwable) {
                IOUtilities.closeReader(fileReader);
                IOUtilities.closeWriter(fileWriter);
                throw throwable;
            }
            IOUtilities.closeReader(fileReader);
            IOUtilities.closeWriter(fileWriter);
        }
        return lineReplacedOrAdded;
    }

    public static List<String> readLines(File file, String lineToCheck) throws FileNotFoundException, IOException, Exception {
        ArrayList<String> lineList = new ArrayList<String>();
        if (file.exists() && !StringUtilities.isEmpty(lineToCheck)) {
            try (BufferedReader fileReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file.getCanonicalPath()), "UTF-8"));){
                String currentLineTextFromFile = null;
                while ((currentLineTextFromFile = fileReader.readLine()) != null) {
                    if (!currentLineTextFromFile.contains(lineToCheck)) continue;
                    lineList.add(currentLineTextFromFile);
                }
            }
        }
        return lineList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeLines(File file, String lineToCheck) throws FileNotFoundException, IOException, Exception {
        block7: {
            block6: {
                BufferedWriter fileWriter;
                BufferedReader fileReader;
                block5: {
                    if (!file.exists() || StringUtilities.isEmpty(lineToCheck)) break block6;
                    if (!file.canWrite()) {
                        file.setWritable(true);
                    }
                    boolean lineRemoved = false;
                    fileReader = null;
                    fileWriter = null;
                    try {
                        fileReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
                        String currentLineTextFromFile = null;
                        StringBuilder buffer = new StringBuilder();
                        while ((currentLineTextFromFile = fileReader.readLine()) != null) {
                            if (currentLineTextFromFile.contains(lineToCheck)) {
                                currentLineTextFromFile = "";
                                lineRemoved = true;
                            }
                            buffer.append(currentLineTextFromFile);
                            buffer.append("\r\n");
                        }
                        if (!lineRemoved) break block5;
                        fileWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));
                        fileWriter.write(buffer.toString());
                        fileWriter.flush();
                    }
                    catch (Throwable throwable) {
                        IOUtilities.closeReader(fileReader);
                        IOUtilities.closeWriter(fileWriter);
                        throw throwable;
                    }
                }
                IOUtilities.closeReader(fileReader);
                IOUtilities.closeWriter(fileWriter);
                break block7;
            }
            System.err.println("The target file does not exist or lineToCheck is empty");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addLines(File file, List<String> srcLines) throws FileNotFoundException, IOException, Exception {
        if (file.exists() && srcLines != null && !srcLines.isEmpty()) {
            if (!file.canWrite()) {
                file.setWritable(true);
            }
            BufferedWriter fileWriter = null;
            try {
                fileWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file, true), "UTF-8"));
                for (String line : srcLines) {
                    fileWriter.write("\r\n" + line);
                }
                fileWriter.flush();
            }
            catch (Throwable throwable) {
                IOUtilities.closeWriter(fileWriter);
                throw throwable;
            }
            IOUtilities.closeWriter(fileWriter);
        }
    }

    public static void removeCommentedLines(String filePath, String directiveToBeChecked, HashMap<String, Boolean> mapValues) {
        block15: {
            try {
                File file = new File(filePath);
                if (!file.exists()) break block15;
                if (!file.canWrite()) {
                    file.setWritable(true);
                }
                try (BufferedReader fileReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), Charset.defaultCharset()));){
                    StringBuffer fileContentBuffer = new StringBuffer();
                    char[] buffer = new char[1024];
                    int len1 = fileReader.read(buffer);
                    while (len1 > 0) {
                        fileContentBuffer.append(buffer, 0, len1);
                        len1 = fileReader.read(buffer);
                    }
                    String fileContent = fileContentBuffer.toString();
                    for (Map.Entry<String, Boolean> pair : mapValues.entrySet()) {
                        String regex = "(?im)^#\\s*" + directiveToBeChecked + "\\s+.*" + pair.getKey() + "\"\\s*$";
                        fileContent = fileContent.replaceAll(regex, "");
                    }
                    try (BufferedWriter fileWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));){
                        fileWriter.write(fileContent);
                        fileWriter.flush();
                    }
                }
            }
            catch (IOException ex) {
                System.out.println("Utility> removeCommentedLines>> Exception: " + ex.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String readUncommentedLine(File bakfile, String startBlock, String endBlock, String lineToCheck) throws FileNotFoundException, IOException, Exception {
        BufferedReader fileReader = null;
        String returnLine = null;
        if (!bakfile.exists()) return returnLine;
        try {
            fileReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(bakfile.getCanonicalPath()), "UTF-8"));
            boolean blockStarted = false;
            boolean blockEndReached = false;
            String currentLineTextFromFile = "";
            while ((currentLineTextFromFile = fileReader.readLine()) != null) {
                String linetext = currentLineTextFromFile.trim();
                if (blockStarted && blockEndReached) continue;
                boolean bl = blockStarted = blockStarted ? blockStarted : linetext.contains(startBlock);
                boolean bl2 = blockEndReached ? blockEndReached : (blockEndReached = blockStarted && linetext.contains(endBlock));
                if (!blockStarted || blockEndReached || StringUtilities.isEmpty(lineToCheck) || linetext.equals("") || linetext.startsWith("#") || !currentLineTextFromFile.contains(lineToCheck)) continue;
                returnLine = currentLineTextFromFile;
                break;
            }
        }
        catch (Throwable throwable) {
            IOUtilities.closeReader(fileReader);
            throw throwable;
        }
        IOUtilities.closeReader(fileReader);
        return returnLine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean unCommentALine(File file, String startBlock, String endBlock, String lineToBeUnCommented) throws FileNotFoundException, IOException, Exception {
        boolean lineUnCommented;
        block10: {
            block9: {
                BufferedWriter fileWriter;
                BufferedReader fileReader;
                block8: {
                    fileReader = null;
                    lineUnCommented = false;
                    System.out.println("Uncommenting line...file=" + file.getAbsolutePath() + ", lineToBeUnCommented=" + lineToBeUnCommented);
                    if (!file.exists()) break block9;
                    if (!file.canWrite()) {
                        file.setWritable(true);
                    }
                    fileWriter = null;
                    try {
                        fileReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
                        String currentLineTextFromFile = "";
                        StringBuilder buffer = new StringBuilder();
                        boolean blockStarted = false;
                        boolean blockEndReached = false;
                        while ((currentLineTextFromFile = fileReader.readLine()) != null) {
                            String linetext = currentLineTextFromFile.trim();
                            if (!blockStarted || !blockEndReached) {
                                boolean bl = blockStarted = blockStarted ? blockStarted : linetext.contains(startBlock);
                                boolean bl2 = blockEndReached ? blockEndReached : (blockEndReached = blockStarted && linetext.contains(endBlock));
                                if (blockStarted && !blockEndReached && !StringUtilities.isEmpty(lineToBeUnCommented) && !linetext.equals("") && currentLineTextFromFile.contains(lineToBeUnCommented)) {
                                    if (linetext.startsWith("#")) {
                                        System.out.println("Uncommenting target line: " + currentLineTextFromFile);
                                        currentLineTextFromFile = lineToBeUnCommented;
                                    } else {
                                        System.out.println("The target line has already been uncommented, no need to change: " + currentLineTextFromFile);
                                    }
                                    lineUnCommented = true;
                                }
                            }
                            buffer.append(currentLineTextFromFile);
                            buffer.append("\r\n");
                        }
                        if (!lineUnCommented) break block8;
                        fileWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));
                        fileWriter.write(buffer.toString());
                        fileWriter.flush();
                    }
                    catch (Throwable throwable) {
                        IOUtilities.closeReader(fileReader);
                        IOUtilities.closeWriter(fileWriter);
                        throw throwable;
                    }
                }
                IOUtilities.closeReader(fileReader);
                IOUtilities.closeWriter(fileWriter);
                break block10;
            }
            System.err.println("Error: the target file does not exist!");
        }
        return lineUnCommented;
    }

    public static boolean removeFileFromDir(String fileName, String targetDir) {
        File theFile = new File(fileName);
        File theDir = new File(targetDir);
        boolean succeeded = false;
        if (theDir.exists() && theDir.isDirectory()) {
            if (theFile.exists() && theFile.delete()) {
                succeeded = true;
                logger.log(Level.FINE, "Zip file " + theFile.getAbsolutePath() + " is removed successfully!!");
            } else {
                succeeded = false;
                logger.log(Level.FINE, "removeFileFromDir: Error deleting -> " + fileName + " from directory - " + targetDir);
            }
        } else {
            logger.log(Level.FINE, "removeFileFromDir: Directory -> " + targetDir + " does not exist!");
            succeeded = false;
        }
        return succeeded;
    }

    public static String getOSName() {
        String osName = System.getProperty(OS_NAME_PROPERTY_KEY);
        String osArch = System.getProperty("os.arch");
        String osVersion = System.getProperty("os.version");
        if (osVersion != null) {
            if (osName != null && osName.equalsIgnoreCase("Windows 2003") && osArch != null && osArch.equalsIgnoreCase("x86") && osVersion.equalsIgnoreCase("5.2")) {
                osName = Utility.getOSNameFromRegistry(osName);
            } else if (Utility.isWindowsOS8ORGreater(osVersion)) {
                osName = Utility.getOSNameFromRegistry(osName);
            }
        }
        return osName;
    }

    public static boolean isWindowsVistaOrGreater(String osVersion) {
        String[] osVerArr;
        boolean result = false;
        if (!StringUtilities.isEmpty(osVersion) && (osVerArr = osVersion.split("\\.")).length > 0 && ("10".equals(osVerArr[0]) || "6".equals(osVerArr[0]))) {
            result = true;
        }
        return result;
    }

    public static boolean isWindowsOS8ORGreater(String osVersion) {
        boolean result = false;
        if (!StringUtilities.isEmpty(osVersion)) {
            if ("6.2".equals(osVersion) || "6.3".equals(osVersion)) {
                result = true;
            } else {
                String[] osVerArr = osVersion.split("\\.");
                if (osVerArr.length > 0 && "10".equals(osVerArr[0])) {
                    result = true;
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getOSNameFromRegistry(String defaultOsName) {
        Process p = null;
        try {
            String[] regRead = new String[]{Utility.getRegFullPath(), "QUERY", "HKEY_LOCAL_MACHINE\\Software\\Microsoft\\Windows NT\\CurrentVersion", "/v", "ProductName"};
            p = RunCommandHandler.getInstance().getProcess(regRead);
            p.waitFor();
            try (BufferedReader br = new BufferedReader(new InputStreamReader(p.getInputStream(), StandardCharsets.UTF_8));){
                String line;
                while ((line = br.readLine()) != null) {
                    if (!line.contains("ProductName") || !line.contains(WINDOWS_OS_NAME_PREFIX)) continue;
                    String string = line.substring(line.indexOf(WINDOWS_OS_NAME_PREFIX));
                    RunCommandHandler.getInstance().closeProcess(p);
                    return string;
                }
            }
            RunCommandHandler.getInstance().closeProcess(p);
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, "Utility> getOSNameFromRegistry>> Could not retrieve OS name from Windows Registry <ProductName>. Default to System.getProperty() value.");
            logger.log(Level.WARNING, ex.getMessage());
        }
        finally {
            RunCommandHandler.getInstance().closeProcess(p);
        }
        return defaultOsName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean writeRegValue(String rootKey, String subKey, String type, String valueName, String value) {
        Process p = null;
        int ret = 1;
        try {
            boolean finished;
            Object[] regRead = new String[]{Utility.getRegFullPath(), "ADD", "\"" + rootKey + "\\" + subKey + "\"", "/V", valueName, "/T", type, "/D", value, "/f"};
            logger.log(Level.WARNING, "Utility> writeRegValue>> cmd: {0} ", Arrays.toString(regRead));
            p = RunCommandHandler.getInstance().getProcess((String[])regRead);
            int count = 0;
            while (!(finished = p.waitFor(5L, TimeUnit.SECONDS)) && count++ < 5) {
            }
            if (!finished) {
                p.destroyForcibly();
            }
            ret = p.exitValue();
            logger.log(Level.WARNING, "Utility> writeRegValue>> ret: {0}", ret);
            RunCommandHandler.getInstance().closeProcess(p);
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, "Utility> writeRegValue>> Could not set value to path: {0}", subKey);
            logger.log(Level.WARNING, "Utility> writeRegValue>> Exception: {0}", ex.getMessage());
        }
        finally {
            RunCommandHandler.getInstance().closeProcess(p);
        }
        return ret != 1;
    }

    public static boolean isOSFromWindows8Family() {
        return Utility.isOSFromWindows8Family(Utility.getOSName());
    }

    public static boolean isOSFromWindows8Family(String osString) {
        return !StringUtilities.isEmpty(osString) && ((osString = osString.toLowerCase()).indexOf("windows 8") >= 0 || osString.indexOf("windows nt 6.2") >= 0 || osString.indexOf("windows nt 6.3") >= 0);
    }

    public static boolean isX64Windows() {
        return isX64WindowsOS;
    }

    public static int compareIpStrings(String strIP1, String strIP2) throws IllegalArgumentException {
        byte[] ip1Bytes = Utility.getIpAddressAsBytes(strIP1);
        byte[] ip2Bytes = Utility.getIpAddressAsBytes(strIP2);
        if (ip1Bytes == null || ip2Bytes == null) {
            String errorMsg = "Utiliy>> compareIPStrings: trying to compare invalid IP pair : " + strIP1 + "," + strIP2;
            logger.log(Level.WARNING, errorMsg);
            throw new IllegalArgumentException(errorMsg);
        }
        BigInteger ip1Int = new BigInteger(1, ip1Bytes);
        BigInteger ip2Int = new BigInteger(1, ip2Bytes);
        return ip1Int.compareTo(ip2Int);
    }

    public static boolean hasEnoughDiskSpace(String exeDir, String disk, long sizeRequired) {
        String strFreeBytes;
        logger.log(Level.FINE, "Utiliy>> hasEnoughDiskSpace: sizeRequired=" + sizeRequired);
        if (disk == null || ((String)disk).length() < 1) {
            logger.log(Level.FINE, "Utiliy>> checkDiskSpaceInConsole: Error-> disk is invalid!");
            return false;
        }
        if (((String)disk).endsWith("\\")) {
            disk = (String)disk + "\\";
        }
        if (exeDir == null || exeDir.length() < 1) {
            logger.log(Level.FINE, "Utiliy>> hasEnoughDiskSpace: Warning-> no exe dir!");
            return false;
        }
        String action = "GetDiskSpace";
        String actionParams = "\"" + (String)disk + "\"";
        Properties props = PackageUtil.runScmHelper(exeDir, action, actionParams);
        if (props == null) {
            logger.log(Level.FINE, "Utiliy>> hasEnoughDiskSpace: Warning-> no props returned!");
            return false;
        }
        String errorCode = props.getProperty("ErrorCode");
        if (errorCode == null || errorCode.length() < 1) {
            errorCode = "<unknown>";
        }
        if ((strFreeBytes = props.getProperty("FreeBytes")) == null) {
            logger.log(Level.FINE, "Utiliy>> hasEnoughDiskSpace: Warning-> no props returned! ErrorCode=" + errorCode);
            return false;
        }
        long freeBytes = -1L;
        try {
            freeBytes = Long.parseLong(strFreeBytes);
        }
        catch (Exception ex) {
            logger.log(Level.FINE, "Utiliy>> hasEnoughDiskSpace: Error getting freeBytes info, sizeRequired=" + sizeRequired);
            logger.log(Level.FINE, "Utiliy>> hasEnoughDiskSpace: Error getting freeBytes info, error=" + ex.getLocalizedMessage());
        }
        logger.log(Level.FINE, "Utiliy>> hasEnoughDiskSpace: OK! freeBytes=" + freeBytes + ", sizeRequired=" + sizeRequired);
        if (freeBytes < 0L) {
            logger.log(Level.FINE, "Utiliy>> hasEnoughDiskSpace: Warning-> no props returned! strFreeBytes=" + strFreeBytes + ", ErrorCode=" + errorCode);
            return false;
        }
        logger.log(Level.FINE, "Utiliy>> hasEnoughDiskSpace: OK! freeBytes=" + freeBytes + ", sizeRequired=" + sizeRequired);
        return freeBytes > sizeRequired;
    }

    public static int toInt(long value) {
        return (int)value;
    }

    public static long toLong(int value, boolean toUnsignedLong) {
        return toUnsignedLong && value < 0 ? Integer.toUnsignedLong(value) : (long)value;
    }

    public static long toUnsignedLong(long intValue) {
        if (intValue < 0L && intValue >= Integer.MIN_VALUE) {
            long newValue = Utility.toLong(Utility.toInt(intValue), true);
            logger.log(Level.FINEST, "Utility>> toUnsignedLong: Debug Message: {0}", Utility.getExceptionStackTrace(new Exception("Warning that " + intValue + " was converted to " + newValue)));
            return newValue;
        }
        return intValue;
    }

    public static int parseInt(String string, int defaultValue) {
        int retValue = defaultValue;
        if (!StringUtilities.isEmpty(string)) {
            try {
                retValue = string.indexOf(HEX_PREFIX) == 0 ? Integer.parseInt(string.substring(HEX_PREFIX.length()), 16) : Integer.parseInt(string);
            }
            catch (NumberFormatException nfe) {
                logger.log(Level.WARNING, "Utility>> parseInt error: {0}", nfe.getMessage());
            }
        }
        return retValue;
    }

    public static long parseLong(String string, long defaultValue) {
        long retValue = defaultValue;
        if (!StringUtilities.isEmpty(string)) {
            try {
                retValue = string.indexOf(HEX_PREFIX) == 0 ? Long.parseLong(string.substring(HEX_PREFIX.length()), 16) : Long.parseLong(string);
            }
            catch (NumberFormatException nfe) {
                logger.log(Level.WARNING, "Utility>> parseLong error: {0}", nfe.getMessage());
            }
        }
        return retValue;
    }

    public static String getNumberString(String str) {
        return Utility.getNumberString(str, "0");
    }

    public static String getNumberString(String valueStr, String defaultValue) {
        char[] valueCharArray;
        if (valueStr == null || valueStr.trim().length() < 1) {
            return Utility.getNumberString(defaultValue);
        }
        for (char valueChar : valueCharArray = valueStr.toCharArray()) {
            if (Character.isDigit(valueChar)) continue;
            return Utility.getNumberString(defaultValue);
        }
        return valueStr;
    }

    public static boolean delete(String path) {
        File file = new File(path);
        return Utility.delete(file);
    }

    public static boolean delete(File file) {
        boolean deleted = false;
        if (file == null) {
            logger.log(Level.WARNING, "Utiliy>> delete >> File is null");
            return true;
        }
        if (file.exists()) {
            deleted = file.isDirectory() ? Utility.deleteDir(file) : Utility.deleteFile(file);
            if (!deleted) {
                logger.log(Level.WARNING, "Utiliy>> delete >> Not able to delete file:" + file.getName());
                file.deleteOnExit();
            }
            return deleted;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getCheckSum(File file) throws NoSuchAlgorithmException, NoSuchProviderException, IOException {
        String fileChecksum = null;
        MessageDigest digest = null;
        try (FilterInputStream dis = null;){
            if (file.exists() && file.isFile()) {
                FileInputStream stream = new FileInputStream(file);
                digest = SymantecMessageDigest.getInstance();
                dis = new DigestInputStream(new BufferedInputStream(stream), digest);
                byte[] byteArray = new byte[2048];
                while (dis.read(byteArray) != -1) {
                }
            }
        }
        if (digest != null) {
            fileChecksum = Utility.toHexString(digest.digest());
        }
        return fileChecksum;
    }

    public static boolean deleteDir(File dir) {
        return Utility.deleteDir(dir, false);
    }

    public static boolean deleteDir(File dir, boolean onlyDeleteChildren) {
        String[] children = dir.list();
        if (null != children) {
            for (String element : children) {
                boolean success = Utility.deleteDir(new File(dir, element));
                if (success) continue;
                return false;
            }
        }
        if (onlyDeleteChildren) {
            return true;
        }
        return dir.delete();
    }

    public static boolean isValidHostname(String hostname) {
        String regexp = "^([a-zA-Z][a-zA-Z0-9\\-\\?\\*]{0,62})([\\.]+[a-zA-Z0-9\\-\\?\\*]{0,63})*$";
        Pattern pattern = Pattern.compile(regexp);
        Matcher match = pattern.matcher(hostname);
        if (match.find()) {
            regexp = "[^\\.\\-]$";
            pattern = Pattern.compile(regexp);
            match = pattern.matcher(hostname);
            return match.find();
        }
        regexp = "^([0-9][a-zA-Z0-9\\-\\?\\*]{0,62})([\\.]+[a-zA-Z0-9\\-\\?\\*]{0,63})*[^\\.\\-]$";
        pattern = Pattern.compile(regexp);
        match = pattern.matcher(hostname);
        if (match.find()) {
            regexp = "[a-zA-Z]";
            pattern = Pattern.compile(regexp);
            match = pattern.matcher(hostname);
            return match.find();
        }
        return false;
    }

    public static boolean isValidPort(String port) {
        boolean retVal = false;
        try {
            Integer portNum;
            if (port != null && !port.trim().equals("") && (portNum = Integer.valueOf(port)) >= 0 && portNum <= 65535) {
                return true;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return retVal;
    }

    public static String formatNumberAsString(int number, int noOfDigits) {
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMinimumIntegerDigits(noOfDigits);
        return nf.format(number);
    }

    public static boolean getBooleanValue(String value, Boolean defaultValue) {
        if (value != null) {
            try {
                return Boolean.valueOf(value);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (defaultValue != null) {
            return defaultValue;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static String getSystemDir() {
        int index;
        String comPath;
        block8: {
            Process process = null;
            comPath = null;
            String string = comPath = System.getProperty("ComSpec") == null ? System.getProperty("COMSPEC") : System.getProperty("ComSpec");
            if (comPath != null && comPath.trim().length() != 0) break block8;
            InputStream is = null;
            BufferedReader reader = null;
            try {
                String[] cmd = new String[]{"cmd", "/c", "set"};
                process = RunCommandHandler.getInstance().getProcess(cmd);
                is = process.getInputStream();
                reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                String line = null;
                while ((line = reader.readLine()) != null) {
                    String[] pair = line.split("=", 2);
                    if (pair.length != 2 || pair[0] == null || pair[0].length() <= 0 || pair[1] == null || pair[1].length() <= 0) continue;
                    System.setProperty(pair[0], pair[1]);
                }
                is.close();
                process.waitFor();
            }
            catch (InterruptedException interruptedException) {
                IOUtilities.closeReader(reader);
                IOUtilities.closeInputStream(is);
                RunCommandHandler.getInstance().closeProcess(process);
            }
            catch (IOException iOException) {
                IOUtilities.closeReader(reader);
                IOUtilities.closeInputStream(is);
                RunCommandHandler.getInstance().closeProcess(process);
                {
                    catch (Throwable throwable) {
                        IOUtilities.closeReader(reader);
                        IOUtilities.closeInputStream(is);
                        RunCommandHandler.getInstance().closeProcess(process);
                        throw throwable;
                    }
                }
            }
            IOUtilities.closeReader(reader);
            IOUtilities.closeInputStream(is);
            RunCommandHandler.getInstance().closeProcess(process);
            comPath = System.getProperty("ComSpec") == null ? System.getProperty("COMSPEC") : System.getProperty("ComSpec");
        }
        String systemDir = null;
        if (comPath != null && (index = comPath.lastIndexOf(File.separator)) > -1) {
            systemDir = comPath.substring(0, index);
        }
        return systemDir;
    }

    public static boolean isRegToolExist() {
        String sysDir = Utility.getSystemDir();
        if (!StringUtilities.isEmpty(sysDir)) {
            return new File(sysDir + File.separator + EXE_REG).exists();
        }
        return false;
    }

    public static String getRegFullPath() {
        if (Utility.isRegToolExist()) {
            return Utility.getSystemDir() + File.separator + EXE_REG;
        }
        return EXE_REG;
    }

    public static void setSystemInstallation() {
        System.setProperty(SYSTEM_INSTALLTION_PROPERTY, String.valueOf(Boolean.TRUE));
    }

    public static boolean isSystemInstallation() {
        return Boolean.getBoolean(SYSTEM_INSTALLTION_PROPERTY);
    }

    public static void setSystemUpgrade() {
        System.setProperty(SYSTEM_UPGRADE_PROPERTY, String.valueOf(Boolean.TRUE));
    }

    public static void resetSystemUpgrade() {
        System.setProperty(SYSTEM_UPGRADE_PROPERTY, String.valueOf(Boolean.FALSE));
    }

    public static boolean isSystemUpgrade() {
        return Boolean.getBoolean(SYSTEM_UPGRADE_PROPERTY);
    }

    public static void deleteFileAnyCaseFromFolder(String file, String fullPath) {
        File pathDir = new File(fullPath);
        if (!pathDir.exists()) {
            return;
        }
        String[] fileNames = pathDir.list();
        if (fileNames == null || fileNames.length < 1) {
            return;
        }
        for (String fileName : fileNames) {
            if (fileName == null || fileName.length() <= 0 || !file.toLowerCase(Locale.ENGLISH).equalsIgnoreCase(fileName)) continue;
            File toRemove = new File(fullPath, fileName);
            if (!toRemove.exists()) break;
            Utility.delete(toRemove);
            break;
        }
    }

    public static String getCorrectVersion(String version) {
        String retVersion = null;
        if (Utility.compareVersion(version, "12.1.0.0") > 0) {
            retVersion = "12.1.0.0";
        } else if (Utility.compareVersion(version, "12.0.0.0") > 0) {
            retVersion = "12.0.0.0";
        } else if (Utility.compareVersion(version, "11.0.0.0") > 0) {
            retVersion = "11.0.0.0";
        }
        return retVersion;
    }

    public static long caculateTotalPages(long totalNumber, int maxNumberPerPage) {
        if (totalNumber <= 0L || maxNumberPerPage <= 0) {
            return 1L;
        }
        long testValue = totalNumber % (long)maxNumberPerPage;
        long isResult = totalNumber / (long)maxNumberPerPage;
        return testValue == 0L ? isResult : isResult + 1L;
    }

    public static String getFileNameFromPath(String filePath) {
        if (StringUtilities.isEmpty(filePath)) {
            return null;
        }
        StringTokenizer token = new StringTokenizer(filePath, "/\\");
        String fileName = null;
        while (token.hasMoreElements()) {
            fileName = (String)token.nextElement();
        }
        return fileName;
    }

    public static boolean isFileReadable(String fileName) {
        boolean result = false;
        File file = new File(fileName);
        if (file.exists() && file.canRead()) {
            result = true;
        }
        return result;
    }

    public static boolean isFileWritable(String fileName) {
        boolean result = false;
        File file = new File(fileName);
        if (file.exists() && file.canWrite()) {
            result = true;
        }
        return result;
    }

    public static String getRandomIDString() {
        byte[] randomKey = new byte[256];
        try {
            random = SecureRandom.getInstance(RANDOM_TRANSFORMATION);
            byte[] seed = SecureRandom.getSeed(20);
            random.setSeed(seed);
            randomKey = new byte[32];
            random.nextBytes(randomKey);
        }
        catch (NoSuchAlgorithmException e1) {
            LoggerUtilities.logException(e1);
        }
        if (randomKey == null || randomKey.length < 1) {
            String id = UUID.randomUUID().toString();
            return id.substring(0, 20);
        }
        String key = Utility.toHexString(randomKey, 0, 32);
        return key;
    }

    public static HashMap<String, String> parseURIParameters(String uri) {
        String[] paramArray;
        HashMap<String, String> paramMap = new HashMap<String, String>();
        if (null == uri) {
            return paramMap;
        }
        for (String param : paramArray = uri.split("&")) {
            String name;
            String[] values = param.split("=");
            if (values.length == 0 || (name = values[0]) == null || name.length() == 0) continue;
            String value = "";
            if (values.length > 1) {
                value = values[1];
            }
            paramMap.put(name, value);
        }
        return paramMap;
    }

    public static String getAllLocalHostIPs() {
        StringBuffer ips = new StringBuffer("");
        try {
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            while (interfaces.hasMoreElements()) {
                NetworkInterface ifc = interfaces.nextElement();
                if (!ifc.isUp()) continue;
                Enumeration<InetAddress> addres = ifc.getInetAddresses();
                while (addres.hasMoreElements()) {
                    InetAddress addr = addres.nextElement();
                    if (addr instanceof Inet6Address || addr.isLoopbackAddress()) continue;
                    if (!StringUtilities.isEmpty(ips.toString())) {
                        ips.append(",");
                    }
                    ips.append(addr.getHostAddress());
                }
            }
        }
        catch (Exception e1) {
            LoggerUtilities.logException(e1);
        }
        if (StringUtilities.isEmpty(ips.toString())) {
            ips.append("127.0.0.1");
        }
        return ips.toString();
    }

    public static boolean isJVMServerMode() {
        boolean isServer = false;
        String vmName = System.getProperties().getProperty("java.vm.name");
        if (!StringUtilities.isEmpty(vmName)) {
            isServer = vmName.toLowerCase(Locale.ENGLISH).indexOf(SERVER_MODE) != -1;
        }
        return isServer;
    }

    public static boolean isSameObject(Object o1, Object o2) {
        if (o1 == null) {
            return o2 == null;
        }
        return o1.equals(o2);
    }

    public static Calendar changeTimeZoneToGMTForScheduleHour(int dayOfWeek, int hour, int minute, Calendar from, Calendar to) {
        from.set(7, dayOfWeek + 1);
        from.set(11, hour);
        from.set(12, minute);
        if (from.getTimeZone().inDaylightTime(from.getTime()) ^ from.getTimeZone().inDaylightTime(new Date())) {
            from.set(5, from.get(5) - 7);
        }
        to.setTime(from.getTime());
        return to;
    }

    public static Calendar changeTimeZoneFromGMTForScheduleHour(int dayOfWeek, int hour, int minute, Calendar from, Calendar to) {
        from.set(7, dayOfWeek + 1);
        from.set(11, hour);
        from.set(12, minute);
        to.setTime(from.getTime());
        if (to.getTimeZone().inDaylightTime(to.getTime()) ^ to.getTimeZone().inDaylightTime(new Date())) {
            from.set(5, from.get(5) - 7);
            to.clear();
            to.setTime(from.getTime());
        }
        return to;
    }

    public static String getLanguage() {
        String language = "";
        Locale defaultLocale = Locale.getDefault();
        String countryCode = defaultLocale.getCountry();
        language = countryCode.equalsIgnoreCase("CN") ? "chinese_simple" : (countryCode.equalsIgnoreCase("TW") || countryCode.equalsIgnoreCase("HK") || countryCode.equalsIgnoreCase("SG") ? "chinese_trad" : defaultLocale.getDisplayLanguage(new Locale("en", "us")).toLowerCase(Locale.ENGLISH));
        return language;
    }

    public static String decryptProfileValue(String encryptedValue, byte[] key) throws GeneralSecurityException, IOException {
        if (encryptedValue == null) {
            return null;
        }
        if (key == null) {
            return null;
        }
        byte[] result = Base64Util.decode(encryptedValue);
        byte[] final_bytes = new byte[16];
        System.arraycopy(result, 0, final_bytes, 0, final_bytes.length);
        byte[] pad_bytes = new byte[16];
        System.arraycopy(result, 16, pad_bytes, 0, pad_bytes.length);
        Cipher cipher = SymantecCipher.getInstance("AES/CBC/PKCS5Padding");
        byte[] keyhash = Utility.getKeyHash(key);
        SecretKeySpec aesKey = new SecretKeySpec(keyhash, 0, 16, "AES");
        IvParameterSpec oIV = new IvParameterSpec(pad_bytes, 0, 16);
        cipher.init(2, (Key)aesKey, oIV);
        byte[] data = cipher.doFinal(final_bytes);
        String plainText = new String(data, "UTF-8");
        return plainText;
    }

    public static String encrypt(String key, String value, String initVector) throws GeneralSecurityException, IOException {
        String password = null;
        byte[] finalkey = Utility.getProfileKey(key.getBytes("UTF-8"), Utility.getProfileKey6());
        password = Utility.encryptProfileValue(value, finalkey, initVector);
        return password;
    }

    public static String decrypt(String key, String encryptedPassword) throws GeneralSecurityException, IOException {
        byte[] finalkey = Utility.getProfileKey(key.getBytes("UTF-8"), Utility.getProfileKey6());
        String result = null;
        result = Utility.decryptProfileValue(encryptedPassword, finalkey);
        return result;
    }

    public static void showURL(String url) {
        try {
            Desktop desktop = Desktop.getDesktop();
            if (Desktop.isDesktopSupported() && desktop.isSupported(Desktop.Action.BROWSE)) {
                System.out.println("Use Java.Desktop to browse the link: " + url.trim().replace("^", ""));
                desktop.browse(new URI(url.trim().replace("^", "")));
                System.out.println("Java.Desktop succeeds.");
            } else {
                URLUtility.showURL(url);
            }
        }
        catch (URISyntaxException ex) {
            URLUtility.showURL(url);
        }
        catch (IOException e1) {
            URLUtility.showURL(url);
        }
    }

    public static String convertInvalidIpToBlank(String ipStr) {
        String result = "";
        if (ipStr != null && InetAddressValidator.getInstance().isValid(ipStr) && !ipStr.equals("0.0.0.0")) {
            result = ipStr;
        }
        return result;
    }

    public static long getUsableSpace(String path) {
        return Utility.getDiskFile(path).getUsableSpace();
    }

    public static File getDiskFile(String path) {
        File file = new File(path);
        while (file.getParent() != null) {
            file = file.getParentFile();
        }
        return file;
    }

    public static long getDirSize(File dir) {
        long size = 0L;
        if (dir != null && dir.exists()) {
            if (dir.isFile()) {
                size = dir.length();
            } else {
                File[] subFiles = dir.listFiles();
                if (subFiles != null && subFiles.length > 0) {
                    for (File file : subFiles) {
                        if (file != null && file.isFile()) {
                            size += file.length();
                            continue;
                        }
                        size += Utility.getDirSize(file);
                    }
                }
            }
        }
        return size;
    }

    public static int hasEnoughSpaceforDirCopy(String srcDir, String dstDir, StringBuffer errMsg) {
        int retValue = 1;
        System.out.println("Utility>>hasEnoughSpaceforDirCopy > srcDir:" + srcDir + "!");
        System.out.println("Utility>>hasEnoughSpaceforDirCopy > dstDir:" + dstDir + "!");
        boolean sameDrive = false;
        String srcPath = null;
        String dstPath = null;
        srcPath = Utility.getDriveLetter(srcDir);
        dstPath = Utility.getDriveLetter(dstDir);
        System.out.println("Utility>>hasEnoughSpaceforDirCopy > srcPath:" + srcPath + "!");
        System.out.println("Utility>>hasEnoughSpaceforDirCopy > dstPath:" + dstPath + "!");
        if (srcPath == null || srcPath.isEmpty()) {
            errMsg.append("Driver letter for source directory is empty!");
            return -1;
        }
        if (dstPath == null || dstPath.isEmpty()) {
            errMsg.append("Driver letter for destination directory is empty!");
            return -1;
        }
        if (srcPath.compareToIgnoreCase(dstPath) == 0) {
            sameDrive = true;
        }
        File srcFile = new File(srcDir);
        File dstFile = new File(dstDir);
        if (!srcFile.exists()) {
            errMsg.append("Source directory " + srcDir + " doesn't exist!");
            return -1;
        }
        if (!dstFile.exists()) {
            errMsg.append("Destination directory " + srcDir + " doesn't exist!");
            return -1;
        }
        long requiredSpace = Utility.getDirSize(srcFile);
        long availableSpace = dstFile.getFreeSpace();
        System.out.println("Utility>>hasEnoughSpaceforDirCopy > Required space:" + requiredSpace);
        System.out.println("Utility>>hasEnoughSpaceforDirCopy > Availavle space:" + availableSpace);
        if (sameDrive) {
            if (requiredSpace * 2L > availableSpace) {
                retValue = 0;
            }
        } else if (requiredSpace > availableSpace) {
            retValue = 0;
        }
        return retValue;
    }

    public static boolean validateExportFilePath(JFrame parent, File exportFile, String title, String suffix, boolean isAjaxswing) {
        int option;
        if (suffix == null) {
            return false;
        }
        MessageResourcesFile msgResFile = new MessageResourcesFile("com.sygate.scm.console.handler.handler");
        boolean exportFileHasPostfix = false;
        Object exportFileName = exportFile.getName().toLowerCase(Locale.ENGLISH);
        exportFileHasPostfix = ((String)exportFileName).endsWith(suffix);
        if (!exportFileHasPostfix) {
            exportFileName = (String)exportFileName + suffix;
        }
        if (((String)exportFileName).length() > 255) {
            JOptionPane.showMessageDialog(parent, MessageFormat.format(msgResFile.getString("PolicyHandler.error.ExportFileNameTooLong"), ((String)exportFileName).length()), title, 0);
            return false;
        }
        try {
            int length = exportFile.getCanonicalPath().length();
            if (!exportFileHasPostfix) {
                length += suffix.length();
            }
            if (length > 255) {
                JOptionPane.showMessageDialog(parent, MessageFormat.format(msgResFile.getString("PolicyHandler.error.ExportFilePathTooLong"), length), title, 0);
                return false;
            }
        }
        catch (IOException e1) {
            LoggerUtilities.logException(e1);
        }
        return !exportFile.exists() || isAjaxswing || (option = JOptionPane.showConfirmDialog(parent, MessageFormat.format(msgResFile.getString("PolicyHandler.ExportFileExists"), exportFile.getPath()), msgResFile.getString("PolicyHandler.title.ExportPolicy"), 2)) != 2;
    }

    public static String calculateHashLatest_DefaultSaltLength(String input) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        return Utility.hashString(input, Utility.generateDefaultRandomSaltBytes());
    }

    public static String calculateHashLatest_DefaultSaltLength_byteInput(byte[] input) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        return Utility.hashString(input, Utility.generateDefaultRandomSaltBytes());
    }

    public static byte[] generateDefaultRandomSaltBytes() {
        byte[] randomBytes = new byte[32];
        SecureRandom secureRandom = new SecureRandom();
        secureRandom.nextBytes(randomBytes);
        return randomBytes;
    }

    public static byte[] generateRandomSaltBytes(int saltLengthInBytes) {
        byte[] randomBytes = new byte[saltLengthInBytes];
        SecureRandom secureRandom = new SecureRandom();
        secureRandom.nextBytes(randomBytes);
        return randomBytes;
    }

    public static String calculatePKDBF2Hash_DefaultSaltLengthDefaultWorkFactor(String input) {
        return Utility.calculatePKDBF2Hash_CustomSaltLengthCustomWorkFactor(input, 20000, 16);
    }

    public static String calculatePKDBF2Hash_DefaultSaltLengthCustomWorkFactor(String input, int workFactor) {
        return Utility.calculatePKDBF2Hash_CustomSaltLengthCustomWorkFactor(input, workFactor, 16);
    }

    public static String calculatePKDBF2Hash_CustomSaltLengthDefaultWorkFactor(String input, int saltLengthInBytes) {
        return Utility.calculatePKDBF2Hash_CustomSaltLengthCustomWorkFactor(input, 20000, saltLengthInBytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String calculatePKDBF2Hash_CustomSaltLengthCustomWorkFactor(String input, int workFactor, int saltLengthInBytes) {
        String returnString = null;
        try {
            byte[] saltBytes = Utility.generateRandomSaltBytes(saltLengthInBytes);
            String saltBytesString = Utility.toHexString(saltBytes);
            String hashString = Utility.createPKDBF2Hash(input, saltBytes, workFactor);
            int saltStringLength = saltBytesString.length();
            Object saltStringLengthLength = Integer.toString(saltStringLength);
            if (((String)saltStringLengthLength).length() < 3) {
                saltStringLengthLength = "0" + (String)saltStringLengthLength;
            }
            String workFactorString = Integer.toString(workFactor);
            String workFactorLengthString = Integer.toString(workFactorString.length());
            returnString = (String)saltStringLengthLength + saltBytesString + workFactorLengthString + workFactorString + hashString;
            return returnString;
        }
        catch (AssertionError | Exception t) {
            LoggerUtilities.log("PKDBF2Hash creation failed");
            LoggerUtilities.logException((Throwable)t);
        }
        finally {
            return returnString;
        }
    }

    public static String createPKDBF2Hash(String input, byte[] saltBytes, int workFactor) throws NoSuchAlgorithmException, InvalidKeySpecException, NoSuchProviderException {
        SecretKeyFactory skf = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA512", "SunJCE");
        PBEKeySpec spec = new PBEKeySpec(input.toCharArray(), saltBytes, workFactor, 512);
        SecretKey key = skf.generateSecret(spec);
        byte[] hashBytes = key.getEncoded();
        return Utility.toHexString(hashBytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isEqualPKDBF2Hash(String input, String previousPKDBF2Hash) {
        boolean retVal = false;
        previousPKDBF2Hash = previousPKDBF2Hash.substring(2);
        String saltStringLength = previousPKDBF2Hash.substring(0, 3);
        int saltLength = Integer.parseInt(saltStringLength);
        String saltString = previousPKDBF2Hash.substring(3, saltLength + 3);
        String workFactorLength = previousPKDBF2Hash.substring(saltLength + 3, saltLength + 3 + 1);
        String workFactorString = previousPKDBF2Hash.substring(saltLength + 3 + 1, saltLength + 3 + 1 + Integer.parseInt(workFactorLength));
        String passwordHashString = previousPKDBF2Hash.substring(saltLength + 3 + 1 + Integer.parseInt(workFactorLength));
        byte[] saltBytes = Utility.fromHexString(saltString);
        try {
            String newlyHashedString = Utility.createPKDBF2Hash(input, saltBytes, Integer.parseInt(workFactorString));
            retVal = newlyHashedString.equals(passwordHashString);
            return retVal;
        }
        catch (AssertionError | Exception t) {
            LoggerUtilities.log("PKDBF2Hash creation failed");
            LoggerUtilities.logException((Throwable)t);
        }
        finally {
            return retVal;
        }
    }

    public static boolean isEqualPKDBF2HashWithMD5Seed(String input, String previousPKDBF2Hash) {
        return Utility.isEqualPKDBF2Hash(Utility.calculateHash(input), previousPKDBF2Hash);
    }

    public static boolean isEqualPKDBF2HashwithSHA1Seed(String adminName, String input, String previousPKDBF2Hash) {
        String sha1Hash = Utility.getSHA1HashForPassword(adminName, input);
        return Utility.isEqualPKDBF2Hash(sha1Hash, previousPKDBF2Hash);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getSHA1HashForPassword(String adminName, String password) {
        String pwdHash = null;
        try {
            MessageDigest digest = SymantecMessageDigest.getInstance("SHA-1");
            byte[] buf = digest.digest((adminName + password).getBytes(Charset.defaultCharset()));
            pwdHash = Utility.toHexString(buf);
            return pwdHash;
        }
        catch (NoSuchAlgorithmException e1) {
            System.out.println(e1);
        }
        finally {
            return pwdHash;
        }
    }

    public static byte[] charToBytes(char[] input) {
        byte[] bytes = null;
        try {
            CharsetEncoder encoder = UTF_8_CharSet.newEncoder();
            ByteBuffer byteBuffer = encoder.encode(CharBuffer.wrap(input));
            bytes = Arrays.copyOf(byteBuffer.array(), byteBuffer.limit());
        }
        catch (CharacterCodingException e1) {
            LoggerUtilities.logException(e1);
        }
        return bytes;
    }

    public static char[] byteToChar(byte[] input) {
        char[] chars = null;
        try {
            CharsetDecoder decoder = UTF_8_CharSet.newDecoder();
            CharBuffer charBuffer = decoder.decode(ByteBuffer.wrap(input));
            chars = Arrays.copyOf(charBuffer.array(), charBuffer.limit());
        }
        catch (CharacterCodingException e1) {
            LoggerUtilities.logException(e1);
        }
        return chars;
    }

    public static String extractSalt(String hashedString, int length) {
        return hashedString.substring(2, 2 + length * 2);
    }

    public static String calculateHashLatest_SpecificSaltLength(String input, byte[] saltBytes) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        return Utility.hashString(input, saltBytes);
    }

    public static String createRequestSignature(Hashtable<String, Object> requestTable) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        String consoleUseCase = System.getProperty("consoleusecase");
        if (consoleUseCase != null) {
            requestTable.put("consoleusecase", consoleUseCase);
        }
        String stringToBeHashed = Utility.getRequestStringToBeHashed(requestTable);
        String signatureString = Utility.calculateHashLatest_DefaultSaltLength(stringToBeHashed);
        String encryptedSignature = null;
        encryptedSignature = System.getProperty("SESSION_KEY") != null ? Utility.encryptLatest(signatureString.toCharArray(), Utility.fromHexString(System.getProperty("SESSION_KEY"))) : Utility.encryptLatest(signatureString.toCharArray());
        return encryptedSignature;
    }

    public static boolean isSignatureRequired(String url) throws MalformedURLException {
        String urlPath = new URL(url).getPath();
        return !urlPath.endsWith("php") && !urlPath.endsWith("dll");
    }

    public static String getSHA256HashValueWithSalt(String paramText, String salt) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        int i;
        if (StringUtilities.isEmpty(paramText)) {
            return null;
        }
        byte[] paramTextHex = Utility.fromHexString(paramText);
        byte[] saltHEX = Utility.fromHexString(salt);
        MessageDigest digest = SymantecMessageDigest.getInstance("SHA-256");
        digest.reset();
        byte[] firstHash = digest.digest(paramTextHex);
        byte[] newInputString = new byte[saltHEX.length + firstHash.length];
        for (i = 0; i < saltHEX.length; ++i) {
            newInputString[i] = saltHEX[i];
        }
        i = saltHEX.length;
        int j = 0;
        while (i < newInputString.length) {
            newInputString[i] = firstHash[j];
            ++i;
            ++j;
        }
        digest = SymantecMessageDigest.getInstance("SHA-256");
        digest.reset();
        byte[] btInputString = digest.digest(newInputString);
        String inputString = Utility.toHexString(btInputString);
        String markerString = Utility.toHexString(new byte[]{1});
        String saltString = Utility.toHexString(saltHEX);
        String returnString = markerString + saltString + inputString;
        return returnString;
    }

    private static String hashString(String input, byte[] salt) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        if (input == null) {
            return null;
        }
        return Utility.hashString(input.getBytes("UTF-8"), salt);
    }

    private static String hashString(byte[] input, byte[] salt) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        int i;
        if (input == null) {
            return null;
        }
        MessageDigest digest = SymantecMessageDigest.getInstance("SHA-256");
        digest.reset();
        byte[] firstHash = digest.digest(input);
        byte[] newInputString = new byte[salt.length + firstHash.length];
        for (i = 0; i < salt.length; ++i) {
            newInputString[i] = salt[i];
        }
        i = salt.length;
        int j = 0;
        while (i < newInputString.length) {
            newInputString[i] = firstHash[j];
            ++i;
            ++j;
        }
        digest = SymantecMessageDigest.getInstance("SHA-256");
        digest.reset();
        byte[] btInputString = digest.digest(newInputString);
        String inputString = Utility.toHexString(btInputString);
        String markerString = Utility.toHexString(new byte[]{1});
        String saltString = Utility.toHexString(salt);
        String returnString = markerString + saltString + inputString;
        return returnString;
    }

    public static String getRequestStringToBeHashed(Hashtable<String, Object> testTable) {
        Set<String> enumeration = testTable.keySet();
        ArrayList<String> list = new ArrayList<String>(enumeration);
        Collections.sort(list);
        StringBuilder builder = new StringBuilder();
        String delimiter = "";
        for (String s : list) {
            builder.append(delimiter);
            builder.append(s + "=" + testTable.get(s));
            delimiter = ",";
        }
        return builder.toString();
    }

    public static String getEmbeddedDbServerName() {
        Object dbServerName = "localhost";
        String hostName = null;
        try {
            hostName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException ex) {
            System.out.println("getEmbeddedDbServerName>> Exception while getting hostname: " + ex.toString());
        }
        if (hostName != null) {
            dbServerName = "SEPM_" + hostName;
        }
        return dbServerName;
    }

    public static void exitSystem(int exitCode) {
        System.exit(exitCode);
    }

    public static boolean isIntegerEquals(Integer integer1, Integer integer2) {
        if (integer1 == null && integer2 == null) {
            return true;
        }
        if (integer1 != null && integer2 != null) {
            return integer1.intValue() == integer2.intValue();
        }
        return false;
    }

    public static boolean isBooleanEquals(Boolean bool1, Boolean bool2) {
        if (bool1 == null && bool2 == null) {
            return true;
        }
        if (bool1 != null && bool2 != null) {
            return bool1.booleanValue() == bool2.booleanValue();
        }
        return false;
    }

    public static boolean setRegistryValueForSymQual(String exeDir, String installFolder, String dataFolder) {
        logger.log(Level.FINE, "Utiliy>> setRegistryValueForSymQual: installFolder=" + installFolder + ", dataFolder=" + dataFolder);
        if (StringUtilities.isEmpty(installFolder) || StringUtilities.isEmpty(dataFolder)) {
            return false;
        }
        if (StringUtilities.isEmpty(exeDir)) {
            logger.log(Level.SEVERE, "Utiliy>> setRegistryValueForSymQual: Warning-> no exe dir!");
            return false;
        }
        String action = "SetRegistryForSymQual";
        String actionParams = "\"" + installFolder + "\" \"" + dataFolder + "\"";
        Properties props = PackageUtil.runScmHelper(exeDir, action, actionParams);
        if (props == null) {
            logger.log(Level.SEVERE, "Utiliy>> setRegistryValueForSymQual: Warning-> no props returned!");
            return false;
        }
        logger.log(Level.FINE, "Utiliy>> setRegistryValueForSymQual: OK!");
        return true;
    }

    public static int compareJVM(String jvm1, String jvm2) throws Exception {
        int result = 0;
        String jvmPrefix = "-Xmx";
        if (jvm1.indexOf("-Xms") >= 0) {
            jvmPrefix = "-Xms";
            if (jvm2.indexOf("-Xmx") >= 0) {
                throw new Exception("Need both parameter starts from same prefix -Xms or -Xmx!");
            }
        } else if (jvm1.indexOf("-Xmx") >= 0) {
            jvmPrefix = "-Xmx";
            if (jvm2.indexOf("-Xms") >= 0) {
                throw new Exception("Need both parameter starts from same prefix -Xms or -Xmx!");
            }
        } else {
            throw new Exception("Need both parameter starts from same prefix -Xms or -Xmx!");
        }
        int intJvm1 = Integer.parseInt(jvm1.substring(jvmPrefix.length(), jvm1.length() - 1));
        int intJvm2 = Integer.parseInt(jvm2.substring(jvmPrefix.length(), jvm2.length() - 1));
        result = intJvm1 - intJvm2;
        return result;
    }

    private static boolean initIsX64WindowsOS() {
        String[] envVars;
        boolean is64bitOS = false;
        for (String envVar : envVars = new String[]{"PROCESSOR_ARCHITEW6432", "PROCESSOR_ARCHITECTURE"}) {
            String osArch = System.getenv(envVar);
            if (osArch == null) continue;
            boolean bl = is64bitOS = osArch.equalsIgnoreCase("AMD64") || osArch.equalsIgnoreCase("x64");
            if (is64bitOS) break;
        }
        return is64bitOS;
    }

    public static boolean isHidSupported(String productVersion) {
        boolean result = false;
        if (Utility.compareVersion(productVersion, "14.0.0.1000", true) >= 0) {
            result = true;
        }
        return result;
    }

    public static boolean isLowBandwidthSupported(String productVersion) {
        boolean result = false;
        if (Utility.compareVersion(productVersion, "14.0.0.1000", true) >= 0) {
            result = true;
        }
        return result;
    }

    public static boolean isWtrSupported(String productVersion) {
        return Utility.compareVersion(productVersion, "14.0.0.1100", true) >= 0;
    }

    public static boolean isTDADSupported(String productVersion) {
        return Utility.compareVersion(productVersion, "14.2.0.1000", true) >= 0;
    }

    public static boolean isPepSupported(String productVersion) {
        boolean result = false;
        if (Utility.compareVersion(productVersion, "14.0.0.0", true) >= 0) {
            result = true;
        }
        return result;
    }

    public static boolean isMemSupported(String productVersion) {
        boolean result = false;
        if (Utility.compareVersion(productVersion, "14.0.0.1000", true) >= 0) {
            result = true;
        }
        return result;
    }

    public static boolean isAcDcSupported(String productVersion) {
        return Utility.compareVersion(productVersion, "14.3.0.4000", true) >= 0;
    }

    public static boolean isMac(String osType) {
        if (osType == null) {
            return false;
        }
        return (Utility.parseLong(osType, 0L) & (long)ActionConstants.MAC_OS_BIT_AND.intValue()) == (long)ActionConstants.MAC_OS_ALL.intValue();
    }

    public static boolean isLinux(Long osType) {
        if (osType == null) {
            return false;
        }
        return ((long)ActionConstants.LINUX_OS_BIT_AND.intValue() & osType) == (long)ActionConstants.LINUX_OS_ALL.intValue();
    }

    public static String getIpAddressLiteral(byte[] addressInBytes) {
        if (addressInBytes == null || addressInBytes.length == 0) {
            return null;
        }
        if (addressInBytes.length != 4 && addressInBytes.length != 16) {
            logger.log(Level.SEVERE, String.format("getIPAddressLiteral: can not convert given byte array to IP address literal : [%s] in hexString (Is it 4 or 16 bytes data ?)", Utility.toHexString(addressInBytes)));
            return null;
        }
        try {
            String addressStr = InetAddress.getByAddress(addressInBytes).getHostAddress();
            return addressStr;
        }
        catch (UnknownHostException e1) {
            logger.log(Level.SEVERE, String.format("getIPAddressLiteral: can not convert given byte array to IP address literal : [%s] in hexString", Utility.toHexString(addressInBytes)));
            LoggerUtilities.logException(e1);
            return null;
        }
    }

    public static byte[] getIpAddressAsBytes(String addressLiteral) {
        if (null == addressLiteral) {
            logger.log(Level.FINE, "getIPAddressAsBytes: null IP address string literal");
            return null;
        }
        String ipLiteral = addressLiteral;
        if (ipLiteral.indexOf("%") >= 0) {
            ipLiteral = ipLiteral.substring(0, ipLiteral.indexOf("%"));
        }
        if (!InetAddressValidator.getInstance().isValid(ipLiteral)) {
            logger.log(Level.FINE, String.format("getIPAddressAsBytes: invalid IP address string literal : [%s]", ipLiteral));
            return null;
        }
        try {
            return InetAddress.getByName(ipLiteral).getAddress();
        }
        catch (UnknownHostException ex) {
            logger.log(Level.SEVERE, String.format("getIPAddressAsBytes: invalid IP address string literal : [%s] : InetAddress.getByName() failed", addressLiteral));
            LoggerUtilities.logException(ex);
            return null;
        }
    }

    public static byte[] getIpAddressAsBytesFromLogEntryStr(String ipAddress) {
        if (!ipAddress.contains(".") && !ipAddress.contains(IPV6_DELIMITER)) {
            ipAddress = Utility.getIPString(Long.parseLong(ipAddress));
        }
        return Utility.getIpAddressAsBytes(ipAddress);
    }

    public static int convertNetmaskToCidr(String subnetMaskString) {
        if (subnetMaskString == null) {
            logger.log(Level.FINE, "Utiliy>> convertNetmaskToCIDR: Warning-> invalid netmask string : null");
            return 0;
        }
        if (subnetMaskString.matches("^\\d+$") && Integer.parseInt(subnetMaskString) >= 0 && Integer.parseInt(subnetMaskString) <= 128) {
            return Integer.parseInt(subnetMaskString);
        }
        try {
            InetAddress netmask = InetAddress.getByName(subnetMaskString);
            byte[] netmaskBytes = netmask.getAddress();
            int cidr = 0;
            boolean zero = false;
            for (byte b : netmaskBytes) {
                int mask = 128;
                for (int i = 0; i < 8; ++i) {
                    int result = b & mask;
                    if (result == 0) {
                        zero = true;
                    } else {
                        if (zero) {
                            logger.log(Level.SEVERE, "Utiliy>> convertNetmaskToCIDR: Warning-> invalid netmask string : " + subnetMaskString);
                            return 0;
                        }
                        ++cidr;
                    }
                    mask >>>= 1;
                }
            }
            return cidr;
        }
        catch (UnknownHostException ex) {
            logger.log(Level.SEVERE, "Utiliy>> convertNetmaskToCIDR: Warning-> invalid netmask string : " + subnetMaskString);
            LoggerUtilities.logException(ex);
            return 0;
        }
    }

    public static String convertCidrToNetmask(int cidr) {
        if (cidr < 0 || cidr > 32) {
            logger.log(Level.SEVERE, "Utiliy>> convertCIDRToNetmask: Warning-> invalid CIDR : " + cidr);
            return null;
        }
        if (cidr == 0) {
            return "0.0.0.0";
        }
        long max = 0xFFFFFFFFL;
        long substractingValue = (long)Math.pow(2.0, 32 - cidr) - 1L;
        long numericIp = max - substractingValue;
        return Utility.getIPStringEx(numericIp);
    }

    public static boolean isLinkLocalAddress(String ip) {
        if (ip == null) {
            return false;
        }
        return ip.toUpperCase().startsWith("FE80");
    }

    public static String shortenIfIpv6Address(String value) {
        if (Utility.isValidIpv6Address(value)) {
            value = Utility.shortenIpv6Address(value);
        }
        return value;
    }

    public static String shortenIpv6Address(String ip) {
        if (null == ip | "".equals(ip)) {
            return ip;
        }
        if (ip.contains(".") && !ip.contains(IPV6_DELIMITER)) {
            return ip;
        }
        if (ip.contains("::") && ip.contains(".")) {
            return Utility.convertMixedIptoPureIpv6(ip);
        }
        if (ip.contains("::")) {
            return ip;
        }
        ip = ip.toLowerCase();
        if ((ip = ip.replaceAll("(^|[^0-9a-f])0+([0-9a-f])", "$1$2")).contains(".")) {
            ip = Utility.convertMixedIptoPureIpv6(ip);
        }
        ip = Utility.replaceLongestChainOfZeroBytes(ip);
        return ip;
    }

    private static String convertMixedIptoPureIpv6(String ip) {
        String[] ipAddrBlocks = ip.split(IPV6_DELIMITER);
        String ipv4Block = ipAddrBlocks[ipAddrBlocks.length - 1];
        Object last2BlocksInHex = "";
        try {
            Inet6Address inetAddress = (Inet6Address)Inet6Address.getByName("::" + ipv4Block);
            String[] mixedModeLast2BytesArray = inetAddress.toString().split(IPV6_DELIMITER);
            last2BlocksInHex = ipAddrBlocks[ipAddrBlocks.length - 2].equals("") && mixedModeLast2BytesArray[6].equals("0") ? mixedModeLast2BytesArray[7] : mixedModeLast2BytesArray[6] + IPV6_DELIMITER + mixedModeLast2BytesArray[7];
            ip = ip.replace(ipv4Block, (CharSequence)last2BlocksInHex);
        }
        catch (UnknownHostException ex) {
            logger.log(Level.SEVERE, "utility>>convertMixedIptoPureIpv6>>Invalid IPv6 address." + ex.getMessage());
        }
        return ip;
    }

    private static String replaceLongestChainOfZeroBytes(String ip) {
        int index = 0;
        int maxLength = 0;
        int ipLength = ip.length();
        for (int i = 0; i < ipLength; ++i) {
            int tempIndex = i;
            int tempLength = 0;
            if (i == 0 && ip.charAt(0) == '0') {
                tempLength += 2;
                ++i;
            }
            while (i < ipLength - 1 && ":0".equals(ip.substring(i, i + 2))) {
                tempLength += 2;
                i += 2;
            }
            if (maxLength >= tempLength) continue;
            maxLength = tempLength;
            index = tempIndex;
        }
        if (maxLength > 2) {
            if (index > 0 && index + maxLength < ip.length()) {
                ip = ip.replaceFirst(ip.substring(index, index + maxLength), IPV6_DELIMITER);
            } else {
                if (index == 0 && maxLength > ip.length()) {
                    ip = ip.replaceFirst(ip.substring(index, maxLength - 1), "::");
                    return ip;
                }
                ip = ip.replaceFirst(ip.substring(index, index + maxLength), "::");
            }
        }
        return ip;
    }

    public static boolean isValidSubnetMaskorCidr(String ipValue, String mask) {
        InetAddressValidator ipValidator = InetAddressValidator.getInstance();
        try {
            if (ipValidator.isValidInet4Address(ipValue)) {
                if (ipValidator.isValidInet4Address(mask) && Utility.convertNetmaskToCidr(mask) != 0) {
                    return true;
                }
                if (Integer.parseInt(mask) > 0 && Integer.parseInt(mask) <= 32) {
                    return true;
                }
            } else if (ipValidator.isValidInet6Address(ipValue)) {
                if (ipValidator.isValidInet6Address(mask) && Utility.convertNetmaskToCidr(mask) != 0) {
                    return true;
                }
                if (Integer.parseInt(mask) > 0 && Integer.parseInt(mask) <= 128) {
                    return true;
                }
            }
        }
        catch (NumberFormatException ex) {
            return false;
        }
        return false;
    }

    public static boolean isTeredoIp(String ip) {
        if (StringUtilities.isEmpty(ip)) {
            return false;
        }
        return ip.startsWith(TEREDO_ADDRESS_PREFIX);
    }

    public static boolean isValidIpv6Address(String ip) {
        if (StringUtilities.isEmpty(ip)) {
            return false;
        }
        ip = Utility.checkAndRemoveBrackets(ip);
        return InetAddressValidator.getInstance().isValidInet6Address(ip);
    }

    public static boolean validatePfx(InputStream storeInputStream, char[] storePass) {
        try {
            KeyStore p12KeyStore = KeyStore.getInstance("PKCS12");
            try {
                p12KeyStore.load(storeInputStream, storePass);
            }
            catch (IOException ex) {
                logger.log(Level.FINEST, "Error in validating Keystore file.");
                return false;
            }
            catch (GeneralSecurityException ex) {
                return false;
            }
            Enumeration<String> aliases = p12KeyStore.aliases();
            String pkeyName = null;
            while (aliases.hasMoreElements()) {
                String element = aliases.nextElement();
                if (!p12KeyStore.isKeyEntry(element)) continue;
                pkeyName = element;
                break;
            }
            if (pkeyName == null) {
                return false;
            }
            PrivateKey privateKey = (PrivateKey)p12KeyStore.getKey(pkeyName, storePass);
            if (privateKey == null) {
                return false;
            }
        }
        catch (GeneralSecurityException ex) {
            return false;
        }
        return true;
    }

    public static boolean passwordMatchesAgainstHash(String dbPasswordHash, String password, String adminName) {
        boolean passwordMatch = false;
        if (dbPasswordHash != null) {
            if (dbPasswordHash.startsWith(MARKER_MD5_SEED)) {
                passwordMatch = Utility.isEqualPKDBF2HashWithMD5Seed(password, dbPasswordHash);
            } else if (dbPasswordHash.startsWith(MARKER_SHA1_SEED)) {
                passwordMatch = Utility.isEqualPKDBF2HashwithSHA1Seed(adminName, password, dbPasswordHash);
            } else if (dbPasswordHash.startsWith(MARKER_PLAINTEXT_SEED)) {
                passwordMatch = Utility.isEqualPKDBF2Hash(password, dbPasswordHash);
            }
        }
        return passwordMatch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] convertInputStreamToBytes(InputStream is, int size, boolean closeInputStream) {
        if (is == null) {
            return null;
        }
        ByteArrayOutputStream bos = null;
        try {
            bos = size <= 0 ? new ByteArrayOutputStream() : new ByteArrayOutputStream(size);
            int intBufferSize = 1024;
            byte[] buffer = new byte[intBufferSize];
            InputStream inputStream = is;
            synchronized (inputStream) {
                int bytesRead;
                while ((bytesRead = is.read(buffer)) != -1) {
                    bos.write(buffer, 0, bytesRead);
                }
            }
        }
        catch (Throwable ex) {
            LoggerUtilities.logException(ex);
            byte[] byArray = null;
            return byArray;
        }
        finally {
            IOUtilities.closeInputStream(is);
            IOUtilities.closeOutputStream(bos);
        }
        byte[] bytes = bos.toByteArray();
        if (bytes == null || bytes.length < 1) {
            logger.log(Level.INFO, "convertInputStreamToBytes: Error-> no data, input size=" + size);
        } else {
            logger.log(Level.INFO, "convertInputStreamToBytes: size=" + bytes.length + ", input size=" + size);
        }
        return bytes;
    }

    public static String checkAndAddBrackets(String hostName) {
        if (hostName != null && ((String)hostName).contains(IPV6_DELIMITER) && !((String)hostName).startsWith(OPENING_SQUARE_BRACKET) && !((String)hostName).endsWith(CLOSING_SQUARE_BRACKET)) {
            hostName = OPENING_SQUARE_BRACKET + (String)hostName + CLOSING_SQUARE_BRACKET;
        }
        return hostName;
    }

    public static String checkAndRemoveBrackets(String hostName) {
        if (hostName != null && hostName.startsWith(OPENING_SQUARE_BRACKET) && hostName.endsWith(CLOSING_SQUARE_BRACKET) && hostName.contains(IPV6_DELIMITER)) {
            hostName = hostName.substring(1, hostName.length() - 1);
        }
        return hostName;
    }

    public static String getOriginalFilename(String filename) {
        int index = filename.indexOf("_");
        if (index != -1 && index > 0 && (index = filename.indexOf("_", index + 1)) != -1 && index > 0) {
            return filename.substring(index + 1);
        }
        return filename;
    }

    public static String getFormattedClientVersion(String rawVersion, boolean ignoreBuildNumber) {
        StringBuffer finalVersion = new StringBuffer();
        StringTokenizer st = new StringTokenizer(rawVersion, ".");
        if (st.countTokens() != 4 || Utility.compareVersion(rawVersion, "14.2.0.1000") < 0) {
            return rawVersion;
        }
        String majorVersion = null;
        String minorVersion = null;
        Object buildNo = null;
        String ruType = null;
        int count = 0;
        block6: while (st.hasMoreTokens()) {
            switch (count) {
                case 0: {
                    majorVersion = st.nextToken();
                    ++count;
                    continue block6;
                }
                case 1: {
                    minorVersion = st.nextToken();
                    ++count;
                    continue block6;
                }
                case 2: {
                    if (ignoreBuildNumber) {
                        st.nextToken();
                        buildNo = "";
                    } else {
                        buildNo = MessageResources.getInstance().getString("com.sygate.scm.util.util", "Utility.build") + " " + st.nextToken();
                    }
                    ++count;
                    continue block6;
                }
                case 3: {
                    ruType = st.nextToken();
                    ruType = Utility.getRUVersion(ruType);
                    ++count;
                    continue block6;
                }
            }
            logger.log(Level.INFO, "leftover tokens in getFormattedClientVersion");
        }
        finalVersion.append(majorVersion).append(".").append(minorVersion).append(" ").append(ruType).append(" ").append((String)buildNo);
        return finalVersion.toString();
    }

    public static String getRUVersion(String ruType) {
        if (ruType == null || ((String)ruType).strip().length() != 4) {
            return ruType;
        }
        if (((String)(ruType = ((String)ruType).strip())).equals("0000")) {
            return "";
        }
        char[] ruTypeChar = ((String)ruType).toCharArray();
        int ruVersion = Integer.parseInt(String.valueOf(ruTypeChar[0]));
        ruType = ruVersion != 0 ? "RU" + ruVersion : "";
        int mpVersion = Integer.parseInt(String.valueOf(ruTypeChar[1]));
        if (mpVersion != 0) {
            ruType = (String)ruType + " MP" + mpVersion;
        }
        return ruType;
    }

    public static boolean isURLReputationSupported(String productVersion) {
        return Utility.compareVersion(productVersion, "14.3.0.0000", true) >= 0;
    }

    public static String getVersion(String packageName) {
        Matcher m = versionPattern.matcher(packageName);
        Object version = "";
        while (m.find()) {
            version = (String)version + m.group();
        }
        return version;
    }

    public static void threadSleep(int seconds) {
        Utility.threadSleep(TimeUnit.SECONDS, seconds);
    }

    public static void threadSleep(TimeUnit timeUnit, int sleepTime) {
        try {
            Thread.sleep(timeUnit.toMillis(sleepTime));
        }
        catch (InterruptedException iex) {
            Thread.currentThread().interrupt();
        }
    }

    public static String getSystemTempDir() {
        Object tempDirPath = System.getProperty("java.io.tmpdir");
        if (!((String)tempDirPath).endsWith(File.separator)) {
            tempDirPath = (String)tempDirPath + File.separator;
        }
        return tempDirPath;
    }

    public static boolean checkFileExist(File file, boolean deleteEmptyFile) {
        if (file.exists() && deleteEmptyFile && file.length() == 0L) {
            logger.log(Level.WARNING, "Utility >> checkFileExist, Deleting 0 size file:", file.getAbsolutePath());
            Utility.delete(file);
        }
        return file.exists();
    }

    public static boolean isEmpty(byte[] array) {
        return array == null || array.length == 0;
    }

    public static void clearPassword(char[] array) {
        if (array != null) {
            for (int index = 0; index < array.length; ++index) {
                array[index] = 32;
            }
        }
    }

    public static String getPowerShellPath() {
        Path sysDir = Path.of(Utility.getSystemDir(), new String[0]);
        return sysDir.resolve(Path.of("WindowsPowerShell", "v1.0", "powershell.exe")).toString();
    }

    public static boolean checkException(Exception exc, String keyword) {
        return Utility.getExceptionStackTrace(exc).contains(keyword.toLowerCase(Locale.getDefault()));
    }

    public static String getExceptionStackTrace(Exception exc) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        exc.printStackTrace(pw);
        return sw.toString().toLowerCase(Locale.getDefault());
    }

    public static boolean isValidChecksum(String checksum) {
        if (checksum.length() != 64 && checksum.length() != 32) {
            return false;
        }
        try {
            Utility.toByteArray(checksum);
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "Utility>>isValidChecksum: " + checksum + ", " + ex.getMessage());
            return false;
        }
        return true;
    }
}

