/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.util;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.SchemaContainer;
import com.sygate.scm.common.configobject.TopLevelObject;
import com.sygate.scm.common.configobject.schema.UpgradePolicy;
import com.sygate.scm.util.DeterministicIdWasher;
import com.sygate.scm.util.GUIDGenerator;
import com.sygate.scm.util.StringUtilities;
import com.sygate.scm.util.SystemLevel;
import com.sygate.scm.util.template.Template;
import com.sygate.scm.util.template.TemplateManager;
import java.io.InputStream;
import java.util.Vector;
import java.util.logging.Logger;

public class UpgradePolicyUtility {
    private static UpgradePolicyUtility singlton = new UpgradePolicyUtility();
    private static final Logger logger = Logger.getLogger(UpgradePolicyUtility.class.getName());
    private UpgradePolicy cachedUpgradePolicy = null;

    private UpgradePolicyUtility() {
    }

    public static UpgradePolicyUtility getInstance() {
        return singlton;
    }

    public UpgradePolicy getDefaultUpgradePolicy(String seed) {
        if (this.cachedUpgradePolicy == null) {
            try (InputStream in = Template.class.getResourceAsStream("default_shared_policies_template.xml");){
                Template temp = TemplateManager.getTemplate(in);
                SchemaContainer container = (SchemaContainer)AbstractSchema.readXML(temp.getXML());
                for (AbstractSchema schema : container.getChildren()) {
                    UpgradePolicy policy;
                    AbstractSchema conObj;
                    SchemaContainer con = (SchemaContainer)schema;
                    Vector<AbstractSchema> childrean = con.getChildren();
                    if (childrean.size() <= 0 || !((conObj = childrean.get(0)) instanceof UpgradePolicy)) continue;
                    this.cachedUpgradePolicy = policy = (UpgradePolicy)conObj;
                    break;
                }
            }
            catch (RuntimeException exc) {
                throw exc;
            }
            catch (Exception exc) {
                logger.log(SystemLevel.STDERR, "", exc);
            }
        }
        if (this.cachedUpgradePolicy == null) {
            return null;
        }
        UpgradePolicy cloneUpgradePolicy = (UpgradePolicy)this.cachedUpgradePolicy.clone();
        DeterministicIdWasher idWasher = new DeterministicIdWasher();
        if (StringUtilities.isEmpty(seed)) {
            seed = GUIDGenerator.getInstance().getGUIDString();
        }
        idWasher.resetTopLevelObjectIDs((TopLevelObject)cloneUpgradePolicy, seed);
        return cloneUpgradePolicy;
    }
}

