/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.util;

import com.sygate.scm.common.i18n.MessageResourcesFile;
import com.sygate.scm.common.ui.AjaxSwingCommonUtil;
import com.sygate.scm.common.ui.ClientAgent;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.RunCommandHandler;
import com.sygate.scm.util.ServerVersion;
import com.sygate.scm.util.StringUtilities;
import com.sygate.scm.util.Utility;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.regex.Pattern;

public class URLUtility {
    public static final int OK = 0;
    public static final int ILLEGAL_ARGUMENT = 1;
    public static final int UNSUPPORTED_OPERATION = 2;
    public static final int LAUNCH_BROWSER_ERROR = 3;
    private static final String SMB_PREFIX = "smb://";
    private static final String PROTOCOL_STR_HTTP = "http";
    private static final String PROTOCOL_STR_HTTPS = "https";
    private static final String PROTOCOL_STR_FTP = "ftp";

    public static void showURL(String url) {
        try {
            int urlRet = URLUtility.browseURI(url);
            switch (urlRet) {
                case 1: 
                case 2: 
                case 3: {
                    if (System.getProperty("os.name").indexOf("Window") == 0) {
                        String[] cmd = new String[]{"cmd", "/c", "start", url.trim()};
                        Runtime.getRuntime().exec(cmd);
                        break;
                    }
                    Runtime.getRuntime().exec("netscape " + url);
                    break;
                }
            }
        }
        catch (IOException ex) {
            LoggerUtilities.logException(ex);
        }
    }

    public static boolean isValidURLForWindows(String urlStr) {
        return URLUtility.isValidURLForWindows(urlStr, true);
    }

    public static boolean isValidURLForWindows(String urlStr, Boolean isValidationRequired) {
        URL_PROTOCOL protocol = URLUtility.validateURL(urlStr, isValidationRequired);
        return protocol != null && protocol != URL_PROTOCOL.SMB;
    }

    public static boolean isValidURLForMac(String urlStr) {
        URL_PROTOCOL protocol = URLUtility.validateURL(urlStr);
        return protocol != null;
    }

    public static URL_PROTOCOL validateURL(String urlStr) {
        return URLUtility.validateURL(urlStr, true);
    }

    public static URL_PROTOCOL validateURL(String urlStr, Boolean isValidationRequired) {
        if (URLUtility.isValidUNCURL(urlStr)) {
            return URL_PROTOCOL.UNC;
        }
        if (URLUtility.isValidSMBURL(urlStr)) {
            return URL_PROTOCOL.SMB;
        }
        String strProtocol = URLUtility.getProtocolFromNormalURL(urlStr, isValidationRequired);
        if (!StringUtilities.isEmpty(strProtocol)) {
            if (PROTOCOL_STR_HTTP.equalsIgnoreCase(strProtocol)) {
                return URL_PROTOCOL.HTTP;
            }
            if (PROTOCOL_STR_HTTPS.equalsIgnoreCase(strProtocol)) {
                return URL_PROTOCOL.HTTPS;
            }
            if (PROTOCOL_STR_FTP.equalsIgnoreCase(strProtocol)) {
                return URL_PROTOCOL.FTP;
            }
        }
        return null;
    }

    public static URL getComposedURL(String baseURL, String queryItems) throws MalformedURLException {
        URL retURL = new URL(baseURL);
        if (!StringUtilities.isEmpty(queryItems)) {
            String query = retURL.getQuery();
            Object file = retURL.getFile();
            file = (String)file + (query == null ? "?" : "&");
            file = (String)file + queryItems;
            retURL = new URL(retURL, (String)file);
        }
        return retURL;
    }

    private static boolean isValidUNCURL(String urlStr) {
        String fqdn;
        int second_pos = urlStr.indexOf("\\", urlStr.indexOf("\\") + 1);
        int third_pos = urlStr.indexOf("\\", second_pos + 1);
        if (second_pos != -1 && third_pos != -1 && urlStr.startsWith("\\\\") && (fqdn = urlStr.substring(second_pos + 1, third_pos)).length() > 254 && fqdn.indexOf(".") != -1) {
            return false;
        }
        String pattern = "^(((^\\\\{2}(?:(?!\\d|-)[a-zA-Z0-9\\-]{1,63}(?<!-)\\.?)+(?:[a-zA-Z]{2,})))|(^\\\\{2}[-\\w]+)|(^\\\\{2}((25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)))(\\\\([^\\\"\\*/:\\?\\|\\<\\>,;\\[\\]\\+=\\\\]+\\\\?)*([^\\\"\\*/:\\?\\|\\<\\>,;\\[\\]\\+=\\\\])+$)";
        if (Pattern.matches(pattern, urlStr)) {
            File file = new File(urlStr);
            String fileName = file.getName();
            return fileName.length() <= 255;
        }
        return false;
    }

    private static String getProtocolFromNormalURL(String urlStr, Boolean isValidationRequired) {
        try {
            String urlWithNoProtocol;
            URL url = new URL(urlStr);
            String protocol = url.getProtocol();
            if (urlStr.length() <= protocol.length() + 3) {
                return null;
            }
            if (!urlStr.substring(protocol.length() + 1, protocol.length() + 3).equalsIgnoreCase("//")) {
                return null;
            }
            if (isValidationRequired.booleanValue() && !Pattern.matches("([\\w-]+(:.*)?@)?([\\w-]+\\.)*[\\w-]+(:[0-9]+)?(/.*)?", urlWithNoProtocol = urlStr.substring(protocol.length() + 3, urlStr.length()))) {
                if (Pattern.matches("([\\w-]+(:.*)?@)?\\[(.*)?\\](:[0-9]+)?(/.*)?", urlWithNoProtocol)) {
                    String ipv6Address = urlWithNoProtocol.substring(urlWithNoProtocol.indexOf("[") + 1, urlWithNoProtocol.indexOf("]"));
                    if (!Utility.isValidIpv6Address(ipv6Address)) {
                        return null;
                    }
                } else {
                    return null;
                }
            }
            return protocol;
        }
        catch (MalformedURLException ex) {
            return null;
        }
    }

    private static boolean isValidSMBURL(String urlStr) {
        if (!StringUtilities.isEmpty(urlStr)) {
            return urlStr.toLowerCase().startsWith(SMB_PREFIX) && urlStr.length() > SMB_PREFIX.length();
        }
        return false;
    }

    public static int browseURI(String uriStr) {
        if (StringUtilities.isEmpty(uriStr)) {
            return 1;
        }
        try {
            return URLUtility.browseURI(new URI(uriStr));
        }
        catch (URISyntaxException ex) {
            return 1;
        }
    }

    public static void openURI(String uriStr) {
        AjaxSwingCommonUtil.executeOneBasedOnWebConsoleRunning(() -> ClientAgent.getCurrentInstance().openInNewTab(uriStr), () -> URLUtility.browseURI(uriStr));
    }

    private static int browseURI(URI uri) {
        if (uri == null) {
            return 1;
        }
        try {
            if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
                Desktop.getDesktop().browse(uri);
                return 0;
            }
            return 2;
        }
        catch (IOException ex) {
            return 3;
        }
        catch (RuntimeException ex) {
            return 1;
        }
    }

    public static void browseFileWithIE(String urlStr) {
        try {
            if (System.getProperty("os.name").indexOf("Window") == 0) {
                String urlName = "file://" + urlStr.trim();
                String browser = System.getenv("PROGRAMFILES") + "\\Internet Explorer\\iexplore.exe";
                String[] cmd = new String[]{browser, urlName};
                RunCommandHandler.getInstance().getProcess(cmd);
            } else {
                Runtime.getRuntime().exec("netscape " + urlStr);
            }
        }
        catch (Exception ex) {
            LoggerUtilities.logException(ex);
        }
    }

    public static String validateWebsiteUrl(String websiteUrl) {
        if (websiteUrl != null && ((String)websiteUrl).trim().length() > 0) {
            URL_PROTOCOL protocol = URLUtility.validateURL((String)websiteUrl);
            if (protocol == null) {
                websiteUrl = "http://" + (String)websiteUrl;
                protocol = URLUtility.validateURL((String)websiteUrl);
            }
            if (protocol != null && (protocol == URL_PROTOCOL.HTTP || protocol == URL_PROTOCOL.HTTPS)) {
                return websiteUrl;
            }
            return null;
        }
        return websiteUrl;
    }

    public static String getVersionLanguageErrorUpdatedUrl(String messageResourcesFileName, String urlResKey, String errorCode) {
        ArrayList<String> replaceStringArray = new ArrayList<String>();
        replaceStringArray.add(ServerVersion.CURRENT_CED_VERSION);
        String language = Utility.getLanguage();
        replaceStringArray.add(language);
        if (!StringUtilities.isEmpty(errorCode)) {
            replaceStringArray.add(errorCode);
        }
        MessageResourcesFile messageResourcesFile = new MessageResourcesFile(messageResourcesFileName);
        return MessageFormat.format(messageResourcesFile.getString(urlResKey), replaceStringArray.toArray());
    }

    public static enum URL_PROTOCOL {
        HTTP,
        HTTPS,
        FTP,
        UNC,
        SMB;

    }
}

