/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.util;

import java.util.Date;
import java.util.HashMap;

public class TimeoutUtility {
    private HashMap<Object, Long> objMap = new HashMap();
    private long timeout;

    public TimeoutUtility(long timeout) {
        this.setTimeout(timeout);
    }

    public boolean startTimer(Object key) {
        if (key == null) {
            return false;
        }
        Date date = new Date();
        this.objMap.put(key, date.getTime());
        return true;
    }

    public boolean resetTimer(Object key) {
        if (key == null) {
            return false;
        }
        this.objMap.remove(key);
        return true;
    }

    public boolean timeoutExpired(Object key) {
        if (key == null) {
            return false;
        }
        Long timeStarted = this.objMap.get(key);
        if (timeStarted == null) {
            return true;
        }
        Date date = new Date();
        Long currentDateTime = date.getTime();
        if (currentDateTime - timeStarted > Long.valueOf(this.timeout)) {
            this.resetTimer(key);
            return true;
        }
        return false;
    }

    public long timeElapsed(Object key) {
        if (key == null) {
            return -1L;
        }
        Long timeStarted = this.objMap.get(key);
        if (timeStarted == null) {
            return -1L;
        }
        Date date = new Date();
        return date.getTime() - timeStarted;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout < 0L ? 0L : timeout;
    }

    public long activeTimerCount() {
        return this.objMap.size();
    }

    public void clearAllTimers() {
        this.objMap.clear();
    }

    public long getTimeout() {
        return this.timeout;
    }
}

