/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.util;

public class TimeCounter {
    private long startTime;
    private long stopTime;
    private long prevStopTime;

    public long getStartTime() {
        return this.startTime;
    }

    public long getStopTime() {
        return this.stopTime;
    }

    public TimeCounter() {
        this.start();
    }

    public long start() {
        this.startTime = System.currentTimeMillis();
        return this.startTime;
    }

    public long stop() {
        this.prevStopTime = this.stopTime == 0L ? this.startTime : this.stopTime;
        this.stopTime = System.currentTimeMillis();
        return this.stopTime;
    }

    public long getDuration() {
        return this.stopTime - this.startTime;
    }

    public double getDurationInSecond() {
        double duration = this.stopTime - this.startTime;
        return duration / 1000.0;
    }

    public String toString() {
        return this.toStringEx2(true);
    }

    public String toStringEx() {
        double duration = this.stopTime - this.prevStopTime;
        return this.stopTime + ", duration: " + duration / 1000.0 + "s (" + duration + ")";
    }

    public String toStringEx2(boolean stop) {
        if (stop) {
            this.stop();
        }
        double duration = this.stopTime - this.prevStopTime;
        return "Duration: " + duration / 1000.0 + "s (" + duration + "ms)";
    }
}

