/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.util;

import com.sygate.scm.util.StringUtilities;
import java.util.HashMap;
import java.util.Map;

public enum TechStatus {
    OFF_AGAINST_POLICY(0),
    ON(1),
    NOT_INSTALLED(2),
    OFF_BY_POLICY(3),
    MALFUNCTION(4),
    OFF_BY_LICENSING_POLICY(5),
    NO_STATUS_REPORTED(127);

    private final int value;
    private static Map<Integer, TechStatus> map;

    private TechStatus(int value) {
        this.value = value;
    }

    public static TechStatus valueOf(int value) {
        return map.get(value);
    }

    public int getValue() {
        return this.value;
    }

    public static TechStatus parse(String strStatus) throws IllegalArgumentException {
        if (StringUtilities.isEmpty(strStatus)) {
            throw new IllegalArgumentException("Argument is null");
        }
        TechStatus status = null;
        try {
            status = TechStatus.valueOf(Integer.parseInt(strStatus));
            if (status == null) {
                throw new IllegalArgumentException("Unexpected value: '" + strStatus + "'");
            }
        }
        catch (NumberFormatException e) {
            status = TechStatus.valueOf(strStatus);
        }
        return status;
    }

    static {
        map = new HashMap<Integer, TechStatus>();
        for (TechStatus ts : TechStatus.values()) {
            map.put(ts.getValue(), ts);
        }
    }
}

