/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.util;

import com.sygate.scm.util.FipsUtil;
import com.sygate.scm.util.LoggerUtilities;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;

public class SymantecMessageDigest
extends MessageDigest {
    public static final String BOUNCY_CASTLE_PROVIDER = "BCFIPS";
    public static final String FIPS_MODE_PROPERTY = "com.symantec.crypto.fips140mode";
    private static final String SUN_PROVIDER = "SUN";

    protected SymantecMessageDigest(String algorithm) {
        super(algorithm);
    }

    public static MessageDigest getInstance(String algorithm) throws NoSuchAlgorithmException {
        String fipsMode = System.getProperty(FIPS_MODE_PROPERTY, "false");
        if (fipsMode.equalsIgnoreCase("true")) {
            FipsUtil.loadBouncyCastleProvider();
            try {
                return MessageDigest.getInstance(algorithm, BOUNCY_CASTLE_PROVIDER);
            }
            catch (NoSuchProviderException e1) {
                LoggerUtilities.log("NoSuchProviderException Exception in getting MessageDigest.getInstance in FIPS Mode: " + e1.getMessage());
                LoggerUtilities.logException(e1);
                return null;
            }
        }
        return MessageDigest.getInstance(algorithm);
    }

    public static MessageDigest getInstance() throws NoSuchAlgorithmException, NoSuchProviderException {
        return MessageDigest.getInstance("MD5", SUN_PROVIDER);
    }

    @Override
    protected void engineUpdate(byte input) {
    }

    @Override
    protected void engineUpdate(byte[] input, int offset, int len) {
    }

    @Override
    protected byte[] engineDigest() {
        return null;
    }

    @Override
    protected void engineReset() {
    }
}

