/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.util;

import com.sygate.scm.util.FipsUtil;
import com.sygate.scm.util.LoggerUtilities;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;

public class SymantecCipher {
    public static final String FIPS_MODE_PROPERTY = "com.symantec.crypto.fips140mode";
    public static final String BOUNCY_CASTLE_PROVIDER = "BCFIPS";

    private SymantecCipher() {
        throw new IllegalStateException("SymantecCipher class");
    }

    public static Cipher getInstance(String algorithm) throws NoSuchAlgorithmException {
        try {
            String fipsMode = System.getProperty(FIPS_MODE_PROPERTY, "false");
            if (fipsMode.equalsIgnoreCase("true")) {
                if (algorithm.equals("DES")) {
                    Cipher cipher = Cipher.getInstance(algorithm);
                    LoggerUtilities.log("DES Provider: " + cipher.getProvider());
                    return cipher;
                }
                FipsUtil.loadBouncyCastleProvider();
                return Cipher.getInstance(algorithm, BOUNCY_CASTLE_PROVIDER);
            }
            return Cipher.getInstance(algorithm);
        }
        catch (NoSuchProviderException | NoSuchPaddingException e1) {
            LoggerUtilities.log("Exception while generating cipher instance: " + e1.getLocalizedMessage());
            LoggerUtilities.logException(e1);
            return null;
        }
    }
}

