/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.util;

import com.sygate.scm.common.configobject.rpc.AgentCommunicationSetting;
import com.sygate.scm.common.configobject.rpc.Certificate;
import com.sygate.scm.common.configobject.rpc.CommConf;
import com.sygate.scm.common.configobject.rpc.LogSetting;
import com.sygate.scm.common.configobject.rpc.RegisterClient;
import com.sygate.scm.common.configobject.rpc.Server;
import com.sygate.scm.common.configobject.rpc.ServerCertList;
import com.sygate.scm.common.configobject.rpc.ServerList;
import com.sygate.scm.common.configobject.rpc.ServerPriorityBlock;
import com.sygate.scm.common.configobject.rpc.ServerSettings;
import com.sygate.scm.common.configobject.schema.AppUpload;
import com.sygate.scm.common.configobject.schema.BehaviorLogSetting;
import com.sygate.scm.common.configobject.schema.Communication;
import com.sygate.scm.common.configobject.schema.HostAddress;
import com.sygate.scm.common.configobject.schema.Log;
import com.sygate.scm.common.configobject.schema.LogUpload;
import com.sygate.scm.common.configobject.schema.PacketLogSetting;
import com.sygate.scm.common.configobject.schema.SecurityLogSetting;
import com.sygate.scm.common.configobject.schema.SemServer;
import com.sygate.scm.common.configobject.schema.SemServerBlock;
import com.sygate.scm.common.configobject.schema.SemServerList;
import com.sygate.scm.common.configobject.schema.SemSite;
import com.sygate.scm.common.configobject.schema.ServerArray;
import com.sygate.scm.common.configobject.schema.ServerCertificate;
import com.sygate.scm.common.configobject.schema.SystemLogSetting;
import com.sygate.scm.common.configobject.schema.TrafficLogSetting;
import com.sygate.scm.common.configobject.schema.TransportServerCertificate;
import com.sygate.scm.common.util.IPAddressUtil;
import com.sygate.scm.util.GUID;
import com.sygate.scm.util.Utility;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class SylinkExportUtil {
    public static ServerSettings exportSylink(GUID domainGUID, Communication communication, SemServerList serverList, List<SemSite> siteList, Log log, ServerCertificate certificate, String serverEncrptKey, String preferredGroup, int agentMode, boolean isSiteAppload, Integer defaultHttpPort, Integer defaultHttpsPort) {
        ServerSettings outServerSetting = SylinkExportUtil.exportSylink(domainGUID, communication, serverList, siteList, log, certificate, serverEncrptKey, isSiteAppload, defaultHttpPort, defaultHttpsPort);
        RegisterClient outRegisterClient = SylinkExportUtil.createRegisterClient(preferredGroup, agentMode);
        outServerSetting.getCommConf().setOptRegisterClient(outRegisterClient);
        return outServerSetting;
    }

    public static ServerSettings exportSylink(GUID domainGUID, Communication communication, SemServerList serverList, List<SemSite> siteList, Log log, ServerCertificate certificate, String serverEncrptKey, boolean isSiteAppload, Integer httpPort, Integer httpsPort) {
        String domainId = domainGUID.toString();
        ServerSettings outServerSetting = new ServerSettings();
        outServerSetting.setDomainId(domainId);
        CommConf outCommConf = new CommConf();
        AgentCommunicationSetting outAgentCommuSetting = SylinkExportUtil.constructAgentCommunicationSetting(communication, serverEncrptKey, isSiteAppload);
        outCommConf.setAgentCommunicationSetting(outAgentCommuSetting);
        ServerList outServerList = SylinkExportUtil.createServerList(serverList, certificate, httpPort, httpsPort);
        outCommConf.setServerList(outServerList);
        ServerCertList outServerCertList = SylinkExportUtil.createServerCertList(siteList);
        outCommConf.setOptServerCertList(outServerCertList);
        LogSetting outLogSetting = SylinkExportUtil.createLogSetting(log);
        outCommConf.setOptLogSetting(outLogSetting);
        outServerSetting.setCommConf(outCommConf);
        return outServerSetting;
    }

    public static AgentCommunicationSetting constructAgentCommunicationSetting(Communication communication, String serverEncrptKey, boolean isSiteAppload) {
        Long heartbeat;
        AgentCommunicationSetting outAgentCommuSetting = new AgentCommunicationSetting();
        Boolean enableCommu = communication.getOptEnable();
        if (enableCommu == null) {
            enableCommu = communication.getDefEnable();
        }
        outAgentCommuSetting.setAlwaysConnect(enableCommu);
        Integer mode = communication.getMode();
        if (mode == null) {
            mode = Communication.PUSH;
        }
        if ((heartbeat = communication.getOptPollModeHeartbeatFreq()) == null) {
            heartbeat = 300L;
        }
        if (mode.equals(Communication.PULL)) {
            outAgentCommuSetting.setOptCommunicationMode(AgentCommunicationSetting.PULL);
            outAgentCommuSetting.setOptPullHeartbeatSeconds(heartbeat.intValue());
        } else {
            outAgentCommuSetting.setOptCommunicationMode(AgentCommunicationSetting.PUSH);
            outAgentCommuSetting.setOptPushHeartbeatSeconds(heartbeat.intValue());
        }
        Long logHeartbeatFreq = communication.getOptUploadLogHeartbeatFreq();
        if (logHeartbeatFreq == null) {
            logHeartbeatFreq = 300L;
        }
        outAgentCommuSetting.setOptUploadLogHeartbeatSeconds(logHeartbeatFreq.intValue());
        Long opstateHeartbeatFreq = communication.getOptUploadOpStateHeartbeatFreq();
        if (opstateHeartbeatFreq == null) {
            opstateHeartbeatFreq = 300L;
        }
        outAgentCommuSetting.setOptUploadOpStateHeartbeatSeconds(opstateHeartbeatFreq.intValue());
        Long cmdstateHeartbeatFreq = communication.getOptUploadCmdStateHeartbeatFreq();
        if (cmdstateHeartbeatFreq == null) {
            cmdstateHeartbeatFreq = 300L;
        }
        outAgentCommuSetting.setOptUploadCmdStateHeartbeatSeconds(cmdstateHeartbeatFreq.intValue());
        AppUpload appUpload = communication.getOptAppUpload();
        if (appUpload != null) {
            Boolean enable = appUpload.getOptEnable();
            if (enable == null) {
                enable = appUpload.getDefEnable();
            }
            outAgentCommuSetting.setUploadLearnedApp(enable != false && isSiteAppload);
        } else {
            outAgentCommuSetting.setUploadLearnedApp(Boolean.FALSE);
        }
        Boolean downloadProfile = communication.getOptDownloadProfile();
        if (downloadProfile == null) {
            downloadProfile = communication.getDefDownloadProfile();
        }
        outAgentCommuSetting.setOptDisableDownloadProfile(downloadProfile == false);
        outAgentCommuSetting.setOptKcs(serverEncrptKey);
        Boolean randomizationEnabled = communication.getOptRandomizationEnabled();
        if (randomizationEnabled == null) {
            randomizationEnabled = communication.getDefRandomizationEnabled();
        }
        outAgentCommuSetting.setOptRandomizationEnabled(randomizationEnabled);
        Integer randomizationRange = communication.getOptRandomizationRange();
        if (randomizationRange == null) {
            randomizationRange = communication.getDefRandomizationRange();
        }
        if (randomizationRange < 1) {
            randomizationRange = 1;
        }
        outAgentCommuSetting.setOptRandomizationRange(randomizationRange);
        Boolean rememberCurrentGroup = Utility.getBooleanValue(communication.getOptRememberCurrentGroup(), communication.getDefRememberCurrentGroup());
        outAgentCommuSetting.setOptRememberCurrentGroup(rememberCurrentGroup);
        Boolean rememberCurrentPolicyMode = Utility.getBooleanValue(communication.getOptRememberCurrentPolicyMode(), communication.getDefRememberCurrentPolicyMode());
        outAgentCommuSetting.setOptRememberCurrentPolicyMode(rememberCurrentPolicyMode);
        Boolean allowClientUploadCriticalEventImmediately = Utility.getBooleanValue(communication.getOptAllowClientUploadCriticalEventImmediately(), communication.getDefAllowClientUploadCriticalEventImmediately());
        outAgentCommuSetting.setOptAllowClientUploadCriticalEventImmediately(allowClientUploadCriticalEventImmediately);
        return outAgentCommuSetting;
    }

    private static RegisterClient createRegisterClient(String preferredGroup, int agentMode) {
        RegisterClient outRegisterClient = new RegisterClient();
        outRegisterClient.setOptPreferredGroup(preferredGroup);
        outRegisterClient.setOptPreferredMode(agentMode);
        return outRegisterClient;
    }

    private static LogSetting createLogSetting(Log _log) {
        LogUpload logUpload = _log.getOptLogUpload();
        LogSetting outLogSetting = new LogSetting();
        if (logUpload != null) {
            Boolean enable = logUpload.getOptEnable();
            if (enable == null) {
                enable = logUpload.getDefEnable();
            }
            outLogSetting.setSendingLogAllowed(enable);
            Integer maxLog = logUpload.getOptMaxUploadLogSize();
            if (maxLog != null) {
                outLogSetting.setMaxLogRecords(maxLog);
            } else {
                outLogSetting.setMaxLogRecords(500);
            }
        } else {
            outLogSetting.setSendingLogAllowed(Boolean.FALSE);
            outLogSetting.setMaxLogRecords(500);
        }
        Boolean enableSystemLog = Boolean.FALSE;
        SystemLogSetting system = _log.getOptSystemLogSetting();
        if (system != null && (enableSystemLog = system.getOptUploadIt()) == null) {
            enableSystemLog = system.getDefUploadIt();
        }
        outLogSetting.setUploadSystemLog(enableSystemLog);
        Boolean enableSecurityLog = Boolean.FALSE;
        SecurityLogSetting security = _log.getOptSecurityLogSetting();
        if (security != null && (enableSecurityLog = security.getOptUploadIt()) == null) {
            enableSecurityLog = security.getDefUploadIt();
        }
        outLogSetting.setUploadSecurityLog(enableSecurityLog);
        Boolean enableTrafficLog = Boolean.FALSE;
        TrafficLogSetting traffic = _log.getOptTrafficLogSetting();
        if (traffic != null && (enableTrafficLog = traffic.getOptUploadIt()) == null) {
            enableTrafficLog = traffic.getDefUploadIt();
        }
        outLogSetting.setUploadTrafficLog(enableTrafficLog);
        Boolean enablePacketLog = Boolean.FALSE;
        PacketLogSetting packet = _log.getOptPacketLogSetting();
        if (packet != null && (enablePacketLog = packet.getOptUploadIt()) == null) {
            enablePacketLog = packet.getDefUploadIt();
        }
        outLogSetting.setUploadRawLog(enablePacketLog);
        Boolean enableBehaviorLog = Boolean.FALSE;
        BehaviorLogSetting behavior = _log.getOptBehaviorLogSetting();
        if (behavior != null && (enableBehaviorLog = behavior.getOptUploadIt()) == null && packet != null) {
            enableBehaviorLog = packet.getDefUploadIt();
        }
        outLogSetting.setUploadProcessLog(enableBehaviorLog);
        return outLogSetting;
    }

    private static ServerCertList createServerCertList(List<SemSite> siteList) {
        ServerCertList outServerCertList = new ServerCertList();
        for (SemSite site : siteList) {
            ServerArray serverArray = site.getServerArray();
            for (int i = 0; i < serverArray.getSemServerCount(); ++i) {
                SemServer server = serverArray.getSemServer(i);
                TransportServerCertificate configCert = server.getOptTransportServerCertificate();
                Certificate schemaCert = new Certificate();
                if (configCert == null) continue;
                schemaCert.setName(configCert.getCertName());
                schemaCert.setOptContent(configCert.getContent());
                outServerCertList.addCertificate(schemaCert);
            }
        }
        return outServerCertList;
    }

    protected static ServerList createServerList(SemServerList serverList, ServerCertificate certificate, Integer defaultHttpPort, Integer defaultHttpsPort) {
        Boolean verifyName;
        ServerList outServerList = new ServerList();
        outServerList.setOptName(serverList.getName());
        boolean onlyHttps = false;
        Integer commSecurity = serverList.getOptCommSecurity();
        if (commSecurity != null && commSecurity.equals(SemServerList.HTTPS_ONLY)) {
            onlyHttps = true;
        }
        if ((verifyName = serverList.getOptVerifyHttpsUrlName()) == null) {
            verifyName = serverList.getDefVerifyHttpsUrlName();
        }
        Vector<SemServerBlock> blocks = serverList.getSemServerBlock();
        Iterator blocksIt = blocks.iterator();
        int cnt = 1;
        while (blocksIt.hasNext()) {
            SemServerBlock block = (SemServerBlock)blocksIt.next();
            if (Boolean.FALSE.equals(block.getOptEnable())) continue;
            ServerPriorityBlock outBlock = new ServerPriorityBlock();
            outBlock.setName("Priority" + cnt++);
            outServerList.addServerPriorityBlock(outBlock);
            Vector<HostAddress> allHosts = block.getHostAddress();
            for (HostAddress host : allHosts) {
                if (Boolean.FALSE.equals(host.getOptEnable())) continue;
                Server outServer = new Server();
                outServer.setOptSigningAlgorithm(true);
                outServer.setOptHttpsVerifyCA(verifyName);
                if (onlyHttps) {
                    outServer.setOptProtocol(com.sygate.scm.common.configobject.agent.Server.HTTPS);
                } else {
                    outServer.setOptProtocol(com.sygate.scm.common.configobject.agent.Server.HTTP);
                }
                outServer.setOptHttpsPort(host.getOptSecurePort() != null ? host.getOptSecurePort() : defaultHttpsPort);
                outServer.setOptHttpPort(host.getOptPort() != null ? host.getOptPort() : defaultHttpPort);
                String address = host.getContent();
                if (null != address) {
                    if (IPAddressUtil.isIPv6LiteralAddress(address)) {
                        outServer.setOptAddressIpv6(address);
                    } else {
                        outServer.setOptAddress(address);
                    }
                }
                if (certificate != null) {
                    Boolean enableSigValidation = certificate.getOptEnableSignatureValidation();
                    if (enableSigValidation == null) {
                        enableSigValidation = certificate.getDefEnableSignatureValidation();
                    }
                    if (enableSigValidation != null) {
                        outServer.setOptVerifySignatures(enableSigValidation);
                    }
                }
                outBlock.addServer(outServer);
            }
        }
        return outServerList;
    }
}

