/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.util;

import com.sygate.scm.common.ui.AjaxSwingCommonUtil;
import javax.swing.SwingUtilities;

public abstract class SwingWorker {
    private Object value;
    private boolean canceled = false;
    private ThreadVar threadVar;

    public boolean isCanceled() {
        return this.canceled;
    }

    protected synchronized Object getValue() {
        return this.value;
    }

    private synchronized void setValue(Object x) {
        this.value = x;
    }

    public abstract Object construct();

    public void finished() {
    }

    public void interrupt() {
        Thread t = this.threadVar.get();
        if (t != null) {
            t.interrupt();
        }
        this.threadVar.clear();
        this.canceled = true;
    }

    public Object get() {
        Thread t;
        while ((t = this.threadVar.get()) != null) {
            try {
                t.join();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return null;
            }
        }
        return this.getValue();
    }

    public SwingWorker() {
        this(Thread.currentThread().getName());
    }

    public SwingWorker(String threadName) {
        final Runnable doFinished = new Runnable(){

            @Override
            public void run() {
                if (!SwingWorker.this.canceled) {
                    SwingWorker.this.finished();
                    AjaxSwingCommonUtil.updateSwingAgentBrowser(true, 0);
                }
            }
        };
        Runnable doConstruct = new Runnable(){

            @Override
            public void run() {
                try {
                    SwingWorker.this.setValue(SwingWorker.this.construct());
                }
                finally {
                    SwingWorker.this.threadVar.clear();
                }
                SwingUtilities.invokeLater(doFinished);
            }
        };
        Thread t = new Thread(doConstruct);
        t.setName(threadName);
        this.threadVar = new ThreadVar(t);
    }

    public void start() {
        Thread t = this.threadVar.get();
        if (t != null) {
            AjaxSwingCommonUtil.updateSwingAgentBrowser(true, 5);
            t.start();
        }
    }

    private static class ThreadVar {
        private Thread thread;

        ThreadVar(Thread t) {
            this.thread = t;
        }

        synchronized Thread get() {
            return this.thread;
        }

        synchronized void clear() {
            this.thread = null;
        }
    }
}

