/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.util;

import com.sygate.scm.common.util.Cast;
import com.sygate.scm.util.EmailValidator;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.validator.EmailAddressValidator;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public class StringUtilities {
    public static final String DELIM_COMMA = ",";
    public static final String DELIM_PERIOD = ".";
    public static final String DELIM_TAB = "\t";
    public static final String DELIM_COLON = ":";
    public static final String DELIM_GRAVE = "`";
    public static final String BCP_FIELD_DELIMITER = "`";
    public static final String BCP_FORMAT_FILE_FIELD_DELIMITER = "\"`\"";
    public static final String BCP_RESTORE_DELIMITER = "\r\n";
    public static final String BCP_ROW_DELIMITER = "\n";
    public static final String BCP_FORMAT_FILE_SUFIX = ".FMT";
    public static final String BCP_FIELD_DELIMITER_FOR_DB_RESTORE = "^|*";
    public static final String BCP_FORMAT_FILE_FIELD_DELIMITER_FOR_DB_RESTORE = "\"^|*\"";
    public static final String BCP_FORMAT_FILE_FIELD_DELIMITER_FOR_DB_RESTORE_UTF16 = "\"^\\\\0|\\\\0*\\\\0\"";
    public static final String BCP_FIELD_DELIMITER_FOR_DB_RESTORE_REGEX = "\"\\^\\\\0\\|\\\\0\\*\\\\0\"";
    public static final String DELIM_SEMICOLON = ";";
    public static final String DELIM_BLOCK_SEMICOLON = ";;";
    public static final String DELIM_EQUALS = "=";
    public static final String DELIM_CARET = "^";
    public static final String DELIM_QUOT = "\"";
    public static final char CSV_FILE_SEPARATOR = ',';
    public static final char BCP_FIELD_SEPARATOR = '`';
    public static final String SYSTEM_FILE_SEPARATOR = System.getProperty("file.separator");
    public static final String REPLCATION_FILE_PREFIX = "rl";
    public static final String REPLCATION_DEL_FILE_SUFFIX = "_DEL";
    public static final String EMPTY_STRING = "";
    public static final String UTF8_ENCODING = "UTF-8";
    public static final String UTF16_ENCODING = "UTF-16LE";
    public static final String ALL_INDEXES = "ALL";
    public static final String PASSWORD_STAKE_HOLDER = "[hidden]";
    public static final String LOOPBACK_IP = "127.0.0.1";
    private static final Pattern charNotAllowedFileNamePattern = Pattern.compile("[\\\\/:*?\"<>|]");
    private static Logger logger = Logger.getLogger(StringUtilities.class.getName());

    public static String from_html_entities(String html_entity_string) {
        if (html_entity_string == null) {
            return EMPTY_STRING;
        }
        String strCleaned = html_entity_string.replaceAll("&lt;", "<");
        strCleaned = strCleaned.replaceAll("&gt;", ">");
        strCleaned = strCleaned.replaceAll("&quot;", "\\\"");
        strCleaned = strCleaned.replaceAll("&#92;", "\\\\");
        strCleaned = strCleaned.replaceAll("&#039;", "'");
        strCleaned = strCleaned.replaceAll("&#39;", "'");
        strCleaned = strCleaned.replaceAll("&#45;&#45;", "--");
        strCleaned = strCleaned.replaceAll("&#36;", "\\$");
        strCleaned = strCleaned.replaceAll("&amp;", "&");
        return strCleaned;
    }

    public static String regularizeFileName(String strOri) {
        return charNotAllowedFileNamePattern.matcher(strOri).replaceAll("-");
    }

    public static boolean isXMLCharValid(char current) {
        boolean isValid = false;
        char emptyChar = '\u0000';
        if (emptyChar != current && (current == '\t' || current == '\n' || current == '\r' || current >= ' ' && current <= '\ud7ff' || current >= '\ue000' && current <= '\ufffd')) {
            isValid = true;
        }
        return isValid;
    }

    public static boolean isXMLStringValid(String src) {
        if (src == null) {
            return true;
        }
        boolean valid = true;
        for (int i = 0; i < src.length(); ++i) {
            if (StringUtilities.isXMLCharValid(src.charAt(i))) continue;
            valid = false;
            break;
        }
        return valid;
    }

    public static String to_html_entities(String string_to_encode) {
        if (string_to_encode == null) {
            return EMPTY_STRING;
        }
        String strFormatted = string_to_encode.replaceAll("&", "&amp;");
        strFormatted = strFormatted.replaceAll("<", "&lt;");
        strFormatted = strFormatted.replaceAll(">", "&gt;");
        strFormatted = strFormatted.replaceAll("\\\"", "&quot;");
        strFormatted = strFormatted.replaceAll("\\\\", "&#92;");
        strFormatted = strFormatted.replaceAll("'", "&#039;");
        strFormatted = strFormatted.replaceAll("--", "&#45;&#45;");
        strFormatted = strFormatted.replaceAll("\\$", "&#36;");
        return strFormatted;
    }

    public static String to_xml_entities(String string_to_encode) {
        if (string_to_encode == null) {
            return EMPTY_STRING;
        }
        StringBuffer result = new StringBuffer();
        int len = string_to_encode.length();
        block6: for (int i = 0; i < len; ++i) {
            char c = string_to_encode.charAt(i);
            if (!StringUtilities.isXMLCharValid(c)) {
                result.append(' ');
                continue;
            }
            if (c < ' ') {
                result.append("&#");
                result.append(Integer.toString(c, 10));
                result.append(';');
                continue;
            }
            switch (c) {
                case '&': {
                    result.append("&amp;");
                    continue block6;
                }
                case '<': {
                    result.append("&lt;");
                    continue block6;
                }
                case '>': {
                    result.append("&gt;");
                    continue block6;
                }
                case '\"': {
                    result.append("&quot;");
                    continue block6;
                }
                default: {
                    result.append(c);
                }
            }
        }
        return result.toString();
    }

    public static String removeDuplicates(String text, String target, String replacement) {
        if (text != null && (text = text.trim()).length() != 0) {
            while (text.contains(target)) {
                text = text.replace(target, replacement);
            }
        }
        return text;
    }

    public static boolean canConvertToLong(String value) {
        boolean result = false;
        try {
            Long.parseLong(value);
            result = true;
        }
        catch (NumberFormatException e) {
            LoggerUtilities.logException(e);
        }
        return result;
    }

    public static String removeBom(String value) {
        String result = value;
        if (value != null && value.length() > 1 && value.indexOf("\ufeff") == 0) {
            result = value.substring(1);
        }
        return result;
    }

    public static String[] parse(String csvText, String token) {
        return StringUtilities.parse(csvText, token, null, null);
    }

    public static String[] parse(String csvText, String token, String startElementToSkip, String endElementToSkip) {
        if (csvText == null || csvText.length() == 0) {
            return new String[0];
        }
        if (token == null || token.length() == 0) {
            token = DELIM_COMMA;
        }
        ArrayList<String> a = new ArrayList<String>();
        int idx1 = 0;
        int idx2 = -1;
        while ((idx2 = csvText.indexOf(token, idx1)) != -1) {
            String subString = csvText.substring(idx1, idx2).trim();
            if (!StringUtilities.isEmpty(startElementToSkip) && !StringUtilities.isEmpty(endElementToSkip) && subString.indexOf(startElementToSkip, 0) != -1) {
                int endElementIndex = csvText.indexOf(endElementToSkip, idx1);
                a.add(csvText.substring(idx1, endElementIndex + endElementToSkip.length()).trim());
                idx1 = endElementIndex + endElementToSkip.length() + token.length();
                continue;
            }
            a.add(subString);
            idx1 = idx2 + token.length();
            if (idx1 < csvText.length()) continue;
            a.add(EMPTY_STRING);
            break;
        }
        if (idx2 == -1 && idx1 <= csvText.length()) {
            a.add(csvText.substring(idx1).trim());
        }
        return a.toArray(new String[a.size()]);
    }

    public static int[] parseVersion(String version) {
        return StringUtilities.parseVersion(version, DELIM_PERIOD);
    }

    public static String getMajorPackageVersion(String version) {
        int[] result = StringUtilities.parsePackageVersion(version);
        if (result == null) {
            return null;
        }
        return result[0] + DELIM_PERIOD + result[1];
    }

    public static boolean isValidPackageVersion(String version) {
        return null != StringUtilities.parsePackageVersion(version);
    }

    public static int[] parsePackageVersion(String version) {
        int[] result = StringUtilities.parseVersion(version);
        if (result != null && result.length != 4) {
            return null;
        }
        return result;
    }

    public static int[] parseVersion(String version, String delim) {
        String[] versioninfo;
        if (!StringUtilities.isEmpty(version) && (versioninfo = version.trim().split("\\" + delim)).length > 0) {
            int[] iVersion = new int[versioninfo.length];
            for (int i = 0; i < versioninfo.length; ++i) {
                try {
                    iVersion[i] = Integer.parseInt(versioninfo[i]);
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return iVersion;
        }
        return null;
    }

    public static String getCSV(Collection<String> c) {
        return StringUtilities.getCSV(c, -1);
    }

    public static String getCSV(Collection<String> c, int countPerLine) {
        if (c == null) {
            return EMPTY_STRING;
        }
        StringBuffer csvList = new StringBuffer();
        int word = 0;
        for (String string : c) {
            if (csvList.length() != 0) {
                csvList.append(DELIM_COMMA);
            }
            if (countPerLine > 0 && word >= countPerLine) {
                csvList.append(String.format("%n", new Object[0]));
                word = 0;
            }
            csvList.append(string);
            if (countPerLine <= 0) continue;
            ++word;
        }
        return csvList.toString();
    }

    public static String getQuotedCSV(String csv) {
        return StringUtilities.getQuotedCSV(Arrays.asList(StringUtilities.parse(csv, DELIM_COMMA)));
    }

    public static String getQuotedCSV(Properties properties) {
        Set keys = (Set)Cast.cast(properties.keySet());
        return StringUtilities.getQuotedCSV(keys);
    }

    public static String getQuotedCSV(Collection<String> c) {
        if (c == null) {
            return EMPTY_STRING;
        }
        StringBuffer csvList = new StringBuffer();
        for (String string : c) {
            if (csvList.length() != 0) {
                csvList.append(DELIM_COMMA);
            }
            csvList.append("'");
            csvList.append(string);
            csvList.append("'");
        }
        return csvList.toString();
    }

    public static String getWordWrappedString(String string, int maxLineLength) {
        StringBuffer buffer = new StringBuffer();
        String separator = System.getProperty("line.separator");
        if (separator == null) {
            separator = BCP_ROW_DELIMITER;
        }
        StringUtilities.wrapString(buffer, string, maxLineLength, separator);
        if (buffer.length() > separator.length() && buffer.lastIndexOf(separator) == buffer.length() - separator.length()) {
            buffer.setLength(buffer.length() - separator.length());
        }
        return buffer.toString();
    }

    private static void wrapString(StringBuffer buffer, String message, int maxLineLength, String lineSeparator) {
        int len = message.length();
        if (len <= 0) {
            buffer.append(message);
            return;
        }
        if (len > maxLineLength) {
            int p = message.lastIndexOf(32, maxLineLength);
            if (p <= 0) {
                p = message.indexOf(32, maxLineLength);
            }
            if (p > 0 && p < len) {
                StringUtilities.wrapString(buffer, message.substring(0, p), maxLineLength, lineSeparator);
                StringUtilities.wrapString(buffer, message.substring(p + 1), maxLineLength, lineSeparator);
                return;
            }
        }
        buffer.append(message).append(lineSeparator);
    }

    public static String getUserNameFromDomainUserMixedString(String s) {
        if (StringUtilities.isEmpty(s)) {
            return EMPTY_STRING;
        }
        String username = s;
        if (s.indexOf("\\") > -1) {
            StringTokenizer tokenizer = new StringTokenizer(s, "\\");
            username = tokenizer.nextToken();
            username = tokenizer.nextToken();
        } else if (s.indexOf("@") > -1) {
            StringTokenizer tokenizer = new StringTokenizer(s, "@");
            username = tokenizer.nextToken();
        }
        return username;
    }

    public static String getDomainNameFromDomainUserMixedString(String s) {
        if (StringUtilities.isEmpty(s)) {
            return EMPTY_STRING;
        }
        String domain = EMPTY_STRING;
        if (s.indexOf("\\") > -1) {
            StringTokenizer tokenizer = new StringTokenizer(s, "\\");
            domain = tokenizer.nextToken();
        } else if (s.indexOf("@") > -1) {
            StringTokenizer tokenizer = new StringTokenizer(s, "@");
            domain = tokenizer.nextToken();
            domain = tokenizer.nextToken();
        }
        return domain;
    }

    public static boolean isEqual(String s1, String s2) {
        if (s1 != null) {
            return s1.equals(s2);
        }
        return s2 == null;
    }

    public static boolean isEqualIgnoreCase(String s1, String s2) {
        if (s1 != null) {
            return s1.equalsIgnoreCase(s2);
        }
        return s2 == null;
    }

    public static long compareAsLong(String s1, String s2) {
        long result = 0L;
        result = !StringUtilities.isValidLong(s1) && !StringUtilities.isValidLong(s1) ? 0L : (!StringUtilities.isValidLong(s1) ? -1L : (!StringUtilities.isValidLong(s2) ? 1L : Long.parseLong(s1) - Long.parseLong(s2)));
        return result;
    }

    public static boolean isValidLong(String str) {
        boolean result = false;
        try {
            Long.parseLong(str);
            result = true;
        }
        catch (NumberFormatException e) {
            LoggerUtilities.logException(e);
        }
        return result;
    }

    public static boolean isEmpty(String string) {
        return string == null || string.trim().length() <= 0;
    }

    public static boolean isNotEmpty(String string) {
        return !StringUtilities.isEmpty(string);
    }

    public static boolean isArrayEmpty(String[] array) {
        return array == null || array.length <= 0;
    }

    public static boolean isLocalHostAddress(String address) {
        boolean ret = false;
        if (StringUtilities.isEmpty(address)) {
            return false;
        }
        if ((address = address.toLowerCase().trim()).equals("localhost")) {
            return true;
        }
        try {
            InetAddress ip = InetAddress.getByName(address);
            if (null != ip) {
                ret = ip.isLoopbackAddress() || ip.isAnyLocalAddress();
            }
        }
        catch (UnknownHostException ex) {
            LoggerUtilities.logException(ex);
            ret = false;
        }
        return ret;
    }

    public static String replace(String s, String find, String replace) {
        int length;
        int replaceLength;
        int findLength;
        if (s == null) {
            return s;
        }
        int stringLength = s.length();
        if (find == null || (findLength = find.length()) == 0) {
            return s;
        }
        if (replace == null) {
            replace = EMPTY_STRING;
        }
        if (findLength == (replaceLength = replace.length())) {
            length = stringLength;
        } else {
            int end;
            int count = 0;
            int start = 0;
            while ((end = s.indexOf(find, start)) != -1) {
                ++count;
                start = end + findLength;
            }
            if (count == 0) {
                return s;
            }
            length = stringLength - count * (findLength - replaceLength);
        }
        int start = 0;
        int end = s.indexOf(find, start);
        if (end == -1) {
            return s;
        }
        StringBuffer sb = new StringBuffer(length);
        while (end != -1) {
            sb.append(s.substring(start, end));
            sb.append(replace);
            start = end + findLength;
            end = s.indexOf(find, start);
        }
        end = stringLength;
        sb.append(s.substring(start, end));
        return sb.toString();
    }

    public static String toGrammerStyle(String oldString) {
        return oldString == null ? EMPTY_STRING : (oldString.length() >= 1 ? oldString.substring(0, 1).toUpperCase() : EMPTY_STRING) + (oldString.length() >= 2 ? oldString.substring(1).toLowerCase() : EMPTY_STRING);
    }

    public static String toStringSafety(Object o) {
        return o == null ? null : o.toString();
    }

    public static String join(Object[] o) {
        return StringUtilities.join(o, false);
    }

    public static String join(Object[] o, String separator) {
        return StringUtilities.join(o, separator, false);
    }

    public static String join(Object[] o, String separator, boolean ignoreNull) {
        if (o == null || o.length == 0) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        boolean firstStringAdded = false;
        for (Object element : o) {
            if (ignoreNull) {
                if (element == null) continue;
                if (firstStringAdded) {
                    buffer.append(separator);
                } else {
                    firstStringAdded = true;
                }
                buffer.append(element);
                continue;
            }
            if (firstStringAdded) {
                buffer.append(separator);
            } else {
                firstStringAdded = true;
            }
            buffer.append(element);
        }
        return new String(buffer);
    }

    public static String join(Object[] o, boolean ignoreNull) {
        if (o == null || o.length == 0) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        for (Object element : o) {
            if (ignoreNull) {
                if (element == null) continue;
                buffer.append(element);
                continue;
            }
            buffer.append(element);
        }
        return new String(buffer);
    }

    public static String join(String str1, String str2) {
        Object[] str = new String[]{str1, str2};
        return StringUtilities.join(str);
    }

    public static String join(String str1, String str2, String str3) {
        Object[] str = new String[]{str1, str2, str3};
        return StringUtilities.join(str);
    }

    public static String join(String str1, String str2, String str3, String str4) {
        Object[] str = new String[]{str1, str2, str3, str4};
        return StringUtilities.join(str);
    }

    public static String join(String str1, String str2, String str3, String str4, String str5) {
        Object[] str = new String[]{str1, str2, str3, str4, str5};
        return StringUtilities.join(str);
    }

    public static String join(String str1, String str2, String str3, String str4, String str5, String str6) {
        Object[] str = new String[]{str1, str2, str3, str4, str5, str6};
        return StringUtilities.join(str);
    }

    public static String joinIgnoreNull(String str1, String str2) {
        Object[] str = new String[]{str1, str2};
        return StringUtilities.join(str, true);
    }

    public static String joinIgnoreNull(String str1, String str2, String str3) {
        Object[] str = new String[]{str1, str2, str3};
        return StringUtilities.join(str, true);
    }

    public static String joinIgnoreNull(String str1, String str2, String str3, String str4) {
        Object[] str = new String[]{str1, str2, str3, str4};
        return StringUtilities.join(str, true);
    }

    public static String joinIgnoreNull(String str1, String str2, String str3, String str4, String str5) {
        Object[] str = new String[]{str1, str2, str3, str4, str5};
        return StringUtilities.join(str, true);
    }

    public static String joinIgnoreNull(String str1, String str2, String str3, String str4, String str5, String str6) {
        Object[] str = new String[]{str1, str2, str3, str4, str5, str6};
        return StringUtilities.join(str, true);
    }

    public static String formatHTML(String pattern, String[] arguments) {
        if (arguments.length > 0) {
            for (int i = 0; i < arguments.length; ++i) {
                arguments[i] = StringUtilities.to_html_entities(arguments[i]);
            }
            return MessageFormat.format(pattern, arguments);
        }
        return pattern;
    }

    public static int getLineCnt(String text) {
        int lineCnt = 0;
        if (!StringUtilities.isEmpty(text)) {
            lineCnt = 1;
            for (char c : text.toCharArray()) {
                if (c != '\n') continue;
                ++lineCnt;
            }
        }
        return lineCnt;
    }

    public static String substringAfter(String str, String separator) {
        if (StringUtilities.isEmpty(str)) {
            return str;
        }
        if (separator == null) {
            return EMPTY_STRING;
        }
        int pos = str.indexOf(separator);
        if (pos == -1) {
            return EMPTY_STRING;
        }
        return str.substring(pos + separator.length());
    }

    public static String substringBefore(String str, String separator) {
        if (StringUtilities.isEmpty(str) || separator == null) {
            return str;
        }
        if (separator.length() == 0) {
            return EMPTY_STRING;
        }
        int pos = str.indexOf(separator);
        if (pos == -1) {
            return str;
        }
        return str.substring(0, pos);
    }

    public static int countMatches(String str, String sub) {
        if (StringUtilities.isEmpty(str) || StringUtilities.isEmpty(sub)) {
            return 0;
        }
        int count = 0;
        int idx = 0;
        while ((idx = str.indexOf(sub, idx)) != -1) {
            ++count;
            idx += sub.length();
        }
        return count;
    }

    public static String listToString(List<String> list) {
        StringBuilder buffer = new StringBuilder();
        if (list != null) {
            for (int index = 0; index < list.size(); ++index) {
                if (index > 0) {
                    buffer.append(DELIM_COMMA);
                }
                buffer.append(list.get(index));
            }
        }
        return buffer.length() > 0 ? buffer.toString() : EMPTY_STRING;
    }

    public static StringBuffer appendToBuffer(StringBuffer buffer, String strToAppend) {
        if (!StringUtilities.isEmpty(strToAppend)) {
            if (buffer.length() > 0) {
                buffer.append(',');
            }
            buffer.append(strToAppend);
        }
        return buffer;
    }

    public static List<String> stringToList(String list) {
        ArrayList<String> result = new ArrayList<String>();
        if (!StringUtilities.isEmpty(list)) {
            String[] splitted;
            for (String address : splitted = list.split("[;,]")) {
                if (address == null || address.length() <= 0 || !EmailValidator.isValidEmailAddress(address)) continue;
                result.add(address);
            }
        }
        return result;
    }

    public static String stripCharacters(String originalString, Map<String, String> toStrips) {
        if (originalString == null) {
            return null;
        }
        AtomicReference<String> replacedStr = new AtomicReference<String>(originalString);
        Optional.ofNullable(toStrips).orElse(Map.of()).keySet().stream().sorted().forEach(v -> replacedStr.set(((String)replacedStr.get()).replace((CharSequence)v, Optional.ofNullable((String)toStrips.get(v)).orElse(EMPTY_STRING))));
        return replacedStr.get();
    }

    public static List<String> removeDupFromList(List<String> emails) {
        ArrayList<String> arrayList1 = new ArrayList<String>();
        if (emails == null || emails.isEmpty()) {
            return null;
        }
        HashSet<String> hashSet = new HashSet<String>(emails);
        if (hashSet != null && !hashSet.isEmpty()) {
            for (String item : hashSet) {
                if (item == null || !EmailAddressValidator.isValid(item) || arrayList1.contains(item)) continue;
                arrayList1.add(item);
            }
        }
        return arrayList1;
    }

    public static String trim(String s) {
        return s == null ? null : s.trim();
    }

    public static String getMaskedSecureIdStringToPrint(String secureId, boolean printThreeCharacter) {
        Object maskedSecureIdStringForPrinting = EMPTY_STRING;
        try {
            if (secureId != null && !secureId.isEmpty()) {
                int numberOfCharacterToBePrinted = printThreeCharacter ? 3 : 2;
                String secureIdString = secureId.trim();
                int oauthTokenLength = secureIdString.length();
                if (secureIdString.length() > 5 + numberOfCharacterToBePrinted) {
                    maskedSecureIdStringForPrinting = secureIdString.substring(0, numberOfCharacterToBePrinted) + "xxxxxxxxxxxx" + secureIdString.substring(oauthTokenLength - numberOfCharacterToBePrinted, oauthTokenLength);
                }
            }
        }
        catch (Throwable th) {
            logger.log(Level.FINEST, "StringUtilities> getMaskedSecureIdStringToPrint>> Masking and converting secureId to create printString is failed.");
        }
        return maskedSecureIdStringForPrinting;
    }
}

