/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.util;

import com.sygate.scm.util.IOUtilities;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.TimeCounter;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SimpleTemplateParser {
    protected String templateString = null;
    String patterns = "";
    protected Properties props = new Properties();

    public String getTemplateString() {
        return this.templateString;
    }

    public void setTemplateString(String templateString) {
        this.templateString = templateString;
    }

    public boolean loadTemplateFromFile(String fileName) {
        this.templateString = SimpleTemplateParser.readFile(fileName);
        return this.templateString != null;
    }

    public boolean loadTemplateFromResource(String fileName, Class<?> className) {
        this.templateString = SimpleTemplateParser.readFileFromResource(fileName, className);
        return this.templateString != null;
    }

    public String getPatterns() {
        return this.patterns;
    }

    public void setProperty(String pattern, String value) {
        boolean existing = this.props.containsKey(pattern);
        this.props.setProperty(pattern, value);
        if (existing) {
            return;
        }
        if (this.patterns != null && this.patterns.length() > 0) {
            this.patterns = this.patterns + "|";
        }
        this.patterns = this.patterns + pattern;
    }

    public String parse() {
        if (this.patterns == null || this.patterns.length() < 1) {
            return this.templateString;
        }
        if (this.templateString == null) {
            return null;
        }
        TimeCounter counter = new TimeCounter();
        counter.start();
        Pattern p = Pattern.compile(this.patterns);
        Matcher m = p.matcher(this.templateString);
        StringBuffer sb = new StringBuffer();
        String value = null;
        while (m.find()) {
            value = (String)this.props.get(m.group());
            if (value == null) continue;
            if (value.indexOf("\\$") == -1 && value.indexOf(36) != -1) {
                value = value.replace("$", "\\$");
            }
            m.appendReplacement(sb, value);
        }
        m.appendTail(sb);
        counter.stop();
        System.out.println("parse template: elapsed time=" + counter.getDuration() + " (" + counter.getDuration() / 1000L + "s)");
        return sb.toString();
    }

    public static String parseTemplateFromResource(String fileName, Class<?> className, Properties props) {
        if (props == null) {
            return null;
        }
        String str = SimpleTemplateParser.readFileFromResource(fileName, className);
        if (str == null) {
            return null;
        }
        Enumeration<Object> en = props.keys();
        while (en.hasMoreElements()) {
            String key = (String)en.nextElement();
            String value = (String)props.get(key);
            str = str.replaceAll(key, value);
        }
        return str;
    }

    public static String readFileFromResource(String fileName, Class<?> className) {
        if (fileName == null || fileName.length() < 1) {
            System.out.println("SimpleTemplateParser>> readFileFromResource: Error-> file name is invalid!");
            return null;
        }
        if (className == null) {
            System.out.println("SimpleTemplateParser>> readFileFromResource: Error-> className is invalid! file=" + fileName);
            return null;
        }
        String str = null;
        try {
            URL url = className.getResource(fileName);
            InputStream is = url.openStream();
            str = SimpleTemplateParser.readCharStream(is);
            is.close();
        }
        catch (Exception ex) {
            System.out.println("SimpleTemplateParser>> readFileFromResource: Error-> failed to load file! file=" + fileName + ", class=" + className.getName());
            LoggerUtilities.logException(ex);
        }
        return str;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFile(String fileName) {
        if (fileName == null || fileName.length() < 1) {
            System.out.println("SimpleTemplateParser>> readFile: Error-> file name is invalid!");
            return null;
        }
        File f = new File(fileName);
        if (!f.exists()) {
            System.out.println("SimpleTemplateParser>> readFile: Error-> File does NOT exist! file=" + f.getAbsolutePath());
            return null;
        }
        if (!f.canRead()) {
            System.out.println("SimpleTemplateParser>> readFile: Error-> File is NOT readable! file=" + f.getAbsolutePath());
            return null;
        }
        String str = null;
        BufferedInputStream is = null;
        try {
            is = new BufferedInputStream(new FileInputStream(f));
            str = SimpleTemplateParser.readCharStream(is);
        }
        catch (Exception e) {
            try {
                System.out.println("SimpleTemplateParser>> readFile: Exception...");
                LoggerUtilities.logException(e);
            }
            catch (Throwable throwable) {
                IOUtilities.closeInputStream(is);
                throw throwable;
            }
            IOUtilities.closeInputStream(is);
        }
        IOUtilities.closeInputStream(is);
        if (str == null) {
            System.out.println("SimpleTempleteParser>> readFile: Error-> Failed to read file: " + f.getAbsolutePath());
        }
        return str;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readCharStream(InputStream inputStream) {
        if (inputStream == null) {
            return null;
        }
        StringBuffer strBuffer = new StringBuffer();
        try {
            InputStream inputStream2 = inputStream;
            synchronized (inputStream2) {
                int len;
                int bufferSize = 1024;
                InputStreamReader reader = new InputStreamReader(inputStream, "UTF-8");
                char[] c = new char[bufferSize];
                do {
                    len = reader.read(c);
                    strBuffer.append(c, 0, len);
                } while (len >= bufferSize);
            }
        }
        catch (Exception e) {
            System.out.println("SimpleTemplateParser>> readCharStream: Error-> Failed to read");
            LoggerUtilities.logException(e);
            return null;
        }
        return strBuffer.toString();
    }
}

