/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.util;

import com.sygate.scm.common.configobject.XMLHelper;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.valueobject.JdbcParametersVO;
import com.sygate.scm.util.IOUtilities;
import com.sygate.scm.util.JdbcUrlUtil;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.StringUtilities;
import com.sygate.scm.util.Utility;
import com.sygate.scm.util.XmlParser;
import com.sygate.scm.util.XmlUtils;
import com.sygate.scm.util.db.JDBCDriverHelper;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ServerXml {
    public static final String PROPERTY_SERVICE = "Service";
    public static final String PROPERTY_ENGINE = "Engine";
    public static final String PROPERTY_HOST = "Host";
    public static final String PROPERTY_VALVE = "Valve";
    public static final String PROPERTY_FACTORY = "Factory";
    public static final String PROPERTY_CONNECTOR = "Connector";
    public static final String ATT_NAME_SSL_IMPLEMENTATION_OLD = "SSLImplementation";
    public static final String ATT_NAME_SSL_IMPLEMENTATION_NEW = "sslImplementationName";
    public static final String SERVER_XML_SERVICE_RMMWEBSERVICE = "WebService";
    private static final String CIPHERS_VALUE = "TLS_RSA_WITH_AES_128_CBC_SHA,TLS_DHE_RSA_WITH_AES_128_CBC_SHA,TLS_DHE_DSS_WITH_AES_128_CBC_SHA,TLS_RSA_WITH_AES_256_CBC_SHA,TLS_DHE_DSS_WITH_AES_256_CBC_SHA,TLS_DHE_RSA_WITH_AES_256_CBC_SHA,SSL_RSA_WITH_3DES_EDE_CBC_SHA,SSL_DHE_RSA_WITH_3DES_EDE_CBC_SHA,SSL_DHE_DSS_WITH_3DES_EDE_CBC_SHA";
    private static final String RMM_WS_ENABLED_COMMENT = "Web services for remote management are enabled. To disable these web services, open a command prompt, navigate to the Tools folder in your Symantec Endpoint Protection Manager installation folder, and type the following: ConfigSEPM.bat -RmmWS:OFF";
    private static final String RMM_WS_DISABLED_COMMENT = "Web services for remote management are disabled. To enable these web services, open a command prompt, navigate to the Tools folder in your Symantec Endpoint Protection Manager installation folder, and type the following: ConfigSEPM.bat -RmmWS:ON";
    private static final String WS_END_TAG = "</Service>";
    private static final String WS_END_DISABLED_TAG = "</Service-->";
    private static final String RMM_WS_START_TAG = "<Service name=\"WebService\">";
    private static final String RMM_WS_START_DISABLED_TAG = "<!--Service name=\"WebService\">";
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final String ROOT_RESOURCE_PROPERTY_MAXACTIVE = "maxActive";
    private static final String ROOT_RESOURCE_PROPERTY_MAXTOTAL = "maxTotal";
    private static final String ROOT_RESOURCE_PROPERTY_MAXWAIT = "maxWait";
    private static final String ROOT_RESOURCE_PROPERTY_MAXWAITMILLS = "maxWaitMillis";
    private static final String ROOT_RESOURCE_PROPERTY_LOGABANDONED = "logAbandoned";
    private static final String CONNECTOR_PROPERTY_PROTOCOL = "protocol";
    private static final String CONNECTOR_PROPERTY_ADDRESS = "address";
    private static final String CONNECTOR_PROPERTY_ADDRESS_IPV4_VALUE = "0.0.0.0";
    private static final String CONNECTOR_PROPERTY_ADDRESS_IPV6_VALUE = "::0";
    private static final String CONNECTOR_PROPERTY_ADDRESS_IPV6_VALUE2 = "::";
    @Deprecated
    private static final String CONNECTOR_PROPERTY_PROTOCOL_HTTP11_DEPRECATED = "org.apache.coyote.http11.Http11Protocol";
    private static final String CONNECTOR_PROPERTY_PROTOCOL_APR = "org.apache.coyote.http11.Http11AprProtocol";
    private static final String CONNECTOR_PROPERTY_PROTOCOL_NIO2 = "org.apache.coyote.http11.Http11Nio2Protocol";
    private static final String CONNECTOR_PROPERTY_SSL_IMPLEMENTATION_OPENSSL = "org.apache.tomcat.util.net.openssl.OpenSSLImplementation";
    private static final String CONNECTOR_PROPERTY_SSL_IMPLEMETATION_KEY = "sslImplementationName";
    private static final String CONNECTOR_PROPERTY_SSLENABLED_PROTOCOLS = "sslEnabledProtocols";
    private static final String CONNECTOR_PROPERTY_CLIENT_AUTH_ATTR = "clientAuth";
    private static final String CONNECTOR_PROPERTY_SSL_PROTOCOL_OLD_ATTR = "sslProtocol";
    private static final String CONNECTOR_PROPERTY_SSL_PROTOCOL = "SSLProtocol";
    private static final String CONNECTOR_PROPERTY_SSL_PROTOCOLS_DEFAULT_VALUE = "TLSv1.2";
    public static final String CONNECTOR_PROPERTY_SSLENABLED = "SSLEnabled";
    public static final String CONNECTOR_PROPERTY_SSLENABLED_TRUE = "true";
    public static final String CONNECTOR_PROPERTY_SSLSCHEME = "scheme";
    public static final String CONNECTOR_PROPERTY_CONNECTION_TIMEOUT = "connectionTimeout";
    public static final String CONNECTOR_PROPERTY_CONNECTION_TIMEOUT_DEFAULT_VALUE = "60000";
    private static final String CONNECTOR_PROPERTY_SSLSCHEME_HTTP = "http";
    public static final String CONNECTOR_PROPERTY_SLSCHEME_HTTPS = "https";
    public static final String CONNECTOR_PROPERTY_SSLSECURE = "secure";
    public static final String CONNECTOR_PROPERTY_SSLSECURE_TRUE = "true";
    private static final String CONNECTOR_PROPERTY_SSLSECURE_FALSE = "false";
    public static final String CONNECTOR_PROPERTY_KEYSTOREPASS = "keystorePass";
    public static final String CONNECTOR_PROPERTY_KEYSTOREFILE = "keystoreFile";
    private static final String CONNECTOR_PROPERTY_CIPHERS = "ciphers";
    private static final String WEBSERVICE_CONNECTOR_SSL_IMPL_CLASS_NAME = "com.sygate.scm.pool.customssl.CustomSSLImplementation";
    private static final String CONNECTOR_PROPERTY_SSLCIPHERSUITE = "SSLCipherSuite";
    private static final String CONNECTOR_PROPERTY_SSLCERTIFICATEFILE = "SSLCertificateFile";
    private static final String CONNECTOR_PROPERTY_SSLCERTIFICATEKEYFILE = "SSLCertificateKeyFile";
    private static final String CONNECTOR_PROPERTY_SSLVERIFYCLIENT = "SSLVerifyClient";
    private static final String CONNECTOR_PROPERTY_SSLVERIFYCLIENT_DEFAULT_VALUE = "optional";
    private static final String CONNECTOR_PROPERTY_SSLCACERTIFICATEFILE = "SSLCACertificateFile";
    private static final String CONNECTOR_PROPERTY_SSLCACERTIFICATEFILE_DEFAULT_VALUE = "smartCard.pem";
    private static final String CONNECTOR_PROPERTY_SSLHONORCIPHERORDER = "SSLHonorCipherOrder";
    private static final String CONNECTOR_PROPERTY_CERTIFICATE_FILE_DEFAULT_VALUE = "server.crt";
    private static final String CONNECTOR_PROPERTY_CERTIFICATE_KEY_DEFAULT_VALUE = "server.key";
    private static final String LISTENER_PROPERTY_CLASS_NAME = "org.apache.catalina.core.AprLifecycleListener";
    private static final String CONNECTOR_PROPERTY_SSLCIPHERSUITE_DEFAULT_VALUE = "HIGH:!MEDIUM:!LOW:!aNULL:!eNULL:!3DES:!RC4:!kDH:!SHA1:!CAMELLIA:!CHACHA20:!ARIAGCM";
    private static final String SERVICE_NAME_SCM = "SCM";
    private static final String ATTRIBUTE_NAME = "name";
    private static final String ATTRIBUTE_ENGINE_NAME_VALUE = "Catalina";
    private static final String ATTRIBUTE_DEFAULT_HOST = "defaultHost";
    private static final String VALVE_PROPERTY_CLASSNAME = "className";
    private static final String VALVE_PROPERTY_CLASSNAME_VALUE = "org.apache.catalina.valves.ErrorReportValve";
    private static final String VALVE_PROPERTY_SHOW_REPORT = "showReport";
    private static final String VALVE_PROPERTY_SHOW_REPORT_VALUE = "false";
    private static final String VALVE_PROPERTY_SHOW_SERVER_INFO = "showServerInfo";
    private static final String VALVE_PROPERTY_SHOW_SERVER_INFO_VALUE = "false";
    private static final String LOG_CLASS_NAME = "ServerXML> ";
    private static final String LOG_METHOD_TOMCAT_VALVE = "updateServerXmlForTomcatErrorValves>> ";
    private static final String LOG_PREFIX_METHOD_TOMCAT_VALVE = "ServerXML> updateServerXmlForTomcatErrorValves>> ";
    private static final String LOG_TOMCAT_ERROR_VALVE_PREXISTS = "TomcatErrorValves preexists. ";
    private static final String LOG_ADDED_ATTRIBUTES = "Added attribute ";
    private static final String LOG_ATTRIBUTE = "Attribute ";
    private static final String LOG_EXISTS = " exists. ";
    private static final String ATTRIBUTE_VALUE_TRUE = "true";
    private static final String ATTRIBUTE_VALUE_FALSE = "false";
    public static final String NEW_SERVER_REWRITE_VALVE_NODE_TO_ADD_PROPERTY = "name=Catalina_WS";
    public static final String VALVE_CLASS_NAME_ORG_APACHE_CATALINA_VALVES_REWRITE_REWRITE_VALVE = "<Valve className=\"org.apache.catalina.valves.rewrite.RewriteValve\" />";
    public static final String ATTRIBUTE_NAME_AUTO_DEPLOY = "autoDeploy";
    public static final String ATTRIBUTE_NAME_DEPLOY_ON_STARTUP = "deployOnStartup";
    public static final String ATTRIBUTE_NAME_LIVE_DEPLOY = "liveDeploy";
    public static final String ATTRIBUTE_NAME_UNPACK_WARS = "unpackWARs";
    public static final String ATTRIBUTE_NAME_DOC_BASE = "docBase";
    public static final String ATTRIBUTE_NAME_PATH = "path";
    public static final String ATTRIBUTE_NAME_RELOADABLE = "reloadable";
    private static long oldLastModified = -1L;
    private static Boolean hasRSA = null;
    private static ROOTXmlHandler handler = null;
    private static Logger logger = Logger.getLogger(ServerXml.class.toString());

    public static boolean isEmbeddedSQLExpress(String serverHome) {
        boolean isEmbeddedSQLExpress = false;
        try {
            String tomcatROOTXmlFilePath = ServerXml.getROOTXmlPath(serverHome);
            XmlParser parser = new XmlParser();
            parser.readXmlFile(tomcatROOTXmlFilePath);
            Document document = parser.getDocument();
            Element contextElement = document.getDocumentElement();
            Element resourceElement = (Element)contextElement.getElementsByTagName("Resource").item(0);
            String value = resourceElement.getAttribute("embedded");
            isEmbeddedSQLExpress = "true".equalsIgnoreCase(value);
        }
        catch (Exception ex) {
            LoggerUtilities.logException(ex);
        }
        return isEmbeddedSQLExpress;
    }

    private static void initialCipher(String serverHome, String serverPort) throws FileNotFoundException, ParserConfigurationException, IOException, SAXException {
        Document doc = ServerXml.getServerXmlDocument(serverHome);
        Element serverElement = doc.getDocumentElement();
        Element serviceElement = XMLHelper.getFirstChildElement(serverElement, PROPERTY_SERVICE);
        ArrayList<Element> connector = XMLHelper.getChildElementByName(serviceElement, PROPERTY_CONNECTOR);
        for (Object e : connector) {
            Element conEle = (Element)e;
            String ciphersAttr = conEle.getAttribute(CONNECTOR_PROPERTY_CIPHERS);
            String portAttr = conEle.getAttribute("port");
            if (ciphersAttr.length() <= 0 || !portAttr.equals(serverPort)) continue;
            hasRSA = ciphersAttr.contains("RSA");
            return;
        }
        hasRSA = Boolean.TRUE;
    }

    public static String getDatabasePassword(String serverHome) {
        String tomcatROOTXmlFilePath = ServerXml.getROOTXmlPath(serverHome);
        XmlParser parser = new XmlParser();
        parser.readXmlFile(tomcatROOTXmlFilePath);
        Document document = parser.getDocument();
        Element contextElement = document.getDocumentElement();
        Element resourceElement = (Element)contextElement.getElementsByTagName("Resource").item(0);
        try {
            String dbPassword = resourceElement.getAttribute("password");
            return Utility.decryptLatestForDB(dbPassword);
        }
        catch (Exception ex) {
            LoggerUtilities.logException(ex);
            return null;
        }
    }

    public static boolean backupServerROOTXmlFiles(String tomcatServerHome) {
        boolean backupFileCreated = false;
        if (StringUtilities.isEmpty(tomcatServerHome)) {
            System.out.println("ServerXml> backupServerROOTXmlFiles>> Server-Home is null or empty.");
        } else {
            String rootXMLFilePath = ServerXml.getROOTXmlPath(tomcatServerHome);
            backupFileCreated = ServerXml.createBackupFile(rootXMLFilePath);
            System.out.println("ServerXml> backupServerROOTXmlFiles>> Is ROOT.xml.bak file created ? " + backupFileCreated);
            String serverXMLFilePath = ServerXml.getServerXmlPath(tomcatServerHome);
            backupFileCreated = ServerXml.createBackupFile(serverXMLFilePath);
            System.out.println("ServerXml> backupServerROOTXmlFiles>> Is Server.xml.bak file deleted ? " + backupFileCreated);
        }
        return backupFileCreated;
    }

    private static boolean createBackupFile(String filePath) {
        boolean backupFileCreated = false;
        String backupFilePath = filePath + ".bak";
        File file = new File(filePath);
        if (file.exists()) {
            File backupFile = new File(backupFilePath);
            boolean existingBackUpFileDeleted = true;
            if (backupFile.exists()) {
                try {
                    backupFile.setWritable(true);
                    existingBackUpFileDeleted = backupFile.delete();
                    System.out.println("ServerXml> createBackupFile>> Is existing backup file deleted ? " + existingBackUpFileDeleted);
                }
                catch (Throwable th) {
                    System.out.println("ServerXml> createBackupFile>> Existing backup file could not be deleted. Error: " + th.getMessage());
                }
            }
            file = null;
            backupFile = null;
            if (existingBackUpFileDeleted) {
                backupFileCreated = Utility.copyFile(filePath, backupFilePath);
                System.out.println("ServerXml> createBackupFile>> Is backup file created ? " + backupFileCreated);
            }
        } else {
            System.out.println("ServerXml> createBackupFile>> " + filePath + " file does not exist.");
        }
        return backupFileCreated;
    }

    public static void restoreServerROOTXmlBackupFiles(String tomcatServerHome) {
        if (StringUtilities.isEmpty(tomcatServerHome)) {
            System.out.println("ServerXml> restoreServerROOTXmlBackupFiles>> Server-Home is null or empty.");
        } else {
            Path rootXMLFilePath = Paths.get(ServerXml.getROOTXmlPath(tomcatServerHome), new String[0]);
            Path rootXMLFilePathBak = Paths.get(ServerXml.getROOTXmlPath(tomcatServerHome) + ".bak", new String[0]);
            if (Files.exists(rootXMLFilePathBak, new LinkOption[0])) {
                rootXMLFilePath.toFile().delete();
                rootXMLFilePathBak.toFile().renameTo(rootXMLFilePath.toFile());
                System.out.println("ServerXml> restoreServerROOTXmlBackupFiles>> Is ROOT.xml file was restored!");
            }
            Path serverXMLFilePath = Paths.get(ServerXml.getServerXmlPath(tomcatServerHome), new String[0]);
            Path serverXMLFilePathBak = Paths.get(ServerXml.getServerXmlPath(tomcatServerHome) + ".bak", new String[0]);
            if (Files.exists(serverXMLFilePathBak, new LinkOption[0])) {
                serverXMLFilePath.toFile().delete();
                serverXMLFilePathBak.toFile().renameTo(serverXMLFilePath.toFile());
                System.out.println("ServerXml> restoreServerROOTXmlBackupFiles>> Is ROOT.xml file was restored!");
            }
        }
    }

    public static boolean deleteServerROOTXmlBackupFiles(String tomcatServerHome) {
        boolean backupFileDeleted = false;
        if (StringUtilities.isEmpty(tomcatServerHome)) {
            System.out.println("ServerXml> deleteServerROOTXmlBackupFiles>> Server-Home is null or empty.");
        } else {
            String rootXMLFilePath = ServerXml.getROOTXmlPath(tomcatServerHome);
            backupFileDeleted = ServerXml.deleteBackupFile(rootXMLFilePath);
            System.out.println("ServerXml> deleteServerROOTXmlBackupFiles>> Is ROOT.xml.bak file deleted ? " + backupFileDeleted);
            String serverXMLFilePath = ServerXml.getServerXmlPath(tomcatServerHome);
            backupFileDeleted = ServerXml.deleteBackupFile(serverXMLFilePath);
            System.out.println("ServerXml> deleteServerROOTXmlBackupFiles>> Is Server.xml.bak file deleted ? " + backupFileDeleted);
        }
        return backupFileDeleted;
    }

    private static boolean deleteBackupFile(String filePath) {
        boolean backupFileDeleted = false;
        try {
            String rootXMLBackupFilePath = filePath + ".bak";
            File rootXMLBackupFile = new File(rootXMLBackupFilePath);
            if (rootXMLBackupFile.exists()) {
                backupFileDeleted = Utility.delete(rootXMLBackupFile);
                System.out.println("ServerXml> deleteBackupFile>> Is backup file deleted ? " + backupFileDeleted);
            } else {
                System.out.println("ServerXml> deleteBackupFile>> backup file does not exist.");
            }
        }
        catch (Throwable th) {
            System.out.println("ServerXml> deleteBackupFile>> Exception while deleting backup file. Exception message: " + th.getMessage());
        }
        return backupFileDeleted;
    }

    public static void verifyAndRetrieveServerROOTXml(String tomcatServerHome) {
        System.out.println("ServerXml>> verifyAndRetrieveROOTXml>> Verifying ROOT.xml...");
        if (StringUtilities.isEmpty(tomcatServerHome)) {
            System.out.println("ServerXml>> verifyAndRetrieveROOTXml>> Server-Home is null or empty.");
        } else {
            String tomcatROOTXmlFilePath = ServerXml.getROOTXmlPath(tomcatServerHome);
            ServerXml.verifyAndRetrieveXmlFile(tomcatROOTXmlFilePath);
            String tomcatServerXmlFilePath = ServerXml.getServerXmlPath(tomcatServerHome);
            ServerXml.verifyAndRetrieveXmlFile(tomcatServerXmlFilePath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void verifyAndRetrieveXmlFile(String filePath) {
        File file = new File(filePath);
        String backupFilePath = filePath + ".bak";
        File backupFile = new File(backupFilePath);
        backupFile.setWritable(true);
        boolean validXml = false;
        if (file.exists()) {
            XmlParser parser = new XmlParser();
            validXml = parser.readXmlFile(filePath);
        }
        if (validXml) {
            System.out.println("ServerXml>> verifyAndRetrieveXmlFile>> .xml file is valid, deleting backup file...");
            if (backupFile.exists()) {
                boolean rootXMLBackupDeleted = backupFile.delete();
                System.out.println("ServerXml>> verifyAndRetrieveXmlFile>> Is .xml.bak file deleted sucessfully ? " + rootXMLBackupDeleted);
            }
        } else {
            System.out.println("ServerXml>> verifyAndRetrieveXmlFile>> .xml file is invalid. Trying to retrieve it from .bak file...");
            boolean xmlFileWritable = file.canWrite();
            System.out.println("ServerXml> verifyAndRetrieveXmlFile>> .xml file is " + (xmlFileWritable ? "" : "not") + " writable.");
            if (backupFile.exists()) {
                file.setWritable(true);
                System.out.println("ServerXml> verifyAndRetrieveXmlFile>> .xml file set it to writable.");
                try {
                    boolean renamed = Utility.renameFile(filePath + ".bak", filePath);
                    System.out.println("ServerXml>> verifyAndRetrieveXmlFile>> .xml file " + (renamed ? "is" : "could not be") + " retrieved from backup (.bak) file.");
                }
                finally {
                    file.setWritable(xmlFileWritable);
                    System.out.println("ServerXml> verifyAndRetrieveXmlFile>> .xml file is set to original writable state.");
                }
            } else {
                System.out.println("ServerXml>> verifyAndRetrieveXmlFile>> No backup file found for .xml.");
            }
        }
    }

    public static boolean hasRSACiphers(String serverHome, String serverPort) throws FileNotFoundException, ParserConfigurationException, IOException, SAXException {
        if (hasRSA == null) {
            ServerXml.initialCipher(serverHome, serverPort);
        }
        return hasRSA;
    }

    public static Document getServerXmlDocument(String serverHome) throws ParserConfigurationException, FileNotFoundException, IOException, SAXException {
        Document document = null;
        try (FileInputStream is = new FileInputStream(ServerXml.getServerXmlPath(serverHome));){
            DocumentBuilder builder = XmlUtils.getSecureDocumentBuilder();
            document = builder.parse(is);
        }
        return document;
    }

    public static String getROOTXmlPath(String serverHome) {
        return serverHome + File.separator + "conf" + File.separator + ATTRIBUTE_ENGINE_NAME_VALUE + File.separator + "localhost" + File.separator + "ROOT.xml";
    }

    public static String getServerXmlPath(String tomcatBaseFilePath) {
        return tomcatBaseFilePath + File.separator + "conf" + File.separator + "server.xml";
    }

    public static String getServerXmlPathForSemApiSrvService(String serverHome) {
        return ServerXml.getServerXmlPath(serverHome + File.separator + "instances" + File.separator + "sepm-api");
    }

    public static String getJDBCPropertiesPath(String serverHome) {
        return serverHome + File.separator + "instances" + File.separator + "sepm-api" + File.separator + "conf" + File.separator + "Catalina_WS" + File.separator + "localhost" + File.separator + "jdbc.properties";
    }

    public static boolean updateAllTomcatServerXmlFilesWithUnsupportedAttributesRemoved(String serverHome) {
        return ServerXml.updateTomcatServerXmlFileWithUnsupportedAttributesRemoved(ServerXml.getServerXmlPath(serverHome)) && ServerXml.updateTomcatServerXmlFileWithUnsupportedAttributesRemoved(ServerXml.getServerXmlPathForSemApiSrvService(serverHome));
    }

    private static boolean updateTomcatServerXmlFileWithUnsupportedAttributesRemoved(String tomcatServerXmlFilePath) {
        XmlParser parser = new XmlParser();
        parser.readXmlFile(tomcatServerXmlFilePath);
        Document document = parser.getDocument();
        Element serverElement = document.getDocumentElement();
        Element serviceElement = XmlParser.getFirstChildElement(serverElement, PROPERTY_SERVICE);
        boolean modified = false;
        while (serviceElement != null) {
            Element connectorElement = XmlParser.getFirstChildElement(serviceElement, PROPERTY_CONNECTOR);
            while (connectorElement != null) {
                if (connectorElement.hasAttribute("debug")) {
                    connectorElement.removeAttribute("debug");
                    modified = true;
                }
                if (connectorElement.hasAttribute("maxProcessors")) {
                    connectorElement.removeAttribute("maxProcessors");
                    modified = true;
                }
                if (connectorElement.hasAttribute("minProcessors")) {
                    connectorElement.removeAttribute("minProcessors");
                    modified = true;
                }
                if (connectorElement.hasAttribute("useURIValidationHack")) {
                    connectorElement.removeAttribute("useURIValidationHack");
                    modified = true;
                }
                connectorElement = XmlParser.getNextMatchingSibling(connectorElement, PROPERTY_CONNECTOR);
            }
            Element engineElement = XmlParser.getFirstChildElement(serviceElement, PROPERTY_ENGINE);
            Element hostElement = XmlParser.getFirstChildElement(engineElement, PROPERTY_HOST);
            if (hostElement != null && hostElement.hasAttribute(ATTRIBUTE_NAME_LIVE_DEPLOY)) {
                hostElement.removeAttribute(ATTRIBUTE_NAME_LIVE_DEPLOY);
                modified = true;
            }
            serviceElement = XmlParser.getNextMatchingSibling(serviceElement, PROPERTY_SERVICE);
        }
        return !modified || parser.saveXml(tomcatServerXmlFilePath);
    }

    public static boolean updateTomcatServerXmlConnector(String serverHome) {
        logger.log(Level.INFO, "Updating connector protocol...");
        String tomcatServerXmlFilePath = ServerXml.getServerXmlPath(serverHome);
        XmlParser parser = new XmlParser();
        try {
            if (!parser.readXmlFile(tomcatServerXmlFilePath)) {
                throw new Exception("Unable to parse server.xml file. Your product is not correctly installed.");
            }
            Document document = parser.getDocument();
            XPathFactory factory = XPathFactory.newInstance();
            XPath xpath = factory.newXPath();
            NodeList connectorNode = (NodeList)xpath.evaluate("//Connector", document, XPathConstants.NODESET);
            logger.log(Level.INFO, "Updaing connectors if applicable...");
            if (connectorNode != null) {
                boolean isUpdated = false;
                for (int i = 0; i < connectorNode.getLength(); ++i) {
                    Element currentConnectorNode = (Element)connectorNode.item(i);
                    isUpdated = ServerXml.updateProtocol(currentConnectorNode);
                    isUpdated = ServerXml.updateConnectionTimeout(currentConnectorNode) || isUpdated;
                }
                if (!isUpdated) {
                    return true;
                }
                if (!parser.saveXml(tomcatServerXmlFilePath)) {
                    logger.log(Level.WARNING, "Failed to save xml");
                    return false;
                }
            } else {
                logger.log(Level.WARNING, "Unable to find a 'Connector' node in server.xml file. Server.xml does not seem to be properly configured.");
                return false;
            }
            return true;
        }
        catch (XPathExpressionException e) {
            logger.log(Level.WARNING, "ServerXml> updateTomcatServerXmlFileProtocol>> Error when parsing server.xml file for updating Connector protocol");
            LoggerUtilities.logException(e);
            return false;
        }
        catch (Exception e) {
            if (e.getMessage() != null) {
                logger.log(Level.WARNING, e.getMessage());
            }
            LoggerUtilities.logException(e);
            return false;
        }
    }

    private static boolean updateProtocol(Element currentConnectorNode) {
        boolean isUpdated = false;
        logger.log(Level.INFO, "Connector Protocol: {0}", currentConnectorNode.getAttribute(CONNECTOR_PROPERTY_PROTOCOL));
        if (CONNECTOR_PROPERTY_SLSCHEME_HTTPS.equalsIgnoreCase(currentConnectorNode.getAttribute(CONNECTOR_PROPERTY_SSLSCHEME)) && "true".equalsIgnoreCase(currentConnectorNode.getAttribute(CONNECTOR_PROPERTY_SSLENABLED))) {
            currentConnectorNode.setAttribute(CONNECTOR_PROPERTY_SSLCIPHERSUITE, CONNECTOR_PROPERTY_SSLCIPHERSUITE_DEFAULT_VALUE);
            currentConnectorNode.setAttribute(CONNECTOR_PROPERTY_PROTOCOL, CONNECTOR_PROPERTY_PROTOCOL_NIO2);
            currentConnectorNode.setAttribute("sslImplementationName", CONNECTOR_PROPERTY_SSL_IMPLEMENTATION_OPENSSL);
            isUpdated = true;
            logger.log(Level.INFO, "Protocol and ssl implementation updated.");
        } else if (currentConnectorNode.getAttribute(CONNECTOR_PROPERTY_PROTOCOL).equals(CONNECTOR_PROPERTY_PROTOCOL_HTTP11_DEPRECATED) || currentConnectorNode.getAttribute(CONNECTOR_PROPERTY_PROTOCOL).equals(CONNECTOR_PROPERTY_PROTOCOL_APR)) {
            currentConnectorNode.setAttribute(CONNECTOR_PROPERTY_PROTOCOL, CONNECTOR_PROPERTY_PROTOCOL_NIO2);
            isUpdated = true;
            logger.log(Level.INFO, "Protocol updated to Nio2.");
        }
        return isUpdated;
    }

    private static boolean updateConnectionTimeout(Element currentConnectorNode) {
        boolean isUpdated = false;
        logger.log(Level.INFO, "Connector connectionTimeout: {0}", currentConnectorNode.getAttribute(CONNECTOR_PROPERTY_CONNECTION_TIMEOUT));
        if (StringUtilities.isEmpty(currentConnectorNode.getAttribute(CONNECTOR_PROPERTY_CONNECTION_TIMEOUT))) {
            currentConnectorNode.setAttribute(CONNECTOR_PROPERTY_CONNECTION_TIMEOUT, CONNECTOR_PROPERTY_CONNECTION_TIMEOUT_DEFAULT_VALUE);
            isUpdated = true;
            logger.log(Level.INFO, "Connector connectionTimeout was updated with default value: {0}", CONNECTOR_PROPERTY_CONNECTION_TIMEOUT_DEFAULT_VALUE);
        }
        return isUpdated;
    }

    public static boolean updateSecureWebServiceConnector(String serverHome) {
        boolean ret = false;
        String tomcatServerXmlFilePath = ServerXml.getServerXmlPath(serverHome);
        XmlParser parser = new XmlParser();
        parser.readXmlFile(tomcatServerXmlFilePath);
        Document document = parser.getDocument();
        Element serverElement = document.getDocumentElement();
        Element serviceElement = (Element)serverElement.getElementsByTagName(PROPERTY_SERVICE).item(0);
        NodeList connectorList = serviceElement.getElementsByTagName(PROPERTY_CONNECTOR);
        for (int i = 0; i < connectorList.getLength(); ++i) {
            Element connectorElement = (Element)connectorList.item(i);
            if (!CONNECTOR_PROPERTY_SSLSCHEME_HTTP.equalsIgnoreCase(connectorElement.getAttribute(CONNECTOR_PROPERTY_SSLSCHEME)) || !"false".equalsIgnoreCase(connectorElement.getAttribute(CONNECTOR_PROPERTY_SSLSECURE))) continue;
            connectorElement.setAttribute(CONNECTOR_PROPERTY_SSLSECURE, "true");
            ret = true;
        }
        if (ret) {
            ret = parser.saveXml(tomcatServerXmlFilePath);
        }
        return ret;
    }

    public static boolean updateWebServiceConnector(String serverHome, String webServicePort, boolean isCustomSSLImplRequired) throws Exception {
        boolean ret = false;
        String tomcatServerXmlFilePath = ServerXml.getServerXmlPath(serverHome);
        XmlParser parser = new XmlParser();
        parser.readXmlFile(tomcatServerXmlFilePath);
        Document document = parser.getDocument();
        Element serverElement = document.getDocumentElement();
        Element serviceElement = (Element)serverElement.getElementsByTagName(PROPERTY_SERVICE).item(0);
        NodeList connectorList = serviceElement.getElementsByTagName(PROPERTY_CONNECTOR);
        Element newWebServiceConnector = null;
        Element webServiceConnector = null;
        for (int i = 0; i < connectorList.getLength(); ++i) {
            Element connectorElement = (Element)connectorList.item(i);
            if (!CONNECTOR_PROPERTY_SLSCHEME_HTTPS.equalsIgnoreCase(connectorElement.getAttribute(CONNECTOR_PROPERTY_SSLSCHEME)) || !"true".equalsIgnoreCase(connectorElement.getAttribute(CONNECTOR_PROPERTY_SSLSECURE))) continue;
            if (!"want".equalsIgnoreCase(connectorElement.getAttribute(CONNECTOR_PROPERTY_CLIENT_AUTH_ATTR))) {
                newWebServiceConnector = (Element)connectorElement.cloneNode(true);
                continue;
            }
            webServiceConnector = connectorElement;
            break;
        }
        if (webServiceConnector != null) {
            if (webServicePort.equalsIgnoreCase(webServiceConnector.getAttribute("port"))) {
                webServiceConnector.setAttribute("port", webServicePort);
                ret = true;
            }
        } else if (newWebServiceConnector != null) {
            newWebServiceConnector.setAttribute("port", webServicePort);
            newWebServiceConnector.setAttribute(CONNECTOR_PROPERTY_CLIENT_AUTH_ATTR, "want");
            if (isCustomSSLImplRequired) {
                newWebServiceConnector.setAttribute("sslImplementationName", WEBSERVICE_CONNECTOR_SSL_IMPL_CLASS_NAME);
            }
            serviceElement.appendChild(newWebServiceConnector);
            ret = true;
        }
        if (ret) {
            ret = parser.saveXml(tomcatServerXmlFilePath);
        }
        return ret;
    }

    public static boolean setKeystoreAttributes(String serverHome, String keyPairPasswd, String keyPairPath) {
        String tomcatServerXmlFilePath = ServerXml.getServerXmlPath(serverHome);
        XmlParser parser = new XmlParser();
        parser.readXmlFile(tomcatServerXmlFilePath);
        Document document = parser.getDocument();
        Element serverElement = document.getDocumentElement();
        NodeList serviceList = serverElement.getElementsByTagName(PROPERTY_SERVICE);
        for (int iservice = 0; serviceList != null && iservice < serviceList.getLength(); ++iservice) {
            if (serviceList.item(iservice) == null) continue;
            Element serviceElement = (Element)serviceList.item(iservice);
            NodeList connectorList = serviceElement.getElementsByTagName(PROPERTY_CONNECTOR);
            for (int i = 0; i < connectorList.getLength(); ++i) {
                Element connectorElement = (Element)connectorList.item(i);
                if (!CONNECTOR_PROPERTY_SLSCHEME_HTTPS.equalsIgnoreCase(connectorElement.getAttribute(CONNECTOR_PROPERTY_SSLSCHEME)) || !"true".equalsIgnoreCase(connectorElement.getAttribute(CONNECTOR_PROPERTY_SSLENABLED))) continue;
                connectorElement.setAttribute(CONNECTOR_PROPERTY_KEYSTOREPASS, keyPairPasswd);
                connectorElement.setAttribute(CONNECTOR_PROPERTY_KEYSTOREFILE, keyPairPath);
            }
        }
        return parser.saveXml(tomcatServerXmlFilePath);
    }

    public static boolean changeValidationQueryTimeoutValue(Element resourceElement, boolean isEmbeddedDB) {
        String vQueryTimeout = resourceElement.getAttribute("validationQueryTimeout");
        int oldQueryTimeout = -1;
        try {
            if (!StringUtilities.isEmpty(vQueryTimeout)) {
                oldQueryTimeout = Integer.parseInt(vQueryTimeout);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        int newQueryTimeout = 60;
        if (isEmbeddedDB) {
            newQueryTimeout = 60;
        }
        if (StringUtilities.isEmpty(vQueryTimeout) || newQueryTimeout > oldQueryTimeout) {
            resourceElement.setAttribute("validationQueryTimeout", String.valueOf(newQueryTimeout));
            return true;
        }
        String testOnBorrow = resourceElement.getAttribute("testOnBorrow");
        if (StringUtilities.isEmpty(testOnBorrow)) {
            resourceElement.setAttribute("testOnBorrow", "true");
            return true;
        }
        return false;
    }

    public static boolean updateROOTXmlIfMSSQL(String serverHome, boolean trustServerCert) throws IOException {
        String tomcatROOTXmlFilePath = ServerXml.getROOTXmlPath(serverHome);
        XmlParser parser = new XmlParser();
        parser.readXmlFile(tomcatROOTXmlFilePath);
        Document document = parser.getDocument();
        Element contextElement = document.getDocumentElement();
        Element resourceElement = (Element)contextElement.getElementsByTagName("Resource").item(0);
        boolean needUpdate = JDBCDriverHelper.updateJDBCDriverToMSJDBC(resourceElement, trustServerCert);
        return !needUpdate || parser.saveXml(tomcatROOTXmlFilePath);
    }

    public static boolean updateROOTXml(String serverHome, boolean isEmbedded, boolean updateSocketTimeout, boolean trustServerCert) throws IOException {
        StringBuffer urlStringBuffer;
        String vquery;
        Element resourceElement;
        String tomcatROOTXmlFilePath = ServerXml.getROOTXmlPath(serverHome);
        XmlParser parser = new XmlParser();
        parser.readXmlFile(tomcatROOTXmlFilePath);
        Document document = parser.getDocument();
        Element contextElement = document.getDocumentElement();
        if (contextElement == null) {
            return false;
        }
        boolean needUpdate = false;
        if (contextElement.hasAttribute("debug")) {
            contextElement.removeAttribute("debug");
            needUpdate = true;
        }
        if ((resourceElement = (Element)contextElement.getElementsByTagName("Resource").item(0)).hasAttribute(ROOT_RESOURCE_PROPERTY_MAXACTIVE)) {
            resourceElement.setAttribute(ROOT_RESOURCE_PROPERTY_MAXTOTAL, resourceElement.getAttribute(ROOT_RESOURCE_PROPERTY_MAXACTIVE));
            resourceElement.removeAttribute(ROOT_RESOURCE_PROPERTY_MAXACTIVE);
            needUpdate = true;
        }
        if (resourceElement.hasAttribute(ROOT_RESOURCE_PROPERTY_MAXWAIT)) {
            resourceElement.setAttribute(ROOT_RESOURCE_PROPERTY_MAXWAITMILLS, resourceElement.getAttribute(ROOT_RESOURCE_PROPERTY_MAXWAIT));
            resourceElement.removeAttribute(ROOT_RESOURCE_PROPERTY_MAXWAIT);
            needUpdate = true;
        }
        if (!resourceElement.hasAttribute(ROOT_RESOURCE_PROPERTY_LOGABANDONED)) {
            resourceElement.setAttribute(ROOT_RESOURCE_PROPERTY_LOGABANDONED, "false");
            needUpdate = true;
        }
        if ((vquery = resourceElement.getAttribute("validationQuery")) != null && vquery.indexOf("DUMMY") > 0) {
            resourceElement.setAttribute("validationQuery", "SELECT count(*) FROM CONNECTION_TEST");
            needUpdate = true;
        }
        if (ServerXml.changeValidationQueryTimeoutValue(resourceElement, isEmbedded)) {
            needUpdate = true;
        }
        if (JdbcUrlUtil.updateLobBufferParam(urlStringBuffer = new StringBuffer(resourceElement.getAttribute("url")))) {
            resourceElement.setAttribute("url", urlStringBuffer.toString());
            needUpdate = true;
        }
        String jdbcUrl = resourceElement.getAttribute("url");
        if (trustServerCert) {
            if (jdbcUrl.contains("trustServerCertificate=false")) {
                needUpdate = true;
                jdbcUrl = jdbcUrl.replace("trustServerCertificate=false", "trustServerCertificate=true");
                resourceElement.setAttribute("url", jdbcUrl);
            }
        } else if (jdbcUrl.contains("trustServerCertificate=true")) {
            needUpdate = true;
            jdbcUrl = jdbcUrl.replace("trustServerCertificate=true", "trustServerCertificate=false");
            resourceElement.setAttribute("url", jdbcUrl);
        }
        if (JDBCDriverHelper.updateJDBCURL(resourceElement, updateSocketTimeout)) {
            needUpdate = true;
        }
        return !needUpdate || parser.saveXml(tomcatROOTXmlFilePath);
    }

    public static boolean addConnectionLeakAttrForROOTXml(String serverHome) {
        boolean ret = false;
        String tomcatROOTXmlFilePath = ServerXml.getROOTXmlPath(serverHome);
        XmlParser parser = new XmlParser();
        parser.readXmlFile(tomcatROOTXmlFilePath);
        Document document = parser.getDocument();
        Element contextElement = document.getDocumentElement();
        Element resourceElement = (Element)contextElement.getElementsByTagName("Resource").item(0);
        if (resourceElement != null) {
            resourceElement.setAttribute("removeAbandonedOnBorrow", Boolean.TRUE.toString());
            ret = parser.saveXml(tomcatROOTXmlFilePath);
        }
        return ret;
    }

    public static boolean updateROOTXml(String serverHome, String JDBCDriverClassName, String JDBCUrl, String SEPMDbUserName, String SEPMDbUserPassword) {
        return ServerXml.updateROOTXml(serverHome, JDBCDriverClassName, JDBCUrl, SEPMDbUserName, SEPMDbUserPassword, null);
    }

    public static boolean updateROOTXml(String serverHome, String JDBCDriverClassName, String JDBCUrl, String SEPMDbUserName, String SEPMDbUserPassword, Boolean isEmbeddedDB) {
        String domain;
        String tomcatROOTXmlFilePath = ServerXml.getROOTXmlPath(serverHome);
        XmlParser parser = new XmlParser();
        parser.readXmlFile(tomcatROOTXmlFilePath);
        Document document = parser.getDocument();
        Element contextElement = document.getDocumentElement();
        Element resourceElement = (Element)contextElement.getElementsByTagName("Resource").item(0);
        resourceElement.setAttribute("driverClassName", JDBCDriverClassName);
        resourceElement.setAttribute("url", JDBCUrl);
        resourceElement.setAttribute("username", SEPMDbUserName);
        if (isEmbeddedDB != null) {
            resourceElement.setAttribute("embedded", isEmbeddedDB.toString());
        }
        if (!StringUtilities.isEmpty(domain = JDBCDriverHelper.getValueForParam(JDBCUrl, "domain"))) {
            resourceElement.setAttribute("domain", domain);
        }
        try {
            resourceElement.setAttribute("password", Utility.encryptLatestForDB(SEPMDbUserPassword.toCharArray()));
        }
        catch (Exception ex) {
            LoggerUtilities.logException(ex);
        }
        return parser.saveXml(tomcatROOTXmlFilePath);
    }

    public static Element createWebServicesConnector(Document document, String webServicesPort) {
        Element webServiceConnector = document.createElement(PROPERTY_CONNECTOR);
        webServiceConnector.setAttribute(CONNECTOR_PROPERTY_SSLENABLED, "true");
        webServiceConnector.setAttribute("acceptCount", "100");
        webServiceConnector.setAttribute("sslImplementationName", WEBSERVICE_CONNECTOR_SSL_IMPL_CLASS_NAME);
        webServiceConnector.setAttribute(CONNECTOR_PROPERTY_CLIENT_AUTH_ATTR, "want");
        webServiceConnector.setAttribute(CONNECTOR_PROPERTY_KEYSTOREPASS, " ");
        webServiceConnector.setAttribute(CONNECTOR_PROPERTY_KEYSTOREFILE, " ");
        webServiceConnector.setAttribute(CONNECTOR_PROPERTY_SSLSECURE, "true");
        webServiceConnector.setAttribute(CONNECTOR_PROPERTY_SSLSCHEME, CONNECTOR_PROPERTY_SLSCHEME_HTTPS);
        webServiceConnector.setAttribute("port", webServicesPort);
        webServiceConnector.setAttribute(CONNECTOR_PROPERTY_SSL_PROTOCOL, CONNECTOR_PROPERTY_SSL_PROTOCOLS_DEFAULT_VALUE);
        webServiceConnector.setAttribute("disableUploadTimeout", "true");
        webServiceConnector.setAttribute("enableLookups", "false");
        webServiceConnector.setAttribute("useBodyEncodingForURI", "true");
        return webServiceConnector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isWebServiceDisabled(String webServiceServerXmlFilePath) {
        file = new File(webServiceServerXmlFilePath);
        if (!file.isFile()) {
            ServerXml.logger.log(Level.WARNING, "Not found WebService Server.Xml file: " + webServiceServerXmlFilePath);
            return false;
        }
        fis = null;
        inputFileReader = null;
        try {
            fis = new FileInputStream(file);
            inputFileReader = new BufferedReader(new InputStreamReader((InputStream)fis, "UTF-8"));
            line = null;
            while ((line = inputFileReader.readLine()) != null) {
                if (line.toUpperCase().indexOf("<!--Service name=\"WebService\">".toUpperCase()) < 0) continue;
                var5_6 = true;
                ** GOTO lbl24
            }
            ** GOTO lbl27
        }
        catch (IOException ex) {
            try {
                LoggerUtilities.logException(ex);
            }
            catch (Throwable var6_7) {
                IOUtilities.closeInputStream(fis);
                IOUtilities.closeReader(inputFileReader);
                throw var6_7;
            }
lbl24:
            // 1 sources

            IOUtilities.closeInputStream(fis);
            IOUtilities.closeReader(inputFileReader);
            return var5_6;
lbl27:
            // 1 sources

            IOUtilities.closeInputStream(fis);
            IOUtilities.closeReader(inputFileReader);
            return false;
            IOUtilities.closeInputStream(fis);
            IOUtilities.closeReader(inputFileReader);
            return false;
        }
    }

    public static void updateRmmConnector(String tomcatServerXmlFilePath, String rmmWebServicesPort, String keyStorePath, String keyStorePwd) {
        XmlParser parser = new XmlParser();
        ServerXml.tryToReadXmlFile(tomcatServerXmlFilePath, parser);
        Document document = parser.getDocument();
        boolean webServiceDisabled = ServerXml.isWebServiceDisabled(tomcatServerXmlFilePath);
        List<Element> rmmWebServiceConnectors = ServerXml.getRmmConnector(document);
        if (rmmWebServiceConnectors != null && rmmWebServiceConnectors.size() > 0) {
            for (int i = 0; i < rmmWebServiceConnectors.size(); ++i) {
                Element rmmWebServiceConnector = rmmWebServiceConnectors.get(i);
                rmmWebServiceConnector.setAttribute("port", rmmWebServicesPort);
                rmmWebServiceConnector.setAttribute(CONNECTOR_PROPERTY_KEYSTOREFILE, keyStorePath);
                rmmWebServiceConnector.setAttribute(CONNECTOR_PROPERTY_KEYSTOREPASS, keyStorePwd);
            }
        } else if (!webServiceDisabled) {
            Element serverElement = document.getDocumentElement();
            serverElement.appendChild(document.createComment(RMM_WS_ENABLED_COMMENT));
            serverElement.appendChild(document.createTextNode("\n"));
            serverElement.appendChild(ServerXml.createWSServiceElement(document, rmmWebServicesPort, keyStorePath, keyStorePwd));
        }
        ServerXml.tryToSaveXmlFile(tomcatServerXmlFilePath, parser);
    }

    public static Element getServiceElement(Document document, String serviceName) {
        Element serverElement = document.getDocumentElement();
        NodeList serviceElementList = serverElement.getElementsByTagName(PROPERTY_SERVICE);
        for (int i = 0; i < serviceElementList.getLength(); ++i) {
            Element serviceElement = (Element)serviceElementList.item(i);
            if (!serviceName.equals(serviceElement.getAttribute(ATTRIBUTE_NAME))) continue;
            return serverElement;
        }
        return null;
    }

    private static void tryToSaveXmlFile(String tomcatServerXmlFilePath, XmlParser parser) {
        try {
            parser.saveXml(tomcatServerXmlFilePath);
        }
        catch (Exception e) {
            System.out.println("ServerXml> Failed to save server.xml file. Exception message = " + e.getLocalizedMessage());
        }
    }

    private static void tryToReadXmlFile(String tomcatServerXmlFilePath, XmlParser parser) {
        try {
            parser.readXmlFile(tomcatServerXmlFilePath);
        }
        catch (Exception e) {
            System.out.println("ServerXml> Failed to read server.xml file. Exception message = " + e.getLocalizedMessage());
        }
    }

    public static ROOTXmlHandler getROOTXmlHandler(String serverHome) {
        return ServerXml.getROOTXmlHandler(serverHome, false);
    }

    public static synchronized ROOTXmlHandler getROOTXmlHandler(String serverHome, boolean forceRefresh) {
        String path = ServerXml.getROOTXmlPath(serverHome);
        File xml = new File(path);
        long lastModified = xml.lastModified();
        if (handler == null || oldLastModified < lastModified || forceRefresh) {
            System.out.println("create a new RootXMLHandler");
            handler = new ROOTXmlHandler();
            SAXParserFactory factory = SAXParserFactory.newInstance();
            try {
                factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
                factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
                SAXParser saxParser = factory.newSAXParser();
                saxParser.parse(xml, (DefaultHandler)handler);
            }
            catch (ParserConfigurationException e) {
                LoggerUtilities.logException(e);
            }
            catch (SAXException e) {
                LoggerUtilities.logException(e);
            }
            catch (IOException e) {
                LoggerUtilities.logException(e);
            }
            oldLastModified = lastModified;
        }
        return handler;
    }

    public static JdbcParametersVO getJdbcParameters(String serverHome) {
        return ServerXml.getJdbcParameters(serverHome, false);
    }

    public static JdbcParametersVO getJdbcParameters(String serverHome, boolean forceRefresh) {
        return ServerXml.readJdbcParameters(serverHome, forceRefresh);
    }

    private static JdbcParametersVO readJdbcParameters(String serverHome, boolean forceRefresh) {
        ROOTXmlHandler rOOTXmlHandler = ServerXml.getROOTXmlHandler(serverHome, forceRefresh);
        String jdbcURL = rOOTXmlHandler.getUrl();
        System.out.println("readJdbcParameters >> jdbcURL: " + jdbcURL);
        String jdbcDriverClass = rOOTXmlHandler.getDriverClassName();
        System.out.println("readJdbcParameters >> jdbcDriverClass: " + jdbcDriverClass);
        String userName = rOOTXmlHandler.getUserName();
        String password = rOOTXmlHandler.getPassword();
        String domain = rOOTXmlHandler.getDomain();
        String mssqlSOReadTimeout = rOOTXmlHandler.getMssqlSocketReadTimeout();
        return new JdbcParametersVO(jdbcDriverClass, jdbcURL, userName, password, domain, mssqlSOReadTimeout);
    }

    private static Element createRmmWebServicesConnector(Document document, String rmmWebServicesPort, String keyStorePath, String keyStorePwd) {
        Element rmmWebServiceConnector = ServerXml.createWebServicesConnector(document, rmmWebServicesPort);
        rmmWebServiceConnector.removeAttribute("sslImplementationName");
        rmmWebServiceConnector.setAttribute(CONNECTOR_PROPERTY_CIPHERS, CIPHERS_VALUE);
        rmmWebServiceConnector.setAttribute(CONNECTOR_PROPERTY_KEYSTOREFILE, keyStorePath);
        rmmWebServiceConnector.setAttribute(CONNECTOR_PROPERTY_KEYSTOREPASS, keyStorePwd);
        return rmmWebServiceConnector;
    }

    private static Element createWSServiceElement(Document document, String rmmWebServicesPort, String keyStorePath, String keyStorePwd) {
        Element serviceElement = document.createElement(PROPERTY_SERVICE);
        serviceElement.setAttribute(ATTRIBUTE_NAME, SERVER_XML_SERVICE_RMMWEBSERVICE);
        serviceElement.appendChild(ServerXml.createRmmWebServicesConnector(document, rmmWebServicesPort, keyStorePath, keyStorePwd));
        Element engineNode = document.createElement(PROPERTY_ENGINE);
        engineNode.setAttribute(ATTRIBUTE_DEFAULT_HOST, "localhost");
        engineNode.setAttribute(ATTRIBUTE_NAME, "Catalina_WS");
        Element realMElement = document.createElement("Realm");
        realMElement.setAttribute(VALVE_PROPERTY_CLASSNAME, "org.apache.catalina.realm.LockOutRealm");
        engineNode.appendChild(realMElement);
        Element hostElement = document.createElement(PROPERTY_HOST);
        hostElement.setAttribute("appBase", "webapps");
        hostElement.setAttribute(ATTRIBUTE_NAME_AUTO_DEPLOY, "false");
        hostElement.setAttribute(ATTRIBUTE_NAME_LIVE_DEPLOY, "false");
        hostElement.setAttribute(ATTRIBUTE_NAME, "localhost");
        hostElement.setAttribute(ATTRIBUTE_NAME_UNPACK_WARS, "true");
        engineNode.appendChild(hostElement);
        Element contextElement = document.createElement("Context");
        contextElement.setAttribute(ATTRIBUTE_NAME_DOC_BASE, "/sepm.war");
        contextElement.setAttribute(ATTRIBUTE_NAME_PATH, "/sepm");
        contextElement.setAttribute(ATTRIBUTE_NAME_RELOADABLE, "false");
        engineNode.appendChild(contextElement);
        serviceElement.appendChild(engineNode);
        return serviceElement;
    }

    private static List<Element> getRmmConnector(Document document) {
        ArrayList<Element> rmmWebServiceConnectors = new ArrayList<Element>();
        Element serviceElement = ServerXml.getServiceElement(document, SERVER_XML_SERVICE_RMMWEBSERVICE);
        if (serviceElement != null) {
            NodeList connectorList = serviceElement.getElementsByTagName(PROPERTY_CONNECTOR);
            for (int i = 0; i < connectorList.getLength(); ++i) {
                Element connectorElement = (Element)connectorList.item(i);
                if (!CONNECTOR_PROPERTY_SLSCHEME_HTTPS.equalsIgnoreCase(connectorElement.getAttribute(CONNECTOR_PROPERTY_SSLSCHEME)) || !"true".equalsIgnoreCase(connectorElement.getAttribute(CONNECTOR_PROPERTY_SSLSECURE)) && !"true".equalsIgnoreCase(connectorElement.getAttribute(CONNECTOR_PROPERTY_SSLENABLED))) continue;
                rmmWebServiceConnectors.add(connectorElement);
            }
        }
        return rmmWebServiceConnectors;
    }

    public static void main(String[] args) {
        String param;
        if (args.length <= 1) {
            ServerXml.printHelp();
            return;
        }
        if (args.length > 1 && ((param = args[1]) == null || param.trim().length() == 0 || param.equalsIgnoreCase("/?") || param.equalsIgnoreCase("-?") || param.equalsIgnoreCase("?") || param.toUpperCase().contains("HELP"))) {
            ServerXml.printHelp();
            return;
        }
        Boolean isRmmWsEnable = null;
        for (int i = 1; i < args.length; ++i) {
            String[] pair;
            String param2 = args[i];
            if (param2 == null || param2.length() <= 0 || (pair = (param2 = param2.toUpperCase()).split(":")).length != 2 || !pair[0].contains("RMMWS")) continue;
            isRmmWsEnable = ServerXml.isEnable(pair[1]);
        }
        if (isRmmWsEnable != null) {
            String serverHome = args[0];
            String serverXmlFilePath = ServerXml.getServerXmlPath(serverHome);
            System.out.println(MessageFormat.format(ServerXml.getString("ServerXML.XMLpath"), serverXmlFilePath));
            try {
                boolean isFileCreated;
                String bakFilePath = serverXmlFilePath + ".bak";
                File bakFile = new File(bakFilePath);
                if (!bakFile.exists() && !(isFileCreated = bakFile.createNewFile())) {
                    System.out.println("Failed to created file: " + bakFilePath);
                }
                Utility.copyFile(serverXmlFilePath, bakFilePath);
                System.out.println(MessageFormat.format(ServerXml.getString("ServerXML.createBackup"), bakFilePath));
                ServerXml.updateRmmWsXML(serverXmlFilePath, isRmmWsEnable);
                ServerXml.updateRmmWsComment(serverXmlFilePath, isRmmWsEnable);
            }
            catch (IOException e) {
                LoggerUtilities.logException(e);
            }
            System.out.println(ServerXml.getString("ServerXML.configSucceed"));
        } else {
            System.out.println(ServerXml.getString("ServerXML.wrongParams"));
            ServerXml.printHelp();
        }
    }

    private static String getString(String key) {
        return MessageResources.getInstance().getString("com.sygate.scm.util.util", key);
    }

    private static void printHelp() {
        System.out.println(ServerXml.getString("ServerXML.command.desA") + "\n" + ServerXml.getString("ServerXML.command.desB") + "\n-RmmWS:ON    " + ServerXml.getString("ServerXML.command.rmmOn") + "\n-RmmWS:OFF   " + ServerXml.getString("ServerXML.command.rmmOff") + "\n-?           " + ServerXml.getString("ServerXML.command.help") + "\n");
    }

    private static Boolean isEnable(String param) {
        param = param.toUpperCase();
        Boolean result = null;
        if (param.equals("ON") || param.equals("ENABLE") || param.equals("1")) {
            result = Boolean.TRUE;
        } else if (param.equals("OFF") || param.equals("DISABLE") || param.equals("0")) {
            result = Boolean.FALSE;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateRmmWsXML(String serverXmlFilePath, boolean isRmmWsEnable) {
        block19: {
            BufferedReader br = null;
            BufferedWriter bw = null;
            boolean needModify = false;
            StringBuffer buf = new StringBuffer();
            try {
                br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(serverXmlFilePath), "UTF-8"));
                String line = null;
                boolean replaceEndTag = false;
                if (isRmmWsEnable) {
                    while ((line = br.readLine()) != null) {
                        if (line.indexOf(RMM_WS_START_TAG) > -1) {
                            System.out.println(ServerXml.getString("ServerXML.rmmAlreadyOn"));
                            needModify = false;
                            break;
                        }
                        if (line.indexOf(RMM_WS_START_DISABLED_TAG) > -1) {
                            line = line.replace(RMM_WS_START_DISABLED_TAG, RMM_WS_START_TAG);
                            replaceEndTag = true;
                        }
                        if (replaceEndTag && line.indexOf(WS_END_DISABLED_TAG) > -1) {
                            line = line.replace(WS_END_DISABLED_TAG, WS_END_TAG);
                            replaceEndTag = false;
                            needModify = true;
                        }
                        buf.append(line).append(LINE_SEPARATOR);
                    }
                } else {
                    while ((line = br.readLine()) != null) {
                        if (line.indexOf(RMM_WS_START_DISABLED_TAG) > -1) {
                            System.out.println(ServerXml.getString("ServerXML.rmmAlreadyOff"));
                            needModify = false;
                            break;
                        }
                        if (line.indexOf(RMM_WS_START_TAG) > -1) {
                            line = line.replace(RMM_WS_START_TAG, RMM_WS_START_DISABLED_TAG);
                            replaceEndTag = true;
                        }
                        if (replaceEndTag && line.indexOf(WS_END_TAG) > -1) {
                            line = line.replace(WS_END_TAG, WS_END_DISABLED_TAG);
                            replaceEndTag = false;
                            needModify = true;
                        }
                        buf.append(line).append(LINE_SEPARATOR);
                    }
                }
                if (needModify) {
                    bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(serverXmlFilePath), "UTF-8"));
                    bw.write(buf.toString());
                    bw.flush();
                    if (isRmmWsEnable) {
                        System.out.println(ServerXml.getString("ServerXML.rmmOn"));
                    } else {
                        System.out.println(ServerXml.getString("ServerXML.rmmOff"));
                    }
                }
                IOUtilities.closeWriter(bw);
            }
            catch (IOException e) {
                LoggerUtilities.logException(e);
                break block19;
            }
            finally {
                IOUtilities.closeWriter(bw);
                IOUtilities.closeReader(br);
            }
            IOUtilities.closeReader(br);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateRmmWsComment(String serverXmlFilePath, boolean isRmmWsEnable) {
        block17: {
            BufferedReader br = null;
            BufferedWriter bw = null;
            StringBuffer buf = new StringBuffer();
            try {
                br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(serverXmlFilePath), "UTF-8"));
                String line = null;
                boolean newComment = true;
                boolean needModify = true;
                if (isRmmWsEnable) {
                    while ((line = br.readLine()) != null) {
                        if (line.indexOf(RMM_WS_ENABLED_COMMENT) > -1) {
                            needModify = false;
                            break;
                        }
                        if (line.indexOf(RMM_WS_DISABLED_COMMENT) > -1) {
                            line = line.replace(RMM_WS_DISABLED_COMMENT, RMM_WS_ENABLED_COMMENT);
                            newComment = false;
                        }
                        if (newComment && line.indexOf(RMM_WS_START_TAG) > -1) {
                            buf.append("<!--Web services for remote management are enabled. To disable these web services, open a command prompt, navigate to the Tools folder in your Symantec Endpoint Protection Manager installation folder, and type the following: ConfigSEPM.bat -RmmWS:OFF-->").append(LINE_SEPARATOR);
                            newComment = false;
                        }
                        buf.append(line).append(LINE_SEPARATOR);
                    }
                } else {
                    while ((line = br.readLine()) != null) {
                        if (line.indexOf(RMM_WS_DISABLED_COMMENT) > -1) {
                            needModify = false;
                            break;
                        }
                        if (line.indexOf(RMM_WS_ENABLED_COMMENT) > -1) {
                            line = line.replace(RMM_WS_ENABLED_COMMENT, RMM_WS_DISABLED_COMMENT);
                            newComment = false;
                        }
                        if (newComment && line.indexOf(RMM_WS_START_DISABLED_TAG) > -1) {
                            buf.append("<!--Web services for remote management are disabled. To enable these web services, open a command prompt, navigate to the Tools folder in your Symantec Endpoint Protection Manager installation folder, and type the following: ConfigSEPM.bat -RmmWS:ON-->").append(LINE_SEPARATOR);
                            newComment = false;
                        }
                        buf.append(line).append(LINE_SEPARATOR);
                    }
                }
                if (needModify) {
                    bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(serverXmlFilePath), "UTF-8"));
                    bw.write(buf.toString());
                    bw.flush();
                }
                IOUtilities.closeWriter(bw);
            }
            catch (IOException e) {
                LoggerUtilities.logException(e);
                break block17;
            }
            finally {
                IOUtilities.closeWriter(bw);
                IOUtilities.closeReader(br);
            }
            IOUtilities.closeReader(br);
        }
    }

    public static boolean removeConnector(String serverXmlFilePath, String port) {
        if (StringUtilities.isEmpty(serverXmlFilePath) || StringUtilities.isEmpty(port)) {
            throw new IllegalArgumentException();
        }
        boolean serverUpdated = false;
        XmlParser parser = new XmlParser();
        parser.readXmlFile(serverXmlFilePath);
        Document document = parser.getDocument();
        Element serverElement = document.getDocumentElement();
        NodeList serviceList = serverElement.getElementsByTagName(PROPERTY_SERVICE);
        boolean connectorRemoved = false;
        block0: for (int j = 0; j < serviceList.getLength(); ++j) {
            Element serviceElement = (Element)serviceList.item(j);
            if (serviceElement == null) continue;
            NodeList connectorList = serviceElement.getElementsByTagName(PROPERTY_CONNECTOR);
            for (int i = 0; i < connectorList.getLength(); ++i) {
                Element connectorElement = (Element)connectorList.item(i);
                if (!connectorElement.getAttribute("port").equals(port)) continue;
                System.out.println("Connector with port " + port + " found");
                serviceElement.removeChild(connectorElement);
                connectorRemoved = true;
                continue block0;
            }
        }
        if (connectorRemoved && parser.saveXml(serverXmlFilePath)) {
            System.out.println("XML saved");
            serverUpdated = true;
        }
        return serverUpdated;
    }

    public static boolean removeAndUpdateRmmWSElements(String serverHome) {
        String serverXmlFilePath = ServerXml.getServerXmlPath(serverHome);
        if (StringUtilities.isEmpty(serverXmlFilePath)) {
            throw new IllegalArgumentException();
        }
        System.out.println("ServerXml> removeAndUpdateRmmWSElements>> Removing RMM Web service from old server server.xml and updating values in new server.xml file...");
        boolean serverUpdated = false;
        XmlParser parser = new XmlParser();
        parser.readXmlFile(serverXmlFilePath);
        Document document = parser.getDocument();
        Element serverElement = document.getDocumentElement();
        Element serviceElement = null;
        String rmmWebServicePort = null;
        String keyStoreFile = null;
        String keyStorePass = null;
        NodeList serviceList = serverElement.getElementsByTagName(PROPERTY_SERVICE);
        for (int j = 0; j < serviceList.getLength(); ++j) {
            serviceElement = (Element)serviceList.item(j);
            if (serviceElement == null || !serviceElement.getAttribute(ATTRIBUTE_NAME).equals(SERVER_XML_SERVICE_RMMWEBSERVICE)) continue;
            NodeList connectorList = serviceElement.getElementsByTagName(PROPERTY_CONNECTOR);
            for (int i = 0; i < connectorList.getLength(); ++i) {
                Element connectorElement = (Element)connectorList.item(i);
                if (connectorElement == null || !CONNECTOR_PROPERTY_SLSCHEME_HTTPS.equalsIgnoreCase(connectorElement.getAttribute(CONNECTOR_PROPERTY_SSLSCHEME)) || !"true".equalsIgnoreCase(connectorElement.getAttribute(CONNECTOR_PROPERTY_SSLSECURE))) continue;
                String connectorElementOldSSLAttrValue = connectorElement.getAttribute(ATT_NAME_SSL_IMPLEMENTATION_OLD);
                String connectorElementNewSSLAttrValue = connectorElement.getAttribute("sslImplementationName");
                String expectedSSLAttrValue = WEBSERVICE_CONNECTOR_SSL_IMPL_CLASS_NAME;
                if (connectorElementOldSSLAttrValue.equalsIgnoreCase(expectedSSLAttrValue) || connectorElementNewSSLAttrValue.equalsIgnoreCase(expectedSSLAttrValue)) continue;
                keyStoreFile = connectorElement.getAttribute(CONNECTOR_PROPERTY_KEYSTOREFILE);
                keyStorePass = connectorElement.getAttribute(CONNECTOR_PROPERTY_KEYSTOREPASS);
                rmmWebServicePort = connectorElement.getAttribute("port");
                System.out.println("ServerXml> removeAndUpdateRmmWSElements>> RMM web service is found in old server server.xml. RmmWebServicePort number = " + rmmWebServicePort);
            }
            if (!StringUtilities.isEmpty(rmmWebServicePort)) {
                ServerXml.updateRmmConnector(ServerXml.getServerXmlPathForSemApiSrvService(serverHome), rmmWebServicePort, keyStoreFile, keyStorePass);
                System.out.println("ServerXml> removeAndUpdateRmmWSElements>> Port, key-path, key-pass values are updated in new server server.xml file.");
            }
            serverElement.removeChild(serviceElement);
            serverUpdated = true;
            if (!parser.saveXml(serverXmlFilePath)) continue;
            System.out.println("ServerXml> removeAndUpdateRmmWSElements>> RMM Web service is removed from old server server.xml file.");
        }
        ServerXml.removeRmmWsComment(serverXmlFilePath);
        System.out.println("ServerXml> removeAndUpdateRmmWSElements>> Removing RMM Web service from old server server.xml and updating values in new server.xml file, done!");
        return serverUpdated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeRmmWsComment(String serverXmlFilePath) {
        block8: {
            BufferedReader br = null;
            BufferedWriter bw = null;
            StringBuffer buf = new StringBuffer();
            try {
                br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(serverXmlFilePath), "UTF-8"));
                String line = null;
                boolean needModify = false;
                while ((line = br.readLine()) != null) {
                    if (line.indexOf(RMM_WS_ENABLED_COMMENT) > -1 || line.indexOf(RMM_WS_DISABLED_COMMENT) > -1) {
                        needModify = true;
                        continue;
                    }
                    buf.append(line).append(LINE_SEPARATOR);
                }
                if (needModify) {
                    bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(serverXmlFilePath), "UTF-8"));
                    bw.write(buf.toString());
                    bw.flush();
                }
                IOUtilities.closeWriter(bw);
            }
            catch (IOException e) {
                LoggerUtilities.logException(e);
                break block8;
            }
            finally {
                IOUtilities.closeWriter(bw);
                IOUtilities.closeReader(br);
            }
            IOUtilities.closeReader(br);
        }
    }

    public static boolean updateAllTomcatServerXmlFilesForAPRWithSslSetting(String serverHome) {
        if (serverHome == null) {
            System.out.println("ServerXML> updateAllTomcatServerXmlFilesForAPRWithSslSetting>> serverHome parameter is null.");
            return false;
        }
        String sslConfigPath = serverHome + File.separator + ".." + File.separator + "apache" + File.separator + "conf" + File.separator + "ssl" + File.separator;
        if (ServerXml.updateTomcatServerXmlFileWithSslSetting(sslConfigPath, ServerXml.getServerXmlPath(serverHome))) {
            return false;
        }
        return !ServerXml.updateTomcatServerXmlFileWithSslSetting(sslConfigPath, ServerXml.getServerXmlPathForSemApiSrvService(serverHome));
    }

    protected static boolean updateTomcatServerXmlFileWithSslSetting(String sslConfigFilePath, String tomcatServerXmlFilePath) {
        if (sslConfigFilePath == null || tomcatServerXmlFilePath == null) {
            System.out.println("ServerXML> updateTomcatServerXmlFileWithSslSetting>> sslConfigFilePath or tomcatServerXmlFilePath parameter is null.");
            return false;
        }
        XmlParser parser = new XmlParser();
        parser.readXmlFile(tomcatServerXmlFilePath);
        Document document = parser.getDocument();
        if (document == null) {
            System.out.println("ServerXML> updateTomcatServerXmlFileWithSslSetting>> No XML document fund in tomcatServerXmlFilePath.");
            return false;
        }
        Element serverElement = document.getDocumentElement();
        Element listenerElement = XmlParser.getFirstChildElement(serverElement, "Listener");
        if (listenerElement == null) {
            listenerElement = document.createElement("Listener");
            listenerElement.setAttribute(VALVE_PROPERTY_CLASSNAME, LISTENER_PROPERTY_CLASS_NAME);
            listenerElement.setAttribute("SSLEngine", "on");
            serverElement.appendChild(listenerElement);
        }
        Element serviceElement = XmlParser.getFirstChildElement(serverElement, PROPERTY_SERVICE);
        while (serviceElement != null) {
            Element connectorElement = XmlParser.getFirstChildElement(serviceElement, PROPERTY_CONNECTOR);
            while (connectorElement != null) {
                String schemeAttr = connectorElement.getAttribute(CONNECTOR_PROPERTY_SSLSCHEME);
                String sslEnabled = connectorElement.getAttribute(CONNECTOR_PROPERTY_SSLENABLED);
                if (schemeAttr.equalsIgnoreCase(CONNECTOR_PROPERTY_SLSCHEME_HTTPS) && sslEnabled.equalsIgnoreCase(Boolean.TRUE.toString())) {
                    connectorElement.removeAttribute(CONNECTOR_PROPERTY_CIPHERS);
                    connectorElement.setAttribute(CONNECTOR_PROPERTY_SSLCIPHERSUITE, CONNECTOR_PROPERTY_SSLCIPHERSUITE_DEFAULT_VALUE);
                    connectorElement.setAttribute(CONNECTOR_PROPERTY_SSLHONORCIPHERORDER, "true");
                    connectorElement.setAttribute(CONNECTOR_PROPERTY_PROTOCOL, CONNECTOR_PROPERTY_PROTOCOL_NIO2);
                    connectorElement.setAttribute("sslImplementationName", CONNECTOR_PROPERTY_SSL_IMPLEMENTATION_OPENSSL);
                    connectorElement.setAttribute(CONNECTOR_PROPERTY_SSLCERTIFICATEFILE, sslConfigFilePath + CONNECTOR_PROPERTY_CERTIFICATE_FILE_DEFAULT_VALUE);
                    connectorElement.setAttribute(CONNECTOR_PROPERTY_SSLVERIFYCLIENT, CONNECTOR_PROPERTY_SSLVERIFYCLIENT_DEFAULT_VALUE);
                    connectorElement.setAttribute(CONNECTOR_PROPERTY_SSLCACERTIFICATEFILE, sslConfigFilePath + CONNECTOR_PROPERTY_SSLCACERTIFICATEFILE_DEFAULT_VALUE);
                    connectorElement.setAttribute(CONNECTOR_PROPERTY_SSLCERTIFICATEKEYFILE, sslConfigFilePath + CONNECTOR_PROPERTY_CERTIFICATE_KEY_DEFAULT_VALUE);
                }
                connectorElement = XmlParser.getNextMatchingSibling(connectorElement, PROPERTY_CONNECTOR);
            }
            serviceElement = XmlParser.getNextMatchingSibling(serviceElement, PROPERTY_SERVICE);
        }
        if (!parser.saveXml(tomcatServerXmlFilePath)) {
            System.out.println("ServerXML> updateTomcatServerXmlFileWithSslSetting>> Error updating server.xml.");
            return true;
        }
        return false;
    }

    public static boolean updateServerXmlForTLSUpgrade(String serverHome) {
        System.out.println("ServerXML> in updateServerXmlForTLSUpgrade");
        if (serverHome == null) {
            System.out.println("ServerXML> updateServerXmlForTLSUpgrade>> serverHome parameter is null.");
            return false;
        }
        XmlParser parser = new XmlParser();
        parser.readXmlFile(serverHome);
        Document document = parser.getDocument();
        Element serverElement = document.getDocumentElement();
        NodeList connectorList = serverElement.getElementsByTagName(PROPERTY_CONNECTOR);
        int length = connectorList.getLength();
        for (int i = 0; i < length; ++i) {
            Element connectorElement = (Element)connectorList.item(i);
            if (connectorElement == null) continue;
            if (connectorElement.hasAttribute(CONNECTOR_PROPERTY_SSL_PROTOCOL_OLD_ATTR)) {
                connectorElement.removeAttribute(CONNECTOR_PROPERTY_SSL_PROTOCOL_OLD_ATTR);
            }
            if (connectorElement.hasAttribute(CONNECTOR_PROPERTY_SSLENABLED_PROTOCOLS)) {
                connectorElement.removeAttribute(CONNECTOR_PROPERTY_SSLENABLED_PROTOCOLS);
            }
            connectorElement.setAttribute(CONNECTOR_PROPERTY_SSL_PROTOCOL, CONNECTOR_PROPERTY_SSL_PROTOCOLS_DEFAULT_VALUE);
        }
        if (!parser.saveXml(serverHome)) {
            System.out.println("ServerXML> updateServerXmlForTLSUpgrade>> Error updating " + serverHome);
            return false;
        }
        return true;
    }

    public static boolean updateServerXmlForTomcatUpgrade(String serverHome) {
        System.out.println("ServerXML> in updateServerXmlForTomcatUpgrade");
        if (serverHome == null) {
            System.out.println("ServerXML> updateServerXmlForTomcatUpgrade>> serverHome parameter is null.");
            return false;
        }
        XmlParser parser = new XmlParser();
        parser.readXmlFile(serverHome);
        Document document = parser.getDocument();
        Element serverElement = document.getDocumentElement();
        NodeList connectorList = serverElement.getElementsByTagName(PROPERTY_CONNECTOR);
        int length = connectorList.getLength();
        for (int i = 0; i < length; ++i) {
            Element connectorElement = (Element)connectorList.item(i);
            if (connectorElement == null || !connectorElement.hasAttribute(CONNECTOR_PROPERTY_CLIENT_AUTH_ATTR)) continue;
            connectorElement.removeAttribute(CONNECTOR_PROPERTY_CLIENT_AUTH_ATTR);
        }
        if (!parser.saveXml(serverHome)) {
            System.out.println("ServerXML> updateServerXmlForTomcatUpgrade>> Error updating " + serverHome);
            return false;
        }
        return true;
    }

    public static boolean updateServerXmlForIpv6Support(String serverXmlFilePath) {
        System.out.println("ServerXML> in updateServerXmlForIpv6Support");
        if (null == serverXmlFilePath) {
            System.out.println("ServerXML> updateServerXmlForIpv6Support>> serverHome parameter is null.");
            return false;
        }
        XmlParser parser = new XmlParser();
        parser.readXmlFile(serverXmlFilePath);
        Document document = parser.getDocument();
        Element serverElement = document.getDocumentElement();
        NodeList connectorList = serverElement.getElementsByTagName(PROPERTY_CONNECTOR);
        int length = connectorList.getLength();
        Element connectorElement = null;
        Node connectorElementRemove = null;
        boolean isIPv6ConnectorPresent = false;
        for (int i = 0; i < length; ++i) {
            connectorElement = (Element)connectorList.item(i);
            if (connectorElement == null || !CONNECTOR_PROPERTY_PROTOCOL_APR.equalsIgnoreCase(connectorElement.getAttribute(CONNECTOR_PROPERTY_PROTOCOL)) && !CONNECTOR_PROPERTY_PROTOCOL_NIO2.equalsIgnoreCase(connectorElement.getAttribute(CONNECTOR_PROPERTY_PROTOCOL))) continue;
            if (connectorElement.getAttribute(CONNECTOR_PROPERTY_ADDRESS).isEmpty()) {
                connectorElement.setAttribute(CONNECTOR_PROPERTY_ADDRESS, CONNECTOR_PROPERTY_ADDRESS_IPV4_VALUE);
                continue;
            }
            if (connectorElement.getAttribute(CONNECTOR_PROPERTY_ADDRESS).equals(CONNECTOR_PROPERTY_ADDRESS_IPV6_VALUE)) {
                isIPv6ConnectorPresent = true;
                continue;
            }
            if (!connectorElement.getAttribute(CONNECTOR_PROPERTY_ADDRESS).equals(CONNECTOR_PROPERTY_ADDRESS_IPV6_VALUE2)) continue;
            connectorElementRemove = connectorElement;
        }
        if (connectorElement != null && !isIPv6ConnectorPresent) {
            System.out.println("ServerXML> Cloning connector and adding IPv6...");
            Element connectorElementIpv6 = (Element)connectorElement.cloneNode(true);
            connectorElementIpv6.setAttribute(CONNECTOR_PROPERTY_ADDRESS, CONNECTOR_PROPERTY_ADDRESS_IPV6_VALUE);
            Node serviceElement = connectorElement.getParentNode();
            serviceElement.insertBefore(connectorElementIpv6, connectorElement.getNextSibling());
        }
        if (connectorElementRemove != null) {
            System.out.println("ServerXML> Removing connector with address ::");
            connectorElementRemove.getParentNode().removeChild(connectorElementRemove);
        }
        if (!parser.saveXml(serverXmlFilePath)) {
            System.out.println("ServerXML> updateServerXmlForIpv6Support>> Error updating " + serverXmlFilePath);
            return false;
        }
        return true;
    }

    public static boolean updateServerXmlForTomcatErrorValves(String serverXmlFilePath) {
        System.out.println(String.format("%s in %s", LOG_CLASS_NAME.trim(), LOG_METHOD_TOMCAT_VALVE));
        if (null == serverXmlFilePath) {
            System.out.println("ServerXML> updateServerXmlForTomcatErrorValves>> serverXmFilePath parameter is null.");
            return false;
        }
        XmlParser parser = new XmlParser();
        parser.readXmlFile(serverXmlFilePath);
        Document document = parser.getDocument();
        boolean modified = ServerXml.updateServerXmlForTomcatErrorValves(document);
        if (modified && !parser.saveXml(serverXmlFilePath)) {
            System.out.println("ServerXML> updateServerXmlForTomcatErrorValves>>  Error updating " + serverXmlFilePath);
            return false;
        }
        return true;
    }

    public static boolean updateNewServerXmlForTomcatRewriteValves(String serverXmlFilePath) {
        logger.log(Level.FINE, "updateNewServerXmlForTomcat Rewrite Valves");
        if (StringUtilities.isEmpty(serverXmlFilePath)) {
            logger.log(Level.WARNING, "newServerXmFilePath parameter is null.");
            return false;
        }
        try {
            XmlParser parser = new XmlParser();
            parser.readXmlFile(serverXmlFilePath);
            Document document = parser.getDocument();
            boolean modified = ServerXml.addElementStringInXml(document, PROPERTY_ENGINE, NEW_SERVER_REWRITE_VALVE_NODE_TO_ADD_PROPERTY, VALVE_CLASS_NAME_ORG_APACHE_CATALINA_VALVES_REWRITE_REWRITE_VALVE);
            return !modified || parser.saveXml(serverXmlFilePath);
        }
        catch (IOException | ParserConfigurationException | SAXException ex) {
            logger.log(Level.SEVERE, "updateNewServerXmlForTomcatRewriteValves>> Error processing ", ex);
            return false;
        }
    }

    public static boolean updateServerXmlForTomcatErrorValves(Document document) {
        if (document == null) {
            System.out.println("ServerXML> updateServerXmlForTomcatErrorValves>>  Not a valid XML file.");
            return false;
        }
        boolean modified = false;
        boolean ifExists = false;
        Element serverElement = document.getDocumentElement();
        Element serviceElement = XmlParser.getFirstChildElement(serverElement, PROPERTY_SERVICE);
        if (serviceElement == null) {
            System.out.println("ServerXML> updateServerXmlForTomcatErrorValves>>  Service element does not exists. ");
            return false;
        }
        while (serviceElement != null) {
            String name = serviceElement.getAttribute(ATTRIBUTE_NAME);
            if (SERVICE_NAME_SCM.equals(name)) {
                System.out.println("ServerXML> updateServerXmlForTomcatErrorValves>>  Found: " + name);
                ifExists = true;
                break;
            }
            System.out.println("ServerXML> updateServerXmlForTomcatErrorValves>>  Skipping service: " + name);
            serviceElement = XmlParser.getNextMatchingSibling(serviceElement, PROPERTY_SERVICE);
        }
        if (!ifExists) {
            System.out.println(String.format("ServerXML> updateServerXmlForTomcatErrorValves>>  Service element (%s) not found. ", SERVICE_NAME_SCM));
            return false;
        }
        Element engineElement = XmlParser.getFirstChildElement(serviceElement, PROPERTY_ENGINE);
        String engineName = engineElement.getAttribute(ATTRIBUTE_NAME);
        String defaultHost = engineElement.getAttribute(ATTRIBUTE_DEFAULT_HOST);
        if (engineName.isBlank() || defaultHost.isBlank()) {
            System.out.println("ServerXML> updateServerXmlForTomcatErrorValves>>  Missing attribute(defaultHost or name) for engine element.");
            return false;
        }
        if (!ATTRIBUTE_ENGINE_NAME_VALUE.equals(engineName)) {
            System.out.println(String.format("ServerXML> updateServerXmlForTomcatErrorValves>>  Unexpected engine name(%s).", engineName));
            return false;
        }
        ifExists = false;
        Element hostElement = null;
        NodeList hostList = engineElement.getElementsByTagName(PROPERTY_HOST);
        int count = hostList.getLength();
        System.out.println("ServerXML> updateServerXmlForTomcatErrorValves>>  Available hosts count: " + count);
        for (int i = 0; i < count; ++i) {
            hostElement = (Element)hostList.item(i);
            String hostName = hostElement.getAttribute(ATTRIBUTE_NAME);
            if (!defaultHost.equals(hostName)) continue;
            System.out.println("ServerXML> updateServerXmlForTomcatErrorValves>>  Found hostNode: " + defaultHost);
            ifExists = true;
            break;
        }
        if (!ifExists) {
            System.out.println(String.format("ServerXML> updateServerXmlForTomcatErrorValves>>  Missing host element with name (%s) ", defaultHost));
            return false;
        }
        NodeList valveList = hostElement.getElementsByTagName(PROPERTY_VALVE);
        count = valveList.getLength();
        System.out.println("ServerXML> updateServerXmlForTomcatErrorValves>>  Available valves count: " + count);
        ifExists = false;
        Element valveElement = null;
        for (int i = 0; i < count; ++i) {
            valveElement = (Element)valveList.item(i);
            if (!VALVE_PROPERTY_CLASSNAME_VALUE.equals(valveElement.getAttribute(VALVE_PROPERTY_CLASSNAME))) continue;
            ifExists = true;
            break;
        }
        if (!ifExists) {
            System.out.println("ServerXML> updateServerXmlForTomcatErrorValves>>  Adding TomcatErrorValves");
            Element newValveElement = document.createElement(PROPERTY_VALVE);
            newValveElement.setAttribute(VALVE_PROPERTY_CLASSNAME, VALVE_PROPERTY_CLASSNAME_VALUE);
            newValveElement.setAttribute(VALVE_PROPERTY_SHOW_REPORT, "false");
            newValveElement.setAttribute(VALVE_PROPERTY_SHOW_SERVER_INFO, "false");
            hostElement.appendChild(newValveElement);
            modified = true;
        } else {
            System.out.println("ServerXML> updateServerXmlForTomcatErrorValves>> TomcatErrorValves preexists. Verify attributes.");
            if (valveElement.getAttribute(VALVE_PROPERTY_SHOW_REPORT).isBlank()) {
                valveElement.setAttribute(VALVE_PROPERTY_SHOW_REPORT, "false");
                modified = true;
                System.out.println("ServerXML> updateServerXmlForTomcatErrorValves>> TomcatErrorValves preexists. Added attribute showReport");
            } else {
                System.out.println("ServerXML> updateServerXmlForTomcatErrorValves>> TomcatErrorValves preexists. Attribute showReport exists. ");
            }
            if (valveElement.getAttribute(VALVE_PROPERTY_SHOW_SERVER_INFO).isBlank()) {
                valveElement.setAttribute(VALVE_PROPERTY_SHOW_SERVER_INFO, "false");
                modified = true;
                System.out.println("ServerXML> updateServerXmlForTomcatErrorValves>> TomcatErrorValves preexists. Added attribute showServerInfo");
            } else {
                System.out.println("ServerXML> updateServerXmlForTomcatErrorValves>> TomcatErrorValves preexists. Attribute showServerInfo exists. ");
            }
        }
        return modified;
    }

    protected static boolean addElementStringInXml(Document document, String tagName, String tagProperty, String inputStr) throws IOException, SAXException, ParserConfigurationException {
        DocumentBuilder documentBuilder = XmlUtils.getSecureDocumentBuilder();
        Document doc = documentBuilder.parse(new InputSource(new StringReader(inputStr)));
        NodeList nodeList = document.getElementsByTagName(tagName);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!StringUtilities.isEmpty(tagProperty) && (node.getNodeType() != 1 || !((Element)node).getAttribute(tagProperty.split("=")[0].trim()).equalsIgnoreCase(tagProperty.split("=")[1].trim()))) continue;
            for (int childIndex = 0; childIndex < node.getChildNodes().getLength(); ++childIndex) {
                Node childNode = node.getChildNodes().item(childIndex);
                if (childNode.getNodeType() != 1 || !((Element)childNode).getTagName().equalsIgnoreCase(doc.getDocumentElement().getTagName())) continue;
                logger.log(Level.WARNING, "updateNewServerXmlForTomcatRewriteValves>>Tag:{} to add is already in the destination", inputStr);
                return false;
            }
            Node elementToAdd = document.importNode(doc.getDocumentElement(), true);
            node.appendChild(elementToAdd);
            logger.log(Level.WARNING, "updateNewServerXmlForTomcatRewriteValves>>Found the Tag: {0} and append child: {1}", new Object[]{node, elementToAdd});
            return true;
        }
        logger.log(Level.WARNING, "updateNewServerXmlForTomcatRewriteValves>>Did not find the Tag with name: {0}, property:{1} and append child: {2}", new Object[]{tagName, tagProperty, inputStr});
        return false;
    }

    public static boolean updateWebswingServerContextOfSemApiSvrServerXml(String serverXmlFilePath) throws XPathExpressionException, ServerXmlUpdateException {
        logger.log(Level.INFO, "updateWebswingServerContextOfSemApiSvrServerXml>>read server xml: {0}", new Object[]{serverXmlFilePath});
        XmlParser parser = new XmlParser();
        if (!parser.readXmlFile(serverXmlFilePath)) {
            logger.log(Level.SEVERE, "updateWebswingServerContextOfSemApiSvrServerXml>>failed read server xml: {0}", new Object[]{serverXmlFilePath});
            throw new ServerXmlUpdateException("failed parse semapi server server.xml");
        }
        if (!ServerXml.updateWebswingServerContextOfSemApiSvrServerXml(parser.getDocument())) {
            logger.log(Level.INFO, "updateWebswingServerContextOfSemApiSvrServerXml>>no need to update webswing server context");
            return true;
        }
        boolean result = parser.saveXml(serverXmlFilePath);
        logger.log(Level.INFO, "updateWebswingServerContextOfSemApiSvrServerXml>>Done: save xml result;{0}", new Object[]{result});
        if (!result) {
            logger.log(Level.SEVERE, "updateWebswingServerContextOfSemApiSvrServerXml>>failed when saving server xml");
            throw new ServerXmlUpdateException("failed save semapi server server.xml");
        }
        return true;
    }

    public static boolean updateWebswingServerContextOfSemApiSvrServerXml(Document document) throws XPathExpressionException, ServerXmlUpdateException {
        XPath xpath = XPathFactory.newInstance().newXPath();
        NodeList nodeList = (NodeList)xpath.compile("//Host/Context[@docBase='webswing-server.war'][@path='/console']").evaluate(document.getDocumentElement(), XPathConstants.NODESET);
        if (nodeList.getLength() > 0) {
            logger.log(Level.WARNING, "updateWebswingServerContextOfSemApiSvrServerXml>> webswing server context is already configured");
            return false;
        }
        nodeList = (NodeList)xpath.compile("//Engine/Host").evaluate(document.getDocumentElement(), XPathConstants.NODESET);
        if (nodeList.getLength() == 0) {
            logger.log(Level.SEVERE, "updateWebswingServerContextOfSemApiSvrServerXml>> no Host node found , skip webswing config");
            throw new ServerXmlUpdateException("failed find host node in semapi server server.xml");
        }
        NodeList sepmNodeList = (NodeList)xpath.compile("//Engine/Context[@docBase='/sepm.war']").evaluate(document.getDocumentElement(), XPathConstants.NODESET);
        for (int i = 0; i < sepmNodeList.getLength(); ++i) {
            Node n = sepmNodeList.item(i);
            n.getParentNode().removeChild(n);
        }
        String[][] hostAttributes = new String[][]{{ATTRIBUTE_NAME_AUTO_DEPLOY, "false"}, {ATTRIBUTE_NAME_DEPLOY_ON_STARTUP, "false"}, {ATTRIBUTE_NAME_LIVE_DEPLOY, "false"}, {ATTRIBUTE_NAME_UNPACK_WARS, "true"}};
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element hostElement = (Element)nodeList.item(i);
            for (int j = 0; j < hostAttributes.length; ++j) {
                hostElement.setAttribute(hostAttributes[j][0], hostAttributes[j][1]);
            }
            sepmNodeList = (NodeList)xpath.compile("//Engine/Host/Context[@docBase='sepm.war']").evaluate(document.getDocumentElement(), XPathConstants.NODESET);
            if (sepmNodeList.getLength() == 0) {
                Element sepmContextElement = document.createElement("Context");
                sepmContextElement.setAttribute(ATTRIBUTE_NAME_DOC_BASE, "sepm.war");
                sepmContextElement.setAttribute(ATTRIBUTE_NAME_PATH, "/sepm");
                sepmContextElement.setAttribute(ATTRIBUTE_NAME_RELOADABLE, "false");
                hostElement.appendChild(sepmContextElement);
            }
            hostElement.appendChild(document.createComment("<Context docBase=\"webswing-server.war\" path=\"/console\" reloadable=\"false\"/>"));
        }
        logger.log(Level.INFO, "updateWebswingServerContextOfSemApiSvrServerXml>> Host node updated with sepm context and webswing context comment");
        return true;
    }

    public static class ServerXmlUpdateException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public ServerXmlUpdateException(String msg) {
            super(msg);
        }
    }

    public static class ROOTXmlHandler
    extends DefaultHandler {
        private String driverClassName = null;
        private String url = null;
        private String userName = null;
        private String password = null;
        private String domain = null;
        private String maxTotal = null;
        private String maxWaitMillis = null;
        private String logAbandoned = null;
        private String mssqlSocketReadTimeout = null;

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            super.startElement(uri, localName, qName, attributes);
            if ("Resource".equalsIgnoreCase(qName)) {
                this.driverClassName = attributes.getValue("driverClassName");
                this.url = attributes.getValue("url");
                this.userName = attributes.getValue("username");
                this.password = attributes.getValue("password");
                this.domain = attributes.getValue("domain");
                this.mssqlSocketReadTimeout = attributes.getValue("mssqlSocketReadTimeout");
                this.maxTotal = attributes.getValue(ServerXml.ROOT_RESOURCE_PROPERTY_MAXTOTAL);
                this.maxWaitMillis = attributes.getValue(ServerXml.ROOT_RESOURCE_PROPERTY_MAXWAITMILLS);
                this.logAbandoned = attributes.getValue(ServerXml.ROOT_RESOURCE_PROPERTY_LOGABANDONED);
            }
        }

        public String getDomain() {
            return this.domain;
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
        }

        public String getDriverClassName() {
            return this.driverClassName;
        }

        public String getUrl() {
            return this.url;
        }

        public String getUserName() {
            return this.userName;
        }

        public String getMaxTotal() {
            return this.maxTotal;
        }

        public void setMaxTotal(String maxTotal) {
            this.maxTotal = maxTotal;
        }

        public String getMaxWaitMillis() {
            return this.maxWaitMillis;
        }

        public void setMaxWaitMillis(String maxWaitMillis) {
            this.maxWaitMillis = maxWaitMillis;
        }

        public String getLogAbandoned() {
            return this.logAbandoned;
        }

        public void setLogAbandoned(String logAbandoned) {
            this.logAbandoned = logAbandoned;
        }

        public String getMssqlSocketReadTimeout() {
            return this.mssqlSocketReadTimeout;
        }

        public String getPassword() {
            try {
                return Utility.decryptDBPassword(this.password);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "ROOTXmlHandler> getPassword>> Error while decryting password from Root.xml file. Exception: " + e.getMessage());
                return "";
            }
        }
    }
}

