/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.util;

import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.ScmLicenseConstants;
import com.sygate.scm.util.SymantecMessageDigest;
import com.sygate.scm.util.Utility;
import java.security.MessageDigest;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ScmLicense
implements ScmLicenseConstants {
    private Date licenseExpDate;
    private Date onlineSubscriptionExpDate;
    private boolean isAdaptiveLocation;
    private boolean isExternalLogging;
    private boolean isFirewallPolicy;
    private boolean isIntrusionPreventionPolicy;
    private boolean isHostIntegrityPolicy;
    private boolean isOSPretectionPolicy;
    private boolean isQuarantinePolicy;
    private boolean isLanSensor;
    private boolean isGatewayEnforcer;
    private boolean isLanEnforcer;
    private boolean isDhcpEnforcer;
    private boolean isAvPolicy;
    private boolean isPolicyOverride;
    private boolean isUpgradePolicy;
    private boolean isTamperProtection;
    private boolean isMemPolicy;
    private boolean isNtrPolicy;
    private boolean isAdaptivePolicy;
    private int workstationsAgentCount;
    private int serversAgentCount;
    private int enforcementAgentCount;
    private int siteCount;
    private int serverCount;
    private boolean isValid;
    private String licenseData;
    private String productName;
    private static String privateKey = "05MES_etagyS";
    private boolean isSAVOnlyProduct;
    private boolean isSNACOnlyProduct;
    private boolean isALLProduct;
    private boolean isSEPSBProduct = false;
    private static final String[] ACCEPTABLE_CONTENT_CATEGORIES = new String[]{"SESM_CONTENT_CATALOG", "CLIENT_UPDATE", "AV_DEFS", "DEC_ABI", "PTS", "SYN_APPS", "IPS", "HI", "SUBMISSION_CONTROL", "IRON", "EFAVT", "EDR", "STIC", "SEPM_API", "ADVML", "SECURITY_FIX", "NTR", "AC", "PCH", "TDAD", "SEF", "WEBEXT", "ASR"};
    private static final String[] SAV_CONTENT_CATEGORIES = new String[]{"SESM_CONTENT_CATALOG", "CLIENT_UPDATE", "AV_DEFS", "DEC_ABI", "PTS", "SYN_APPS", "IPS", "SUBMISSION_CONTROL", "IRON", "EFAVT", "EDR", "STIC", "SEPM_API", "ADVML", "SECURITY_FIX", "NTR", "AC", "PCH", "TDAD", "SEF", "WEBEXT", "ASR"};

    public ScmLicense(String licenseData) {
        this.initialize();
        this.importScmLicense(licenseData);
    }

    public static String getChecksum(Element element) {
        ArrayList<String> list = new ArrayList<String>();
        ScmLicense.updateChecksumList(element, list);
        Collections.sort(list);
        try {
            MessageDigest md = SymantecMessageDigest.getInstance();
            for (int i = 0; i < list.size(); ++i) {
                md.update(list.get(i).getBytes("UTF-8"));
            }
            md.update(privateKey.getBytes("UTF-8"));
            String checksum = Utility.toHexString(md.digest());
            return checksum;
        }
        catch (Exception ex) {
            LoggerUtilities.logException(ex);
            return null;
        }
    }

    public String getProductName() {
        return this.productName;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public boolean isPerpetual() {
        return this.licenseExpDate == null;
    }

    public boolean isLicenseExpired() {
        if (this.isPerpetual()) {
            return false;
        }
        Date today = new Date();
        return today.after(this.licenseExpDate);
    }

    private boolean importScmLicense(String licenseData) {
        this.licenseData = licenseData;
        this.isValid = this.parseAndValidate();
        return this.isValid;
    }

    public Date getLicenseExpirationDate() {
        Date tempLicenseExpirationDate = (Date)(this.licenseExpDate == null ? null : this.licenseExpDate.clone());
        return tempLicenseExpirationDate;
    }

    public Date getOnlineSubscriptionExpirationDate() {
        Date tempOnlineSubscriptionExpDate = (Date)(this.onlineSubscriptionExpDate == null ? null : this.onlineSubscriptionExpDate.clone());
        return tempOnlineSubscriptionExpDate;
    }

    public int getWorkstationsAgentsCount() {
        return this.workstationsAgentCount;
    }

    public int getServersAgentsCount() {
        return this.serversAgentCount;
    }

    public int getEnforcementAgentCount() {
        return this.enforcementAgentCount;
    }

    public int getSiteCount() {
        return this.siteCount;
    }

    public int getServerCount() {
        return this.serverCount;
    }

    public boolean isAdaptiveLocation() {
        return this.isAdaptiveLocation;
    }

    public boolean isExternalLogging() {
        return this.isExternalLogging;
    }

    public boolean isFirewallPolicy() {
        return this.isFirewallPolicy;
    }

    public boolean isIntrusionPreventionPolicy() {
        return this.isIntrusionPreventionPolicy;
    }

    public boolean isHostIntegrityPolicy() {
        return this.isHostIntegrityPolicy;
    }

    public boolean isOSProtectionPolicy() {
        return this.isOSPretectionPolicy;
    }

    public boolean isMemPolicy() {
        return this.isMemPolicy;
    }

    public boolean isNtrPolicy() {
        return this.isNtrPolicy;
    }

    public boolean isQuarantinePolicy() {
        return this.isQuarantinePolicy;
    }

    public boolean isLANSensor() {
        return this.isLanSensor;
    }

    public boolean isGatewayEnforcer() {
        return this.isGatewayEnforcer;
    }

    public boolean isLanEnforcer() {
        return this.isLanEnforcer;
    }

    public boolean isDhcpEnforcer() {
        return this.isDhcpEnforcer;
    }

    public boolean isAvPolicy() {
        return this.isAvPolicy;
    }

    public boolean isPolicyOverride() {
        return this.isPolicyOverride;
    }

    public boolean isUpgradePolicy() {
        return this.isUpgradePolicy;
    }

    public boolean isAdaptivePolicy() {
        return this.isAdaptivePolicy;
    }

    public boolean isTamperProtection() {
        return this.isTamperProtection;
    }

    public boolean isSAVOnlyProduct() {
        return this.isSAVOnlyProduct;
    }

    public boolean isSNACOnlyProduct() {
        return this.isSNACOnlyProduct;
    }

    public boolean isALLProduct() {
        return this.isALLProduct;
    }

    public boolean isQualifiedLuContentCategory(String categoryName) {
        boolean isKnown;
        if (categoryName.equals("CLIENT_UPDATE")) {
            return !Utility.isTrialVersion();
        }
        boolean isAcceptable = this.isAcceptable(categoryName);
        if (!isAcceptable && !(isKnown = this.isKnownCategory(categoryName))) {
            isAcceptable = true;
        }
        return isAcceptable;
    }

    private boolean isAcceptable(String categoryName) {
        String[] supportedCategories = new String[]{};
        if (this.isSAVOnlyProduct()) {
            supportedCategories = this.isSEPSBProduct ? SAV_CONTENT_CATEGORIES : ACCEPTABLE_CONTENT_CATEGORIES;
        } else if (this.isALLProduct()) {
            supportedCategories = ACCEPTABLE_CONTENT_CATEGORIES;
        }
        for (int index = 0; index < supportedCategories.length; ++index) {
            if (!supportedCategories[index].equals(categoryName)) continue;
            return true;
        }
        return false;
    }

    public boolean isKnownCategory(String categoryName) {
        String[] knownCategories;
        for (String knownCategory : knownCategories = ACCEPTABLE_CONTENT_CATEGORIES) {
            if (!knownCategory.equalsIgnoreCase(categoryName)) continue;
            return true;
        }
        return categoryName.equalsIgnoreCase("SEPM_LIVEUPDATE_DATABASE");
    }

    private void initialize() {
        try {
            this.licenseExpDate = new SimpleDateFormat("MM/dd/yyyy").parse("01/01/1970");
        }
        catch (ParseException ex) {
            LoggerUtilities.logException(ex);
        }
        this.workstationsAgentCount = 0;
        this.serversAgentCount = 0;
        this.enforcementAgentCount = 0;
        this.siteCount = 0;
        this.serverCount = 0;
    }

    private boolean parseAndValidate() {
        String oldLicenseData = this.licenseData;
        String newLicenseData = "SEPSB";
        int i = oldLicenseData.indexOf(47);
        if (i >= 0 && i + 1 < oldLicenseData.length()) {
            newLicenseData = oldLicenseData.substring(i + 1);
            oldLicenseData = oldLicenseData.substring(0, i);
        }
        if (!(oldLicenseData.equals("SAV") || oldLicenseData.equals("SNAC") || oldLicenseData.equals("ALL"))) {
            System.out.println("ERROR>>> Invalid License Data");
            return false;
        }
        if (!newLicenseData.equals("SEPSB") && !newLicenseData.equals("SEPE")) {
            System.out.println("ERROR>>> Invalid License Data");
            return false;
        }
        this.workstationsAgentCount = -1;
        this.serversAgentCount = -1;
        this.enforcementAgentCount = -1;
        this.siteCount = -1;
        this.serverCount = -1;
        this.licenseExpDate = new Date(Long.MAX_VALUE);
        this.onlineSubscriptionExpDate = new Date(Long.MAX_VALUE);
        this.isAdaptiveLocation = true;
        this.isExternalLogging = true;
        this.productName = oldLicenseData;
        if (oldLicenseData.equals("SAV")) {
            this.isSAVOnlyProduct = true;
            this.isSNACOnlyProduct = false;
            this.isALLProduct = false;
        } else if (oldLicenseData.equals("SNAC")) {
            this.isSNACOnlyProduct = true;
            this.isSAVOnlyProduct = false;
            this.isALLProduct = false;
        } else {
            this.isALLProduct = true;
            this.isSAVOnlyProduct = false;
            this.isSNACOnlyProduct = false;
        }
        if (!this.isSNACOnlyProduct) {
            this.isFirewallPolicy = true;
            this.isIntrusionPreventionPolicy = true;
            this.isLanSensor = true;
            this.isGatewayEnforcer = true;
            this.isLanEnforcer = true;
            this.isDhcpEnforcer = true;
            this.isOSPretectionPolicy = true;
            this.isAvPolicy = true;
            this.isPolicyOverride = true;
            this.isUpgradePolicy = true;
            this.isTamperProtection = true;
            this.isMemPolicy = true;
            this.isNtrPolicy = true;
            this.isAdaptivePolicy = true;
        }
        newLicenseData = System.getProperty("Spc.Product.Type", "");
        this.isSEPSBProduct = newLicenseData.equalsIgnoreCase("SEPSB");
        if (this.isSEPSBProduct) {
            this.isOSPretectionPolicy = false;
        }
        if (this.isSNACOnlyProduct || this.isALLProduct || this.isSAVOnlyProduct && !this.isSEPSBProduct) {
            this.isHostIntegrityPolicy = true;
            this.isQuarantinePolicy = true;
        }
        this.isSNACOnlyProduct = false;
        if (this.isALLProduct) {
            this.isALLProduct = false;
            this.isSAVOnlyProduct = true;
        }
        return true;
    }

    private static void updateChecksumList(Element element, List<String> list) {
        list.add(ScmLicense.getAttributeValues(element));
        NodeList children = element.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1) continue;
            ScmLicense.updateChecksumList((Element)child, list);
        }
    }

    private static String getAttributeValues(Element element) {
        StringBuffer attribute = new StringBuffer();
        NamedNodeMap attriMap = element.getAttributes();
        if (attriMap == null) {
            return "null";
        }
        Node nameAttri = attriMap.getNamedItem("Name");
        if (nameAttri != null) {
            attribute.append(nameAttri.getNodeValue());
        }
        TreeMap<String, String> map = new TreeMap<String, String>();
        for (int i = 0; i < attriMap.getLength(); ++i) {
            Node attriNode = attriMap.item(i);
            String name = attriNode.getNodeName();
            if (name.equals("Name")) continue;
            map.put(name, attriNode.getNodeValue());
        }
        Iterator values = map.values().iterator();
        while (values.hasNext()) {
            attribute.append((String)values.next());
        }
        return attribute.toString();
    }
}

