/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.util;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.schema.SemLocalSettings;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.StringUtilities;
import com.sygate.scm.util.Utility;
import com.sygate.scm.util.template.Template;
import com.sygate.scm.util.template.TemplateManager;
import java.util.EnumSet;
import java.util.StringTokenizer;

public class SchemaVersion {
    public static final String SEP_5_0_0_SCHEMA = "5.0.0";
    public static final String SEP_5_1_0_SCHEMA = "5.1.0";
    public static final String SEP_5_1_1_SCHEMA = "5.1.1";
    public static final String HAMLET_ET3_SCHEMA = "11.0.0.0";
    public static final String HAMLET_SCHEMA = "11.0.0.1";
    public static final String MR1_SCHEMA = "11.0.0.3";
    public static final String MR2_SCHEMA = "11.0.0.4";
    public static final String MR3_BETA_SCHEMA = "11.0.0.7";
    public static final String MR3_SCHEMA = "11.0.1.0";
    public static final String MR4_SCHEMA = "11.0.2.0";
    public static final String MR4MP1_SCHEMA = "11.0.2.1";
    public static final String MR4MP2_SCHEMA = "11.0.2.2";
    public static final String MR4MP3_SCHEMA = "11.0.2.4";
    public static final String MR5_SCHEMA = "11.0.3.0";
    public static final String MR5MP1_SCHEMA = "11.0.3.1";
    public static final String SANDIA_HOT_FIX_SCHEMA = "11.0.3.2";
    public static final String RU6_SCHEMA = "11.0.6.0";
    public static final String DIETCOKE_SCHEMA = "12.0.0.0";
    public static final String DIETCOKE_RU1_SCHEMA = "12.0.1.0";
    public static final String RU6MP1_SCHEMA = "11.0.6.1";
    public static final String RU6MP2_SCHEMA = "11.0.6.2";
    public static final String RU7_SCHEMA = "11.0.7.0";
    public static final String RU7MP1_SCHEMA = "11.0.7.1";
    public static final String RU7MP2_SCHEMA = "11.0.7.2";
    public static final String RU7MP4_SCHEMA = "11.0.7.4";
    public static final String AMBER_SCHEMA = "12.1.0.0";
    public static final String AMBER_SCHEMA_BETA1 = "12.1.0.1";
    public static final String AMBER_SCHEMA_BETA2 = "12.1.0.2";
    public static final String AMBER_SCHEMA_RC = "12.1.0.3";
    public static final String AMBER_SCHEMA_RU1 = "12.1.1.0";
    public static final String AMBER_SCHEMA_RU1_MP1 = "12.1.1.1";
    public static final String JAGUAR_SCHEMA_PFC = "12.1.2.0";
    public static final String JAGUAR_SCHEMA_BETA1 = "12.1.2.1";
    public static final String JAGUAR_SCHEMA_BETA2 = "12.1.2.2";
    public static final String MCLAREN_SCHEMA_RU3 = "12.1.3.0";
    public static final String TESLA_SCHEMA_RU4 = "12.1.4.0";
    public static final String LIGHTCYCLE_SCHEMA_RU4MP1 = "12.1.4.1";
    public static final String FERRARI_SCHEMA_PCC = "12.1.5.0";
    public static final String FERRARI_SCHEMA_ALPHA = "12.1.5.1";
    public static final String FERRARI_SCHEMA_BETA1 = "12.1.5.2";
    public static final String FERRARI_SCHEMA_BETA2 = "12.1.5.3";
    public static final String FERRARI_SCHEMA_RC = "12.1.5.4";
    public static final String PORSCHE_SCHEMA_BETA = "12.1.6.0";
    public static final String PORSCHE_SCHEMA_RC = "12.1.6.1";
    public static final String VROD_SCHEMA_RC = "12.1.6.2";
    public static final String PORSCHE_SCHEMA_MP2 = "12.1.6.3";
    public static final String PORSCHE_SCHEMA_MP3 = "12.1.6.4";
    public static final String PORSCHE_SCHEMA_MP4 = "12.1.6.5";
    public static final String PORSCHE_SCHEMA_MP5 = "12.1.6.6";
    public static final String PORSCHE_SCHEMA_MP6 = "12.1.6.7";
    public static final String PORSCHE_SCHEMA_MP7 = "12.1.6.8";
    public static final String PORSCHE_SCHEMA_MP8 = "12.1.6.9";
    public static final String PORSCHE_SCHEMA_MP9 = "12.1.6.10";
    public static final String PORSCHE_SCHEMA_MP10 = "12.1.6.11";
    public static final String LAMBORGHINI_CUSTOMER_PREVIEW_SCHEMA = "12.2.0.0";
    public static final String LAMBORGHINI_SCHEMA_BETA = "14.0.0.0";
    public static final String LAMBORGHINI_SCHEMA_RC = "14.0.0.1";
    public static final String LAMBORGHINI_SCHEMA_RC2 = "14.0.0.2";
    public static final String LAMBORGHINI_SCHEMA_MP1 = "14.0.0.3";
    public static final String LAMBORGHINI_SCHEMA_MP1_BOSCH_HOT_FIX = "14.0.0.4";
    public static final String LAMBORGHINI_SCHEMA_MP2 = "14.0.0.5";
    public static final String LAMBORGHINI_SCHEMA_RU1 = "14.0.1.0";
    public static final String LAMBORGHINI_SCHEMA_RU1_RC = "14.0.1.1";
    public static final String LAMBORGHINI_SCHEMA_RU1_MP1 = "14.0.1.2";
    public static final String LAMBORGHINI_SCHEMA_RU1_MP2 = "14.0.1.3";
    public static final String RAINIER_SCHEMA = "14.2.0.0";
    public static final String RAINIER_SCHEMA_MP1 = "14.2.0.2";
    public static final String OLD_SCHEMA_VERSION_REGEX = "\\d\\d\\.\\d\\.\\d\\.\\d";
    public static final String EVERGREEN_SCHEMA = "14.2.1.1000";
    public static final String EVERGREEN_SCHEMA_MP1 = "14.2.1.1100";
    public static final String SAHYADRI_SCHEMA = "14.2.2.2000";
    public static final String SAHYADRI_SCHEMA_MP1 = "14.2.2.2100";
    public static final String OLYMPUS_SCHEMA = "14.3.0.0000";
    public static final String OLYMPUS_SCHEMA_MP1 = "14.3.0.0100";
    public static final String SCHEMA_143_RU1 = "14.3.1.1000";
    public static final String SCHEMA_143_RU1_MP1 = "14.3.1.1100";
    public static final String SCHEMA_143_RU2 = "14.3.2.2000";
    public static final String SCHEMA_143_RU3 = "14.3.3.3000";
    public static final String SCHEMA_143_RU4 = "14.3.4.4000";
    public static final String SCHEMA_143_RU5 = "14.3.5.5000";
    public static final String SCHEMA_143_RU6 = "14.3.6.6000";
    public static final String SCHEMA_143_RU7 = "14.3.7.7000";
    public static final String SCHEMA_143_RU8 = "14.3.8.8000";
    public static final String SCHEMA_143_RU9 = "14.3.9.9000";
    public static final String SCHEMA_143_RU10 = "14.3.10.10000";
    public static final String SCHEMA_VERSION_REMOVE_EMBEDDEDDB = "14.3.1.1000";
    public static final String SCHEMA_VERSION_UPGRADE_NEED_DBA = "14.0.0.1";
    public static final String CURRENT_SCHEMA = "14.3.10.10000";

    public static final boolean isReleaseVersion() {
        boolean isReleaseVersion = true;
        try {
            Template slsTmpl = TemplateManager.getSemLocalSettingsTemplate(false);
            SemLocalSettings semLocalSettings = (SemLocalSettings)AbstractSchema.readXML(slsTmpl.getXML());
            if (semLocalSettings != null) {
                isReleaseVersion = semLocalSettings.getOptReleaseVersion() == null ? semLocalSettings.getDefReleaseVersion() : semLocalSettings.getOptReleaseVersion();
            }
        }
        catch (Exception e) {
            LoggerUtilities.logException(e);
        }
        return isReleaseVersion;
    }

    public static enum UPGRADE_RESTORE_SUPPORTED_HIGHEST_VERSIONS {
        CURRENT_SCHEMA("14.3.10.10000"),
        SERIES_143RU9_SCHEMA("14.3.9.9000"),
        SERIES_143RU8_SCHEMA("14.3.8.8000"),
        SERIES_143RU7_SCHEMA("14.3.7.7000"),
        SERIES_143RU6_SCHEMA("14.3.6.6000"),
        SERIES_143RU5_SCHEMA("14.3.5.5000"),
        SERIES_143RU4_SCHEMA("14.3.4.4000"),
        SERIES_143RU3_SCHEMA("14.3.3.3000"),
        SERIES_143RU2_SCHEMA("14.3.2.2000"),
        SERIES_143RU1_SCHEMA("14.3.1.1100"),
        SERIES_143_SCHEMA("14.3.0.0100"),
        SERIES_142RU2_SCHEMA("14.2.2.2100"),
        SERIES_142RU1_SCHEMA("14.2.1.1100"),
        SERIES_142_SCHEMA("14.2.0.2"),
        SERIES_140RU1_SCHEMA("14.0.1.3"),
        SERIES_140_SCHEMA("14.0.0.5"),
        SERIES_122_SCHEMA("12.2.0.0"),
        SERIES_121RU6_SCHEMA("12.1.6.11");

        private final String versionNumber;

        public static boolean isSupported(SemLocalSettings semLocalSettingsFrom, String serverVersionTo) throws Exception {
            boolean isSupported = true;
            if (semLocalSettingsFrom != null) {
                boolean isReleaseVersionFrom = semLocalSettingsFrom.getOptReleaseVersion() == null ? semLocalSettingsFrom.getDefReleaseVersion() : semLocalSettingsFrom.getOptReleaseVersion();
                boolean isReleaseVersionTo = SchemaVersion.isReleaseVersion();
                System.out.println("SchemaVersion>> isSupported> isReleaseVersionFrom: " + isReleaseVersionFrom + ", isReleaseVersionTo: " + isReleaseVersionTo);
                String serverVersionFrom = semLocalSettingsFrom.getOptServerVersion();
                isSupported = UPGRADE_RESTORE_SUPPORTED_HIGHEST_VERSIONS.isSupported(isReleaseVersionFrom, isReleaseVersionTo, serverVersionFrom, serverVersionTo);
            } else {
                System.out.println("SchemaVersion>> isSupported> ignored, semLocalSettingsFrom is null!");
            }
            return isSupported;
        }

        public static boolean isSupported(boolean isReleaseVersionFrom, boolean isReleaseVersionTo, String serverVersionFrom, String serverVersionTo) {
            boolean isSupported = true;
            System.out.println("SchemaVersion>> isSupported> isReleaseVersionFrom: " + isReleaseVersionFrom + ", isReleaseVersionTo: " + isReleaseVersionTo);
            if (!isReleaseVersionFrom) {
                if (isReleaseVersionTo) {
                    isSupported = false;
                    System.out.println("SchemaVersion>> isSupported> Preview build to Release Build is not allowed!");
                } else {
                    System.out.println("SchemaVersion>> isSupported> Preview build to Preview Build, to Preview Build: " + serverVersionTo + ", from Preview Build: " + serverVersionFrom);
                    if (serverVersionTo != null && !serverVersionTo.equals(serverVersionFrom)) {
                        isSupported = false;
                        System.out.println("SchemaVersion>> isSupported> Preview Build to Preview Build is not allowed when build number is not same!");
                    }
                }
            }
            return isSupported;
        }

        public static boolean isSupported(String versionToBeSupported) {
            boolean upgradeRestoreSupportedForTheGivenVersion = false;
            String majorVersionToBeSupported = null;
            String minorVersionToBeSupported = null;
            String ruVersionToBeSupported = null;
            String majorVersion = null;
            String minorVersion = null;
            String ruVersion = null;
            StringTokenizer tokenizer = null;
            if (!StringUtilities.isEmpty(versionToBeSupported)) {
                EnumSet<UPGRADE_RESTORE_SUPPORTED_HIGHEST_VERSIONS> versions = EnumSet.allOf(UPGRADE_RESTORE_SUPPORTED_HIGHEST_VERSIONS.class);
                System.out.println("VersionToBeSupported: " + versionToBeSupported);
                tokenizer = new StringTokenizer(versionToBeSupported, ".");
                if (tokenizer.hasMoreTokens()) {
                    majorVersionToBeSupported = tokenizer.nextToken();
                }
                if (tokenizer.hasMoreTokens()) {
                    minorVersionToBeSupported = tokenizer.nextToken();
                }
                if (tokenizer.hasMoreTokens()) {
                    ruVersionToBeSupported = tokenizer.nextToken();
                }
                for (UPGRADE_RESTORE_SUPPORTED_HIGHEST_VERSIONS version : versions) {
                    String versionNumber = version.getVersionNumber();
                    tokenizer = new StringTokenizer(versionNumber, ".");
                    if (tokenizer.hasMoreTokens()) {
                        majorVersion = tokenizer.nextToken();
                    }
                    if (tokenizer.hasMoreTokens()) {
                        minorVersion = tokenizer.nextToken();
                    }
                    if (tokenizer.hasMoreTokens()) {
                        ruVersion = tokenizer.nextToken();
                    }
                    if (!majorVersion.equals(majorVersionToBeSupported) || !minorVersion.equals(minorVersionToBeSupported) || !ruVersion.equals(ruVersionToBeSupported)) continue;
                    if (SchemaVersion.PORSCHE_SCHEMA_MP10.equalsIgnoreCase(versionNumber) && Utility.compareVersion(versionNumber, versionToBeSupported) != 0) {
                        System.out.println("SchemaVersion>> isSupported> versionToBeSupported '" + versionToBeSupported + "' is not supported, only version >= '12.1.6.11' is supported.");
                        upgradeRestoreSupportedForTheGivenVersion = false;
                        break;
                    }
                    if (Utility.compareVersion(versionNumber, versionToBeSupported) == -1) {
                        System.out.println("SchemaVersion>> isSupported> versionToBeSupported '" + versionToBeSupported + "' is greater than the current highest supported version '" + versionNumber + "' for this release.");
                        upgradeRestoreSupportedForTheGivenVersion = false;
                        break;
                    }
                    System.out.println("SchemaVersion>> isSupported> versionToBeSupported '" + versionToBeSupported + "  is supported for this release");
                    upgradeRestoreSupportedForTheGivenVersion = true;
                    break;
                }
            }
            return upgradeRestoreSupportedForTheGivenVersion;
        }

        private UPGRADE_RESTORE_SUPPORTED_HIGHEST_VERSIONS(String versionNumber) {
            this.versionNumber = versionNumber;
        }

        public String getVersionNumber() {
            return this.versionNumber;
        }
    }
}

