/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.util;

import com.sygate.scm.util.BabyThread;
import com.sygate.scm.util.ICommandHandler;
import com.sygate.scm.util.IOUtilities;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.StringUtilities;
import com.sygate.scm.util.Utility;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Optional;

public class RunCommandHandler
implements ICommandHandler {
    private static final int MAXLEN = 1024;
    private int maxOutputLength = 1024;
    OutputStream normalOut;
    OutputStream errorOut;
    StringBuffer normalString = null;
    StringBuffer errorString = null;
    public static final long NO_TIMEOUT = 0L;
    public static final int MAX_WATCHDOGTHREAD_QUIT_TIME_MS = 60000;
    private static final String CATALINA_BASE = System.getProperty("catalina.base", "");
    protected Object lock = new Object();
    private String[] windowsProcessName = new String[]{"msiexec", "cmd", "net", "reg", "gpresult", "RunDll32", "sc"};

    public RunCommandHandler(OutputStream normal, OutputStream error) {
        this.normalOut = normal;
        this.errorOut = error;
        this.maxOutputLength = 1024;
    }

    public RunCommandHandler(OutputStream normal, OutputStream error, int maxOutputLength) {
        this.normalOut = normal;
        this.errorOut = error;
        this.maxOutputLength = maxOutputLength;
    }

    public static ICommandHandler getInstance() {
        ICommandHandler handler = null;
        try {
            Class<?> commandHandler = null;
            if (!StringUtilities.isEmpty(CATALINA_BASE) && Utility.isJVMServerMode()) {
                try {
                    commandHandler = Class.forName("com.sygate.scm.server.util.ServerRunCommandHandler");
                }
                catch (ClassNotFoundException cnfe) {
                    System.out.println("RunCommandHandler>> getInstance> ClassNotFoundException raised Error: " + cnfe.getMessage());
                    LoggerUtilities.logException(cnfe);
                    commandHandler = Class.forName("com.sygate.scm.util.RunCommandHandler");
                }
            } else {
                commandHandler = Class.forName("com.sygate.scm.util.RunCommandHandler");
            }
            handler = (ICommandHandler)commandHandler.getConstructor(OutputStream.class, OutputStream.class).newInstance(null, null);
        }
        catch (Exception ex) {
            LoggerUtilities.logException(ex);
        }
        finally {
            if (handler == null) {
                handler = new RunCommandHandler(null, null);
            }
        }
        return handler;
    }

    public static int runCommandLine(String[] command) throws IOException, InterruptedException {
        return RunCommandHandler.runCommandLine(command, null, null, null, null);
    }

    public static void runWindowsCommandLine(String[] command) throws IOException {
        Runtime.getRuntime().exec(command, null, null);
    }

    public static int runCommandLine(String[] command, String[] env, String workDir, OutputStream normalOut, OutputStream errorOut) throws IOException, InterruptedException {
        RunCommandHandler comHandler = new RunCommandHandler(normalOut, errorOut);
        File fWorkingDir = null;
        if (workDir != null) {
            fWorkingDir = new File(workDir);
        }
        return comHandler.run(command, env, fWorkingDir, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int handleProcess(final Process process, final long maxDuration) throws InterruptedException {
        BabyThread processWatchDog = null;
        if (maxDuration > 0L) {
            processWatchDog = new BabyThread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        Object object = RunCommandHandler.this.lock;
                        synchronized (object) {
                            RunCommandHandler.this.lock.wait(maxDuration);
                        }
                    }
                    catch (InterruptedException ie) {
                        System.out.println("RunCommandHandler>> processWatchDog> Done.");
                    }
                    finally {
                        try {
                            process.exitValue();
                        }
                        catch (IllegalThreadStateException ex) {
                            process.destroy();
                            System.out.println("RunCommandHandler>> processWatchDog> Execution timed out, process is destroyed");
                        }
                    }
                }
            };
            processWatchDog.setDaemon(true);
            processWatchDog.start();
        }
        int ret = -1;
        try {
            if (this.normalString == null) {
                this.normalString = new StringBuffer();
            }
            if (this.errorString == null) {
                this.errorString = new StringBuffer();
            }
            ReadThread normal = new ReadThread(process.getInputStream(), this.normalOut, this.normalString, "stdin", this.maxOutputLength);
            ReadThread error = new ReadThread(process.getErrorStream(), this.errorOut, this.errorString, "stderr", this.maxOutputLength);
            normal.start();
            error.start();
            ret = process.waitFor();
            normal.join();
            error.join();
        }
        finally {
            this.closeProcess(process);
            if (processWatchDog != null && processWatchDog.isAlive()) {
                processWatchDog.interrupt();
                processWatchDog.join(60000L);
            }
        }
        return ret;
    }

    @Override
    public int run(String[] command, String[] env, File workDir, long maxDuration) throws IOException, InterruptedException {
        if (command == null || command.length == 0) {
            return 0;
        }
        Process process = this.getProcess(command, env, workDir);
        return this.handleProcess(process, maxDuration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int run(String[] command, String[] env, File workDir, long maxDuration, String interactiveUserInput) throws IOException, InterruptedException {
        if (command == null || command.length == 0 || interactiveUserInput == null) {
            return 0;
        }
        Process process = this.getProcess(command, env, workDir);
        BufferedWriter processInputWriter = null;
        try {
            processInputWriter = new BufferedWriter(new OutputStreamWriter(process.getOutputStream(), "UTF-8"));
            processInputWriter.write(interactiveUserInput);
            processInputWriter.flush();
        }
        catch (Throwable throwable) {
            IOUtilities.closeWriter(processInputWriter);
            throw throwable;
        }
        IOUtilities.closeWriter(processInputWriter);
        return this.handleProcess(process, maxDuration);
    }

    @Override
    public Process getProcess(String[] command) throws IOException {
        return this.getProcess(command, null, null);
    }

    @Override
    public Process getProcess(String[] command, String[] env, File workDir) throws IOException {
        String adjustedCmd;
        if (!this.isWindowsProcess(command[0]) && (adjustedCmd = this.adjustLaunchCommand(command[0])) != null) {
            command[0] = adjustedCmd;
        }
        return Runtime.getRuntime().exec(command, env, workDir);
    }

    @Override
    public String getNormalOut() {
        return Optional.ofNullable(this.normalString).orElse(new StringBuffer()).toString();
    }

    @Override
    public String getErrorOut() {
        return Optional.ofNullable(this.errorString).orElse(new StringBuffer()).toString();
    }

    @Override
    public void closeProcess(Process pro) {
        try {
            if (pro != null) {
                pro.getErrorStream().close();
                IOUtilities.closeInputStream(pro.getInputStream());
                IOUtilities.closeOutputStream(pro.getOutputStream());
            }
            if (pro != null) {
                pro.destroy();
            }
        }
        catch (Exception ignore) {
            LoggerUtilities.logException(ignore);
        }
    }

    @Override
    public String adjustLaunchCommand(String cmd) {
        Object adjustedCmd = null;
        if (cmd != null) {
            if (cmd.startsWith("\"") && cmd.endsWith("\"")) {
                cmd = cmd.substring(1, cmd.length() - 1);
            }
            File processTobeLaunched = new File(cmd);
            adjustedCmd = cmd;
            if (!processTobeLaunched.isAbsolute()) {
                adjustedCmd = processTobeLaunched.getAbsolutePath();
            }
            if (!((String)adjustedCmd).startsWith("\"")) {
                adjustedCmd = "\"" + processTobeLaunched.getAbsolutePath() + "\"";
            }
        }
        return adjustedCmd;
    }

    private boolean isWindowsProcess(String cmd) {
        String cmdName = cmd.trim().toLowerCase();
        if (cmdName != null && cmdName.endsWith(".exe")) {
            int endIndex = cmdName.lastIndexOf(".exe");
            int startIndex = cmdName.lastIndexOf("\\");
            cmdName = cmdName.substring(startIndex + 1, endIndex);
        }
        int size = this.windowsProcessName.length;
        for (int i = 0; i < size; ++i) {
            if (!cmdName.equalsIgnoreCase(this.windowsProcessName[i])) continue;
            return true;
        }
        return false;
    }

    protected static class ReadThread
    extends BabyThread {
        int maxOutputLength;
        InputStream in;
        OutputStream out;
        StringBuffer strOutput;
        final String threadNamePostfix;

        ReadThread(InputStream in, OutputStream out, StringBuffer stringOutput, String threadNamePostfix, int maxOutputLength) {
            if (threadNamePostfix == null) {
                throw new IllegalArgumentException("ThreadNamePostfix arg is null");
            }
            this.in = in;
            this.out = out;
            this.strOutput = stringOutput;
            this.threadNamePostfix = "_" + threadNamePostfix;
            this.maxOutputLength = maxOutputLength;
        }

        @Override
        public void run() {
            byte[] buff = new byte[1024];
            int len = -1;
            int wholeLen = 0;
            String threadName = Thread.currentThread().getName() + this.threadNamePostfix;
            Thread.currentThread().setName(threadName);
            try {
                while ((len = this.in.read(buff, 0, 1024)) != -1) {
                    if (this.out != null) {
                        this.out.write(buff, 0, len);
                        this.out.flush();
                    }
                    if (this.maxOutputLength > 0 && wholeLen >= this.maxOutputLength) continue;
                    this.strOutput.append(new String(buff, 0, len, "UTF-8"));
                    wholeLen += len;
                }
            }
            catch (IOException e) {
                LoggerUtilities.logException(e);
            }
        }
    }
}

