/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.util;

import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.StringUtilities;
import java.time.DateTimeException;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RevisionFormatter {
    public static final String YYYYMMDDRRR = "YYYYMMDDRRR";
    public static final String YYMMDDRRR = "YYMMDDRRR";
    public static final String yYMMDDRRR = "yYMMDDRRR";
    public static final Pattern SEQUENCE_NUMBER_FULL_YEAR_MATCH_PATTERN = Pattern.compile("(\\d{4})(\\d{2})(\\d{2})(\\d{3})");
    public static final Pattern SEQUENCE_NUMBER_SHORT_YEAR_MATCH_PATTERN = Pattern.compile("(\\d{2})(\\d{2})(\\d{2})(\\d{3})");
    public static final DateTimeFormatter PATTERN_DATE_FORMATTER = DateTimeFormatter.ofLocalizedDate(FormatStyle.SHORT);

    public static String convertSequenceEx(String sequence) {
        StringBuilder formatted = new StringBuilder();
        int year = 0;
        int month = 0;
        int day = 0;
        int revision = 0;
        Matcher m = SEQUENCE_NUMBER_SHORT_YEAR_MATCH_PATTERN.matcher(sequence);
        boolean matched = m.matches();
        if (matched) {
            year = Integer.parseInt(m.group(1)) + 2000;
        } else {
            m = SEQUENCE_NUMBER_FULL_YEAR_MATCH_PATTERN.matcher(sequence);
            matched = m.matches();
            if (matched) {
                year = Integer.parseInt(m.group(1));
            }
        }
        if (matched) {
            month = Integer.parseInt(m.group(2));
            day = Integer.parseInt(m.group(3));
            revision = Integer.parseInt(m.group(4));
            try {
                String formattedDate = LocalDate.of(year, month, day).format(PATTERN_DATE_FORMATTER);
                formatted.append(formattedDate).append(" r").append(revision);
            }
            catch (DateTimeException dateTimeException) {
                // empty catch block
            }
        }
        return formatted.toString();
    }

    public static int convertSequenceEx(String sequence, String format, StringBuffer strDate) {
        StringBuffer sb = new StringBuffer();
        sb.append(sequence);
        if (yYMMDDRRR.equals(format) && sb.length() > 9) {
            if (strDate != null) {
                strDate.append("1970-01-01");
            }
            return 0;
        }
        String strYear = "";
        String strMonth = "";
        String strDay = "";
        String strRev = "";
        if (YYYYMMDDRRR.equals(format)) {
            strYear = sb.substring(0, 4);
            strMonth = sb.substring(4, 6);
            strDay = sb.substring(6, 8);
            strRev = sb.substring(8);
        } else {
            while (sb.length() < 9) {
                sb.insert(0, "0");
            }
            strYear = sb.substring(0, 2);
            strMonth = sb.substring(2, 4);
            strDay = sb.substring(4, 6);
            strRev = sb.substring(6);
        }
        try {
            if (!(yYMMDDRRR.equals(format) || YYYYMMDDRRR.equals(format) || YYMMDDRRR.equals(format))) {
                throw new Exception("BadFormat");
            }
            int nYear = Integer.parseInt(strYear);
            int nMonth = Integer.parseInt(strMonth);
            int nDay = Integer.parseInt(strDay);
            int nRev = Integer.parseInt(strRev);
            if (nMonth <= 0 || nMonth > 12) {
                throw new NumberFormatException();
            }
            int daysmax = 31;
            if (nMonth == 4 || nMonth == 6 || nMonth == 9 || nMonth == 11) {
                daysmax = 30;
            }
            if (nMonth == 2) {
                int n = daysmax = nYear / 4 * 4 == nYear ? 29 : 28;
            }
            if (nDay <= 0 || nDay > daysmax) {
                throw new NumberFormatException();
            }
            if (strDate != null) {
                if (!YYYYMMDDRRR.equals(format)) {
                    strDate.append(nYear + 2000);
                } else {
                    strDate.append(nYear);
                }
                strDate.append("-");
                strDate.append(strMonth);
                strDate.append("-");
                strDate.append(strDay);
            }
            return nRev;
        }
        catch (NumberFormatException nfe) {
            if (strDate != null) {
                strDate.append("1970-01-01");
            }
            return 0;
        }
        catch (Exception nfe) {
            if (strDate != null) {
                strDate.append("1970-01-01");
            }
            return 0;
        }
    }

    public static String toBuildNumberFormat(String sequenceNumber) {
        Object buildNumberString;
        Object object = buildNumberString = sequenceNumber == null ? "" : sequenceNumber;
        if (!StringUtilities.isEmpty(sequenceNumber)) {
            try {
                Long seqNumLong = Long.parseLong(sequenceNumber);
                Long majorVersion = seqNumLong >> 24;
                Long remainingSeqNumber = seqNumLong ^ majorVersion << 24;
                Long minorVersion = remainingSeqNumber >> 16;
                Long buildNumber = remainingSeqNumber ^ minorVersion << 16;
                buildNumberString = String.valueOf(majorVersion) + "." + String.valueOf(minorVersion) + "." + String.valueOf(buildNumber);
            }
            catch (Exception e) {
                System.out.println("Error while converting sequence number to build format. Using sequence number as is");
                LoggerUtilities.logException(e);
            }
        }
        return buildNumberString;
    }
}

