/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.util;

import com.sygate.scm.common.configobject.schema.TimeFrame;
import java.util.Calendar;
import java.util.HashMap;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ReplicationScheduleUtility {
    private static Logger logger = Logger.getLogger(ReplicationScheduleUtility.class.getName());
    private static HashMap<String, ReplicationPartnerScheduleState> siteMap = new HashMap();

    public static HashMap<String, ReplicationPartnerScheduleState> getSiteMap() {
        return siteMap;
    }

    public static boolean isCurTimeWithInTimeFrames(Calendar currentTime, TimeFrame timeFrame, boolean useTimeZoneGMT) {
        if (timeFrame == null) {
            logger.log(Level.FINE, "TaskSchedule>> isCurTimeWithInTimeFrames, time frame window is coming empty, so returning true");
            return true;
        }
        int startHour = timeFrame.getOptStartHour() == null ? timeFrame.getDefStartHour() : timeFrame.getOptStartHour();
        int startMin = timeFrame.getOptStartMin() == null ? timeFrame.getDefStartMin() : timeFrame.getOptStartMin();
        int endHour = timeFrame.getOptEndHour() == null ? timeFrame.getDefEndHour() : timeFrame.getOptEndHour();
        int endMin = timeFrame.getOptEndMin() == null ? timeFrame.getDefEndMin() : timeFrame.getOptEndMin();
        TimeZone tz = null;
        if (useTimeZoneGMT) {
            tz = TimeZone.getTimeZone("GMT");
        }
        if (startHour == 0 && endHour == 24) {
            return true;
        }
        Calendar start = ReplicationScheduleUtility.getRequiredCalendarInstance(tz);
        Calendar end = ReplicationScheduleUtility.getRequiredCalendarInstance(tz);
        start.set(11, startHour);
        start.set(12, startMin);
        end.set(11, endHour);
        end.set(12, endMin);
        if (!ReplicationScheduleUtility.isEqualTime(currentTime, start) && start.after(end)) {
            if (currentTime.after(start)) {
                end.add(5, 1);
            } else {
                start.add(5, -1);
            }
        }
        logger.log(Level.FINE, "TaskSchedule>> isCurTimeWithInTimeFrames, \nStart Day: " + start.get(7) + " Start Hour: " + start.get(11) + " Start Minute: " + start.get(12) + " , \nEnd Day: " + end.get(7) + " End Hour: " + end.get(11) + " End Minute: " + end.get(12) + " , \nCurrent Day: " + currentTime.get(7) + " Current Hour: " + currentTime.get(11) + " Current Minute: " + currentTime.get(12));
        return ReplicationScheduleUtility.isEqualTime(currentTime, start) || ReplicationScheduleUtility.isEqualTime(currentTime, end) || currentTime.after(start) && currentTime.before(end);
    }

    private static boolean isEqualTime(Calendar source, Calendar target) {
        return source.get(7) == target.get(7) && source.get(11) == target.get(11) && source.get(12) == target.get(12);
    }

    public static Calendar getStartTimeFromTimeFrame(TimeFrame timeFrame, boolean useTimeZoneGMT) {
        TimeZone tz = null;
        if (useTimeZoneGMT) {
            tz = TimeZone.getTimeZone("GMT");
        }
        int startHour = timeFrame.getOptStartHour() == null ? timeFrame.getDefStartHour() : timeFrame.getOptStartHour();
        int startMin = timeFrame.getOptStartMin() == null ? timeFrame.getDefStartMin() : timeFrame.getOptStartMin();
        Calendar start = ReplicationScheduleUtility.getRequiredCalendarInstance(tz);
        Calendar now = ReplicationScheduleUtility.getRequiredCalendarInstance(tz);
        start.set(11, startHour);
        start.set(12, startMin);
        while (start.before(now)) {
            start.add(5, 1);
        }
        logger.log(Level.FINE, "TaskSchedule>> getStartTimeFromTimeFrame: start Day - " + start.get(7) + " Start Hour: " + start.get(11) + " Start Minute: " + start.get(12));
        return start;
    }

    private static Calendar getRequiredCalendarInstance(TimeZone tz) {
        Calendar calender = tz == null ? Calendar.getInstance() : Calendar.getInstance(tz);
        return calender;
    }

    public static class ReplicationPartnerScheduleState {
        private boolean replicationScheduleChanged = false;
        private long previousReplicationTime = 0L;

        public void setPreviousReplicationTime(long previousReplicationTime) {
            this.previousReplicationTime = previousReplicationTime;
        }

        public boolean isReplicationScheduleChanged() {
            return this.replicationScheduleChanged;
        }

        public void setReplicationScheduleChanged(boolean replicationScheduleChanged) {
            this.replicationScheduleChanged = replicationScheduleChanged;
        }

        public long getPreviousReplicationTime() {
            return this.previousReplicationTime;
        }
    }
}

