/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.util;

import com.sygate.scm.util.StringUtilities;
import com.sygate.scm.util.Utility;

public class ROSType {
    private long osType = 0L;

    public ROSType(long osType) {
        this.osType = osType;
    }

    public ROSType(String osType) {
        this.initialize(osType);
    }

    private boolean initialize(String osType) {
        boolean result = false;
        if (!StringUtilities.isEmpty(osType)) {
            this.osType = Utility.parseLong(osType, 0L);
            result = true;
        }
        return result;
    }

    public boolean isValid() {
        long tmpOsType = this.osType >> 24;
        return tmpOsType > 0L;
    }

    public boolean isWindowsOS() {
        long tmpOsType = this.osType >> 24;
        return 1L == tmpOsType || 2L == tmpOsType || 3L == tmpOsType;
    }

    public boolean isWindowsWorkstationOS() {
        long tmpOsType = this.osType >> 24;
        return 1L == tmpOsType;
    }

    public boolean isWindowsDomainControllerOS() {
        long tmpOsType = this.osType >> 24;
        return 2L == tmpOsType;
    }

    public boolean isWindowsServerOS() {
        long tmpOsType = this.osType >> 24;
        return 3L == tmpOsType;
    }

    public boolean isMacOS() {
        long tmpOsType = this.osType >> 24;
        return 16L == tmpOsType;
    }

    public boolean isLinuxOS() {
        long tmpOsType = this.osType >> 24;
        return 127L == tmpOsType;
    }

    public int getMajorVersion() {
        return Utility.toInt((this.osType & 0xFF0000L) >> 16);
    }

    public int getMinorVersion() {
        return Utility.toInt((this.osType & 0xFF00L) >> 8);
    }

    public int getPlatformID() {
        return Utility.toInt(this.osType & 0xFFL);
    }
}

