/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.util;

import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.Collection;

public class PortCheckUtil {
    private static final int SOCKET_TIMEOUT_LOCALLY = 3000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isPortInUse(int port) {
        boolean portInUse = false;
        Socket socket = null;
        try {
            System.out.println("Checking if port is in use for port " + port + " timeout = 3000 ms");
            socket = new Socket();
            socket.connect(new InetSocketAddress("localhost", port), 3000);
            portInUse = true;
        }
        catch (Exception e) {
            System.out.println("Exception: " + e.getMessage());
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (Exception e) {
                    System.out.println("Exception: " + e.getMessage());
                }
            }
        }
        System.out.println("PortInUse = " + portInUse);
        return portInUse;
    }

    public static int resovlePortConflict(int portToCheck, Collection<Integer> portInuseList) {
        int freePort = PortCheckUtil.getNextFreePort(portToCheck);
        boolean hasConflict = false;
        if (portInuseList == null || portInuseList.isEmpty()) {
            return freePort;
        }
        do {
            hasConflict = false;
            for (Integer iPort : portInuseList) {
                if (iPort == null || iPort != freePort) continue;
                hasConflict = true;
                ++freePort;
                break;
            }
            freePort = PortCheckUtil.getNextFreePort(freePort);
        } while (hasConflict);
        return freePort;
    }

    public static int getNextFreePort(int port) {
        int freePort = port;
        while (PortCheckUtil.isPortInUse(freePort)) {
            ++freePort;
        }
        return freePort;
    }
}

