/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.util;

import com.sygate.scm.util.LoggerUtilities;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;

public class PemCodec {
    private static final int BYTES_PER_LINE = 64;
    private static final char[] pem_array;
    private static final byte[] pem_convert_array;

    public static byte[] encodeAtom(byte[] buf, int pos, int offset) {
        byte[] ret = new byte[4];
        if (offset == 1) {
            ret[0] = (byte)pem_array[buf[pos] >>> 2 & 0x3F];
            ret[1] = (byte)pem_array[(buf[pos] << 4 & 0x30) + 0];
            ret[2] = 61;
            ret[3] = 61;
        } else if (offset == 2) {
            ret[0] = (byte)pem_array[buf[pos] >>> 2 & 0x3F];
            ret[1] = (byte)pem_array[(buf[pos] << 4 & 0x30) + (buf[pos + 1] >>> 4 & 0xF)];
            ret[2] = (byte)pem_array[(buf[pos + 1] << 2 & 0x3C) + 0];
            ret[3] = 61;
        } else {
            ret[0] = (byte)pem_array[buf[pos] >>> 2 & 0x3F];
            ret[1] = (byte)pem_array[(buf[pos] << 4 & 0x30) + (buf[pos + 1] >>> 4 & 0xF)];
            ret[2] = (byte)pem_array[(buf[pos + 1] << 2 & 0x3C) + (buf[pos + 2] >>> 6 & 3)];
            ret[3] = (byte)pem_array[buf[pos + 2] & 0x3F];
        }
        return ret;
    }

    static int decodeAtom(Reader reader, byte[] buf, int pos) throws IOException {
        int c = reader.read();
        if (c < 0) {
            return -1;
        }
        if ((c = pem_convert_array[c]) < 0) {
            return 0;
        }
        buf[pos] = (byte)(c << 2);
        c = reader.read();
        if (c < 0) {
            return -1;
        }
        if ((c = pem_convert_array[c]) < 0) {
            return 0;
        }
        int n = pos;
        buf[n] = (byte)(buf[n] | c >> 4);
        buf[pos + 1] = (byte)(c << 4);
        c = reader.read();
        if (c < 0 || c == 61) {
            return 1;
        }
        if ((c = pem_convert_array[c]) < 0) {
            return 0;
        }
        int n2 = pos + 1;
        buf[n2] = (byte)(buf[n2] | c >> 2);
        buf[pos + 2] = (byte)(c << 6);
        c = reader.read();
        if (c < 0 || c == 61) {
            return 2;
        }
        if ((c = pem_convert_array[c]) < 0) {
            return 0;
        }
        int n3 = pos + 2;
        buf[n3] = (byte)(buf[n3] | c);
        return 3;
    }

    public static String der2pem(byte[] der) {
        byte[] atom;
        int count = der.length / 3;
        StringBuffer buf = new StringBuffer();
        int icount = 0;
        for (int i = 0; i < count; ++i) {
            atom = PemCodec.encodeAtom(der, 3 * i, 3);
            buf.append(new String(atom, StandardCharsets.UTF_8));
            if (++icount < 16) continue;
            icount = 0;
            buf.append("\n");
        }
        int left = der.length % 3;
        if (left > 0) {
            atom = PemCodec.encodeAtom(der, 3 * count, left);
            buf.append(new String(atom, StandardCharsets.UTF_8));
        }
        buf.append("\n");
        return buf.toString();
    }

    public static byte[] pem2der(String pem) {
        try {
            int ret;
            StringReader reader = new StringReader(pem);
            byte[] buf = new byte[45];
            int i = 0;
            while (i < 45 && (ret = PemCodec.decodeAtom(reader, buf, i)) != -1) {
                i = ret != 3 ? 0 : i + 3;
            }
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            bos.write(buf, 0, i);
            int j = 0;
            while (j < 3) {
                int k = PemCodec.decodeAtom(reader, buf, 0);
                if (k > 0) {
                    bos.write(buf, 0, k);
                    if (k < 3) break;
                    j = 0;
                    continue;
                }
                if (k == -1) break;
                ++j;
            }
            reader.close();
            return bos.toByteArray();
        }
        catch (Exception e) {
            LoggerUtilities.logException(e);
            return null;
        }
    }

    static {
        int i;
        pem_array = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
        pem_convert_array = new byte[256];
        for (i = 0; i < 255; ++i) {
            PemCodec.pem_convert_array[i] = -1;
        }
        for (i = 0; i < pem_array.length; ++i) {
            PemCodec.pem_convert_array[PemCodec.pem_array[i]] = (byte)i;
        }
    }
}

