/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.util;

import com.sygate.scm.common.configobject.TimeUtil;
import com.sygate.scm.common.configobject.schema.AdministratorState;
import com.sygate.scm.common.configobject.schema.SemAdministrator;

public class PasswordExpirationCheckUtil {
    public static boolean isPasswordExpired(SemAdministrator admin, AdministratorState adminState, boolean isSBProduct) {
        if (adminState == null || adminState.getOptLastPasswordChangeTime() == null || adminState.getOptLastPasswordChangeTime() == 0L) {
            return true;
        }
        if (AdministratorState.ACTIVE.equals(PasswordExpirationCheckUtil.getRandomPasswordStatus(adminState))) {
            return true;
        }
        if (PasswordExpirationCheckUtil.isPasswordNeverExpires(admin)) {
            return false;
        }
        return PasswordExpirationCheckUtil.getPasswordDuration(admin, adminState, isSBProduct) <= 0L;
    }

    public static int getRandomPasswordStatus(AdministratorState adminState) {
        if (adminState == null || adminState.getOptRandomPasswordStatus() == null) {
            return AdministratorState.INACTIVE;
        }
        return adminState.getOptRandomPasswordStatus();
    }

    public static boolean isPasswordNeverExpires(SemAdministrator admin) {
        if (admin != null) {
            if (SemAdministrator.SECURID.equals(admin.getOptAuthenticationMethod()) || SemAdministrator.DIRECTORY.equals(admin.getOptAuthenticationMethod())) {
                return true;
            }
            if (admin.getOptPasswordAge() != null) {
                return admin.getOptPasswordAge() < 0;
            }
            if (admin.getDefPasswordAge() != null) {
                return admin.getDefPasswordAge() < 0;
            }
        }
        return false;
    }

    public static long getLastPasswordChangeTime(AdministratorState adminState) {
        if (adminState == null || adminState.getOptLastPasswordChangeTime() == null) {
            return 0L;
        }
        return adminState.getOptLastPasswordChangeTime();
    }

    public static long getPasswordElapsedTime(AdministratorState adminState) {
        long time = PasswordExpirationCheckUtil.getLastPasswordChangeTime(adminState);
        if (time < 1L) {
            return -1L;
        }
        return TimeUtil.getServerTime() - time;
    }

    public static long getPasswordDuration(SemAdministrator admin, AdministratorState adminState, boolean isSBE) {
        long elapsedTime = PasswordExpirationCheckUtil.getPasswordElapsedTime(adminState);
        if (elapsedTime < 1L) {
            return PasswordExpirationCheckUtil.getPasswordAge(admin, isSBE);
        }
        return PasswordExpirationCheckUtil.getPasswordAge(admin, isSBE) - elapsedTime;
    }

    private static long getPasswordAge(SemAdministrator admin, boolean isSBE) {
        if (admin != null && admin.getOptPasswordAge() != null) {
            if (admin.getOptPasswordAge() >= 0) {
                return PasswordExpirationCheckUtil.convertToMs(admin.getOptPasswordAge());
            }
            return Long.MAX_VALUE;
        }
        return PasswordExpirationCheckUtil.convertToMs(PasswordExpirationCheckUtil.getDefaultPasswordAgeDays(isSBE));
    }

    public static int getDefaultPasswordAgeDays(boolean isSBE) {
        if (isSBE) {
            return 90;
        }
        return 60;
    }

    private static long convertToMs(int days) {
        return (long)days * 86400000L;
    }
}

