/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.util;

import com.sygate.scm.common.action.DownloadFiles;
import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.TimeUtil;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.schema.ClientFeature;
import com.sygate.scm.common.configobject.schema.ClientInstallationFeatures;
import com.sygate.scm.common.configobject.schema.CommunicationOption;
import com.sygate.scm.common.configobject.schema.EnabledClientFeatures;
import com.sygate.scm.common.configobject.schema.HostAddress;
import com.sygate.scm.common.configobject.schema.InstallationOption;
import com.sygate.scm.common.configobject.schema.ObjReference;
import com.sygate.scm.common.configobject.schema.PackageInfo;
import com.sygate.scm.common.configobject.schema.PackageLuFile;
import com.sygate.scm.common.configobject.schema.PackageLuInfo;
import com.sygate.scm.common.configobject.schema.PhysicalFile;
import com.sygate.scm.common.configobject.schema.PresharedSecret;
import com.sygate.scm.common.configobject.schema.RebootOptions;
import com.sygate.scm.common.configobject.schema.SemServer;
import com.sygate.scm.common.configobject.schema.SemServerBlock;
import com.sygate.scm.common.configobject.schema.SemServerList;
import com.sygate.scm.common.configobject.schema.SemSite;
import com.sygate.scm.common.configobject.schema.ServerArray;
import com.sygate.scm.common.configobject.schema.SoftwarePackage;
import com.sygate.scm.common.configobject.schema.TransportServerCertificate;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.ClientInstallFeatureSetUtility;
import com.sygate.scm.common.util.IPAddressUtil;
import com.sygate.scm.util.ConstantValue;
import com.sygate.scm.util.GUIDGenerator;
import com.sygate.scm.util.ICommandHandler;
import com.sygate.scm.util.IOUtilities;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.RunCommandHandler;
import com.sygate.scm.util.StringUtilities;
import com.sygate.scm.util.TimeCounter;
import com.sygate.scm.util.Utility;
import com.sygate.scm.util.XmlParser;
import com.sygate.scm.util.ZipUtil;
import com.sygate.scm.util.ini.IniFile;
import com.sygate.scm.util.ini.IniProperty;
import com.sygate.scm.util.ini.IniRoot;
import com.sygate.scm.util.ini.IniSection;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class PackageUtil {
    private static Logger logger = Logger.getLogger(PackageUtil.class.getName());
    public static final int PACKAGE_SOURCE_TYPE_SEA = 1;
    public static final int PACKAGE_SOURCE_TYPE_SPA = 2;
    public static final String PACKAGE_SOURCE_DIR = "Packages";
    public static final String APP_REMOVER_DIR = "TPAR";
    public static final String APP_REMOVER_ZIP = "TPAR.ZIP";
    public static final String MIN_VERSION_FOR_APP_REMOVER = "14.3.0000.1000";
    public static final String PACKAGE_SOURCE_DIR_SEA = "SEA";
    public static final String PACKAGE_SOURCE_DIR_SPA = "SPA";
    public static final String LANGUAGE_ENGLISH = "en_us";
    public static final int TYPE_UNKNOWN = -1;
    public static final int TYPE_SPA = 105;
    public static final int TYPE_SEA = 151;
    public static final String LABEL_TYPE_UNKNOWN = "N/A";
    public static final String LABEL_TYPE_SPA = "Symantec Protection Agent";
    public static final String LABEL_TYPE_SEA = "Symantec Enforcement Agent";
    public static final String EXE_PACKLIST = "packlist.exe";
    public static final String EXE_PACKAGE_TOOL = "SEPMPackageTool.exe";
    public static final String EXE_PACKAGE_TOOL_WILD_MATCH_CHAR = "*";
    public static final String EXE_PACKAGE_TOOL_SUPPRESS_EXTRACT_CHAR = ":NOEXTRACT";
    public static final String PACKLIST_XML = "packlist.xml";
    public static final int UI_LEVEL_UNKNOWN = -1;
    public static final int UI_LEVEL_NORMAL = 0;
    public static final int UI_LEVEL_UNATTENDED = 1;
    public static final int UI_LEVEL_SILENT = 2;
    public static final String UI_LEVEL_NORMAL_STR = "Normal";
    public static final String UI_LEVEL_UNATTENDED_STR = "Unattended";
    public static final String UI_LEVEL_NORMAL_VALUESTR = "f";
    public static final String UI_LEVEL_UNATTENDED_VALUESTR = "u";
    public static final String UI_LEVEL_SILENT_VALUESTR = "s";
    public static final String KEY_ERROR_MESSAGE = "Error_Message";
    public static final String KEY_PACKAGE_CHECKSUM = "PackageChecksum";
    public static final String IDC_NO_CHANGE = "NONE";
    public static final int ERROR_COPY = 1;
    public static final int ERROR_READ_SP_INFO = 2;
    public static final int ERROR_GENERATE_PACKLIST = 3;
    public static final int ERROR_MODIFY_SETAID = 4;
    public static final int ERROR_ZIP = 5;
    public static final int ERROR_UNROLL_CAB = 6;
    public static final int MIN_NUMBER_OF_VERSION_FOR_CLIENT_PACKAGE = 2;
    public static final int DEFAULT_NUMBER_OF_VERSION_FOR_CLIENT_PACKAGE = 3;
    public static final String EXE_SSAWRAPPER = "SaSetupWrapper.exe";
    public static final String EXE_SSAWRAPPER_DST = "SsaWrapper.exe";
    public static final String SETUP_EXE = "setup.exe";
    public static final String EXE_SCMHELPER = "ScmHelper.exe";
    public static final String PACKAGE_CACHE_FULL = "FULL";
    public static final String PACKAGE_CACHE_FULL_ZIP = "FULL.ZIP";
    public static final String INSTALL_PACKAGE_TEMP_FULL = "FULL_";
    public static final String INSTALL_PACKAGE_TEMP_FULL_ZIP = "FULL.ZIP_";
    public static final String PROFILE_DATA_FILE_NAME = "serdef.dat";
    private static final int MAKE_SFX_SUCCESS = 0;
    public static final String MAC_EXP_SNAC_ZIP_FILE_NAME = "Symantec Network Access Control.zip";
    public static final String LINUX_EXP_SNAC_ZIP_FILE_NAME = "SymantecNetworkAccessControl.zip";
    public static final String MAC_EXP_SEP_ZIP_FILE_NAME = "Symantec Endpoint Protection.zip";
    public static final String LINUX_EXP_SEP_ZIP_FILE_NAME = "SymantecEndpointProtection.zip";
    public static final String PACKAGE_FILE_INFO = ".info";
    public static final String PACKAGE_FILE_DAT = ".dat";
    public static final String PACKAGE_FILE_DEFCLEAN = ".DefClean";
    private static List<String> SAVFeatureList;
    public static final String IDC_DISABLE = "IDCENABLE=0";
    private static final String SNAC_FOLDER_NAME = "snac";
    private static final String SEP_FOLDER_NAME = "sep";
    private static final String SNAC_ON_DEMAND_FOLDER_NAME = "snacondemand";
    private static final String UNKNOWN_FOLDER_NAME = "unknown";
    public static final int CIP_VERSION_11_X = 1;
    public static final int CIP_VERSION_12_1_OR_LATER = 2;
    public static final int CIP_VERSION_OTHER = 3;
    public static final int CHECK_HI_CONTENT_PASS = 0;
    private static final String CIP_VERSION_12_1_STR = "12.1";
    public static final String PROFILE_FILE = "serdef.dat";
    public static final String IDS_FILE = "sdi.dat";
    public static final String CONFIG_XML = "sylink.xml";
    public static final String SETAID_INI = "setAid.ini";
    public static final String SETUP_INI = "setup.ini";
    public static final String HI_CONTENT_FILE = "HIDefs.zip";
    public static final String NE_LICENSE = "sep_NE.slf";
    public static final String SEP_COMMUNICATION_UPDATER_FILE_EXE_NAME = "SepCommunicationUpdater.exe";
    public static final String SEP_COMMUNICATION_UPDATER_FILE_ZIP_NAME = "SepCommunicationUpdater.zip";
    public static final String VALUE_ENABLED = "1";
    public static final String VALUE_DISABLED = "0";
    public static final String SECTION_APP_REMOVER = "TPAR";
    public static final String SECTION_PREDEFINED_SMC_CONFIG = "PREDEFINED_SMC_CONFIG";
    public static final String SECTION_CUSTOM_SMC_CONFIG = "CUSTOM_SMC_CONFIG";
    public static final String SECTION_LU_CONFIG = "LU_CONFIG";
    public static final String KEY_KEEPPREVIOUSSETTING = "KeepPreviousSetting";
    public static final String KEY_REDUCEDSIZE = "ReducedSize";
    public static final String KEY_DARKNETWORK = "DarkNetwork";
    public static final String KEY_LOWBANDWIDTH = "LowBandwidth";
    public static final String VALUE_LOWBANDWIDTH_DEFAULT = "0";
    public static final String VALUE_REDUCEDSIZE_DEFAULT = "0";
    public static final String VALUE_DARKNETWORK_DEFAULT = "0";
    public static final String PACKAGE_VERSION_SEPARATOR = ".";
    public static final String SERVER_ATTRIBUTE_ADDRESS = "Address";
    public static final String SERVER_ATTRIBUTE_ADDRESS_IPV6 = "AddressIpv6";
    private static final String[] IGNORE_FILES_IN_PACKLIST;

    public static boolean createZipFile(String sourceDir, File zipFile) {
        System.out.println("PackageHandler>> createZipFile: Begin... source=" + sourceDir + ", zipFileName=" + zipFile.getAbsolutePath());
        try {
            Utility.deleteFile(zipFile.getName());
            System.out.println("PackageHandler>> createZipFile: zipping the source dir...");
            ZipUtil.zipData(-1, sourceDir, zipFile.getAbsolutePath());
        }
        catch (IOException ex) {
            System.out.println("PackageHandler>> createZipFile: Exception... ");
            LoggerUtilities.logException(ex);
            System.out.println("PackageHandler>> createZipFile: Error-> Failed to create a zip file!");
            return false;
        }
        System.out.println("PackageHandler>> createZipFile: Done!");
        return true;
    }

    public static boolean isLinuxStub(String platform) {
        return "LINUXSTUB".equals(platform) || "LINUXSTUB_ARM64".equals(platform);
    }

    public static PhysicalFile createSemPhysicalFile(String physicalFileId, String physicalFileBinaryDataId, String physicalFielName, String name, String description, String checksume) {
        PhysicalFile spf = new PhysicalFile();
        spf.setId(physicalFileId);
        spf.setFileLastModifiedTime(TimeUtil.getServerTime());
        spf.setCreationTime(TimeUtil.getServerTime());
        spf.setName(name);
        spf.setFileName(physicalFielName);
        spf.setOptDescription(description);
        spf.setFileChecksum(checksume);
        spf.setFileSize(Utility.getFileSize(physicalFielName));
        ObjReference obj = new ObjReference();
        obj.setName("LinkToFileContent");
        obj.setTargetType("ExPhysicalFileStream");
        obj.setTargetId(physicalFileBinaryDataId);
        spf.setObjReference(obj);
        return spf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int createPackage(String sourcePath, String packagePath, String packageName, String exeDir, Map<String, String> retMap) throws IOException {
        if (!PackageUtil.doesPackageExists(sourcePath)) {
            System.out.println("PackageHandler>> importPackages: Ignore-> dir of package " + packageName + " doesn't exist or no file in it!!");
            return -1;
        }
        String name = "";
        String description = "";
        SoftwarePackage sp = PackageUtil.generateSoftwarePackage(name, description, null, sourcePath);
        Object targetDir = System.getProperty("java.io.tmpdir");
        if (!((String)targetDir).endsWith(File.separator)) {
            targetDir = (String)targetDir + File.separator;
        }
        targetDir = (String)targetDir + GUIDGenerator.getInstance().getGUIDString();
        try {
            if (!Utility.copyDir(sourcePath, (String)targetDir, true)) {
                int n = 1;
                return n;
            }
            if (!PackageUtil.readPackageInfo(new File((String)targetDir), sp)) {
                int n = 2;
                return n;
            }
            if (!PackageUtil.generatePackList(exeDir, sp, (String)targetDir, (String)targetDir, true)) {
                int n = 3;
                return n;
            }
            retMap.put(KEY_PACKAGE_CHECKSUM, sp.getPackageInfo().getChecksum());
            if (!PackageUtil.modifySetAidIni(sp, (String)targetDir, true)) {
                int n = 4;
                return n;
            }
            File packageZipFile = new File(packagePath + File.separator + packageName + PACKAGE_FILE_DAT);
            if (!PackageUtil.createZipFile((String)targetDir, packageZipFile)) {
                int n = 5;
                return n;
            }
            sp.getPackageInfo().setSize(Utility.getFileSize(packagePath + File.separator + packageName + PACKAGE_FILE_DAT));
            sp.getPackageInfo().setOptUnZippedSize(Utility.getDirectorySize((String)targetDir));
            try (BufferedOutputStream fos = new BufferedOutputStream(new FileOutputStream(packagePath + File.separator + packageName + PACKAGE_FILE_INFO));){
                sp.writeXML(fos);
                ((OutputStream)fos).flush();
            }
            int n = 0;
            return n;
        }
        catch (ValidationException e) {
            LoggerUtilities.logException(e);
        }
        finally {
            Utility.emptyDir((String)targetDir, true);
        }
        return -1;
    }

    public static void deletePackageFiles(File sourcePath) {
        File[] filePackages = sourcePath.listFiles();
        int len = filePackages == null ? 0 : filePackages.length;
        for (int i = 0; i < len; ++i) {
            String fileName = filePackages[i].getName();
            if (!fileName.endsWith(PACKAGE_FILE_INFO) && !fileName.endsWith(PACKAGE_FILE_DAT) && !fileName.endsWith(PACKAGE_FILE_DEFCLEAN)) continue;
            Utility.delete(filePackages[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SoftwarePackage readSoftwarePackage(String packageInfoFile) throws IOException, ValidationException, SAXException {
        SoftwarePackage softwarePackage;
        BufferedInputStream is = null;
        try {
            is = new BufferedInputStream(new FileInputStream(packageInfoFile));
            SoftwarePackage sp = (SoftwarePackage)AbstractSchema.readXML(is);
            sp.setId(Utility.getGUIDString());
            Utility.washIds(sp);
            softwarePackage = sp;
        }
        catch (Throwable throwable) {
            IOUtilities.closeInputStream(is);
            throw throwable;
        }
        IOUtilities.closeInputStream(is);
        return softwarePackage;
    }

    public static boolean isSoftwarePackageSupported(SoftwarePackage softwarePackage) {
        boolean isSupported = false;
        if (softwarePackage != null && softwarePackage.getPackageInfo() != null) {
            String version = softwarePackage.getPackageInfo().getVersion();
            isSupported = Utility.compareVersion(version, "14.0.0.0") >= 0;
        }
        return isSupported;
    }

    private static boolean doesPackageExists(String dir) {
        if (dir == null || dir.length() < 1) {
            return false;
        }
        File f = new File(dir);
        if (!f.isDirectory() || !f.exists()) {
            return false;
        }
        String[] files = f.list();
        return files != null && files.length > 0;
    }

    public static boolean generatePackList(String exeDir, SoftwarePackage sp, String packageFullPath, String packlistOutputDir, boolean modifyPackageInfoCheckSum) {
        if (exeDir == null || exeDir.length() < 1) {
            System.out.println("PackageHandler>> generatePackList: Warning-> no exe dir!");
            return false;
        }
        return PackageUtil.generatePackList(sp, exeDir, packageFullPath, packlistOutputDir, modifyPackageInfoCheckSum);
    }

    public static String[] getPackageNames(String packagePath) {
        File packageDir = new File(packagePath);
        FilenameFilter filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                File newFile = new File(dir, name);
                return newFile.toString().toLowerCase().endsWith(PackageUtil.PACKAGE_FILE_INFO);
            }
        };
        String[] packageNames = packageDir.list(filter);
        String[] fullPathNames = null;
        if (packageNames != null) {
            fullPathNames = new String[packageNames.length];
            for (int i = 0; i < packageNames.length; ++i) {
                fullPathNames[i] = packagePath + File.separator + packageNames[i];
            }
        }
        return fullPathNames;
    }

    public static SoftwarePackage generateSoftwarePackage(String name, String description, String siteId, String sourcePath) {
        SoftwarePackage softwarePackage = new SoftwarePackage();
        softwarePackage.setId(GUIDGenerator.getInstance().getGUIDString());
        softwarePackage.setName(name);
        softwarePackage.setOptDescription(description);
        softwarePackage.setCreationTime(TimeUtil.getServerTime());
        PackageInfo pi = new PackageInfo();
        pi.setType(1);
        pi.setSize(0L);
        pi.setVersion("104");
        pi.setCreationTime(softwarePackage.getCreationTime());
        pi.setLastModifiedTime(softwarePackage.getCreationTime());
        softwarePackage.setPackageInfo(pi);
        InstallationOption option = new InstallationOption();
        option.setOptEnable(false);
        option.setKeepAllDataOnUpgrade(true);
        option.setUserInterfaceLevel(InstallationOption.NORMAL);
        softwarePackage.setOptInstallationOption(option);
        if (siteId != null) {
            CommunicationOption optionComm = new CommunicationOption();
            ObjReference ref = new ObjReference();
            ref.setName("SemServerListLink");
            ref.setTargetType("SemServerList");
            ref.setTargetId(siteId);
            optionComm.setOptObjReference(ref);
            softwarePackage.setOptCommunicationOption(optionComm);
        }
        PackageUtil.retrieveLuInfoFromProperties(sourcePath, softwarePackage);
        return softwarePackage;
    }

    public static boolean modifyConfigXmlFromZipFile(SemServerList serverList, String preferredGroup, String exportPath, String srcFilePath, String outputFilePath, String configFilePath, String packageToolPath, String[] file_filter, boolean alwaysConnect, String domainID, PresharedSecret ps, ArrayList<SemSite> sites) throws Exception {
        File zipFile = new File(srcFilePath);
        if (!PackageUtil.extractFilesFromZipFile(zipFile.getAbsolutePath(), null, exportPath, file_filter, packageToolPath)) {
            return false;
        }
        return PackageUtil.modifyExportConfigXML(preferredGroup, serverList, configFilePath, true, domainID, ps, sites, alwaysConnect, 1);
    }

    public static synchronized String updateIDCSettingsInPackageDeltaZip(String zipFilename, File packageFolder, File tempFolder, String pkgEXEDir, SoftwarePackage softwarePackage, boolean isIdcEnabled) throws Exception {
        boolean changed = false;
        String errorString = null;
        TimeCounter counter = new TimeCounter();
        counter.start();
        boolean successful = true;
        String[] deltaFiles = packageFolder.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".dax");
            }
        });
        if (deltaFiles != null && deltaFiles.length > 0) {
            for (String deltaFile : deltaFiles) {
                errorString = PackageUtil.updateIDCSettingsInPackageZip(deltaFile, packageFolder.getAbsolutePath(), tempFolder, pkgEXEDir, softwarePackage, isIdcEnabled);
                if (errorString == null) {
                    successful = true;
                    changed = true;
                    continue;
                }
                if (errorString.compareToIgnoreCase(IDC_NO_CHANGE) == 0) {
                    successful = true;
                    changed = false;
                    continue;
                }
                successful = false;
                break;
            }
        }
        counter.stop();
        if (!successful) {
            return errorString;
        }
        if (!changed) {
            return IDC_NO_CHANGE;
        }
        return null;
    }

    public static synchronized String updateIDCSettingsInPackageZip(String zipFilePath, String packageFolder, File tempFolder, String packageExeToolDir, SoftwarePackage softwarePackage, boolean isIdcEnabled) throws Exception {
        boolean successful = true;
        boolean changed = false;
        String packageExeToolpath = packageExeToolDir + File.separator + EXE_PACKAGE_TOOL;
        TimeCounter counter = new TimeCounter();
        counter.start();
        if (tempFolder.exists()) {
            Utility.deleteDir(tempFolder.getPath());
        }
        if (!tempFolder.mkdirs()) {
            System.out.println("CHECKSUM DEBUG>>updateIDCSettingsInPackageZip. Fail to create temp folder");
        }
        HashSet<String> arr = new HashSet<String>();
        arr.add(SETUP_INI);
        arr.add(PACKLIST_XML);
        String[] file_filter = arr.toArray(new String[0]);
        successful = PackageUtil.extractFilesFromZipFile(zipFilePath, null, tempFolder.getPath(), file_filter, packageExeToolpath);
        File setupiniFile = new File(tempFolder, SETUP_INI);
        if (setupiniFile.exists() && successful && PackageUtil.isIDCSetupRequireChange(setupiniFile.getAbsolutePath(), isIdcEnabled)) {
            successful = PackageUtil.modifySetupIni(setupiniFile.getAbsolutePath(), isIdcEnabled);
            changed = true;
        }
        if (successful && changed) {
            File newZip;
            String packList;
            File remotePackList;
            boolean hasPackList;
            File fullPath = new File(packageFolder + File.separator + PACKAGE_CACHE_FULL.toLowerCase());
            boolean hasFullFolder = fullPath.exists();
            String destPath = fullPath + File.separator + SETUP_INI;
            String destZip = tempFolder.getAbsolutePath() + File.separator + zipFilePath.substring(zipFilePath.lastIndexOf(File.separator) + 1);
            if (hasFullFolder) {
                Utility.delete(destPath);
                Utility.copyFileNIOTransfer(setupiniFile, new File(destPath));
            }
            if ((hasPackList = (remotePackList = new File(packList = fullPath + File.separator + PACKLIST_XML)).exists()) && (successful = PackageUtil.generatePackList(packageExeToolDir, softwarePackage, tempFolder.getPath(), tempFolder.getPath(), true))) {
                Utility.delete(tempFolder + File.separator + PACKLIST_XML);
                Utility.copyFileNIOTransfer(remotePackList, new File(tempFolder.getAbsolutePath(), PACKLIST_XML));
            }
            if ((successful = PackageUtil.putFilesToZipFile(destZip, tempFolder.getAbsolutePath(), tempFolder.getAbsolutePath(), file_filter, packageExeToolpath)) && (newZip = new File(destZip)).exists()) {
                Utility.removeFileFromDir(zipFilePath, packageFolder);
                Utility.removeFileFromDir(zipFilePath + ".sig", packageFolder);
                Utility.removeFileFromDir(zipFilePath + ".sha2.sig", packageFolder);
                if (!newZip.renameTo(new File(zipFilePath))) {
                    System.out.println("CHECKSUM DEBUG>>updateIDCSettingsInPackageZip. Fail to rename sig file");
                }
            }
        }
        Utility.deleteDir(tempFolder.getPath());
        counter.stop();
        if (!successful && changed) {
            return "Packagetask:updateIDCSettingsInPackageZip failed.";
        }
        if (successful && !changed) {
            return IDC_NO_CHANGE;
        }
        return null;
    }

    public static boolean pullFilesFromZip(String zipFilePath, String working_folder, String output_folder, String[] file_filter, String packageToolPath) throws Exception {
        StringBuffer toolLogs = new StringBuffer();
        boolean result = ZipUtil.runBT('e', zipFilePath, working_folder, output_folder, file_filter, packageToolPath, toolLogs);
        System.out.println("ZipUtil: result of tool: " + result);
        System.out.println("ZipUtil: Tool logs after execution: " + toolLogs);
        return result;
    }

    public static boolean replaceFilesInZipFile(String zipFilePath, String working_folder, String output_folder, String[] file_filter, String packageToolPath) throws Exception {
        StringBuffer toolLogs = new StringBuffer();
        return ZipUtil.runBT('r', zipFilePath, working_folder, output_folder, file_filter, packageToolPath, toolLogs);
    }

    public static boolean extractFilesFromZipFile(String zipFilePath, String working_folder, String output_folder, String[] file_filter, String packageToolPath) throws Exception {
        StringBuffer toolLogs = new StringBuffer();
        boolean result = ZipUtil.runBT('d', zipFilePath, working_folder, output_folder, file_filter, packageToolPath, toolLogs);
        System.out.println("ZipUtil: result of tool: " + result);
        System.out.println("ZipUtil: Tool logs after execution: " + toolLogs);
        return result;
    }

    public static boolean putFilesToZipFile(String zipFilePath, String working_folder, String output_folder, String[] file_filter, String packageToolPath) throws Exception {
        StringBuffer toolLogs = new StringBuffer();
        boolean result = ZipUtil.runBT('a', zipFilePath, working_folder, output_folder, file_filter, packageToolPath, toolLogs);
        System.out.println("ZipUtil: result of tool: " + result);
        System.out.println("ZipUtil: Tool logs after execution: " + toolLogs);
        return result;
    }

    public static Element modifyServerSettings(Document doc, String domainId) {
        ArrayList<String> listPath = new ArrayList<String>();
        listPath.add("ServerSettings");
        Element elementServerSettings = XmlParser.getElementByPath(listPath, doc);
        if (elementServerSettings == null) {
            System.out.println("PackageUtil> modifyConfigXml: Warning-> add ServerSettings");
            elementServerSettings = doc.createElement("ServerSettings");
            doc.appendChild(elementServerSettings);
        }
        elementServerSettings.setAttribute("DomainId", domainId);
        return elementServerSettings;
    }

    public static Element modifyCommConf(Document doc, Element elementServerSettings) {
        ArrayList<String> listPath = new ArrayList<String>();
        listPath.add("CommConf");
        Element elementCommConf = XmlParser.getChildElementByPath(listPath, elementServerSettings);
        if (elementCommConf == null) {
            System.out.println("PackageUtil> modifyConfigXml: Warning-> add CommConf");
            elementCommConf = doc.createElement("CommConf");
            elementServerSettings.appendChild(elementCommConf);
        }
        return elementCommConf;
    }

    public static Element modifyRegisterClient(Document doc, Element elementCommConf, String preferredGroup, int agentMode) {
        ArrayList<String> listPath = new ArrayList<String>();
        listPath.add("RegisterClient");
        Element elementRegisterClient = XmlParser.getChildElementByPath(listPath, elementCommConf);
        if (elementRegisterClient == null) {
            System.out.println("PackageUtil> modifyConfigXml: Warning-> add elementRegisterClient");
            elementRegisterClient = doc.createElement("RegisterClient");
            elementCommConf.appendChild(elementRegisterClient);
        }
        if (!StringUtilities.isEmpty(preferredGroup)) {
            elementRegisterClient.setAttribute("PreferredGroup", preferredGroup);
        }
        elementRegisterClient.setAttribute("PreferredMode", String.valueOf(agentMode));
        return elementRegisterClient;
    }

    public static Element modifyAgentCommunicationSetting(Document doc, boolean alwaysConnect, PresharedSecret ps, Element elementCommConf) {
        ArrayList<String> listPath = new ArrayList<String>();
        listPath.add("AgentCommunicationSetting");
        Element elementAgentCommunication = XmlParser.getChildElementByPath(listPath, elementCommConf);
        if (elementAgentCommunication == null) {
            System.out.println("PackageUtil> modifyConfigXml: Warning-> add elementAgentCommunication");
            elementAgentCommunication = doc.createElement("AgentCommunicationSetting");
            elementCommConf.appendChild(elementAgentCommunication);
        }
        elementAgentCommunication.setAttribute("AlwaysConnect", alwaysConnect ? VALUE_ENABLED : "0");
        String kcs = "";
        try {
            if (ps != null) {
                kcs = ps.getSecretHash();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.out.println("PackageUtil> modifyConfigXml: kcs=" + kcs);
        elementAgentCommunication.setAttribute("Kcs", kcs);
        String mode = elementAgentCommunication.getAttribute("CommunicationMode");
        if (!StringUtilities.isEmpty(mode)) {
            if ("PUSH".equalsIgnoreCase(mode.trim())) {
                elementAgentCommunication.setAttribute("PushHeartbeatSeconds", "300");
            } else {
                elementAgentCommunication.setAttribute("PullHeartbeatSeconds", "300");
            }
        }
        return elementAgentCommunication;
    }

    public static Element modifyServerList(Document doc, SemServerList serverList, Boolean signatureVerification, Element elementCommConf, String defaultHttpPort) {
        ArrayList<String> listPath = new ArrayList<String>();
        listPath.add("ServerList");
        Element elementServerList = XmlParser.getChildElementByPath(listPath, elementCommConf);
        if (elementServerList != null) {
            elementCommConf.removeChild(elementServerList);
        }
        int count = serverList.getSemServerBlockCount();
        elementServerList = doc.createElement("ServerList");
        elementCommConf.appendChild(elementServerList);
        elementServerList.setAttribute("Name", serverList.getName());
        elementServerList.setAttribute("FreezeSmsList", "0");
        boolean useHttps = false;
        if (serverList.getOptCommSecurity() != null && serverList.getOptCommSecurity().intValue() == SemServerList.HTTPS_ONLY.intValue()) {
            useHttps = true;
        }
        boolean verifyHttps = serverList.getOptVerifyHttpsUrlName() == null ? serverList.getDefVerifyHttpsUrlName() : serverList.getOptVerifyHttpsUrlName();
        int index = 0;
        for (int j = 0; j < count; ++j) {
            int hostCount;
            SemServerBlock block = serverList.getSemServerBlock(j);
            if (block == null || (block.getOptEnable() != null ? block.getOptEnable() == false : block.getDefEnable() == false) || (hostCount = block.getHostAddressCount()) == 0) continue;
            Element elementServerBlock = doc.createElement("ServerPriorityBlock");
            elementServerBlock.setAttribute("Name", "List" + index++);
            elementServerList.appendChild(elementServerBlock);
            for (int k = 0; k < hostCount; ++k) {
                HostAddress host = block.getHostAddress(k);
                String address = host.getContent();
                if (address == null || address.length() <= 0) continue;
                Element elementServer = doc.createElement("Server");
                elementServer.setAttribute("SigningAlgorithm", VALUE_ENABLED);
                if (IPAddressUtil.isIPv6LiteralAddress(address)) {
                    elementServer.setAttribute(SERVER_ATTRIBUTE_ADDRESS_IPV6, address);
                } else {
                    elementServer.setAttribute(SERVER_ATTRIBUTE_ADDRESS, address);
                }
                PackageUtil.addHTTPElements(defaultHttpPort, useHttps, verifyHttps, host, elementServer, signatureVerification);
                elementServerBlock.appendChild(elementServer);
            }
        }
        return elementServerList;
    }

    private static void addHTTPElements(String defaultHttpPort, boolean useHttps, boolean verifyHttps, HostAddress host, Element elementServer, Boolean signatureVerification) {
        if (useHttps) {
            if (host.getOptSecurePort() != null) {
                elementServer.setAttribute("HttpsPort", host.getOptSecurePort().toString());
            }
            if (verifyHttps) {
                elementServer.setAttribute("HttpsVerifyCA", VALUE_ENABLED);
            }
            elementServer.setAttribute("Protocol", "HTTPS");
        } else if (host.getOptPort() == null) {
            elementServer.setAttribute("HttpPort", defaultHttpPort);
        } else {
            elementServer.setAttribute("HttpPort", host.getOptPort().toString());
        }
        if (signatureVerification != null) {
            if (signatureVerification.booleanValue()) {
                elementServer.setAttribute("VerifySignatures", VALUE_ENABLED);
            } else {
                elementServer.setAttribute("VerifySignatures", "0");
            }
        }
    }

    public static Element modifyServerCertList(Document doc, ArrayList<SemSite> sites, Element elementCommConf) {
        ArrayList<String> listPath = new ArrayList<String>();
        listPath.add("ServerCertList");
        Element elementServerCertList = XmlParser.getChildElementByPath(listPath, elementCommConf);
        if (elementServerCertList != null) {
            elementCommConf.removeChild(elementServerCertList);
        }
        elementServerCertList = doc.createElement("ServerCertList");
        elementCommConf.appendChild(elementServerCertList);
        for (SemSite site : sites) {
            if (site != null && Boolean.TRUE.equals(Utility.getBooleanValue(site.getOptSuspended(), site.getDefSuspended()))) continue;
            if (site == null) {
                throw new IllegalStateException("PackageUtil>modifyServerCertList>>site was null");
            }
            ServerArray serverArray = site.getServerArray();
            for (int i = 0; i < serverArray.getSemServerCount(); ++i) {
                SemServer server = serverArray.getSemServer(i);
                TransportServerCertificate configCert = server.getOptTransportServerCertificate();
                if (configCert == null) continue;
                Element elementCert = doc.createElement("Certificate");
                elementCert.setAttribute("Name", configCert.getCertName());
                Text n = doc.createTextNode(configCert.getContent());
                elementCert.appendChild(n);
                elementServerCertList.appendChild(elementCert);
            }
        }
        return elementServerCertList;
    }

    public static boolean modifyExportConfigXML(String preferredGroup, SemServerList serverList, String exportPath, Boolean signatureVerification, String domainId, PresharedSecret ps, ArrayList<SemSite> sites, Boolean alwaysConnect, int agentMode) {
        if (serverList == null || serverList.getSemServerBlockCount() < 1) {
            return false;
        }
        String xml = exportPath + File.separator + CONFIG_XML;
        XmlParser parser = new XmlParser();
        Document doc = null;
        if (new File(xml).exists() && !parser.readXmlFile(xml)) {
            return false;
        }
        doc = parser.getDocument();
        Element elementServerSettings = PackageUtil.modifyServerSettings(doc, domainId);
        Element elementCommConf = PackageUtil.modifyCommConf(doc, elementServerSettings);
        PackageUtil.modifyRegisterClient(doc, elementCommConf, preferredGroup, agentMode);
        PackageUtil.modifyAgentCommunicationSetting(doc, alwaysConnect, ps, elementCommConf);
        PackageUtil.modifyServerList(doc, serverList, signatureVerification, elementCommConf, "");
        PackageUtil.modifyServerCertList(doc, sites, elementCommConf);
        if (!parser.saveXml(xml)) {
            return false;
        }
        System.out.println("PackageUtil> modifySylink: Done! xml=" + xml);
        return true;
    }

    public static void addLowBandWidthSetting(IniSection section, boolean isLowBandwidthOn, String version) {
        if (section == null) {
            return;
        }
        if (Utility.compareVersion(version, "14.0.0.1000", true) < 0) {
            return;
        }
        String value = isLowBandwidthOn ? VALUE_ENABLED : "0";
        IniProperty prop = section.getPropertyByName(KEY_LOWBANDWIDTH);
        if (prop == null) {
            section.addProperty(KEY_LOWBANDWIDTH, value, true);
        } else {
            prop.setValue(value);
        }
    }

    public static boolean modifySetAidIni(SoftwarePackage sp, String exportPath, boolean isModifyInstallationOption) {
        IniFile file = new IniFile();
        String ini = exportPath + File.separator + "SetAid.ini";
        if (!file.read(ini)) {
            System.out.println("PackageHandler>> modifySetAidIni: Error-> Failed to read \"" + ini + "\"");
            return false;
        }
        IniSection section = file.getRoot().getSectionByName(SECTION_PREDEFINED_SMC_CONFIG);
        if (section == null && (section = file.getRoot().addSingleSection(SECTION_PREDEFINED_SMC_CONFIG)) == null) {
            System.out.println("PackageHandler>> modifySetAidIni: Error-> Failed to retrieve Section PREDEFINED_SMC_CONFIG from \"" + ini + "\"");
            return false;
        }
        IniProperty prop = section.getPropertyByName(KEY_PACKAGE_CHECKSUM);
        if (prop == null && (prop = section.addProperty(KEY_PACKAGE_CHECKSUM, "", true)) == null) {
            System.out.println("PackageHandler>> modifySetAidIni: Error-> Failed to retrieve property PackageChecksum from \"" + ini + "\"");
            return false;
        }
        prop.setValue(sp.getPackageInfo().getChecksum());
        boolean isInstallOptionEnabled = false;
        InstallationOption io = sp.getOptInstallationOption();
        if (io != null && io.getOptEnable() != null) {
            isInstallOptionEnabled = io.getOptEnable();
        }
        if (isModifyInstallationOption && isInstallOptionEnabled) {
            section = file.getRoot().getSectionByName(SECTION_CUSTOM_SMC_CONFIG);
            if (section == null && (section = file.getRoot().addSingleSection(SECTION_CUSTOM_SMC_CONFIG)) == null) {
                System.out.println("PackageHandler>> modifySetAidIni: Error-> Failed to retrieve Section CUSTOM_SMC_CONFIG from \"" + ini + "\"");
                return false;
            }
            prop = section.getPropertyByName("InstallUserInterfaceLevel");
            if (prop == null && (prop = section.addProperty("InstallUserInterfaceLevel", "", true)) == null) {
                System.out.println("PackageHandler>> modifySetAidIni: Error-> Failed to retrieve property InstallUserInterfaceLevel from \"" + ini + "\"");
                return false;
            }
            String value = "";
            if (io.getUserInterfaceLevel().equals(InstallationOption.NORMAL)) {
                value = UI_LEVEL_NORMAL_VALUESTR;
            }
            if (io.getUserInterfaceLevel().equals(InstallationOption.UNATTENDED)) {
                value = UI_LEVEL_UNATTENDED_VALUESTR;
            }
            if (io.getUserInterfaceLevel().equals(InstallationOption.SILENT)) {
                value = UI_LEVEL_SILENT_VALUESTR;
            }
            prop.setValue(value);
            prop = section.getPropertyByName(KEY_KEEPPREVIOUSSETTING);
            if (prop == null && (prop = section.addProperty(KEY_KEEPPREVIOUSSETTING, "", true)) == null) {
                System.out.println("PackageHandler>> modifySetAidIni: Error-> Failed to retrieve property KeepPreviousSetting from \"" + ini + "\"");
                return false;
            }
            prop.setValue(io.getKeepAllDataOnUpgrade() != false ? VALUE_ENABLED : "0");
        }
        if (!file.save(ini)) {
            System.out.println("PackageHandler>> modifySetAidIni: Error-> Failed to save \"" + ini + "\"");
            return false;
        }
        System.out.println("PackageHandler>> modifySetAidIni: Done! ini=" + ini);
        return true;
    }

    private static String readPackageChecksum(String packListOutputDir) {
        XmlParser parser = new XmlParser();
        String xml = packListOutputDir + File.separator + PACKLIST_XML;
        if (!parser.readXmlFile(xml)) {
            System.out.println("PackageHandler>> readPackageChecksum: Error-> Failed to read packlist.xml under \"" + packListOutputDir + "\"");
            return null;
        }
        Document doc = parser.getDocument();
        ArrayList<String> listPath = new ArrayList<String>();
        listPath.add("PackageList");
        listPath.add("Package");
        Element element = XmlParser.getElementByPath(listPath, doc);
        if (element == null) {
            System.out.println("PackageHandler>> readPackageChecksum: Error-> The format of packlist.xml is invalid under \"" + packListOutputDir + "\": Missing PackageList/Package");
            return null;
        }
        String value = element.getAttribute("Checksum");
        if (value == null || value.length() < 1) {
            System.out.println("PackageHandler>> readPackageChecksum: Error-> Failed to read the package checksum from packlist.xml under \"" + packListOutputDir + "\"");
            return null;
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean readPackageInfo(File packageDir, SoftwarePackage sp) {
        File f = new File(packageDir, CONFIG_XML);
        if (!f.exists()) {
            System.out.println("PackageHandler>> readPackageInfo: Error-> no sylink.xml...");
            return false;
        }
        Properties props = new Properties();
        BufferedInputStream io = null;
        try {
            io = new BufferedInputStream(new FileInputStream(new File(packageDir, SETUP_INI)));
            props.load(io);
        }
        catch (Exception ex) {
            boolean bl;
            try {
                System.out.println("PackageHandler>> readPackageInfo: Error-> Failed to read setup.ini");
                LoggerUtilities.logException(ex);
                bl = false;
            }
            catch (Throwable throwable) {
                IOUtilities.closeInputStream(io);
                throw throwable;
            }
            IOUtilities.closeInputStream(io);
            return bl;
        }
        IOUtilities.closeInputStream(io);
        String version = props.getProperty("ProductVersion");
        if (version == null) {
            System.out.println("PackageHandler>> readPackageInfo: Error-> no version info in setup.ini");
            return false;
        }
        sp.getPackageInfo().setVersion(version);
        String packageName = props.getProperty("PackageName");
        if (packageName == null) {
            System.out.println("PackageHandler>> readPackageInfo: Error-> no packageName in setup.ini");
            return false;
        }
        sp.getPackageInfo().setOptPackageName(packageName);
        String strPkgSizeWithoutDefs = props.getProperty("PkgSizeWithoutDefs");
        if (strPkgSizeWithoutDefs != null && strPkgSizeWithoutDefs.length() > 0) {
            try {
                long pkgSizeWODefs = Long.parseLong(strPkgSizeWithoutDefs);
                if (pkgSizeWODefs > 0L) {
                    sp.getPackageInfo().setOptPkgSizeWithoutDefs(pkgSizeWODefs);
                }
            }
            catch (NumberFormatException e) {
                System.out.println("Setup.ini contains invalid value for PkgSizeWithoutDefs: " + strPkgSizeWithoutDefs);
            }
        }
        props.clear();
        FileInputStream iniIs = null;
        InputStreamReader reader = null;
        try {
            iniIs = new FileInputStream(new File(packageDir, SETAID_INI));
            reader = new InputStreamReader((InputStream)iniIs, Charset.defaultCharset());
            props.load(reader);
        }
        catch (Exception ex) {
            boolean bl;
            try {
                System.out.println("PackageHandler>> readPackageInfo: Error-> Failed to read setAid.ini");
                LoggerUtilities.logException(ex);
                bl = false;
            }
            catch (Throwable throwable) {
                IOUtilities.closeReader(reader);
                IOUtilities.closeInputStream(iniIs);
                throw throwable;
            }
            IOUtilities.closeReader(reader);
            IOUtilities.closeInputStream(iniIs);
            return bl;
        }
        IOUtilities.closeReader(reader);
        IOUtilities.closeInputStream(iniIs);
        String language = props.getProperty("Language");
        if (language == null || language.length() == 0) {
            System.out.println("PackageHandler>> readPackageInfo: Warning-> no language info in setAid.ini");
            sp.getPackageInfo().setOptLanuage(LANGUAGE_ENGLISH);
        } else {
            sp.getPackageInfo().setOptLanuage(language);
        }
        String type = props.getProperty("AppType");
        try {
            int t = Integer.parseInt(type);
            sp.getPackageInfo().setType(t);
        }
        catch (Exception ex) {
            System.out.println("PackageHandler>> readPackageInfo: Error-> no package type info in setAid.ini");
            return false;
        }
        String platformType = props.getProperty("PlatformType");
        if (platformType == null || platformType.length() == 0) {
            System.out.println("PackageHandler>> readPackageInfo: Warning-> no platformType info in setAid.ini");
            sp.getPackageInfo().setOptPlatformType("WIN32BIT");
        } else {
            sp.getPackageInfo().setOptPlatformType(platformType);
        }
        String notesUrl = props.getProperty("Url");
        sp.getPackageInfo().setOptReleaseNotesUrl(notesUrl);
        String format_str = MessageResources.getInstance().getString("com.sygate.scm.common.log.log", "PackageUtil.PackageNameFormat");
        Object[] obj = new Object[]{PackageUtil.getTypeDisplayString(sp.getPackageInfo().getType()), version, platformType};
        String name = MessageFormat.format(format_str, obj);
        sp.setName(name);
        return true;
    }

    private static String getTypeDisplayString(int type) {
        return MessageResources.getInstance().getString("com.sygate.scm.common.log.log", "PackageUtil.PackageType_" + type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean retrieveLuInfoFromProperties(String sourcePath, SoftwarePackage sp) {
        String setupIniFileName;
        IniFile iniFile;
        String value;
        String[] luReqAttributes = new String[]{"ServerProduct", "ServerVersion", "ServerLanguage", "ClientProduct", "ClientVersion", "ClientLanguage", "ServerMoniker", "ClientMoniker", "SequenceNumber", "ShortName"};
        Properties props = new Properties();
        String iniName = sourcePath + File.separator + SETAID_INI;
        FileInputStream is = null;
        InputStreamReader reader = null;
        try {
            is = new FileInputStream(iniName);
            reader = new InputStreamReader((InputStream)is, Charset.defaultCharset());
            props.load(reader);
        }
        catch (Exception ex) {
            boolean bl;
            try {
                System.out.println("SoftwarePackageObject>> checkValidPackage: Error-> Failed to read " + iniName + "...");
                LoggerUtilities.logException(ex);
                bl = false;
            }
            catch (Throwable throwable) {
                IOUtilities.closeReader(reader);
                IOUtilities.closeInputStream(is);
                throw throwable;
            }
            IOUtilities.closeReader(reader);
            IOUtilities.closeInputStream(is);
            return bl;
        }
        IOUtilities.closeReader(reader);
        IOUtilities.closeInputStream(is);
        String msgPrefix = "SoftwarePackageObject>> retrieveLuInfo: Error-> no ";
        PackageLuInfo luInfo = new PackageLuInfo();
        block16: for (int i = 0; i < luReqAttributes.length; ++i) {
            value = props.getProperty(luReqAttributes[i]);
            if (value == null || value.equals("")) {
                System.out.println(msgPrefix + luReqAttributes[i] + " in " + iniName);
                return false;
            }
            switch (i) {
                case 0: {
                    luInfo.setServerProduct(value);
                    continue block16;
                }
                case 1: {
                    luInfo.setServerVersion(value);
                    continue block16;
                }
                case 2: {
                    luInfo.setServerLanguage(value);
                    continue block16;
                }
                case 3: {
                    luInfo.setClientProduct(value);
                    continue block16;
                }
                case 4: {
                    luInfo.setClientVersion(value);
                    continue block16;
                }
                case 5: {
                    luInfo.setClientLanguage(value);
                    continue block16;
                }
                case 6: {
                    luInfo.setServerMoniker(value);
                    continue block16;
                }
                case 7: {
                    luInfo.setClientMoniker(value);
                    continue block16;
                }
                case 8: {
                    luInfo.setSequenceNumber(value);
                    continue block16;
                }
                case 9: {
                    luInfo.setShortName(value);
                    continue block16;
                }
            }
        }
        value = props.getProperty("SequenceTag");
        if (value != null && !value.equals("")) {
            luInfo.setOptSequenceTag(value);
        }
        if ((value = props.getProperty("DisplayName")) != null && !value.equals("")) {
            luInfo.setOptDisplayName(value);
        }
        if (!(iniFile = new IniFile()).read(setupIniFileName = sourcePath + File.separator + SETUP_INI)) {
            return false;
        }
        IniSection section = iniFile.getRoot().getSectionByName("Startup");
        if (section == null) {
            return false;
        }
        IniProperty prop = section.getPropertyByName("ProductVersion");
        if (prop == null) {
            return false;
        }
        String version = prop.getValue();
        String[] result = version.split("\\.", -1);
        if (result.length < 4) {
            return false;
        }
        luInfo.setSequenceNumber(result[2]);
        if (PackageUtil.is121OrAbove(version)) {
            luInfo.setSequenceNumber(PackageUtil.getSequenceNumber(version));
        }
        PackageInfo pkgInfo = sp.getPackageInfo();
        pkgInfo.setOptPackageLuInfo(luInfo);
        return true;
    }

    public static boolean is121OrAbove(String srcVersion) {
        if (srcVersion.contains(" ")) {
            srcVersion = srcVersion.substring(0, srcVersion.indexOf(" "));
        }
        boolean is121orAbove = false;
        String srcMajor = null;
        String srcMinor = null;
        StringTokenizer tokenizer = new StringTokenizer(srcVersion, PACKAGE_VERSION_SEPARATOR);
        if (tokenizer.hasMoreTokens()) {
            srcMajor = tokenizer.nextToken();
        }
        if (tokenizer.hasMoreTokens()) {
            srcMinor = tokenizer.nextToken();
        }
        if (srcMajor == null || srcMinor == null) {
            return false;
        }
        int srcMajorint = Integer.parseInt(srcMajor);
        int srcMinorint = Integer.parseInt(srcMinor);
        if (srcMajorint >= 12 && srcMinorint >= 1) {
            is121orAbove = true;
        } else if (srcMajorint > 12) {
            is121orAbove = true;
        }
        return is121orAbove;
    }

    public static String getSequenceNumber(String srcVersion) {
        String srcMajor = null;
        String srcMinor = null;
        String maintenance = null;
        StringTokenizer tokenizer = new StringTokenizer(srcVersion, PACKAGE_VERSION_SEPARATOR);
        if (tokenizer.hasMoreTokens()) {
            srcMajor = tokenizer.nextToken();
        }
        if (tokenizer.hasMoreTokens()) {
            srcMinor = tokenizer.nextToken();
        }
        if (tokenizer.hasMoreTokens()) {
            maintenance = tokenizer.nextToken();
        }
        if (srcMajor == null || srcMinor == null || maintenance == null) {
            throw new IllegalStateException("PackageUtil>getSequenceNumber> malformed srcVersion:" + srcVersion);
        }
        return String.valueOf(Long.parseLong(srcMajor) << 24 | Long.parseLong(srcMinor) << 16 | Long.parseLong(maintenance));
    }

    public static String getZipFile(String infoFile) {
        String datFile;
        File packageFile = new File(infoFile);
        String fullPath = packageFile.getAbsolutePath();
        int pos = fullPath.lastIndexOf(PACKAGE_VERSION_SEPARATOR);
        if (pos != -1 && new File(datFile = fullPath.substring(0, pos) + PACKAGE_FILE_DAT).exists()) {
            return datFile;
        }
        return null;
    }

    public static List<String> getIgnoreListForPackList() {
        return Arrays.asList(IGNORE_FILES_IN_PACKLIST);
    }

    public static boolean generatePackList(SoftwarePackage softwarePackage, String packListExePath, String packageFullPath, String packlistOutputDir, boolean modifyPackageInfoCheckSum) {
        return PackageUtil.generatePackList(softwarePackage, packListExePath, packageFullPath, packlistOutputDir, modifyPackageInfoCheckSum, false);
    }

    public static boolean generatePackList(SoftwarePackage softwarePackage, String packListExePath, String packageFullPath, String packlistOutputDir, boolean modifyPackageInfoCheckSum, boolean forceRegenerate) {
        String buildNumber = PackageUtil.getBuildNumber(softwarePackage);
        if (buildNumber == null || buildNumber.length() < 1) {
            System.out.println("PackageHandler>> generatePackList: Error-> Failed to retrieve the build number of the package.");
            return false;
        }
        return PackageUtil.generatePackList(softwarePackage, packListExePath, packageFullPath, packlistOutputDir, modifyPackageInfoCheckSum, buildNumber, false);
    }

    public static boolean generatePackList(SoftwarePackage softwarePackage, String packListExePath, String packageFullPath, String packlistOutputDir, boolean modifyPackageInfoCheckSum, String buildNumber, boolean forceRegenerate) {
        if (packListExePath == null || packListExePath.length() < 1) {
            System.out.println("PackageHandler>> generatePackList: Warning-> no exe dir!");
            return false;
        }
        if (buildNumber == null || buildNumber.length() < 1) {
            System.out.println("PackageHandler>> generatePackList: Error-> Failed to retrieve the build number of the package.");
            return false;
        }
        System.out.println("PackageHandler>> generatePackList: buildnumber=" + buildNumber);
        boolean result = false;
        try {
            result = PackageUtil.runPacklist(packListExePath, packageFullPath, packlistOutputDir, buildNumber, PackageUtil.getIgnoreListForPackList(), forceRegenerate);
        }
        catch (Exception ex) {
            LoggerUtilities.logException(ex);
        }
        if (result) {
            if (modifyPackageInfoCheckSum) {
                String checksum = PackageUtil.readPackageChecksum(packlistOutputDir);
                if (checksum == null || checksum.length() < 1) {
                    result = false;
                } else {
                    System.out.println("PackageHandler>> generatePackList: checksum=" + checksum);
                    softwarePackage.getPackageInfo().setChecksum(checksum);
                }
            }
        } else {
            System.out.println("PackageHandler>> generatePackList: Error-> Failed to generate packlist.xml under " + packageFullPath + "!");
        }
        return result;
    }

    public static String generatePackList(String packListExePath, String packageBuildNumber, String packageFullPath, String packlistOutputDir, boolean modifyPackageInfoCheckSum) {
        String packageChecksum = null;
        boolean result = false;
        try {
            result = PackageUtil.runPacklist(packListExePath, packageFullPath, packlistOutputDir, packageBuildNumber, PackageUtil.getIgnoreListForPackList());
        }
        catch (Exception ex) {
            LoggerUtilities.logException(ex);
        }
        if (result) {
            if (modifyPackageInfoCheckSum) {
                packageChecksum = PackageUtil.readPackageChecksum(packlistOutputDir);
                System.out.println("Utility>> generatePackList: checksum=" + packageChecksum);
            }
        } else {
            System.out.println("Utility>> generatePackList: Fail to generate packlist");
        }
        return packageChecksum;
    }

    public static String getBuildNumber(SoftwarePackage softwarePackage) {
        int index;
        if (softwarePackage == null) {
            return null;
        }
        String version = softwarePackage.getPackageInfo().getVersion();
        if (Boolean.TRUE.equals(softwarePackage.getPackageInfo().getOptSecurityFixPackage())) {
            version = softwarePackage.getPackageInfo().getOptProductBuildNum();
        }
        if ((index = version.lastIndexOf(PACKAGE_VERSION_SEPARATOR)) < 0) {
            return null;
        }
        String[] result = version.split("\\.", -1);
        return result[2];
    }

    public static IniSection writeRebootOpts(IniProperty prop, IniSection section, RebootOptions rebootOpts) {
        String promptUserStr = null;
        promptUserStr = rebootOpts.getOptPromptUser() != null ? rebootOpts.getOptPromptUser().toString() : rebootOpts.getDefPromptUser().toString();
        String promptMessage = "";
        if (rebootOpts.getOptPromptMessage() != null) {
            promptMessage = rebootOpts.getOptPromptMessage();
            promptMessage = promptMessage.replaceAll("\n", "\\\\n");
        }
        String rebootMethodStr = "CLIENT";
        try {
            rebootMethodStr = rebootOpts.getOptRebootMethodValue();
        }
        catch (Exception ve) {
            LoggerUtilities.logException(ve);
        }
        if (rebootMethodStr == null) {
            rebootMethodStr = "CLIENT";
        }
        Integer maxSnoozeCount = rebootOpts.getOptMaxSnoozeCount() == null ? rebootOpts.getDefMaxSnoozeCount() : rebootOpts.getOptMaxSnoozeCount();
        Integer snoozeInterval = rebootOpts.getOptSnoozeInterval() == null ? rebootOpts.getDefSnoozeInterval() : rebootOpts.getOptSnoozeInterval();
        Integer displayTimeout = rebootOpts.getOptDisplayTimeout() == null ? rebootOpts.getDefDisplayTimeout() : rebootOpts.getOptDisplayTimeout();
        String rebootScheduleStr = "LATER";
        try {
            rebootScheduleStr = rebootOpts.getOptRebootScheduleValue();
        }
        catch (Exception ve) {
            LoggerUtilities.logException(ve);
        }
        if (rebootScheduleStr == null) {
            rebootScheduleStr = "LATER";
        }
        String rebootDayStr = "TODAY";
        try {
            rebootDayStr = rebootOpts.getOptRebootDayValue();
        }
        catch (Exception ve) {
            LoggerUtilities.logException(ve);
        }
        if (rebootDayStr == null) {
            rebootDayStr = "TODAY";
        }
        Integer rebootMinutes = rebootOpts.getOptRebootMinutes() == null ? rebootOpts.getDefRebootMinutes() : rebootOpts.getOptRebootMinutes();
        Boolean rebootRandomize = rebootOpts.getOptRandomize() == null ? rebootOpts.getDefRandomize() : rebootOpts.getOptRandomize();
        Integer rebootRandomizeHours = rebootOpts.getOptRandomizeHours() == null ? rebootOpts.getDefRandomizeHours() : rebootOpts.getOptRandomizeHours();
        String promptTypeStr = "COUNTDOWN";
        try {
            promptTypeStr = rebootOpts.getOptPromptTypeValue();
        }
        catch (Exception ve) {
            LoggerUtilities.logException(ve);
        }
        if (promptTypeStr == null) {
            promptTypeStr = "COUNTDOWN";
        }
        Integer countdown = rebootOpts.getOptCountdown() == null ? rebootOpts.getDefCountdown() : rebootOpts.getOptCountdown();
        Boolean hardReboot = rebootOpts.getOptHardReboot() == null ? rebootOpts.getDefHardReboot() : rebootOpts.getOptHardReboot();
        Boolean autoReboot = rebootOpts.getOptAutoReboot() == null ? rebootOpts.getDefAutoReboot() : rebootOpts.getOptAutoReboot();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("RebootPromptUser", promptUserStr);
        map.put("RebootPromptMessage", promptMessage);
        map.put("RebootMethod", rebootMethodStr);
        map.put("RebootMaxSnoozeCount", maxSnoozeCount.toString());
        map.put("SnoozeInterval", snoozeInterval.toString());
        map.put("RebootDisplayTimeout", displayTimeout.toString());
        map.put("RebootSchedule", rebootScheduleStr);
        map.put("RebootDay", rebootDayStr);
        map.put("RebootMinutes", rebootMinutes.toString());
        map.put("RebootRandomize", rebootRandomize.toString());
        map.put("RebootRandomizeHours", rebootRandomizeHours.toString());
        map.put("PromptType", promptTypeStr);
        map.put("Countdown", countdown.toString());
        map.put("HardReboot", hardReboot.toString());
        map.put("AutoReboot", autoReboot.toString());
        for (Map.Entry mEntry : map.entrySet()) {
            String key = (String)mEntry.getKey();
            String value = (String)mEntry.getValue();
            IniProperty propTemp = section.getPropertyByName(key);
            if (propTemp == null) {
                propTemp = section.addProperty(key, value, true);
                if (propTemp != null) continue;
                System.out.println("PackageUtil> modifySetAidIni: Error-> Failed to retrieve RebootOption <" + key + ">");
                continue;
            }
            propTemp.setValue(value);
        }
        return section;
    }

    public static boolean modifySetAidIniMac(String setAidIniDirPath, boolean keepAllDataOnUpgrade) {
        IniFile file = new IniFile();
        String ini = setAidIniDirPath + File.separator + SETAID_INI;
        if (!file.read(ini)) {
            System.out.println("PackageUtil> modifySetAidIni: Error-> Failed to read the file of setAid.ini");
            return false;
        }
        IniSection section = file.getRoot().getSectionByName(SECTION_PREDEFINED_SMC_CONFIG);
        if (section == null && (section = file.getRoot().addSingleSection(SECTION_PREDEFINED_SMC_CONFIG)) == null) {
            System.out.println("PackageUtil> modifySetAidIni: Error-> Failed to retrieve <PREDEFINED_SMC_CONFIG>");
            return false;
        }
        IniProperty prop = section.getPropertyByName(KEY_KEEPPREVIOUSSETTING);
        if (prop == null && (prop = section.addProperty(KEY_KEEPPREVIOUSSETTING, "", true)) == null) {
            System.out.println("PackageUtil> modifySetAidIni: Error-> Failed to retrieve <KeepPreviousSetting>");
            return false;
        }
        prop.setValue(keepAllDataOnUpgrade ? VALUE_ENABLED : "0");
        if (!file.save(ini)) {
            System.out.println("PackageUtil> modifySetAidIni: Error-> Failed to save \"" + ini + "\"");
            return false;
        }
        System.out.println("PackageUtil> modifySetAidIni: Done! ini=" + ini);
        return true;
    }

    static boolean modifySetAidIni(String packageChecksum, InstallationOption installationOption, ClientInstallationFeatures clientFeature, boolean toBuildFeatures, String exportPath, boolean isModifyInstallationOption, boolean isLuRunEnabled, RebootOptions rebootOpts, String version, String fullversion, boolean isLowBandwidthOn, boolean retainExistingClientFeatures) {
        boolean buildFeatureList;
        IniFile file = new IniFile();
        String ini = exportPath + File.separator + SETAID_INI;
        if (!file.read(ini)) {
            System.out.println("PackageUtil> modifySetAidIni: Error-> Failed to read the file of setAid.ini");
            return false;
        }
        IniSection section = file.getRoot().getSectionByName(SECTION_PREDEFINED_SMC_CONFIG);
        if (section == null && (section = file.getRoot().addSingleSection(SECTION_PREDEFINED_SMC_CONFIG)) == null) {
            System.out.println("PackageUtil> modifySetAidIni: Error-> Failed to retrieve <PREDEFINED_SMC_CONFIG>");
            return false;
        }
        IniProperty prop = section.getPropertyByName(KEY_PACKAGE_CHECKSUM);
        if (prop == null && (prop = section.addProperty(KEY_PACKAGE_CHECKSUM, "", true)) == null) {
            System.out.println("PackageUtil> modifySetAidIni: Error-> Failed to retrieve <PackageChecksum>");
            return false;
        }
        if (packageChecksum != null && !packageChecksum.equals("")) {
            prop.setValue(packageChecksum);
        }
        boolean isEnabled = false;
        if (installationOption != null) {
            isEnabled = installationOption.getOptEnable();
        }
        if (isModifyInstallationOption && isEnabled) {
            section = file.getRoot().getSectionByName(SECTION_CUSTOM_SMC_CONFIG);
            if (section == null && (section = file.getRoot().addSingleSection(SECTION_CUSTOM_SMC_CONFIG)) == null) {
                System.out.println("PackageUtil> modifySetAidIni: Error-> Failed to retrieve <CUSTOM_SMC_CONFIG>");
                return false;
            }
            prop = section.getPropertyByName("InstallUserInterfaceLevel");
            if (prop == null && (prop = section.addProperty("InstallUserInterfaceLevel", "", true)) == null) {
                System.out.println("PackageUtil> modifySetAidIni: Error-> Failed to retrieve <InstallUserInterfaceLevel>");
                return false;
            }
            prop.setValue(PackageUtil.getUserInterfaceLevelValueStringForIni(installationOption));
            prop = section.getPropertyByName(KEY_KEEPPREVIOUSSETTING);
            if (prop == null && (prop = section.addProperty(KEY_KEEPPREVIOUSSETTING, "", true)) == null) {
                System.out.println("PackageUtil> modifySetAidIni: Error-> Failed to retrieve <KeepPreviousSetting>");
                return false;
            }
            prop.setValue(PackageUtil.getKeepAllDataOnUpgradeValueStringForIni(installationOption));
            prop = section.getPropertyByName("DestinationDirectory");
            if (prop == null && (prop = section.addProperty("DestinationDirectory", "", true)) == null) {
                System.out.println("PackageUtil> modifySetAidIni: Error-> Failed to retrieve <DestinationDirectory>");
                return false;
            }
            prop.setValue(PackageUtil.isInstallDirEnabled(installationOption) ? PackageUtil.getInstallDir(installationOption) : "");
            prop = section.getPropertyByName("InstallationLogDir");
            if (prop == null && (prop = section.addProperty("InstallationLogDir", "", true)) == null) {
                System.out.println("PackageUtil> modifySetAidIni: Error-> Failed to retrieve <InstallationLogDir>");
                return false;
            }
            prop.setValue(PackageUtil.isInstallLogEnabled(installationOption) ? PackageUtil.getInstallLogFile(installationOption) : "");
            prop = section.getPropertyByName("LaunchIt");
            if (prop == null && (prop = section.addProperty("LaunchIt", "", true)) == null) {
                System.out.println("PackageUtil> modifySetAidIni: Error-> Failed to retrieve <LaunchIt>");
                return false;
            }
            prop.setValue(PackageUtil.isStartAgentEnabled(installationOption) ? VALUE_ENABLED : "0");
            prop = section.getPropertyByName("OptOutRepSubmission");
            if (prop == null && (prop = section.addProperty("OptOutRepSubmission", "0", false)) == null) {
                System.out.println("PackageUtil> modifySetAidIni: Error-> Failed to retrieve <OptOutRepSubmission>");
                return false;
            }
            prop.setValue(PackageUtil.isMrCleanOptionEnabled(installationOption) ? "0" : VALUE_ENABLED);
            prop = section.getPropertyByName("AddProgramIntoStartMenu");
            if (prop == null && (prop = section.addProperty("AddProgramIntoStartMenu", "", true)) == null) {
                System.out.println("PackageUtil> modifySetAidIni: Error-> Failed to retrieve <AddProgramIntoStartMenu>");
                return false;
            }
            prop.setValue(PackageUtil.isStartMenuEnabled(installationOption) ? VALUE_ENABLED : "0");
            prop = section.getPropertyByName("UIRebootMode");
            if (prop == null && (prop = section.addProperty("UIRebootMode", "", true)) == null) {
                System.out.println("PackageUtil> modifySetAidIni: Error-> Failed to retrieve <UIRebootMode>");
                return false;
            }
            int restart = PackageUtil.getRestartSetting(installationOption);
            if (restart == InstallationOption.PROMPT_WHEN_RESTART) {
                prop.setValue("0");
            } else if (restart == InstallationOption.ASK_FOR_RESTART) {
                prop.setValue(VALUE_ENABLED);
            } else if (restart == InstallationOption.SILENT_RESTART) {
                prop.setValue("2");
            } else if (restart == InstallationOption.DO_NOTHING) {
                prop.setValue("3");
            } else {
                prop.setValue("0");
            }
            if (Utility.compareVersion(fullversion, "12.2.0.0") >= 0) {
                prop = section.getPropertyByName(KEY_DARKNETWORK);
                if (prop == null && (prop = section.addProperty(KEY_DARKNETWORK, "0", true)) == null) {
                    System.out.println("PackageUtil> modifySetAidIni: Failed to add DarkNetwork default value");
                    return false;
                }
                if (PackageUtil.isReducedInstallSizeSpecified(installationOption)) {
                    prop.setValue("0");
                } else if (PackageUtil.isDarkNetwork(installationOption)) {
                    prop.setValue(VALUE_ENABLED);
                } else {
                    prop.setValue("0");
                }
            }
            if ((prop = section.getPropertyByName(KEY_REDUCEDSIZE)) == null && (prop = section.addProperty(KEY_REDUCEDSIZE, "0", true)) == null) {
                System.out.println("PackageUtil> modifySetAidIni: Failed to add ReducedSize default value");
                return false;
            }
            prop.setValue(PackageUtil.isReducedInstallSizeSpecified(installationOption) ? VALUE_ENABLED : "0");
            if (rebootOpts == null) {
                System.out.println("PackageUtil> modifySetAidIni: Error-> Failed to retrieve RebootOption <PromptUser>");
                return false;
            }
            if ((section = PackageUtil.writeRebootOpts(prop, section, rebootOpts)) == null) {
                return false;
            }
            if (Utility.compareVersion(fullversion, "14.0.0.1000", true) >= 0) {
                String value = isLowBandwidthOn ? VALUE_ENABLED : "0";
                IniProperty propLb = section.getPropertyByName(KEY_LOWBANDWIDTH);
                if (propLb == null) {
                    section.addProperty(KEY_LOWBANDWIDTH, value, true);
                } else {
                    propLb.setValue(value);
                }
            }
        }
        if (toBuildFeatures && !retainExistingClientFeatures && !(buildFeatureList = PackageUtil.buildSAVFeatureList(file, clientFeature, version))) {
            System.out.println("PackageUtil> modifySetAidIni: Failed to build feature set, enabled features empty");
            return false;
        }
        section = file.getRoot().getSectionByName(SECTION_LU_CONFIG);
        if (section == null && (section = file.getRoot().addSingleSection(SECTION_LU_CONFIG)) == null) {
            System.out.println("PackageUtil> modifySetAidIni: Error-> Failed to retrieve <LU_CONFIG>");
            return false;
        }
        prop = section.getPropertyByName("CONNECT_LU_SERVER");
        if (prop == null) {
            prop = section.addProperty("CONNECT_LU_SERVER", isLuRunEnabled ? VALUE_ENABLED : "0", true);
            if (prop == null) {
                System.out.println("PackageUtil> modifySetAidIni: Error-> Failed to retrieve <LU_RUN>");
                return false;
            }
        } else {
            prop.setValue(isLuRunEnabled ? VALUE_ENABLED : "0");
        }
        if (!file.save(ini)) {
            System.out.println("PackageUtil> modifySetAidIni: Error-> Failed to save \"" + ini + "\"");
            return false;
        }
        System.out.println("PackageUtil> modifySetAidIni: Done! ini=" + ini);
        return true;
    }

    public static boolean saveInstallOptions(IniFile file, String ini, InstallationOption installationOption) {
        IniSection section = file.getRoot().getSectionByName(SECTION_CUSTOM_SMC_CONFIG);
        if (section == null && (section = file.getRoot().addSingleSection(SECTION_CUSTOM_SMC_CONFIG)) == null) {
            System.out.println("PackageUtil> modifySetAidIni: Error-> Failed to retrieve <CUSTOM_SMC_CONFIG>");
            return false;
        }
        IniProperty prop = section.getPropertyByName("InstallUserInterfaceLevel");
        if (prop == null && (prop = section.addProperty("InstallUserInterfaceLevel", "", true)) == null) {
            System.out.println("PackageUtil> modifySetAidIni: Error-> Failed to retrieve <InstallUserInterfaceLevel>");
            return false;
        }
        prop.setValue(PackageUtil.getUserInterfaceLevelValueStringForIni(installationOption));
        prop = section.getPropertyByName(KEY_KEEPPREVIOUSSETTING);
        if (prop == null && (prop = section.addProperty(KEY_KEEPPREVIOUSSETTING, "", true)) == null) {
            System.out.println("PackageUtil> modifySetAidIni: Error-> Failed to retrieve <KeepPreviousSetting>");
            return false;
        }
        prop.setValue(PackageUtil.getKeepAllDataOnUpgradeValueStringForIni(installationOption));
        prop = section.getPropertyByName("DestinationDirectory");
        if (prop == null && (prop = section.addProperty("DestinationDirectory", "", true)) == null) {
            System.out.println("PackageUtil> modifySetAidIni: Error-> Failed to retrieve <DestinationDirectory>");
            return false;
        }
        prop.setValue(PackageUtil.isInstallDirEnabled(installationOption) ? PackageUtil.getInstallDir(installationOption) : "");
        prop = section.getPropertyByName("InstallationLogDir");
        if (prop == null && (prop = section.addProperty("InstallationLogDir", "", true)) == null) {
            System.out.println("PackageUtil> modifySetAidIni: Error-> Failed to retrieve <InstallationLogDir>");
            return false;
        }
        prop.setValue(PackageUtil.isInstallLogEnabled(installationOption) ? PackageUtil.getInstallLogFile(installationOption) : "");
        prop = section.getPropertyByName("LaunchIt");
        if (prop == null && (prop = section.addProperty("LaunchIt", "", true)) == null) {
            System.out.println("PackageUtil> modifySetAidIni: Error-> Failed to retrieve <LaunchIt>");
            return false;
        }
        prop.setValue(PackageUtil.isStartAgentEnabled(installationOption) ? VALUE_ENABLED : "0");
        prop = section.getPropertyByName("OptOutRepSubmission");
        if (prop == null && (prop = section.addProperty("OptOutRepSubmission", "0", false)) == null) {
            System.out.println("PackageUtil> modifySetAidIni: Error-> Failed to retrieve <OptOutRepSubmission>");
            return false;
        }
        prop.setValue(PackageUtil.isMrCleanOptionEnabled(installationOption) ? "0" : VALUE_ENABLED);
        prop = section.getPropertyByName("AddProgramIntoStartMenu");
        if (prop == null && (prop = section.addProperty("AddProgramIntoStartMenu", "", true)) == null) {
            System.out.println("PackageUtil> modifySetAidIni: Error-> Failed to retrieve <AddProgramIntoStartMenu>");
            return false;
        }
        prop.setValue(PackageUtil.isStartMenuEnabled(installationOption) ? VALUE_ENABLED : "0");
        prop = section.getPropertyByName("UIRebootMode");
        if (prop == null && (prop = section.addProperty("UIRebootMode", "", true)) == null) {
            System.out.println("PackageUtil> modifySetAidIni: Error-> Failed to retrieve <UIRebootMode>");
            return false;
        }
        int restart = PackageUtil.getRestartSetting(installationOption);
        if (restart == InstallationOption.PROMPT_WHEN_RESTART) {
            prop.setValue("0");
        } else if (restart == InstallationOption.ASK_FOR_RESTART) {
            prop.setValue(VALUE_ENABLED);
        } else if (restart == InstallationOption.SILENT_RESTART) {
            prop.setValue("2");
        } else if (restart == InstallationOption.DO_NOTHING) {
            prop.setValue("3");
        } else {
            prop.setValue("0");
        }
        section = file.getRoot().getSectionByName("TPAR");
        if (section == null && (section = file.getRoot().addSingleSection("TPAR")) == null) {
            System.out.println("PackageUtil> modifySetAidIni: Error-> Failed to retrieve <TPAR>");
            return false;
        }
        prop = section.getPropertyByName("Enable");
        if (prop == null && (prop = section.addProperty("Enable", "", true)) == null) {
            System.out.println("PackageUtil> modifySetAidIni: Error-> Failed to retrieve <Enable>");
            return false;
        }
        prop.setValue(PackageUtil.isUnInstallEnabled(installationOption) ? VALUE_ENABLED : "0");
        if (!file.save(ini)) {
            System.out.println("PackageUtil> modifySetAidIni: Error-> Failed to save \"" + ini + "\"");
            return false;
        }
        return true;
    }

    public static String readPackageChecksumfromSetaidIni(String exportPath) {
        String packageChecksum = "";
        IniFile file = new IniFile();
        String ini = exportPath + File.separator + SETAID_INI;
        if (!file.read(ini)) {
            System.out.println("PackageUtil> readPackageChecksumfromSetaidIni: Error-> Failed to read the file of setAid.ini");
            return packageChecksum;
        }
        IniProperty prop = null;
        StringBuffer sbuff = new StringBuffer("");
        IniSection section = file.getRoot().getSectionByName(SECTION_PREDEFINED_SMC_CONFIG);
        if (section != null) {
            sbuff.append("PREDEFINED_SMC_CONFIG section found, ");
            prop = section.getPropertyByName(KEY_PACKAGE_CHECKSUM);
            if (prop != null) {
                packageChecksum = prop.getValue();
                sbuff.append("PackageChecksum property found, ");
            }
        }
        System.out.println("PackageUtil> readPackageChecksumfromSetaidIni: " + sbuff.toString() + "checksum: " + packageChecksum);
        return packageChecksum;
    }

    public static boolean modifySetAidIniSetupIni(String packageChecksum, InstallationOption installationOption, ClientInstallationFeatures clientFeature, boolean toBuildFeatures, String exportPath, boolean isModifyInstallationOption, boolean isLuRunEnabled, RebootOptions rebootOpts, String version) {
        return PackageUtil.modifySetAidIniSetupIni(packageChecksum, installationOption, clientFeature, toBuildFeatures, exportPath, isModifyInstallationOption, isLuRunEnabled, rebootOpts, version, false, false);
    }

    public static boolean modifySetAidIniSetupIni(String packageChecksum, InstallationOption installationOption, ClientInstallationFeatures clientFeature, boolean toBuildFeatures, String exportPath, boolean isModifyInstallationOption, boolean isLuRunEnabled, RebootOptions rebootOpts, String version, boolean lowBandwidthEnabled, boolean retainExistingFeatures) {
        String tempFile = exportPath + File.separator + ".." + File.separator + "..";
        String packageFolder = tempFile + File.separator + "packages";
        String srcAppRemoverZip = packageFolder + File.separator + "TPAR" + File.separator + APP_REMOVER_ZIP;
        return PackageUtil.modifySetAidIniSetupIni(packageChecksum, installationOption, clientFeature, toBuildFeatures, exportPath, isModifyInstallationOption, isLuRunEnabled, rebootOpts, version, srcAppRemoverZip, null, lowBandwidthEnabled, retainExistingFeatures);
    }

    public static boolean modifySetAidIniSetupIni(String packageChecksum, InstallationOption installationOption, ClientInstallationFeatures clientFeature, boolean toBuildFeatures, String exportPath, boolean isModifyInstallationOption, boolean isLuRunEnabled, RebootOptions rebootOpts, String version, String srcAppRemoverZip, String srcCleanWipeZip) {
        return PackageUtil.modifySetAidIniSetupIni(packageChecksum, installationOption, clientFeature, toBuildFeatures, exportPath, isModifyInstallationOption, isLuRunEnabled, rebootOpts, version, srcAppRemoverZip, srcCleanWipeZip, false, false);
    }

    public static boolean modifySetAidIniSetupIni(String packageChecksum, InstallationOption installationOption, ClientInstallationFeatures clientFeature, boolean toBuildFeatures, String exportPath, boolean isModifyInstallationOption, boolean isLuRunEnabled, RebootOptions rebootOpts, String version, String srcAppRemoverZip, String srcCleanWipeZip, boolean lowBandwidthEnabled, boolean retainExistingClientFeatures) {
        String fullversion = version;
        if ((version = Utility.compareVersion(version, "14.3.0.5000", true) >= 0 ? "14.3.5000.0" : (Utility.compareVersion(version, "14.3.0.4000", true) >= 0 ? "14.3.4000.0" : (Utility.compareVersion(version, "14.2.0.1000", true) >= 0 ? "14.2.1000.0" : (Utility.compareVersion(version, "14.2.0.0", true) >= 0 ? "14.2.0000.0" : (Utility.compareVersion(version, "12.1.1925.0") >= 0 ? "12.1.2000.0" : (Utility.compareVersion(version, "12.1.0.0") >= 0 ? "12.1.0.0" : "11.0.0.0")))))) == "11.0.0.0" && installationOption.getUserInterfaceLevel().intValue() == InstallationOption.SILENT.intValue()) {
            installationOption.setOptRestartOption(InstallationOption.DO_NOTHING);
        }
        boolean isAppRemoverSupportedPackage = toBuildFeatures;
        System.out.println("PackageUtil> modifySetAidIniSetupIni: isAppRemoverSupportedPackage" + isAppRemoverSupportedPackage);
        boolean retSetAid = PackageUtil.modifySetAidIni(packageChecksum, installationOption, clientFeature, toBuildFeatures, exportPath, isModifyInstallationOption, isLuRunEnabled, rebootOpts, version, fullversion, lowBandwidthEnabled, retainExistingClientFeatures);
        boolean retSetup = PackageUtil.modifySetupIni(installationOption, exportPath, isModifyInstallationOption, fullversion, isAppRemoverSupportedPackage);
        boolean addAppRemover = true;
        if (PackageUtil.isUnInstallEnabled(installationOption) && isAppRemoverSupportedPackage) {
            if (Utility.compareVersion(fullversion, MIN_VERSION_FOR_APP_REMOVER, true) >= 0) {
                addAppRemover = PackageUtil.addAppRemover(srcAppRemoverZip, exportPath);
                if (!addAppRemover) {
                    System.out.println("PackageUtil> modifySetAidIniSetupIni: Error occured while adding TPAR");
                }
            } else {
                System.out.println("PackageUtil> modifySetAidIniSetupIni: Minimum version supported by TPAR is 14.3.0000.1000");
            }
        } else {
            System.out.println("PackageUtil> modifySetAidIniSetupIni: Either Uninstall is not enabled/ not supported by this software package");
        }
        return retSetAid && retSetup && addAppRemover;
    }

    static boolean addAppRemover(String srcAppRemoverZip, String exportPath) {
        boolean isSuccessful = false;
        System.out.println("PackageUtil> addAppRemover: Entered");
        String appRemoverunzipPath = exportPath + File.separator + "TPAR";
        System.out.println("PackageUtil> addAppRemover path: " + appRemoverunzipPath);
        File fAppRemoverZip = new File(srcAppRemoverZip);
        try {
            isSuccessful = ZipUtil.unzipFile(fAppRemoverZip, appRemoverunzipPath);
        }
        catch (Exception e) {
            System.out.println("PackageUtil> addAppRemover: Failed");
            System.out.println("PackageUtil> AppRemover zip file path" + srcAppRemoverZip);
            isSuccessful = false;
        }
        System.out.println("PackageUtil> addAppRemover: Exit");
        return isSuccessful;
    }

    static boolean modifySetupIni(InstallationOption installationOption, String exportPath, boolean isModifyInstallationOption, String pkgVersion, boolean isAppRemoverSupportedPackage) {
        int restart;
        if (installationOption == null) {
            return true;
        }
        boolean isEnabled = false;
        isEnabled = installationOption.getOptEnable();
        if (!isModifyInstallationOption || !isEnabled) {
            return true;
        }
        IniFile file = new IniFile();
        String ini = exportPath + File.separator + SETUP_INI;
        if (!file.read(ini)) {
            System.out.println("PackageUtil> modifySetupIni: Error-> Failed to read the file of setup.ini");
            return false;
        }
        IniSection section = file.getRoot().getSectionByName("Startup");
        if (section == null && (section = file.getRoot().addSingleSection("Startup")) == null) {
            System.out.println("PackageUtil> modifySetupIni: Error-> Failed to retrieve [Startup]");
            return false;
        }
        IniProperty prop = section.getPropertyByName("CmdLine");
        if (prop == null && (prop = section.addProperty("CmdLine", "", true)) == null) {
            System.out.println("PackageUtil> modifySetupIni: Error-> Failed to retrieve <CmdLine>");
            return false;
        }
        StringBuffer cmdLine = new StringBuffer();
        if (installationOption.getUserInterfaceLevel().equals(InstallationOption.UNATTENDED)) {
            cmdLine.append("/qb!");
        } else if (installationOption.getUserInterfaceLevel().equals(InstallationOption.SILENT)) {
            cmdLine.append("/qn");
        }
        if (cmdLine.toString().length() > 0) {
            cmdLine.append(" ");
        }
        if (PackageUtil.isInstallLogEnabled(installationOption)) {
            String logFile = PackageUtil.getInstallLogFile(installationOption).trim();
            if (logFile.length() == 0) {
                logFile = "%TEMP%\\SEP_INST.LOG";
            }
            cmdLine.append("/l*v ");
            cmdLine.append("\"" + logFile + "\"");
        }
        if (cmdLine.toString().length() > 0) {
            cmdLine.append(" ");
        }
        if ((restart = PackageUtil.getRestartSetting(installationOption)) == InstallationOption.DO_NOTHING) {
            cmdLine.append("REBOOT=ReallySuppress");
        }
        prop.setValue(cmdLine.toString());
        section = file.getRoot().getSectionByName("TPAR");
        if (isAppRemoverSupportedPackage && Utility.compareVersion(pkgVersion, MIN_VERSION_FOR_APP_REMOVER, true) >= 0) {
            if (section == null) {
                file.getRoot().addSeparator();
                section = file.getRoot().addSingleSection("TPAR");
                if (section == null) {
                    System.out.println("PackageUtil> modifySetupIni: Error-> Failed to retrieve [TPAR]");
                    return false;
                }
            }
            if ((prop = section.getPropertyByName("Enable")) == null && (prop = section.addProperty("Enable", "", true)) == null) {
                System.out.println("PackageUtil> modifySetupIni: Error-> Failed to retrieve <Enable>");
                return false;
            }
            prop.setValue(PackageUtil.isUnInstallEnabled(installationOption) ? VALUE_ENABLED : "0");
        }
        if (!file.save(ini)) {
            System.out.println("PackageUtil> modifySetupIni: Error-> Failed to save \"" + ini + "\"");
            return false;
        }
        System.out.println("PackageUtil> modifySetupIni: Done! ini=" + ini);
        return true;
    }

    public static boolean isIDCSetupRequireChange(String setupIniFile, boolean isIdcEnabled) {
        IniFile file = new IniFile();
        if (!file.read(setupIniFile)) {
            System.out.println("PackageUtil> isIDCSetupRequireChange: Error-> Failed to read the file of setup.ini");
            return false;
        }
        IniSection section = file.getRoot().getSectionByName("Startup");
        if (section == null) {
            System.out.println("PackageUtil> isIDCSetupRequireChange: Error-> Failed to retrieve [Startup]");
            return false;
        }
        IniProperty prop = section.getPropertyByName("CmdLine");
        if (prop == null) {
            System.out.println("PackageUtil> isIDCSetupRequireChange: Error-> Failed to retrieve <CmdLine>");
            return false;
        }
        String cmdLine = prop.getValue();
        int index = cmdLine.indexOf(IDC_DISABLE);
        if (index != -1 && isIdcEnabled) {
            return true;
        }
        return index == -1 && !isIdcEnabled;
    }

    public static boolean modifySetupIni(String setupIniFile, boolean isIdcEnabled) {
        IniFile file = new IniFile();
        if (!file.read(setupIniFile)) {
            System.out.println("PackageUtil> modifySetupIni: Error-> Failed to read the file of setup.ini");
            return false;
        }
        IniSection section = file.getRoot().getSectionByName("Startup");
        if (section == null) {
            System.out.println("PackageUtil> modifySetupIni: Error-> Failed to retrieve [Startup]");
            return false;
        }
        IniProperty prop = section.getPropertyByName("CmdLine");
        if (prop == null) {
            System.out.println("PackageUtil> modifySetupIni: Error-> Failed to retrieve <CmdLine>");
            return false;
        }
        boolean isModified = false;
        Object cmdLine = prop.getValue();
        int index = ((String)cmdLine).indexOf(IDC_DISABLE);
        if (index != -1 && isIdcEnabled) {
            cmdLine = ((String)cmdLine).substring(0, index);
            isModified = true;
        } else if (index == -1 && !isIdcEnabled) {
            cmdLine = (String)cmdLine + " IDCENABLE=0";
            isModified = true;
        } else if (index < 0 && isIdcEnabled) {
            cmdLine = (String)cmdLine + " IDCENABLE=0";
            isModified = true;
        }
        prop.setValue((String)cmdLine);
        if (!file.save(setupIniFile)) {
            System.out.println("PackageUtil> modifySetupIni: Error-> Failed to save \"" + setupIniFile + "\"");
            return false;
        }
        System.out.println("PackageUtil> modifySetupIni: Done! ini=" + setupIniFile);
        return isModified;
    }

    public static boolean isPackageAvailForIdcSetting(String setupIniFile) {
        IniFile file = new IniFile();
        if (!file.read(setupIniFile)) {
            System.out.println("PackageUtil> isPackageAvailForIdcSetting: Error-> Failed to read the file of setup.ini");
            return false;
        }
        IniSection section = file.getRoot().getSectionByName("Startup");
        if (section == null) {
            System.out.println("PackageUtil> isPackageAvailForIdcSetting: Error-> Failed to retrieve [Startup]");
            return false;
        }
        IniProperty prop = section.getPropertyByName("ProductVersion");
        if (prop == null) {
            System.out.println("PackageUtil> isPackageAvailForIdcSetting: Error-> Failed to retrieve <ProductVersion>");
            return false;
        }
        String version = prop.getValue();
        return PackageUtil.isRU6AndUpClientPackageSupportIDC(version);
    }

    public static boolean isRU6AndUpClientPackageSupportIDC(String version) {
        if (version == null || version.length() < 1) {
            return false;
        }
        int index = version.indexOf(PACKAGE_VERSION_SEPARATOR);
        if (index < 0) {
            return false;
        }
        String[] result = version.split("\\.", -1);
        if (result.length < 4) {
            return false;
        }
        try {
            int majorVersion = Integer.parseInt(result[0]);
            int seqNumber = Integer.parseInt(result[2]);
            return majorVersion == 11 && seqNumber > 5700 || Utility.compareVersion(version, "12.1.0.0") > 0;
        }
        catch (NumberFormatException ex) {
            LoggerUtilities.logException(ex);
            return false;
        }
    }

    private static boolean buildSAVFeatureList(IniFile file, ClientInstallationFeatures cFeature, String version) {
        IniSection section = file.getRoot().getSectionByName("FEATURE_SELECTION");
        if (section == null) {
            file.getRoot().addSeparator();
            section = file.getRoot().addSingleSection("FEATURE_SELECTION");
            if (section == null) {
                System.out.println("PackageUtil> modifySetAidIni: Error-> Failed to retrieve <PREDEFINED_SMC_CONFIG>");
            }
        }
        int is142Ru1OrLater = Utility.compareVersion(version, "14.2.0.1000");
        if (cFeature == null) {
            for (String name : PackageUtil.getSAVFeatureList(version)) {
                String value;
                if (is142Ru1OrLater >= 0 && (name.equals("NotesSnapin") || name.equals("Pop3Smtp")) || (value = Utility.getProperty(name, section)) != null && value.trim().length() != 0) continue;
                Utility.setProperty(name, VALUE_ENABLED, section);
            }
            return true;
        }
        EnabledClientFeatures enabledFeatures = ClientInstallFeatureSetUtility.findFeatureVersionFromFeatureSet(version, cFeature, false);
        if (enabledFeatures.getClientFeatureCount() == 0) {
            System.out.println("PackageUtil> modifySetAidIni: Error-> There is no enabled client features for this product version");
            return false;
        }
        for (ClientFeature clientF : enabledFeatures.getClientFeature()) {
            String name = clientF.getFeatureName();
            if (name == null || name.trim().length() < 1 || is142Ru1OrLater >= 0 && (name.equals("NotesSnapin") || name.equals("Pop3Smtp"))) continue;
            Boolean enabled = clientF.getOptEnabled();
            if (enabled == null) {
                enabled = clientF.getDefEnabled() == false;
            }
            String value = enabled != false ? VALUE_ENABLED : "0";
            Utility.setProperty(name, value, section);
        }
        if (Utility.compareVersion(version, "12.1.0.0") >= 0) {
            Utility.setProperty("Core", VALUE_ENABLED, section);
        }
        return true;
    }

    public static synchronized List<String> getSAVFeatureList(String version) {
        if (SAVFeatureList == null) {
            SAVFeatureList = new LinkedList<String>();
            if (Utility.compareVersion(version, "14.2.0.1000", true) >= 0) {
                SAVFeatureList.add("Core");
                SAVFeatureList.add("SAVMain");
                SAVFeatureList.add("Download");
                SAVFeatureList.add("OutlookSnapin");
                SAVFeatureList.add("PTPMain");
                SAVFeatureList.add("TruScan");
                SAVFeatureList.add("DCMain");
                SAVFeatureList.add("NTPMain");
                SAVFeatureList.add("Firewall");
                SAVFeatureList.add("ITPMain");
                SAVFeatureList.add("ADDefense");
                SAVFeatureList.add("NTR");
            } else if (Utility.compareVersion(version, "12.0") > 0) {
                SAVFeatureList.add("Core");
                SAVFeatureList.add("SAVMain");
                SAVFeatureList.add("Download");
                SAVFeatureList.add("OutlookSnapin");
                SAVFeatureList.add("NotesSnapin");
                SAVFeatureList.add("Pop3Smtp");
                SAVFeatureList.add("PTPMain");
                SAVFeatureList.add("TruScan");
                SAVFeatureList.add("DCMain");
                SAVFeatureList.add("NTPMain");
                SAVFeatureList.add("Firewall");
                SAVFeatureList.add("ITPMain");
            } else {
                SAVFeatureList.add("SAVMain");
                SAVFeatureList.add("EMailTools");
                SAVFeatureList.add("OutlookSnapin");
                SAVFeatureList.add("NotesSnapin");
                SAVFeatureList.add("Pop3Smtp");
                SAVFeatureList.add("ITPMain");
                SAVFeatureList.add("Firewall");
                SAVFeatureList.add("PTPMain");
                SAVFeatureList.add("COHMain");
                SAVFeatureList.add("DCMain");
            }
        }
        return SAVFeatureList;
    }

    private static String getUserInterfaceLevelValueStringForIni(InstallationOption option) {
        if (option == null) {
            return "";
        }
        if (option.getUserInterfaceLevel().equals(InstallationOption.NORMAL)) {
            return UI_LEVEL_NORMAL_VALUESTR;
        }
        if (option.getUserInterfaceLevel().equals(InstallationOption.UNATTENDED)) {
            return UI_LEVEL_UNATTENDED_VALUESTR;
        }
        if (option.getUserInterfaceLevel().equals(InstallationOption.SILENT)) {
            return UI_LEVEL_SILENT_VALUESTR;
        }
        return "";
    }

    public static boolean isKeepAllDataOnUpgrade(InstallationOption option) {
        if (option == null) {
            return false;
        }
        if (option.getKeepAllDataOnUpgrade() == null) {
            return false;
        }
        return option.getKeepAllDataOnUpgrade();
    }

    public static boolean isMrCleanOptionEnabled(InstallationOption option) {
        if (option == null) {
            return true;
        }
        return option.getOptEnableMrCleanSubMission() == null ? option.getDefEnableMrCleanSubMission() : option.getOptEnableMrCleanSubMission();
    }

    private static String getKeepAllDataOnUpgradeValueStringForIni(InstallationOption option) {
        return PackageUtil.isKeepAllDataOnUpgrade(option) ? VALUE_ENABLED : "0";
    }

    public static boolean isInstallDirEnabled(InstallationOption option) {
        if (option == null) {
            return false;
        }
        return option.getOptSpecifyInstallationDirectory() == null ? option.getDefSpecifyInstallationDirectory() : option.getOptSpecifyInstallationDirectory();
    }

    public static String getInstallDir(InstallationOption option) {
        if (option == null) {
            return "";
        }
        String dir = option.getOptInstallationDirectory();
        if (dir == null) {
            dir = "";
        }
        return dir;
    }

    public static boolean isReducedInstallSizeSpecified(InstallationOption option) {
        if (option == null) {
            return false;
        }
        Boolean value = option.getOptSpecifyReducedInstallSize();
        if (value == null) {
            value = option.getDefSpecifyReducedInstallSize();
        }
        return value;
    }

    public static boolean isDarkNetwork(InstallationOption option) {
        if (option == null) {
            return false;
        }
        Boolean value = option.getOptDarkNetwork();
        if (value == null) {
            value = option.getDefDarkNetwork();
        }
        return value;
    }

    public static boolean isInstallLogEnabled(InstallationOption option) {
        if (option == null) {
            return false;
        }
        return option.getOptEnableInstallationLog() == null ? option.getDefEnableInstallationLog() : option.getOptEnableInstallationLog();
    }

    public static boolean isUnInstallEnabled(InstallationOption option) {
        if (option == null) {
            return false;
        }
        return option.getOptEnableCompetitiveUninstall() == null ? option.getDefEnableCompetitiveUninstall().booleanValue() : option.getOptEnableCompetitiveUninstall().booleanValue();
    }

    public static boolean isPreInstallCleanupEnabled(InstallationOption option) {
        if (option == null) {
            return false;
        }
        return option.getOptEnablePreInstallCleanup() == null ? option.getDefEnablePreInstallCleanup().booleanValue() : option.getOptEnablePreInstallCleanup().booleanValue();
    }

    public static boolean isCuApplicablePackage(SoftwarePackage sp) {
        if (sp.getPackageInfo().getType() != 105) {
            return false;
        }
        if (sp.getPackageInfo().getOptPlatformType().equals("Mac")) {
            return false;
        }
        String version = null;
        version = Boolean.TRUE.equals(sp.getPackageInfo().getOptSecurityFixPackage()) ? sp.getPackageInfo().getOptProductBuildNum() : sp.getPackageInfo().getVersion();
        if (Utility.compareVersion(version, MIN_VERSION_FOR_APP_REMOVER, true) < 0) {
            return false;
        }
        return !ConstantValue.isLinuxPlatform(sp.getPackageInfo().getOptPlatformType());
    }

    public static String getInstallLogFile(InstallationOption option) {
        if (option == null) {
            return "";
        }
        String file = option.getOptInstallationLogFileName();
        if (file == null) {
            file = "";
        }
        return file;
    }

    public static boolean isStartAgentEnabled(InstallationOption option) {
        if (option == null) {
            return false;
        }
        return option.getOptStartAgentAfterInstallation() == null ? option.getDefStartAgentAfterInstallation() : option.getOptStartAgentAfterInstallation();
    }

    public static boolean isStartMenuEnabled(InstallationOption option) {
        if (option == null) {
            return false;
        }
        return option.getOptAddProgramIntoStartMenu() == null ? option.getDefAddProgramIntoStartMenu() : option.getOptAddProgramIntoStartMenu();
    }

    public static int getRestartSetting(InstallationOption option) {
        if (option == null) {
            return InstallationOption.ASK_FOR_RESTART;
        }
        Integer restart = option.getOptRestartOption();
        if (restart == null) {
            restart = option.getDefRestartOption();
        }
        return restart;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties runScmHelper(String commandDir, String action, String actionParams) {
        String tempOutputFile = Utility.generateTempFileName(commandDir, "scmhelper_", null, "ini");
        String exePath = commandDir + File.separator + EXE_SCMHELPER;
        String[] command = new String[]{exePath, "\"" + tempOutputFile + "\"", action, actionParams};
        int ret = -1;
        try {
            ret = RunCommandHandler.runCommandLine(command);
        }
        catch (InterruptedException e) {
            LoggerUtilities.logException(e);
        }
        catch (IOException e) {
            LoggerUtilities.logException(e);
        }
        if (ret != 0) {
            System.out.println("Utility>> runScmHelper: Error-> Failed to run ScmHelper!!");
            return null;
        }
        File output = new File(tempOutputFile);
        if (!output.exists()) {
            System.out.println("Utility>> runScmHelper: Error-> no output generated! output=" + output.getAbsolutePath());
            return null;
        }
        boolean ok = true;
        Properties props = new Properties();
        InputStream fis = null;
        try {
            fis = new BufferedInputStream(new FileInputStream(output));
            props.load(fis);
        }
        catch (Exception e) {
            System.out.println("Utility>> runScmHelper: Error-> load file " + output.getAbsolutePath());
            LoggerUtilities.logException(e);
            ok = false;
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Exception e) {}
            }
            Utility.deleteFile(output.getName());
        }
        if (!ok) {
            return null;
        }
        int i = 0;
        Enumeration<?> en = props.propertyNames();
        while (en.hasMoreElements()) {
            Object oKey = en.nextElement();
            Object oValue = props.get(oKey);
            System.out.println("Utility>> runScmHelper: props#" + i++ + ", " + oKey.toString() + "=" + oValue.toString());
        }
        System.out.println("Utility>> runScmHelper: OK!");
        return props;
    }

    public static boolean runMakeSFX(String commandDir, String targetExe, String sourceZipFile) throws Exception {
        File sourceFile = new File(sourceZipFile);
        if (!sourceFile.exists()) {
            System.out.println("Utility>> runMakeSFX: Error-> source doesn't exist! source=" + sourceFile.getAbsolutePath());
            return false;
        }
        File targetFile = new File(targetExe);
        if (targetFile.exists()) {
            Utility.deleteFile(targetExe);
        }
        String exePath = commandDir + File.separator + "MakeSFX.exe";
        String[] command = new String[]{exePath, "--zip", "\"" + sourceFile.getAbsolutePath() + "\"", "--sfx", "\"" + targetFile.getAbsolutePath() + "\"", "--launch-exe", EXE_SSAWRAPPER_DST, "--launch-arguments", "<pass>", "--target-dir", "<temp>", "--cleanup"};
        ICommandHandler comHandler = RunCommandHandler.getInstance();
        int ret = -1;
        try {
            ret = comHandler.run(command, null, null, 0L);
        }
        catch (InterruptedException e) {
            LoggerUtilities.logException(e);
        }
        if (ret != 0) {
            System.out.println("Utility>> runMakeSFX: Error-> Failed to run MakeSFX!!");
            System.out.println("Error: " + comHandler.getErrorOut());
            System.out.println("Normal: " + comHandler.getNormalOut());
            return false;
        }
        if (!targetFile.exists()) {
            System.out.println("Utility>> runMakeSFX: Error-> no exe generated! target=" + targetFile.getAbsolutePath());
            return false;
        }
        System.out.println("Utility>> runMakeSFX: OK! target=" + targetFile.getAbsolutePath());
        return true;
    }

    public static boolean runPacklist(String commandDir, String exportDir, String outputDir, String buildNumber, List<String> ignoreList) throws Exception {
        return PackageUtil.runPacklist(commandDir, exportDir, outputDir, buildNumber, ignoreList, false);
    }

    public static boolean runPacklist(String commandDir, String exportDir, String outputDir, String buildNumber, List<String> ignoreList, boolean forceRun) throws Exception {
        File packlistFile = new File(outputDir, PACKLIST_XML);
        if (!forceRun && packlistFile.exists() && PackageUtil.readPackageChecksum(outputDir) != null) {
            System.out.println("Utility>> runPacklist: Has Valid Packlist, do not need to run packlist to avoid different checksum issues!!");
            return true;
        }
        if (packlistFile.exists()) {
            Utility.deleteFile(packlistFile.getName());
        }
        String exePath = commandDir + File.separator + EXE_PACKLIST;
        String[] command = null;
        if (ignoreList != null && ignoreList.size() > 0) {
            command = new String[8 + ignoreList.size()];
            command[7] = "-ignore";
            int index = 8;
            for (String ignoreFile : ignoreList) {
                command[index++] = "\"" + ignoreFile + "\"";
            }
        } else {
            command = new String[]{"\"" + exePath + "\"", "-p", "\"" + exportDir + "\"", "-b", "\"" + buildNumber + "\"", "-d", "\"" + outputDir + "\""};
        }
        if (RunCommandHandler.runCommandLine(command, null, commandDir, System.out, System.err) != 0) {
            System.out.println("Utility>> runPacklist: Error-> Failed to run packlist!!");
            return false;
        }
        if (!packlistFile.exists()) {
            System.out.println("Utility>> runPacklist: Error-> no packlist.xml generated! target=" + packlistFile.getAbsolutePath());
            return false;
        }
        System.out.println("Utility>> runPacklist: OK! target=" + packlistFile.getAbsolutePath());
        return true;
    }

    public static String getSoftwarePackageProductTypeName(SoftwarePackage sp) {
        int type = sp.getPackageInfo().getType();
        if (151 == type) {
            return SNAC_FOLDER_NAME;
        }
        if (300 == type) {
            return SNAC_ON_DEMAND_FOLDER_NAME;
        }
        if (105 == type) {
            return SEP_FOLDER_NAME;
        }
        return UNKNOWN_FOLDER_NAME;
    }

    public static String getSoftwarePackagePlatformType(SoftwarePackage sp) {
        String platformType = sp.getPackageInfo().getOptPlatformType();
        if (StringUtilities.isEmpty(platformType) && StringUtilities.isEmpty(platformType = sp.getPackageInfo().getDefPlatformType())) {
            platformType = "WIN32BIT";
        }
        return platformType;
    }

    public static String getMacExportCIPZipFileName(SoftwarePackage sp) {
        int type = sp.getPackageInfo().getType();
        if (151 == type) {
            return MAC_EXP_SNAC_ZIP_FILE_NAME;
        }
        if (300 == type) {
            return MAC_EXP_SNAC_ZIP_FILE_NAME;
        }
        if (105 == type) {
            return MAC_EXP_SEP_ZIP_FILE_NAME;
        }
        return PACKAGE_CACHE_FULL_ZIP;
    }

    public static String getLinuxExportCIPZipFileName(SoftwarePackage sp) {
        int type = sp.getPackageInfo().getType();
        if (151 == type || 300 == type) {
            return LINUX_EXP_SNAC_ZIP_FILE_NAME;
        }
        if (105 == type) {
            return LINUX_EXP_SEP_ZIP_FILE_NAME;
        }
        return PACKAGE_CACHE_FULL_ZIP;
    }

    public static int getCIPVersion(SoftwarePackage sp) {
        String serverVersion;
        if (sp == null) {
            throw new IllegalArgumentException("Software Package is null");
        }
        PackageLuInfo luInfo = sp.getPackageInfo().getOptPackageLuInfo();
        if (luInfo != null && !StringUtilities.isEmpty(serverVersion = luInfo.getServerVersion())) {
            String[] parts = serverVersion.split("\\.");
            if (parts == null || parts.length < 2) {
                throw new IllegalArgumentException("Invalidate Server Version, Server Version:" + serverVersion);
            }
            if ("11".equals(parts[0])) {
                return 1;
            }
            String versionStr = parts[0] + PACKAGE_VERSION_SEPARATOR + parts[1];
            if (Utility.compareVersion(versionStr, CIP_VERSION_12_1_STR) >= 0) {
                return 2;
            }
        }
        return 3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getMpkgFolderName(String filePath, String regPackgeName) throws Exception {
        String result = null;
        File zipFile = new File(filePath);
        ZipInputStream zis = null;
        try {
            zis = new ZipInputStream(new BufferedInputStream(new FileInputStream(zipFile)));
            ZipEntry entry = null;
            Pattern pattern = Pattern.compile(regPackgeName, 2);
            Matcher match = null;
            while ((entry = zis.getNextEntry()) != null) {
                String entryName = entry.getName();
                match = pattern.matcher(entryName);
                if (!match.matches()) continue;
                result = match.group(1);
            }
        }
        catch (Throwable throwable) {
            IOUtilities.closeInputStream(zis);
            throw throwable;
        }
        IOUtilities.closeInputStream(zis);
        return result;
    }

    public static void cleanDirAndCreateIfReq(String destFolder) {
        try {
            File folder = new File(destFolder);
            if (folder.exists()) {
                if (folder.isFile()) {
                    Utility.deleteFile(destFolder);
                } else {
                    Utility.deleteDir(destFolder);
                }
            }
            Utility.createDir(destFolder);
        }
        catch (Exception e) {
            System.out.println("Error creating dir: " + destFolder);
        }
    }

    public static String getLicenseAbsenceMsg(int packageType) {
        String msgParameter = MessageResources.getInstance().getString("com.sygate.scm.util.util", "PackageUtil.unknownType");
        String msgFormat = MessageResources.getInstance().getString("com.sygate.scm.util.util", "PackageUtil.wrongTypeMsg");
        Object[] obj = null;
        if (105 == packageType) {
            msgParameter = MessageResources.getInstance().getString("com.sygate.scm.util.util", "PackageUtil.SAV");
        } else if (151 == packageType) {
            msgParameter = MessageResources.getInstance().getString("com.sygate.scm.util.util", "PackageUtil.SNAC");
        } else {
            msgFormat = MessageResources.getInstance().getString("com.sygate.scm.util.util", "PackageUtil.wrongTypeMsg_unKnown");
        }
        obj = new String[]{msgParameter, msgParameter};
        return MessageFormat.format(msgFormat, obj);
    }

    public static boolean isPackageAutoUpgradable(SoftwarePackage sp) {
        return PackageUtil.isPackageAutoUpgradable(sp.getPackageInfo());
    }

    public static boolean isPackageAutoUpgradable(PackageInfo info) {
        String platform = info.getOptPlatformType();
        if (StringUtilities.isEmpty(platform)) {
            platform = info.getDefPlatformType();
        }
        if ("WIN32BIT".equalsIgnoreCase(platform) || "WIN64BIT".equalsIgnoreCase(platform)) {
            return true;
        }
        return "Mac".equalsIgnoreCase(platform) && (300 == info.getType() || !PackageUtil.isClientPackageVersionBefore(info, "12.2.0.0"));
    }

    public static boolean isPackageRemoteInstallable(SoftwarePackage sp) {
        PackageInfo info = sp.getPackageInfo();
        String platform = info.getOptPlatformType();
        if (StringUtilities.isEmpty(platform)) {
            platform = info.getDefPlatformType();
        }
        return "WIN32BIT".equalsIgnoreCase(platform) || "WIN64BIT".equalsIgnoreCase(platform) ? 105 == info.getType() || 151 == info.getType() : "Mac".equalsIgnoreCase(platform) && !PackageUtil.isClientPackageVersionBefore(sp, "12.1.1925.0");
    }

    public static List<String> getCategoryList(int packageType, String feature, String version) {
        List<Object> cateList = new ArrayList();
        String featureVersion = Utility.getFeatureSetVersion(version);
        if (Utility.compareVersion(featureVersion, "14.2.1000.0") >= 0) {
            List<String> list142RU1 = Arrays.asList(ConstantValue.getContent142ru1());
            cateList = new ArrayList<String>(list142RU1);
        } else if (Utility.compareVersion(featureVersion, "14.2.0000.0") == 0) {
            List<String> list14RU1 = Arrays.asList(ConstantValue.getContent140ru1());
            cateList = new ArrayList<String>(list14RU1);
        } else if (Utility.compareVersion(featureVersion, "12.1.2000.0") == 0) {
            List<String> list14RU1 = Arrays.asList(ConstantValue.getContent140ru1());
            cateList = new ArrayList<String>(list14RU1);
        } else if (Utility.compareVersion(featureVersion, "12.1.0.0") == 0) {
            List<String> list121 = Arrays.asList(ConstantValue.getContent121());
            cateList = new ArrayList<String>(list121);
        }
        if (Utility.compareVersion(featureVersion, "12.1.0.0") >= 0) {
            if (!feature.equalsIgnoreCase("TruScan") && !feature.equalsIgnoreCase("Download")) {
                if (feature.equalsIgnoreCase("EMailTools") || feature.equalsIgnoreCase("OutlookSnapin") || feature.equalsIgnoreCase("NotesSnapin") || feature.equalsIgnoreCase("Pop3Smtp") || feature.equalsIgnoreCase("SAVMain")) {
                    cateList = PackageUtil.removeFromList(cateList, "CIDS");
                } else if (feature.equalsIgnoreCase("ITPMain")) {
                    cateList = PackageUtil.removeFromList(cateList, "IRON");
                } else {
                    cateList = new ArrayList();
                    if (feature.equalsIgnoreCase("DCMain")) {
                        cateList.add("AC");
                    }
                }
            }
        } else if (feature.equalsIgnoreCase("COHMain") || feature.equalsIgnoreCase("EMailTools") || feature.equalsIgnoreCase("OutlookSnapin") || feature.equalsIgnoreCase("NotesSnapin") || feature.equalsIgnoreCase("Pop3Smtp") || feature.equalsIgnoreCase("SAVMain")) {
            cateList.add("AV_DEFS");
        } else if (feature.equalsIgnoreCase("Firewall")) {
            cateList.add("IPS");
        } else {
            cateList = new ArrayList();
        }
        if (Utility.compareVersion(version, "14.2.0.1000", true) == -1) {
            cateList = PackageUtil.removeFromList(cateList, "PCH");
            cateList = PackageUtil.removeFromList(cateList, "TDAD");
        }
        if (Utility.compareVersion(version, "14.2.0.0", true) == -1) {
            cateList = PackageUtil.removeFromList(cateList, "AC");
        }
        if (Utility.compareVersion(version, "12.2.0.0") == -1) {
            cateList = PackageUtil.removeFromList(cateList, "EDR");
            cateList = PackageUtil.removeFromList(cateList, "STIC");
        }
        if (Utility.compareVersion(version, "14.0.0.1000", true) == -1) {
            cateList = PackageUtil.removeFromList(cateList, "ADVML");
        }
        if (Utility.compareVersion("14.0.0.1000", version, true) == 1) {
            cateList = PackageUtil.removeFromList(cateList, "NTR");
        }
        if (Utility.compareVersion(version, "12.1.5394.6000") == -1) {
            cateList = PackageUtil.removeFromList(cateList, "HI");
        }
        if (packageType == 151) {
            cateList.clear();
        }
        return cateList;
    }

    public static List<String> removeFromList(List<String> newList, String luCatHi) {
        ArrayList<String> list = new ArrayList<String>(newList);
        Iterator<String> iter = list.iterator();
        while (iter.hasNext()) {
            String s = iter.next();
            if (!s.equals(luCatHi)) continue;
            iter.remove();
        }
        return list;
    }

    public static RebootOptions getDefaultRebootOptions() {
        String messageTxtAreaStr = MessageResources.getInstance().getString("com.sygate.scm.util.util", "PackageUtil.defaultRebootMessage");
        return PackageUtil.getDefaultRebootOptions(messageTxtAreaStr);
    }

    public static RebootOptions getDefaultRebootOptions(String defaultPromptMessage) {
        RebootOptions options = new RebootOptions(false);
        options.setOptRebootMethod(RebootOptions.CLIENT);
        options.setOptRebootSchedule(RebootOptions.LATER);
        options.setOptRebootDay(RebootOptions.TODAY);
        options.setOptRebootMinutes(180);
        options.setOptRandomize(Boolean.TRUE);
        options.setOptRandomizeHours(2);
        options.setOptPromptUser(Boolean.TRUE);
        options.setOptPromptType(RebootOptions.SNOOZE);
        options.setOptPromptMessage(defaultPromptMessage);
        options.setOptDisplayTimeout(60);
        options.setOptCountdown(5);
        options.setOptMaxSnoozeCount(3);
        options.setOptSnoozeInterval(60);
        options.setOptHardReboot(Boolean.TRUE);
        options.setOptAutoReboot(Boolean.TRUE);
        return options;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HashMap<String, String> getAgentInfoFromChecksumFolder(String checksumFilePath) {
        HashMap<String, String> agentInfo = new HashMap<String, String>();
        String clientLanguage = "";
        String platformType = "";
        String agentType = "";
        String agentVersion = "";
        IniFile setAidiniFile = new IniFile();
        IniFile setupIniFile = new IniFile();
        File fullFolderFile = new File(checksumFilePath + File.separator + "full");
        String checksumFullZipTemp = checksumFilePath + File.separator + "fulltemp";
        try {
            IniProperty prop;
            if (fullFolderFile.exists()) {
                setAidiniFile.read(fullFolderFile.getPath() + File.separator + SETAID_INI);
                setupIniFile.read(fullFolderFile.getPath() + File.separator + SETUP_INI);
            } else {
                File checksumFullZipTempFolder = new File(checksumFullZipTemp);
                if (checksumFullZipTempFolder.exists()) {
                    Utility.deleteDir(checksumFullZipTemp);
                }
                if (!checksumFullZipTempFolder.mkdir()) {
                    System.out.println("CHECKSUM DEBUG>>getAgentInfoFromChecksumFolder. Fail to create checksumFullZipTempFolder");
                }
                String srcZipFilePath = checksumFilePath + File.separator + "full.zip";
                ZipUtil.extractFileFromJAR(srcZipFilePath, "SetAid.ini", checksumFullZipTemp);
                ZipUtil.extractFileFromJAR(srcZipFilePath, SETAID_INI, checksumFullZipTemp);
                ZipUtil.extractFileFromJAR(srcZipFilePath, "setaid.ini", checksumFullZipTemp);
                ZipUtil.extractFileFromJAR(srcZipFilePath, "Setup.ini", checksumFullZipTemp);
                ZipUtil.extractFileFromJAR(srcZipFilePath, SETUP_INI, checksumFullZipTemp);
                setAidiniFile.read(checksumFullZipTemp + File.separator + SETAID_INI);
                setupIniFile.read(checksumFullZipTemp + File.separator + SETUP_INI);
            }
            IniRoot root = setAidiniFile.getRoot();
            IniSection section = root.getSectionByName(SECTION_LU_CONFIG);
            if (section != null && (prop = section.getPropertyByName("ClientLanguage")) != null) {
                clientLanguage = prop.getValue();
            }
            if ((section = root.getSectionByName(SECTION_PREDEFINED_SMC_CONFIG)) != null) {
                prop = section.getPropertyByName("PlatformType");
                if (prop != null) {
                    platformType = prop.getValue();
                }
                if ((prop = section.getPropertyByName("AppType")) != null) {
                    agentType = prop.getValue();
                }
            }
            if ((section = (root = setupIniFile.getRoot()).getSectionByName("Startup")) != null && (prop = section.getPropertyByName("ProductVersion")) != null) {
                agentVersion = prop.getValue();
            }
        }
        catch (Exception e1) {
            System.out.println("CHECKSUM DEBUG>>getAgentInfoFromChecksumFolder. " + e1.getMessage());
        }
        finally {
            Utility.deleteDir(checksumFullZipTemp);
        }
        agentInfo.put("ClientLanguage", clientLanguage);
        agentInfo.put("PlatformType", platformType);
        agentInfo.put("ProductVersion", agentVersion);
        agentInfo.put("AppType", agentType);
        return agentInfo;
    }

    public static boolean getIdcSettingFromChecksumFolder(String clientPackagePath, String[] checksumFilePathes) {
        IniProperty prop;
        IniFile setupIniFile = new IniFile();
        String pkgTempFolder = clientPackagePath + File.separator + "fulltemp";
        File folder = new File(pkgTempFolder);
        if (folder.exists()) {
            Utility.deleteDir(pkgTempFolder);
        }
        if (!folder.mkdirs()) {
            return false;
        }
        for (int i = 0; i < checksumFilePathes.length; ++i) {
            String checksumFilePath = clientPackagePath + File.separator + checksumFilePathes[i];
            File fullFolderFile = new File(checksumFilePath + File.separator + "full");
            if (fullFolderFile.exists()) {
                String setupIni = fullFolderFile + File.separator + SETUP_INI;
                if (!new File(setupIni).exists()) continue;
                setupIniFile.read(setupIni);
                break;
            }
            String fullzip = checksumFilePath + File.separator + "full.zip";
            ZipUtil.extractFileFromJAR(fullzip, "Setup.ini", pkgTempFolder);
            ZipUtil.extractFileFromJAR(fullzip, SETUP_INI, pkgTempFolder);
            if (!new File(pkgTempFolder, "Setup.ini").exists() && !new File(pkgTempFolder, SETUP_INI).exists()) continue;
            setupIniFile.read(pkgTempFolder + File.separator + SETUP_INI);
            break;
        }
        Utility.deleteDir(pkgTempFolder);
        IniRoot root = setupIniFile.getRoot();
        IniSection section = root.getSectionByName("Startup");
        if (section != null && (prop = section.getPropertyByName("CmdLine")) != null) {
            String cmdLine = prop.getValue();
            return cmdLine.indexOf(IDC_DISABLE) < 0;
        }
        return true;
    }

    public static EnabledClientFeatures getEnabledFeaturesByVersion(ClientInstallationFeatures features, String version) {
        EnabledClientFeatures ecf = null;
        Vector<EnabledClientFeatures> list = features.getEnabledClientFeatures();
        if (list == null || list.size() < 1) {
            return null;
        }
        for (EnabledClientFeatures ef : list) {
            if (ef == null || ef.getOptMinVersion().compareToIgnoreCase(version) != 0) continue;
            ecf = ef;
            break;
        }
        return ecf;
    }

    public static EnabledClientFeatures getEnabledFeaturesByPackageVersion(ClientInstallationFeatures features, String pkgVersion) {
        String version = Utility.compareVersion(pkgVersion, "14.3.0.5000", true) >= 0 ? "14.3.5000.0" : (Utility.compareVersion(pkgVersion, "14.3.0.4000", true) >= 0 ? "14.3.4000.0" : (Utility.compareVersion(pkgVersion, "14.2.0.1000", true) >= 0 ? "14.2.1000.0" : (Utility.compareVersion(pkgVersion, "14.2.0.0", true) >= 0 ? "14.2.0000.0" : (Utility.compareVersion(pkgVersion, "12.1.1925.0") >= 0 ? "12.1.2000.0" : (Utility.compareVersion(pkgVersion, "12.1.0.0") >= 0 ? "12.1.0.0" : "11.0.0.0")))));
        return PackageUtil.getEnabledFeaturesByVersion(features, version);
    }

    public static String getSylinkDropExeName(String platform) {
        String name = "SylinkDrop.exe";
        if ("Mac".equals(platform)) {
            name = "SylinkDrop";
        }
        return name;
    }

    public static String getSylinkDropExePath(String platform) {
        Object path = "";
        path = "Mac".equals(platform) ? DownloadFiles.SYLINK_DROP_EXE_MAC_PATH + File.separator + "SylinkDrop" : DownloadFiles.SYLINK_DROP_EXE_WIN_PATH + File.separator + "SylinkDrop.exe";
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeSylinkdropOptionsXMLForMac(String path) throws IOException {
        String password = "";
        BufferedWriter bufferedWriter = null;
        String line1 = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
        String line2 = "<SylinkDrop>";
        String line3a = "<Parameters silent=\"1\" smcpassword=\"" + password + "\" ";
        String line3b = "sylinkfile=\"./sylink.xml\" statusfile=\"./SyLinkDropStatus.xml\" />";
        String line4 = "</SylinkDrop>";
        try {
            bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(path + File.separator + "SylinkDropCommand.xml"), "UTF-8"));
            bufferedWriter.write(line1);
            bufferedWriter.newLine();
            bufferedWriter.write(line2);
            bufferedWriter.newLine();
            bufferedWriter.write(line3a + line3b);
            bufferedWriter.newLine();
            bufferedWriter.write(line4);
            bufferedWriter.newLine();
        }
        catch (Throwable throwable) {
            IOUtilities.closeWriter(bufferedWriter);
            throw throwable;
        }
        IOUtilities.closeWriter(bufferedWriter);
    }

    public static void writeSylinkdropOptionsXML(String path) throws IOException {
        BufferedWriter bufferedWriter = null;
        try {
            bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(path + File.separator + "SylinkDropCommand.xml"), "UTF-8"));
            bufferedWriter.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            bufferedWriter.newLine();
            bufferedWriter.write("<SylinkDrop>");
            bufferedWriter.newLine();
            bufferedWriter.write("<Parameters silent=\"1\" sylinkfile=\"Sylink.xml\" StatusFile=\"VPRemoteExecutionStatus.xml\" />");
            bufferedWriter.newLine();
            bufferedWriter.write("</SylinkDrop>");
            bufferedWriter.newLine();
        }
        catch (Throwable throwable) {
            IOUtilities.closeWriter(bufferedWriter);
            throw throwable;
        }
        IOUtilities.closeWriter(bufferedWriter);
    }

    public static void checkCompressedPackageFileIntegrity(String binaryFileName, SoftwarePackage sp) throws IOException {
        long actualSize;
        System.out.println("Checking binary file integrity...file=" + binaryFileName);
        File file = null;
        if (!StringUtilities.isEmpty(binaryFileName)) {
            file = new File(binaryFileName);
        }
        if (file == null || !file.exists()) {
            throw new IOException(MessageResources.getInstance().getString("com.sygate.scm.util.util", "PackageUtil.pkgfileNotExist"));
        }
        long expSize = sp.getPackageInfo().getSize();
        if (expSize != (actualSize = Utility.getFileSize(binaryFileName))) {
            System.out.println("The actual file size (" + actualSize + ") does not match the expected size (" + expSize + ").");
            throw new IOException(MessageResources.getInstance().getString("com.sygate.scm.util.util", "PackageUtil.pkgfileNotIntact"));
        }
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(file);
        }
        catch (IOException e) {
            LoggerUtilities.logException(e);
            throw new IOException(MessageResources.getInstance().getString("com.sygate.scm.util.util", "PackageUtil.pkgfileNotZip"));
        }
        finally {
            try {
                if (zipFile != null) {
                    zipFile.close();
                }
            }
            catch (Exception zipE) {
                LoggerUtilities.logException(zipE);
            }
        }
        System.out.println("Checking binary file integrity...Done");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean setPackageSizeToPackageInfo(PackageInfo pi, String zipFilename) {
        if (zipFilename == null || StringUtilities.isEmpty(zipFilename)) {
            return false;
        }
        long unZippedSize = 0L;
        ZipFile zipFile = null;
        try {
            System.out.println("PackageUtil->setPackageSizeToPackageInfo: " + zipFilename);
            zipFile = new ZipFile(zipFilename);
            ZipEntry entry = null;
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                entry = entries.nextElement();
                if (entry.isDirectory()) continue;
                unZippedSize += entry.getSize();
                String entryName = entry.getName();
                if (!Arrays.asList(ConstantValue.getAllContentArray()).contains(entryName.toLowerCase())) continue;
                PackageLuFile luFile = new PackageLuFile();
                luFile.setFileName(entryName);
                luFile.setzippedSize(entry.getCompressedSize());
                luFile.setUnZippedSize(entry.getSize());
                pi.addPackageLuFile(luFile);
                System.out.println("PackageUtil.setPackageSizeToPackageInfo: Content file: " + entryName + "  Compressed size: " + entry.getCompressedSize() + "  Uncompressed size: " + entry.getSize());
            }
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (zipFile != null) {
                    zipFile.close();
                }
            }
            catch (Exception ignore) {
                LoggerUtilities.logException(ignore);
            }
        }
        long size = Utility.getFileSize(zipFilename);
        pi.setSize(size);
        pi.setOptUnZippedSize(unZippedSize);
        System.out.println("Package new (zip/unzip) size: " + size + "  " + unZippedSize);
        return true;
    }

    public static boolean isClientPackageVersionBefore(SoftwarePackage softwarePackage, String requiredSchemaVersion) {
        boolean isVersionBefore = false;
        if (softwarePackage != null) {
            isVersionBefore = PackageUtil.isClientPackageVersionBefore(softwarePackage.getPackageInfo(), requiredSchemaVersion);
        }
        return isVersionBefore;
    }

    private static boolean isClientPackageVersionBefore(PackageInfo packageInfo, String requiredSchemaVersion) {
        String pkgVersion;
        boolean isVersionBefore = false;
        if (packageInfo != null && !StringUtilities.isEmpty(pkgVersion = packageInfo.getVersion()) && Utility.compareVersion(pkgVersion, requiredSchemaVersion) < 0) {
            isVersionBefore = true;
        }
        return isVersionBefore;
    }

    public static ArrayList<SoftwarePackage> sortPackageListByVersionAndOsType(ArrayList<SoftwarePackage> packages) {
        ArrayList<SoftwarePackage> result = new ArrayList<SoftwarePackage>();
        result.addAll(PackageUtil.sortPackageListByVersion(packages, true, true));
        return result;
    }

    public static List<SoftwarePackage> sortPackageListByVersion(List<SoftwarePackage> packages, boolean includePlatform, boolean isDesc) {
        ArrayList<SoftwarePackage> result = new ArrayList<SoftwarePackage>();
        Comparator comparator = (s1, s2) -> {
            int compareResult = s1 == null && s2 == null ? 0 : (s1 == null ? -1 : (s2 == null ? 1 : PackageUtil.getPackageFormattedVersion(s1.getPackageInfo(), includePlatform).compareTo(PackageUtil.getPackageFormattedVersion(s2.getPackageInfo(), includePlatform))));
            return isDesc ? 0 - compareResult : compareResult;
        };
        result.addAll(packages);
        Collections.sort(result, comparator);
        return result;
    }

    public static boolean isAtleastOneFeatureSelected(String productVersion, ClientInstallationFeatures clientInstallationFeatures) {
        EnabledClientFeatures enabledFeatures;
        if (clientInstallationFeatures != null && (enabledFeatures = ClientInstallFeatureSetUtility.findFeatureVersionFromFeatureSet(productVersion, clientInstallationFeatures)).getClientFeatureCount() == 0) {
            System.out.println("isAtleastOneFeatureSelected >>: Error-> There is no enabled client features for this product version");
            return false;
        }
        return true;
    }

    public static String getPackageFormattedVersion(PackageInfo packageInfo, boolean includePlatForm) {
        String version = PackageUtil.getPackageVersion(packageInfo);
        Object result = version;
        String[] versions = version.split("\\.");
        if (versions.length == 4) {
            result = PackageUtil.isPackageBeforeFerrari(packageInfo) ? (String)(includePlatForm ? PackageUtil.getPackagePlatformType(packageInfo, 3) + PACKAGE_VERSION_SEPARATOR : "") + PackageUtil.getPackageVersion(6, versions[0]) + PACKAGE_VERSION_SEPARATOR + PackageUtil.getPackageVersion(6, versions[1]) + PACKAGE_VERSION_SEPARATOR + PackageUtil.getPackageVersion(8, versions[2]) + PACKAGE_VERSION_SEPARATOR + PackageUtil.getPackageVersion(8, versions[3]) : (String)(includePlatForm ? PackageUtil.getPackagePlatformType(packageInfo, 3) + PACKAGE_VERSION_SEPARATOR : "") + PackageUtil.getPackageVersion(6, versions[0]) + PACKAGE_VERSION_SEPARATOR + PackageUtil.getPackageVersion(6, versions[1]) + PACKAGE_VERSION_SEPARATOR + PackageUtil.getPackageVersion(8, versions[3]) + PACKAGE_VERSION_SEPARATOR + PackageUtil.getPackageVersion(8, versions[2]);
        }
        return result;
    }

    static String getPackagePlatformType(PackageInfo packageInfo, int length) {
        String platformType = Optional.ofNullable(packageInfo.getOptPlatformType()).orElse("");
        int diff = length - platformType.length();
        if (length <= 0) {
            return "";
        }
        if (diff > 0) {
            return platformType + "0".repeat(diff);
        }
        return platformType.substring(0, length);
    }

    static boolean isPackageBeforeFerrari(PackageInfo packageInfo) {
        boolean result = false;
        try {
            String[] versions = PackageUtil.getPackageVersion(packageInfo).split("\\.");
            if (versions.length == 4) {
                result = Integer.parseInt(versions[2]) < 5000 && Integer.parseInt(versions[3]) < 5000 && CIP_VERSION_12_1_STR.equals(versions[0] + PACKAGE_VERSION_SEPARATOR + versions[1]) || "11".equals(versions[0]);
            }
        }
        catch (NumberFormatException ne) {
            logger.log(Level.SEVERE, "getPackageFormatedVersion error: {0}", ne.getMessage());
        }
        return result;
    }

    static String getPackageVersion(PackageInfo packageInfo) {
        return Optional.ofNullable(packageInfo).map(PackageInfo::getOptProductBuildNum).filter(StringUtils::isNotBlank).orElse(Optional.ofNullable(packageInfo).map(PackageInfo::getVersion).filter(StringUtils::isNotBlank).orElse(""));
    }

    private static String getPackageVersion(int length, String version) {
        StringBuffer result = new StringBuffer();
        int originalLength = version.length();
        for (int i = 0; originalLength < length && i < length - originalLength; ++i) {
            result.append("0");
        }
        result.append(version);
        return result.toString();
    }

    static {
        IGNORE_FILES_IN_PACKLIST = new String[]{"serdef.dat", IDS_FILE, CONFIG_XML, SETAID_INI, NE_LICENSE, "sep.slf", "snac.slf", "VDefs.zip", "rvdefs.zip", "IronDefs.zip", "IronWLDefs.zip", "IronRevokeDefs.zip", "IDSDefs.zip", "IPSDef.zip", "BashDefs.zip", HI_CONTENT_FILE, "VDefHub.zip", "vdefhub.zip", "IDSHub.zip", "SMRDefs.zip", "Contents.info", "EDRDefs.zip", "STICDefs.zip", "AdvMLStaticDefs.zip", "NTRDefs.zip"};
    }
}

