/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.util;

import com.sygate.scm.common.configobject.schema.ClientFeature;
import com.sygate.scm.common.configobject.schema.EnabledClientFeatures;
import com.sygate.scm.util.ContentFileCleaner;
import com.sygate.scm.util.StringUtilities;
import com.sygate.scm.util.Utility;
import java.io.File;
import java.util.HashSet;
import java.util.Set;

public class PackageContentsUtil {
    public static void cleanupContents(String contentFileDir, EnabledClientFeatures enabledFeatures) {
        PackageContentsUtil.cleanupContents_current(contentFileDir, enabledFeatures);
        PackageContentsUtil.cleanupContents_legacy(contentFileDir, enabledFeatures);
    }

    private static void cleanupContents_current(String contentFileDir, EnabledClientFeatures enabledFeatures) {
        if (null == enabledFeatures || Utility.compareVersion(enabledFeatures.getOptMinVersion(), "12.1.0.0") < 0) {
            return;
        }
        ContentFileCleaner virusContentCleaner = new ContentFileCleaner(new String[]{contentFileDir + File.separator + "VDefs.zip", contentFileDir + File.separator + "rvdefs.zip", contentFileDir + File.separator + "VDefHub.zip", contentFileDir + File.separator + "V15Defs.zip", contentFileDir + File.separator + "V3Defs.zip", contentFileDir + File.separator + "AdvMLStaticDefs.zip", contentFileDir + File.separator + "ApPortalDefs.zip", contentFileDir + File.separator + "SMRDefs.zip"}, new String[]{"SAVMain", "Download", "OutlookSnapin", "NotesSnapin", "Pop3Smtp", "TruScan", "Intrusion Prevention"});
        ContentFileCleaner bashContentCleaner = new ContentFileCleaner(new String[]{contentFileDir + File.separator + "BashDefs.zip", contentFileDir + File.separator + "EDRDefs.zip"}, new String[]{"SAVMain", "Download", "OutlookSnapin", "NotesSnapin", "Pop3Smtp", "TruScan", "Intrusion Prevention"});
        ContentFileCleaner idsContentCleaner = new ContentFileCleaner(new String[]{contentFileDir + File.separator + "IDSDefs.zip", contentFileDir + File.separator + "IDSHub.zip"}, new String[]{"Download", "TruScan", "Intrusion Prevention", "ITPMain"});
        ContentFileCleaner ironContentCleaner = new ContentFileCleaner(new String[]{contentFileDir + File.separator + "IronDefs.zip", contentFileDir + File.separator + "IronWLDefs.zip", contentFileDir + File.separator + "IronRevokeDefs.zip"}, new String[]{"SAVMain", "Download", "OutlookSnapin", "NotesSnapin", "Pop3Smtp", "TruScan"});
        ContentFileCleaner.ContentFileCleanerWorker worker = new ContentFileCleaner.ContentFileCleanerWorker(new ContentFileCleaner[]{virusContentCleaner, bashContentCleaner, idsContentCleaner, ironContentCleaner}, enabledFeatures);
        worker.startWork();
    }

    private static void cleanupContents_legacy(String contentFileDir, EnabledClientFeatures enabledFeatures) {
        if (null == enabledFeatures || Utility.compareVersion(enabledFeatures.getOptMinVersion(), "12.1.0.0") >= 0) {
            return;
        }
        ContentFileCleaner viriusContentCleaner = new ContentFileCleaner(new String[]{contentFileDir + File.separator + "VDefHub.zip", contentFileDir + File.separator + "VDefs.zip"}, new String[]{"SAVMain", "OutlookSnapin", "NotesSnapin", "Pop3Smtp", "TruScan"});
        ContentFileCleaner ipsContentCleaner = new ContentFileCleaner(new String[]{contentFileDir + File.separator + "IPSDef.zip"}, new String[]{"Firewall"});
        ContentFileCleaner.ContentFileCleanerWorker worker = new ContentFileCleaner.ContentFileCleanerWorker(new ContentFileCleaner[]{viriusContentCleaner, ipsContentCleaner}, enabledFeatures);
        worker.startWork();
    }

    public static boolean isAVDefsFile(String luFileName) {
        boolean result = false;
        if (!StringUtilities.isEmpty(luFileName) && (luFileName.equalsIgnoreCase("VDefs.zip") || luFileName.equalsIgnoreCase("rvdefs.zip") || luFileName.equalsIgnoreCase("V15Defs.zip") || luFileName.equalsIgnoreCase("V3Defs.zip") || luFileName.equalsIgnoreCase("AdvMLStaticDefs.zip"))) {
            result = true;
        }
        return result;
    }

    public static Set<String> getPackageLuContentFileNames(EnabledClientFeatures enabledFeatures, boolean reduced, String packageVersion, boolean useLbContent) {
        HashSet<String> contentNames = new HashSet<String>();
        if (enabledFeatures == null || Utility.compareVersion(enabledFeatures.getOptMinVersion(), "12.1.0.0") < 0) {
            return contentNames;
        }
        if (Utility.compareVersion(enabledFeatures.getOptMinVersion(), "12.1.2000.0") == 0) {
            contentNames.add("EFAVTDefs.zip");
        }
        if (Utility.compareVersion(packageVersion, "12.1.4400.5000") >= 0) {
            contentNames.add("SMRDefs.zip");
        }
        if (Utility.compareVersion(packageVersion, "12.1.5394.6000") >= 0) {
            contentNames.add("HIDefs.zip");
        }
        if (Utility.compareVersion(packageVersion, "12.2.0.0") >= 0) {
            contentNames.add("STICDefs.zip");
            contentNames.add("EDRDefs.zip");
        }
        if (Utility.compareVersion(packageVersion, "14.0.0.1000") > 0) {
            contentNames.add("NTRDefs.zip");
        }
        if (Utility.compareVersion(packageVersion, "14.2.0.1000", true) >= 0) {
            contentNames.add("PCHDefs.zip");
            contentNames.add("TDADDefs.zip");
        }
        HashSet<String> av = new HashSet<String>();
        if (Utility.compareVersion(packageVersion, "12.2.0.0") < 0) {
            if (!reduced) {
                av.add("VDefs.zip");
            } else {
                av.add("rvdefs.zip");
            }
        } else if (Utility.compareVersion(packageVersion, "12.2.0.0") >= 0) {
            if (!reduced) {
                av.add("V15Defs.zip");
            } else if (useLbContent) {
                if (Utility.compareVersion(packageVersion, "14.0.0.1000", true) >= 0) {
                    av.add("AdvMLStaticDefs.zip");
                } else {
                    av.add("V3Defs.zip");
                }
            } else {
                av.add("V3Defs.zip");
            }
        }
        if (Utility.compareVersion(packageVersion, "14.3.0.3000", true) < 0) {
            av.add("ApPortalDefs.zip");
        }
        HashSet<String> avReqFeatures = new HashSet<String>();
        avReqFeatures.add("SAVMain");
        avReqFeatures.add("Download");
        avReqFeatures.add("OutlookSnapin");
        avReqFeatures.add("NotesSnapin");
        avReqFeatures.add("Pop3Smtp");
        avReqFeatures.add("TruScan");
        PackageContentsUtil.getPackageLuContentFileNames(contentNames, av, avReqFeatures, enabledFeatures);
        HashSet<String> bash = new HashSet<String>();
        bash.add("BashDefs.zip");
        HashSet<String> bashReqFeatures = new HashSet<String>();
        bashReqFeatures.add("SAVMain");
        bashReqFeatures.add("Download");
        bashReqFeatures.add("OutlookSnapin");
        bashReqFeatures.add("NotesSnapin");
        bashReqFeatures.add("Pop3Smtp");
        bashReqFeatures.add("TruScan");
        PackageContentsUtil.getPackageLuContentFileNames(contentNames, bash, bashReqFeatures, enabledFeatures);
        HashSet<String> ids = new HashSet<String>();
        ids.add("IDSDefs.zip");
        HashSet<String> idsReqFeatures = new HashSet<String>();
        idsReqFeatures.add("Download");
        idsReqFeatures.add("TruScan");
        idsReqFeatures.add("ITPMain");
        PackageContentsUtil.getPackageLuContentFileNames(contentNames, ids, idsReqFeatures, enabledFeatures);
        HashSet<String> iron = new HashSet<String>();
        iron.add("IronDefs.zip");
        iron.add("IronWLDefs.zip");
        iron.add("IronRevokeDefs.zip");
        HashSet<String> ironReqFeatures = new HashSet<String>();
        ironReqFeatures.add("SAVMain");
        ironReqFeatures.add("Download");
        ironReqFeatures.add("OutlookSnapin");
        ironReqFeatures.add("NotesSnapin");
        ironReqFeatures.add("Pop3Smtp");
        ironReqFeatures.add("TruScan");
        PackageContentsUtil.getPackageLuContentFileNames(contentNames, iron, ironReqFeatures, enabledFeatures);
        return contentNames;
    }

    private static void getPackageLuContentFileNames(Set<String> contentNames, Set<String> reqContentNames, Set<String> reqFeatures, EnabledClientFeatures enabledFeatures) {
        for (ClientFeature clientFeature : enabledFeatures.getClientFeature()) {
            if (!clientFeature.getOptEnabled().booleanValue() || !reqFeatures.contains(clientFeature.getFeatureName())) continue;
            contentNames.addAll(reqContentNames);
            return;
        }
    }
}

