/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class OutputStreamLogger
extends ByteArrayOutputStream {
    private final Logger logger;
    private final Level level;
    private final String lineSeparator;

    public OutputStreamLogger(Logger logger, Level level) {
        this.logger = logger;
        this.level = level;
        this.lineSeparator = System.getProperty("line.separator");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() throws IOException {
        OutputStreamLogger outputStreamLogger = this;
        synchronized (outputStreamLogger) {
            super.flush();
            String record = this.toString("UTF-8");
            super.reset();
            if (record.length() == 0 || record.equals(this.lineSeparator)) {
                return;
            }
            this.logger.logp(this.level, "", "", record);
        }
    }
}

