/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.util;

public final class OpenSSLKey {
    private static final int[] RSA_ENCRYPTION = new int[]{1, 2, 840, 113549, 1, 1, 1};
    private static final byte[] nullBytes = new byte[]{5, 0};

    public byte[] convertPrivateKey(byte[] b) {
        if (b == null) {
            return null;
        }
        byte[] bytes = new byte[b.length];
        System.arraycopy(b, 0, bytes, 0, b.length);
        byte[] octetBytes = this.encodeOctetString(bytes);
        byte[] oidBytes = this.encodeOID(RSA_ENCRYPTION);
        byte[] verBytes = new byte[]{2, 1, 0};
        byte[][] seqBytes = new byte[4][];
        seqBytes[0] = oidBytes;
        seqBytes[1] = nullBytes;
        seqBytes[2] = null;
        byte[] oidSeqBytes = this.encodeSequence(seqBytes);
        seqBytes[0] = verBytes;
        seqBytes[1] = oidSeqBytes;
        seqBytes[2] = octetBytes;
        seqBytes[3] = null;
        return this.encodeSequence(seqBytes);
    }

    private byte[] encodeOID(int[] oid) {
        int len = 0;
        int offset = 0;
        int oLen = 0;
        if (oid == null) {
            return null;
        }
        oLen = 1;
        for (int i = 2; i < oid.length; ++i) {
            oLen += this.getOIDCompLength(oid[i]);
        }
        len = oLen + this.getLengthOfLengthField(oLen) + 1;
        byte[] bytes = new byte[len];
        bytes[0] = 6;
        offset = this.writeLengthField(bytes, oLen);
        bytes[offset++] = (byte)(40 * oid[0] + oid[1]);
        for (int i = 2; i < oid.length; ++i) {
            offset = this.writeOIDComp(oid[i], bytes, offset);
        }
        return bytes;
    }

    private byte[] encodeOctetString(byte[] bytes) {
        int len = 0;
        int offset = 0;
        int oLen = 0;
        if (bytes == null) {
            return null;
        }
        oLen = bytes.length;
        len = oLen + this.getLengthOfLengthField(oLen) + 1;
        byte[] newBytes = new byte[len];
        newBytes[0] = 4;
        offset = this.writeLengthField(newBytes, oLen);
        if (len - oLen != offset) {
            return null;
        }
        System.arraycopy(bytes, 0, newBytes, offset, oLen);
        return newBytes;
    }

    private byte[] encodeSequence(byte[][] byteArrays) {
        int len = 0;
        int offset = 0;
        int oLen = 0;
        if (byteArrays == null) {
            return null;
        }
        for (int i = 0; i < byteArrays.length && byteArrays[i] != null; ++i) {
            oLen += byteArrays[i].length;
        }
        len = oLen + this.getLengthOfLengthField(oLen) + 1;
        byte[] bytes = new byte[len];
        bytes[0] = 48;
        offset = this.writeLengthField(bytes, oLen);
        if (len - oLen != offset) {
            return null;
        }
        for (int i = 0; i < byteArrays.length && byteArrays[i] != null; ++i) {
            System.arraycopy(byteArrays[i], 0, bytes, offset, byteArrays[i].length);
            offset += byteArrays[i].length;
        }
        return bytes;
    }

    private int writeLengthField(byte[] bytes, int len) {
        if (len < 127) {
            bytes[1] = (byte)len;
            return 2;
        }
        int lenOfLenField = this.getLengthOfLengthField(len);
        bytes[1] = (byte)(lenOfLenField - 1 | 0x80);
        for (int i = lenOfLenField; i >= 2; --i) {
            int length = len >>> (lenOfLenField - i) * 8;
            bytes[i] = (byte)length;
        }
        return lenOfLenField + 1;
    }

    private int getLengthOfLengthField(int len) {
        if (len <= 127) {
            return 1;
        }
        if (len <= 255) {
            return 2;
        }
        if (len <= 65535) {
            return 3;
        }
        if (len <= 0xFFFFFF) {
            return 4;
        }
        return 5;
    }

    private int getOIDCompLength(int comp) {
        if (comp <= 127) {
            return 1;
        }
        if (comp <= 16383) {
            return 2;
        }
        if (comp <= 0x1FFFFF) {
            return 3;
        }
        if (comp <= 0xFFFFFFF) {
            return 4;
        }
        return 5;
    }

    private int writeOIDComp(int comp, byte[] bytes, int offset) {
        int len = this.getOIDCompLength(comp);
        for (int i = len - 1; i > 0; --i) {
            bytes[offset++] = (byte)(comp >>> i * 7 | 0x80);
        }
        bytes[offset++] = (byte)(comp & 0x7F);
        return offset;
    }
}

