/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.util;

import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.StringUtilities;
import com.sygate.scm.util.Utility;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class NetworkUtils {
    private static Logger logger = Logger.getLogger(NetworkUtils.class.getName());

    public static String getHostAddress() {
        try {
            return InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException ex) {
            logger.log(Level.WARNING, ex.getMessage());
            return "Unknown Host Address";
        }
    }

    public static String getLocalIpv6Addresses() {
        StringBuffer ips = new StringBuffer("");
        try {
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            while (interfaces.hasMoreElements()) {
                NetworkInterface ifc = interfaces.nextElement();
                if (!ifc.isUp()) continue;
                Enumeration<InetAddress> addres = ifc.getInetAddresses();
                while (addres.hasMoreElements()) {
                    InetAddress addr = addres.nextElement();
                    if (addr instanceof Inet4Address || addr.isLoopbackAddress() || addr.isLinkLocalAddress()) continue;
                    if (!StringUtilities.isEmpty(ips.toString())) {
                        ips.append(",");
                    }
                    ips.append(Utility.shortenIpv6Address(addr.getHostAddress()));
                }
            }
        }
        catch (Exception ex) {
            LoggerUtilities.logException(ex);
        }
        return ips.toString();
    }

    public static String getLocalHostAddresses() {
        String ipv6Address = NetworkUtils.getLocalIpv6Addresses();
        if (!StringUtilities.isEmpty(ipv6Address)) {
            return ipv6Address;
        }
        return Utility.getAllLocalHostIPs();
    }

    public static boolean isLocalAddress(String remoteIp) {
        if (StringUtilities.isEmpty(remoteIp)) {
            return false;
        }
        return NetworkUtils.getAllLocalIPAddress(false).contains(Utility.getDecompressedIpv6Addr(remoteIp.toLowerCase()));
    }

    public static Set<String> getAllLocalIPAddress(Boolean isShortIp) {
        return NetworkUtils.getAllLocalIPAddress(isShortIp, false);
    }

    public static Set<String> getAllLocalIPAddress(boolean isShortIp, boolean isAddLoopbackAddress) {
        HashSet<String> result = new HashSet<String>();
        try {
            Enumeration<NetworkInterface> netInterfaces = NetworkInterface.getNetworkInterfaces();
            while (netInterfaces.hasMoreElements()) {
                Enumeration<InetAddress> ips = netInterfaces.nextElement().getInetAddresses();
                while (ips.hasMoreElements()) {
                    InetAddress ip = ips.nextElement();
                    if (ip.isLoopbackAddress() && !isAddLoopbackAddress) continue;
                    String ipStr = ip.getHostAddress().toLowerCase();
                    int pos = ipStr.indexOf("%");
                    if (pos >= 0) {
                        ipStr = ipStr.substring(0, pos);
                    }
                    if (isShortIp) {
                        result.add(Utility.shortenIpv6Address(ipStr).toLowerCase());
                        continue;
                    }
                    result.add(Utility.getDecompressedIpv6Addr(ipStr).toLowerCase());
                }
            }
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, ex.getMessage());
        }
        return result;
    }

    public static boolean isLoopbackAddress(String ipAddress) {
        if (StringUtilities.isEmpty(ipAddress)) {
            return false;
        }
        InetAddress ip = null;
        try {
            ip = InetAddress.getByName(ipAddress);
        }
        catch (UnknownHostException ex) {
            logger.log(Level.WARNING, ex.getMessage());
        }
        if (ip == null) {
            return false;
        }
        return ip.isLoopbackAddress();
    }

    public static String getNonLoopBackLocalAddress() {
        InetAddress[] localhostArray;
        InetAddress linkLocalAddress = null;
        try {
            localhostArray = InetAddress.getAllByName(InetAddress.getLocalHost().getHostName());
        }
        catch (Exception ex) {
            logger.info(ex.getMessage());
            return "";
        }
        for (InetAddress localHostAddr : localhostArray) {
            if (localHostAddr.isLoopbackAddress()) continue;
            if (localHostAddr.isLinkLocalAddress()) {
                linkLocalAddress = localHostAddr;
                continue;
            }
            return localHostAddr.getHostAddress();
        }
        if (linkLocalAddress != null) {
            String ipStr = linkLocalAddress.getHostAddress();
            int pos = ipStr.indexOf("%");
            if (pos >= 0) {
                ipStr = ipStr.substring(0, pos);
            }
            return ipStr;
        }
        return "";
    }
}

