/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.util;

import com.sygate.scm.common.configobject.schema.NtrPolicy;
import com.sygate.scm.util.StringUtilities;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class NTRPolicyUtility {
    private static final String OPTIONAL_TOKEN_PREFIX_RE = "(?:[a-z0-9A-Z\\.]{1,50}:)?";
    private static final String FULL_CIA_TOKEN_RE = "[^-]{32}-[^-]{32}-(\\d{1,10})";
    private static final String TUNNEL_TOKEN_RE = "(?:[a-z0-9A-Z\\.]{1,50}:)?(?:(?:[^-]{32}-[^-]{32}-(\\d{1,10}))|(?:\\d{1,10})|(?:[^-]{32}))";
    private static final Pattern TUNNEL_TOKEN_PATTERN = Pattern.compile("(?:[a-z0-9A-Z\\.]{1,50}:)?(?:(?:[^-]{32}-[^-]{32}-(\\d{1,10}))|(?:\\d{1,10})|(?:[^-]{32}))");
    private static final Pattern TUNNEL_TOKEN_CTCv2_PATTERN = Pattern.compile("^([a-z0-9A-Z.]{1,15}:)?(\\d{1,10}\\.)([A-Za-z0-9-_]{64})$");
    private static Logger logger = Logger.getLogger(NTRPolicyUtility.class.getName());

    public static boolean isValidCiaIntegrationTokenFormat(NtrPolicy ntrPolicy) {
        return NTRPolicyUtility.getCiaIntegrationTokenFormat(ntrPolicy.getOptCiaCustomerToken()) != TokenFormat.BAD;
    }

    public static TokenFormat getCiaIntegrationTokenFormat(String token) {
        if (StringUtilities.isEmpty(token)) {
            return TokenFormat.BAD;
        }
        Matcher matcher = TUNNEL_TOKEN_PATTERN.matcher(token);
        boolean isValid = matcher.matches();
        if (isValid && matcher.group(1) != null) {
            String version = matcher.group(1);
            try {
                if (Integer.parseInt(version) < 1) {
                    isValid = false;
                }
            }
            catch (NumberFormatException ex) {
                isValid = false;
            }
        }
        if (isValid) {
            return TokenFormat.CTCV1;
        }
        isValid = TUNNEL_TOKEN_CTCv2_PATTERN.matcher(token).matches();
        return isValid ? TokenFormat.CTCV2 : TokenFormat.BAD;
    }

    public static boolean isTokenValidAndFormatCTCV2(NtrPolicy ntrPolicy) {
        String tokenString = ntrPolicy.getOptCiaCustomerToken();
        if (StringUtilities.isEmpty(tokenString)) {
            logger.log(Level.INFO, "Found empty token");
            return false;
        }
        logger.log(Level.INFO, "Found non empty token, validating it");
        TokenFormat tokenFormatValue = NTRPolicyUtility.getCiaIntegrationTokenFormat(tokenString);
        boolean isValid = tokenFormatValue != TokenFormat.BAD;
        logger.log(Level.INFO, "Token is Valid? : " + isValid + "  Token format: " + tokenFormatValue.toString());
        if (isValid && tokenFormatValue == TokenFormat.CTCV2) {
            logger.log(Level.INFO, "Token is valid and of format CTCV2 ");
            return true;
        }
        return false;
    }

    public static enum TokenFormat {
        BAD,
        CTCV1,
        CTCV2;

    }
}

