/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.util;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.schema.EnforcedHiRequirementArray;
import com.sygate.scm.common.configobject.schema.HiHostIntegrityPolicy;
import com.sygate.scm.common.configobject.schema.HiReqTemplate;
import com.sygate.scm.common.configobject.schema.HiRequirement;
import com.sygate.scm.common.configobject.schema.HiRequirementSystem;
import com.sygate.scm.common.configobject.schema.HiScriptBlock;
import com.sygate.scm.common.configobject.schema.HostIntegritySetting;
import com.sygate.scm.common.configobject.schema.HostIntegrityTrigger;
import com.sygate.scm.common.configobject.schema.MacHiRequirementSystem;
import com.sygate.scm.common.configobject.schema.UnknownContent;
import com.sygate.scm.hi.library.AswSignatureAgeCriteria;
import com.sygate.scm.hi.library.AswSignatureDateCriteria;
import com.sygate.scm.hi.library.AvSignatureAgeCriteria;
import com.sygate.scm.hi.library.AvSignatureDateCriteria;
import com.sygate.scm.hi.library.EnforceAswSignature;
import com.sygate.scm.hi.library.EnforceAvSignature;
import com.sygate.scm.hi.library.HiParm_CheckAswUpToDate;
import com.sygate.scm.hi.library.HiParm_CheckAvInstallation;
import com.sygate.scm.hi.library.HiParm_CheckAvRunning;
import com.sygate.scm.hi.library.HiParm_CheckAvUpToDate;
import com.sygate.scm.hi.library.HiParm_CheckFwInstallation;
import com.sygate.scm.hi.library.HiParm_CheckFwRunning;
import com.sygate.scm.hi.library.HiParm_CheckOS;
import com.sygate.scm.hi.library.HiParm_EnforceAsw;
import com.sygate.scm.hi.library.HiParm_EnforceAv;
import com.sygate.scm.hi.library.HiParm_EnforceFw;
import com.sygate.scm.hi.library.HiParm_EnforcePatch;
import com.sygate.scm.hi.library.HiParm_EnforceServicePack;
import com.sygate.scm.util.IntegerRange;
import com.sygate.scm.util.IntegerSet;
import com.sygate.scm.util.StringUtilities;
import com.sygate.scm.util.XPathSchemaUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public final class MigHIPolicyUtils {
    private static final MigHIPolicyUtils instance = new MigHIPolicyUtils();
    private static final Map<String, String> OS_MASK_MAP = new HashMap<String, String>();
    private static final Set<String> UNSUPPORTED_OS_MASK_SET = new HashSet<String>();
    private static final Set<String> UNSUPPORTED_FW_TYPE_SET = new HashSet<String>();
    private static final Map<String, String> AV_TYPE_STR_MAP = new HashMap<String, String>();
    public static final long MAX_AGE_VALUE = 18200L;
    public static final long MAX_AGE_VALUE_IN_SECONDS = 1572480000L;

    private MigHIPolicyUtils() {
    }

    public static MigHIPolicyUtils getInstance() {
        return instance;
    }

    private void log(String msg) {
        System.out.println(msg);
    }

    public boolean migrateSSEPWinHiPolicy(HiHostIntegrityPolicy policy) throws Exception {
        EnforcedHiRequirementArray ssepReqArray;
        if (policy == null) {
            return false;
        }
        this.log("Begin to migrate SSEP Windows HI policy, policy name:" + policy.getName());
        int processedNum = 0;
        HiRequirementSystem ssepReqSystem = policy.getOptHiRequirementSystem();
        if (ssepReqSystem != null && (ssepReqArray = ssepReqSystem.getOptEnforcedHiRequirementArray()) != null && ssepReqArray.getHiRequirementCount() > 0) {
            Vector<HiRequirement> ssepReqs = ssepReqArray.getHiRequirement();
            for (HiRequirement ssepReq : ssepReqs) {
                this.log("Begin to migrate Requirement, requirement name:" + ssepReq.getName());
                Vector<AbstractSchema> unknownContectVec = XPathSchemaUtil.getAllChilrenOfType(ssepReq, 1);
                if (unknownContectVec == null || unknownContectVec.size() <= 0) continue;
                for (UnknownContent unknownContent : unknownContectVec) {
                    if (this.processUnmatchedItems(unknownContent)) {
                        ++processedNum;
                    }
                    if (this.processUnsupportItems(ssepReqArray, ssepReq, unknownContent)) {
                        ++processedNum;
                    }
                    if (!this.processAgeValue(unknownContent)) continue;
                    ++processedNum;
                }
            }
        }
        return processedNum > 0;
    }

    public boolean migrateHIPolicyAdvanceSetting(HiHostIntegrityPolicy policy) throws Exception {
        boolean processed = false;
        if (policy != null) {
            this.log("Begin to migrate policy advance setting, policy name:" + policy.getName());
            HostIntegrityTrigger trigger = policy.getHostIntegrityTrigger();
            HostIntegritySetting setting = policy.getHostIntegritySetting();
            if (trigger != null && setting != null) {
                Long historyTime;
                Long triggerTime = trigger.getOptHostIntegrityTimer();
                if (triggerTime == null) {
                    triggerTime = trigger.getDefHostIntegrityTimer();
                }
                if ((historyTime = setting.getOptMaxHistoryTime()) == null) {
                    historyTime = setting.getDefMaxHistoryTime();
                }
                if (historyTime < triggerTime) {
                    this.log("Change history time to match trigger time, history time:" + String.valueOf(historyTime) + ", trigger time:" + String.valueOf(triggerTime));
                    setting.setOptMaxHistoryTime(triggerTime);
                    processed = true;
                }
            }
        }
        return processed;
    }

    public boolean migrateSSEPMacHIPolicy(HiHostIntegrityPolicy policy, Map<String, HiReqTemplate> hiLibObj) throws Exception {
        EnforcedHiRequirementArray ssepReqArray;
        HiRequirementSystem ssepReqSystem = policy.getOptHiRequirementSystem();
        MacHiRequirementSystem sepMacSystem = null;
        EnforcedHiRequirementArray sepMacArray = null;
        if (ssepReqSystem != null && (ssepReqArray = ssepReqSystem.getOptEnforcedHiRequirementArray()) != null && ssepReqArray.getHiRequirementCount() > 0) {
            sepMacSystem = new MacHiRequirementSystem();
            sepMacArray = new EnforcedHiRequirementArray();
            Vector<HiRequirement> ssepReqs = ssepReqArray.getHiRequirement();
            for (HiRequirement ssepReq : ssepReqs) {
                if (hiLibObj != null) {
                    HiScriptBlock scriptBlk = ssepReq.getHiScript().getHiScriptBlock().get(0);
                    String funcName = scriptBlk.getOptHiRETURN().getOptHiCALL().getFuncName();
                    sepMacArray.addHiRequirement(this.convertSSEPMacHIPolicyToAmber(funcName, hiLibObj));
                    continue;
                }
                HiRequirement sepMacReq = (HiRequirement)AbstractSchema.readXML(ssepReq.getDocument());
                sepMacReq.setOptReqOsType("Mac");
                sepMacArray.addHiRequirement(sepMacReq);
            }
            sepMacSystem.setOptEnforcedHiRequirementArray(sepMacArray);
            policy.setOptMacHiRequirementSystem(sepMacSystem);
            policy.setOptHiRequirementSystem(null);
            policy.setOptOsType(null);
            return true;
        }
        return false;
    }

    private HiRequirement convertSSEPMacHIPolicyToAmber(String functionName, Map<String, HiReqTemplate> hiLibObj) throws Exception {
        HiRequirement hiRequirement;
        block5: {
            block9: {
                block8: {
                    block7: {
                        block6: {
                            hiRequirement = null;
                            if (!functionName.equalsIgnoreCase("IpfwStart")) break block6;
                            for (Map.Entry<String, HiReqTemplate> pairs : hiLibObj.entrySet()) {
                                String hiReqName = pairs.getKey().toString();
                                if (!hiReqName.contains("FirewallRunning")) continue;
                                HiReqTemplate hiTemplate = pairs.getValue();
                                hiRequirement = hiTemplate.getHiRequirement();
                                hiRequirement.setName("IPFirewall Running");
                                hiRequirement.setOptReqOsType("Mac");
                                break block5;
                            }
                            break block5;
                        }
                        if (!functionName.contains("confidentialUpdate")) break block7;
                        for (Map.Entry<String, HiReqTemplate> pairs : hiLibObj.entrySet()) {
                            String hiReqName = pairs.getKey().toString();
                            if (!hiReqName.contains("NortonConfidential")) continue;
                            HiReqTemplate hiTemplate = pairs.getValue();
                            hiRequirement = hiTemplate.getHiRequirement();
                            hiRequirement.setName("Norton Confidential is installed");
                            hiRequirement.setOptReqOsType("Mac");
                            break block5;
                        }
                        break block5;
                    }
                    if (!functionName.contains("NortonEnable")) break block8;
                    for (Map.Entry<String, HiReqTemplate> pairs : hiLibObj.entrySet()) {
                        String hiReqName = pairs.getKey().toString();
                        if (!hiReqName.contains("SAV-APEnabled")) continue;
                        HiReqTemplate hiTemplate = pairs.getValue();
                        hiRequirement = hiTemplate.getHiRequirement();
                        hiRequirement.setName("Symantec anti-virus production Auto-Protect is enabled");
                        hiRequirement.setOptReqOsType("Mac");
                        break block5;
                    }
                    break block5;
                }
                if (!functionName.contains("SavInstall")) break block9;
                for (Map.Entry<String, HiReqTemplate> pairs : hiLibObj.entrySet()) {
                    String hiReqName = pairs.getKey().toString();
                    if (!hiReqName.contains("SAVInstalled")) continue;
                    HiReqTemplate hiTemplate = pairs.getValue();
                    hiRequirement = hiTemplate.getHiRequirement();
                    hiRequirement.setName("Symantec anti-virus production is installed");
                    hiRequirement.setOptReqOsType("Mac");
                    break block5;
                }
                break block5;
            }
            if (!functionName.contains("SystemUpdate")) break block5;
            for (Map.Entry<String, HiReqTemplate> pairs : hiLibObj.entrySet()) {
                String hiReqName = pairs.getKey().toString();
                if (!hiReqName.contains("MacUpdate")) continue;
                HiReqTemplate hiTemplate = pairs.getValue();
                hiRequirement = hiTemplate.getHiRequirement();
                hiRequirement.setName("Mac OS update is up to date");
                hiRequirement.setOptReqOsType("Mac");
                break;
            }
        }
        return hiRequirement;
    }

    private boolean processUnmatchedItems(UnknownContent content) throws Exception {
        boolean processed = false;
        ConfigObject schema = (ConfigObject)AbstractSchema.readXML(content.getContent());
        if (schema != null) {
            if (this.processUnmatchedOSType(schema)) {
                content.setConent(schema.getBytes());
                processed |= true;
            }
            if (this.processUnmatchedAVTypeString(schema)) {
                content.setConent(schema.getBytes());
                processed |= true;
            }
        }
        return processed;
    }

    private boolean processUnsupportItems(EnforcedHiRequirementArray ssepReqArray, HiRequirement ssepReq, UnknownContent content) throws Exception {
        boolean processed = false;
        ConfigObject schema = (ConfigObject)AbstractSchema.readXML(content.getContent());
        if (schema != null) {
            RET_STATUS status = this.processUnsupportOSType(schema);
            if (status == RET_STATUS.PROCESSED) {
                content.setConent(schema.getBytes());
                processed |= true;
            } else if (status == RET_STATUS.NEED_REMOVE_PARENT) {
                this.log("Since this requirement contains unsupported OS Type, Remove the requirement during the migration, requirement name:" + ssepReq.getName());
                ssepReqArray.removeHiRequirement(ssepReq);
                return true;
            }
            status = this.processUnsupportFWType(schema);
            if (status == RET_STATUS.NEED_REMOVE_PARENT) {
                this.log("Since this requirement contains unsupported FW, Remove the requirement during the migration, requirement name:" + ssepReq.getName());
                ssepReqArray.removeHiRequirement(ssepReq);
                return true;
            }
        }
        return processed;
    }

    private boolean processAgeValue(UnknownContent content) throws Exception {
        boolean processed = false;
        ConfigObject schema = (ConfigObject)AbstractSchema.readXML(content.getContent());
        if (schema != null) {
            HiParm_EnforceAsw obj;
            EnforceAswSignature aswSig;
            if (schema instanceof HiParm_CheckAswUpToDate) {
                AswSignatureDateCriteria dateSignature;
                long age;
                Long ageValue;
                HiParm_CheckAswUpToDate obj2 = (HiParm_CheckAswUpToDate)schema;
                AswSignatureAgeCriteria signature = obj2.getOptAswSignatureAgeCriteria();
                if (signature != null && (ageValue = signature.getAgeValue()) != null && (age = ageValue.longValue()) > 1572480000L) {
                    age = 1572480000L;
                    signature.setAgeValue(age);
                    processed = true;
                    this.log("Change the HiParm_CheckAswUpToDate age to max age");
                }
                if ((dateSignature = obj2.getOptAswSignatureDateCriteria()) != null) {
                    Long dateValue = dateSignature.getDateValue();
                    dateSignature.setDateValue(this.processDateValue(dateValue));
                    processed = true;
                    this.log("Updated the HiParm_CheckAvUpToDate date value");
                }
            } else if (schema instanceof HiParm_CheckAvUpToDate) {
                AvSignatureDateCriteria dateSignature;
                long age;
                Long ageValue;
                HiParm_CheckAvUpToDate obj3 = (HiParm_CheckAvUpToDate)schema;
                AvSignatureAgeCriteria signature = obj3.getOptAvSignatureAgeCriteria();
                if (signature != null && (ageValue = signature.getAgeValue()) != null && (age = ageValue.longValue()) > 1572480000L) {
                    age = 1572480000L;
                    signature.setAgeValue(age);
                    processed = true;
                    this.log("Change the HiParm_CheckAvUpToDate age to max age");
                }
                if ((dateSignature = obj3.getOptAvSignatureDateCriteria()) != null) {
                    Long dateValue = dateSignature.getDateValue();
                    dateSignature.setDateValue(this.processDateValue(dateValue));
                    processed = true;
                    this.log("Updated the HiParm_CheckAvUpToDate date value");
                }
            } else if (schema instanceof HiParm_EnforceAv) {
                HiParm_EnforceAv obj4 = (HiParm_EnforceAv)schema;
                EnforceAvSignature avSig = obj4.getOptEnforceAvSignature();
                if (avSig != null) {
                    AvSignatureDateCriteria dateSignature;
                    long age;
                    Long ageValue;
                    AvSignatureAgeCriteria ageSig = avSig.getOptAvSignatureAgeCriteria();
                    if (ageSig != null && (ageValue = ageSig.getAgeValue()) != null && (age = ageValue.longValue()) > 1572480000L) {
                        age = 1572480000L;
                        ageSig.setAgeValue(age);
                        processed = true;
                        this.log("Change the HiParm_EnforceAv age to max age");
                    }
                    if ((dateSignature = avSig.getOptAvSignatureDateCriteria()) != null) {
                        Long dateValue = dateSignature.getDateValue();
                        dateSignature.setDateValue(this.processDateValue(dateValue));
                        processed = true;
                        this.log("Updated the HiParm_CheckAvUpToDate date value");
                    }
                }
            } else if (schema instanceof HiParm_EnforceAsw && (aswSig = (obj = (HiParm_EnforceAsw)schema).getOptEnforceAswSignature()) != null) {
                AswSignatureDateCriteria dateSignature;
                long age;
                AswSignatureAgeCriteria ageSig = aswSig.getOptAswSignatureAgeCriteria();
                Long ageValue = ageSig.getAgeValue();
                if (ageValue != null && (age = ageValue.longValue()) > 1572480000L) {
                    age = 1572480000L;
                    ageSig.setAgeValue(age);
                    processed = true;
                    this.log("Change the HiParm_EnforceAsw age to max age");
                }
                if ((dateSignature = aswSig.getOptAswSignatureDateCriteria()) != null) {
                    Long dateValue = dateSignature.getDateValue();
                    dateSignature.setDateValue(this.processDateValue(dateValue));
                    processed = true;
                    this.log("Updated the HiParm_CheckAvUpToDate date value");
                }
            }
        }
        if (processed) {
            content.setConent(schema.getBytes());
        }
        return processed;
    }

    private Long processDateValue(Long dateValue) {
        long hour = 28800000L;
        long date = 0L;
        if (dateValue != null) {
            date = dateValue;
            date -= hour;
        }
        return date;
    }

    private boolean processUnmatchedOSType(ConfigObject schema) throws Exception {
        HiParm_CheckOS checkOs;
        HiParm_EnforcePatch enforcePatch;
        String sepmOsMask;
        IntegerSet osMaskSet;
        HiParm_EnforceServicePack enforceSP;
        String osMask = "";
        boolean processed = false;
        if (schema instanceof HiParm_EnforceServicePack && (osMask = (enforceSP = (HiParm_EnforceServicePack)schema).getOsMask()) != null && osMask.trim().length() > 0 && this.matchOSMask(osMaskSet = new IntegerSet(osMask, 16))) {
            sepmOsMask = osMaskSet.toString(16);
            this.log("HiParm_EnforceServicePack, SPM osMask:" + osMask + ",change to SEPM osMask:" + sepmOsMask);
            enforceSP.setOsMask(sepmOsMask);
            processed |= true;
        }
        if (schema instanceof HiParm_EnforcePatch && (osMask = (enforcePatch = (HiParm_EnforcePatch)schema).getOsMask()) != null && osMask.trim().length() > 0 && this.matchOSMask(osMaskSet = new IntegerSet(osMask, 16))) {
            sepmOsMask = osMaskSet.toString(16);
            this.log("HiParm_EnforcePatch, SPM osMask:" + osMask + ",change to SEPM osMask:" + sepmOsMask);
            enforcePatch.setOsMask(sepmOsMask);
            processed |= true;
        }
        if (schema instanceof HiParm_CheckOS && (osMask = (checkOs = (HiParm_CheckOS)schema).getOsMask()) != null && osMask.trim().length() > 0 && this.matchOSMask(osMaskSet = new IntegerSet(osMask, 16))) {
            sepmOsMask = osMaskSet.toString(16);
            this.log("HiParm_CheckOS, SPM osMask:" + osMask + ",change to SEPM osMask:" + sepmOsMask);
            checkOs.setOsMask(sepmOsMask);
            processed |= true;
        }
        return processed;
    }

    private RET_STATUS processUnsupportOSType(ConfigObject schema) throws Exception {
        IntegerSet osMaskSet;
        HiParm_CheckOS checkOs;
        String osMask = "";
        RET_STATUS status = RET_STATUS.NOT_PROCESSED;
        if (schema instanceof HiParm_EnforceServicePack) {
            IntegerSet osMaskSet2;
            HiParm_EnforceServicePack enforceSP = (HiParm_EnforceServicePack)schema;
            osMask = enforceSP.getOsMask();
            if (osMask != null && osMask.trim().length() > 0 && this.dropUnSupportedOSMask(osMaskSet2 = new IntegerSet(osMask, 16))) {
                String sepmOsMask = osMaskSet2.toString(16);
                if (StringUtilities.isEmpty(sepmOsMask)) {
                    status = RET_STATUS.NEED_REMOVE_PARENT;
                } else {
                    enforceSP.setOsMask(sepmOsMask);
                    status = RET_STATUS.PROCESSED;
                }
            }
        } else if (schema instanceof HiParm_EnforcePatch) {
            IntegerSet osMaskSet3;
            HiParm_EnforcePatch enforcePatch = (HiParm_EnforcePatch)schema;
            osMask = enforcePatch.getOsMask();
            if (osMask != null && osMask.trim().length() > 0 && this.dropUnSupportedOSMask(osMaskSet3 = new IntegerSet(osMask, 16))) {
                String sepmOsMask = osMaskSet3.toString(16);
                if (StringUtilities.isEmpty(sepmOsMask)) {
                    status = RET_STATUS.NEED_REMOVE_PARENT;
                } else {
                    enforcePatch.setOsMask(sepmOsMask);
                    status = RET_STATUS.PROCESSED;
                }
            }
        } else if (schema instanceof HiParm_CheckOS && (osMask = (checkOs = (HiParm_CheckOS)schema).getOsMask()) != null && osMask.trim().length() > 0 && this.dropUnSupportedOSMask(osMaskSet = new IntegerSet(osMask, 16))) {
            String sepmOsMask = osMaskSet.toString(16);
            if (StringUtilities.isEmpty(sepmOsMask)) {
                status = RET_STATUS.NEED_REMOVE_PARENT;
            } else {
                checkOs.setOsMask(sepmOsMask);
                status = RET_STATUS.PROCESSED;
            }
        }
        return status;
    }

    private boolean processUnmatchedAVTypeString(ConfigObject schema) throws Exception {
        HiParm_CheckAvUpToDate checkAVUpToDate;
        HiParm_CheckAvRunning checkAVRunning;
        HiParm_CheckAvInstallation checkAVInstall;
        String mappedTypeStr;
        HiParm_EnforceAv enforceAV;
        String typeStr;
        boolean processed = false;
        if (schema instanceof HiParm_EnforceAv && !StringUtilities.isEmpty(typeStr = (enforceAV = (HiParm_EnforceAv)schema).getOptAvTypeString()) && AV_TYPE_STR_MAP.containsKey(typeStr)) {
            mappedTypeStr = AV_TYPE_STR_MAP.get(typeStr);
            this.log("Map the Unmatched AV type string, from " + typeStr + " to " + mappedTypeStr);
            enforceAV.setOptAvTypeString(mappedTypeStr);
            processed = true;
        }
        if (schema instanceof HiParm_CheckAvInstallation && !StringUtilities.isEmpty(typeStr = (checkAVInstall = (HiParm_CheckAvInstallation)schema).getOptAvTypeString()) && AV_TYPE_STR_MAP.containsKey(typeStr)) {
            mappedTypeStr = AV_TYPE_STR_MAP.get(typeStr);
            this.log("Map the Unmatched AV type string, from " + typeStr + " to " + mappedTypeStr);
            checkAVInstall.setOptAvTypeString(mappedTypeStr);
            processed = true;
        }
        if (schema instanceof HiParm_CheckAvRunning && !StringUtilities.isEmpty(typeStr = (checkAVRunning = (HiParm_CheckAvRunning)schema).getOptAvTypeString()) && AV_TYPE_STR_MAP.containsKey(typeStr)) {
            mappedTypeStr = AV_TYPE_STR_MAP.get(typeStr);
            this.log("Map the Unmatched AV type string, from " + typeStr + " to " + mappedTypeStr);
            checkAVRunning.setOptAvTypeString(mappedTypeStr);
            processed = true;
        }
        if (schema instanceof HiParm_CheckAvUpToDate && !StringUtilities.isEmpty(typeStr = (checkAVUpToDate = (HiParm_CheckAvUpToDate)schema).getOptAvTypeString()) && AV_TYPE_STR_MAP.containsKey(typeStr)) {
            mappedTypeStr = AV_TYPE_STR_MAP.get(typeStr);
            this.log("Map the Unmatched AV type string, from " + typeStr + " to " + mappedTypeStr);
            checkAVUpToDate.setOptAvTypeString(mappedTypeStr);
            processed = true;
        }
        return processed;
    }

    private boolean matchOSMask(IntegerSet osMaskSet) throws Exception {
        int number = 0;
        Set<Map.Entry<String, String>> entrySet = OS_MASK_MAP.entrySet();
        for (Map.Entry<String, String> entry : entrySet) {
            if (!osMaskSet.contains(entry.getKey(), 16)) continue;
            ++number;
            osMaskSet.delete(new IntegerRange(entry.getKey(), 16));
            if (osMaskSet.contains(entry.getValue(), 16)) continue;
            osMaskSet.add(new IntegerRange(entry.getValue(), 16));
        }
        return number > 0;
    }

    private boolean dropUnSupportedOSMask(IntegerSet osMaskSet) throws Exception {
        int number = 0;
        for (String osMask : UNSUPPORTED_OS_MASK_SET) {
            if (!osMaskSet.contains(osMask, 16)) continue;
            ++number;
            this.log("drop Unsupported OS Mask:" + osMask);
            osMaskSet.delete(new IntegerRange(osMask, 16));
        }
        return number > 0;
    }

    private RET_STATUS processUnsupportFWType(ConfigObject schema) throws Exception {
        HiParm_CheckFwRunning checkFWRunning;
        HiParm_CheckFwInstallation checkFWInstall;
        HiParm_EnforceFw enforceFW;
        String typeStr;
        if (schema instanceof HiParm_EnforceFw ? !StringUtilities.isEmpty(typeStr = (enforceFW = (HiParm_EnforceFw)schema).getOptFwTypeString()) && UNSUPPORTED_FW_TYPE_SET.contains(typeStr) : (schema instanceof HiParm_CheckFwInstallation ? !StringUtilities.isEmpty(typeStr = (checkFWInstall = (HiParm_CheckFwInstallation)schema).getOptFwTypeString()) && UNSUPPORTED_FW_TYPE_SET.contains(typeStr) : schema instanceof HiParm_CheckFwRunning && !StringUtilities.isEmpty(typeStr = (checkFWRunning = (HiParm_CheckFwRunning)schema).getOptFwTypeString()) && UNSUPPORTED_FW_TYPE_SET.contains(typeStr))) {
            return RET_STATUS.NEED_REMOVE_PARENT;
        }
        return RET_STATUS.NOT_PROCESSED;
    }

    static {
        OS_MASK_MAP.put("0x255", "0x259");
        OS_MASK_MAP.put("0x257", "0x259");
        OS_MASK_MAP.put("0x258", "0x259");
        OS_MASK_MAP.put("0x256", "0x261");
        OS_MASK_MAP.put("0x259", "0x261");
        OS_MASK_MAP.put("0x260", "0x261");
        OS_MASK_MAP.put("0x261", "0x261");
        UNSUPPORTED_OS_MASK_SET.add("0x100");
        UNSUPPORTED_OS_MASK_SET.add("0x101");
        UNSUPPORTED_OS_MASK_SET.add("0x102");
        UNSUPPORTED_OS_MASK_SET.add("0x103");
        UNSUPPORTED_OS_MASK_SET.add("0x110");
        UNSUPPORTED_OS_MASK_SET.add("0x111");
        UNSUPPORTED_OS_MASK_SET.add("0x120");
        UNSUPPORTED_OS_MASK_SET.add("0x220");
        UNSUPPORTED_OS_MASK_SET.add("0x221");
        UNSUPPORTED_OS_MASK_SET.add("0x222");
        UNSUPPORTED_OS_MASK_SET.add("0x223");
        AV_TYPE_STR_MAP.put("AV_NORTON_CORP", "AV_NORTON_CORP_SEP");
        UNSUPPORTED_FW_TYPE_SET.add("FW_SYMANTEC_CSF");
    }

    private static enum RET_STATUS {
        NOT_PROCESSED,
        PROCESSED,
        NEED_REMOVE_PARENT;

    }
}

