/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.util;

import com.sygate.scm.util.IOUtilities;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.PackageUtil;
import com.sygate.scm.util.Utility;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class MacPackageFormatHelper {
    public static final String MAC_META_PACKAGE_FORMAT_REG = "^(.*\\.mpkg)[\\\\|/].*";
    public static final String MAC_FLAT_PACKAGE_FORMAT_REG = "^(.*\\Symantec Endpoint Protection).*";
    public static final String MAC_RESOURCES_FORMAT_FLAT = "^(.*[\\\\|/]Additional Resources[\\\\|/]).*";
    public static final String MAC_APP_PACKAGE_FORMAT_REG = "^(.*\\.app)[\\\\|/].*";
    public static final String MAC_EXPORT_XML_CFG_REG_META = "^(.*\\.mpkg[\\\\|/]Contents[\\\\|/]Resources[\\\\|/])";
    public static final int FLAT_PACKAGE_CONSTANT = 1;
    public static final int META_PACKAGE_CONSTANT = 2;
    public static final int APP_PACKAGE_CONSTANT = 3;
    private static final String FLAT_PACKAGE_EXT = ".pkg";
    private static final String META_PACKAGE_EXT = ".mpkg";
    private static final String APP_PACKAGE_EXT = ".app";
    private static final String MAC_INI_CONTENTS_PATH = "Contents";
    private static final String MAC_INI_PATH = "Contents" + File.separator + "Resources";
    private static final String MAC_INI_PATH_MAC_SEPARATOR = "Contents/Resources";
    private static final String MAC_VIRUSDEFS_PATH = MAC_INI_PATH + File.separator + "NAVDefs.pkg";
    private static final String MAC_PLUGINS = "plugins";
    private static final String MAC_PLUGINS_PATH = "Contents" + File.separator + "plugins";
    private static final String JAGUAR_BASE_MAC_INI = "Symantec Endpoint Protection";
    private static final String JAGUAR_MAC_INI_PATH = "Symantec Endpoint Protection" + File.separator + "Additional Resources";
    private static final String JAGUAR_MAC_VIRUSDEFS = "SEPDEFS.zip";
    private static final String JAGUAR_BASE_MAC_INI_SEPARATOR = "Additional Resources";
    private static final String TESLA_EXTRA_FOLDERS = "Symantec Endpoint Protection Installer.app" + File.separator + "Contents";
    private static final String TESLA_BASE_MAC_INI = "Symantec Endpoint Protection" + File.separator + TESLA_EXTRA_FOLDERS;
    private static final String TESLA_MAC_INI_PATH = TESLA_BASE_MAC_INI + File.separator + "Additional Resources";
    private static final String TESLA_BASE_MAC_INI_SEPARATOR = TESLA_EXTRA_FOLDERS + File.separator + "Additional Resources";
    private static final String PACKAGE_STRUCTURE_FOR_REMOTE_PUSH_APP = "Symantec Endpoint Protection/Symantec Endpoint Protection Installer.app/Contents/MacOS/Symantec Endpoint Protection Installer";
    private static final String PACKAGE_STRUCTURE_FOR_REMOTE_PUSH_PKG = "Symantec Endpoint Protection/Symantec Endpoint Protection.pkg";
    public static final String MAC_PACKAGE_ZIP_NAME = "Symantec Endpoint Protection";
    public static final String MAC_PACKAGE_ZIP_NAME_WITH_EXT = "Symantec Endpoint Protection.zip";
    private int pkgFormat;
    private String pkgName = null;
    private String srcFilePath = null;
    private String configDirPath = null;
    private String configDirPathAlt = null;
    private String relativeConfigDirPath = null;
    private String virusDefsBase = null;
    private String virusDefsPath = null;
    private String packageExtention = null;
    private String installArchiveName = null;
    private String configDirPathWithSeperator = null;
    private boolean isInvalidPackage = false;
    private String pluginsBase = null;
    private String plugins = null;
    private boolean isAddResMovementRequired = false;

    public MacPackageFormatHelper(String srcFile) {
        if (srcFile == null) {
            return;
        }
        this.srcFilePath = srcFile;
        this.initialize();
    }

    public boolean isMacZipPackage() {
        return this.getPackageFormat() == 1 || this.getPackageFormat() == 2 || this.getPackageFormat() == 3;
    }

    public boolean isMacZipFlatPackage() {
        return this.getPackageFormat() == 1;
    }

    public boolean isMacZipAppPackage() {
        return this.getPackageFormat() == 3;
    }

    private void initialize() {
        this.initializePackageFormat();
        this.setResourcesPaths();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializePackageFormat() {
        ZipInputStream zis;
        block16: {
            File zipFile = new File(this.srcFilePath);
            zis = null;
            try {
                zis = new ZipInputStream(new BufferedInputStream(new FileInputStream(zipFile)));
                ZipEntry entry = null;
                Pattern pattern_meta = Pattern.compile(MAC_META_PACKAGE_FORMAT_REG, 2);
                Pattern pattern_flat = Pattern.compile(MAC_RESOURCES_FORMAT_FLAT, 2);
                Pattern pattern_app = Pattern.compile(MAC_APP_PACKAGE_FORMAT_REG, 2);
                Matcher match_flat = null;
                Matcher match_meta = null;
                Matcher match_app = null;
                boolean isAppFound = false;
                boolean isAddResFound = false;
                boolean isMpkgFound = false;
                String addResEntry = null;
                while ((entry = zis.getNextEntry()) != null) {
                    String entryName = entry.getName();
                    if (!isAppFound && (match_app = pattern_app.matcher(entryName)).matches()) {
                        isAppFound = true;
                    }
                    if (!isAddResFound && (match_flat = pattern_flat.matcher(entryName)).matches()) {
                        isAddResFound = true;
                        addResEntry = entryName;
                    }
                    if (!isMpkgFound && (match_meta = pattern_meta.matcher(entryName)).matches()) {
                        isMpkgFound = true;
                    }
                    if (!isAppFound || !isAddResFound) continue;
                    break;
                }
                if (isAppFound) {
                    if (addResEntry == null) {
                        this.setIsInvalidPackage(true);
                    } else {
                        this.setPackageFormat(3);
                        if (!addResEntry.contains(APP_PACKAGE_EXT)) {
                            this.isAddResMovementRequired = true;
                        }
                    }
                } else if (isMpkgFound) {
                    this.setPackageFormat(2);
                } else if (isAddResFound) {
                    this.setPackageFormat(1);
                }
                if (this.getPackageFormat() == 1 || this.getPackageFormat() == 2 || this.getPackageFormat() == 3) break block16;
                this.setIsInvalidPackage(true);
            }
            catch (IOException e) {
                try {
                    System.out.println("MacPackageFormatHelper.checkPackageFormat() :: Exception while reading the Additional Resources file path in " + this.srcFilePath);
                    LoggerUtilities.logException(e);
                }
                catch (Throwable throwable) {
                    IOUtilities.closeInputStream(zis);
                    throw throwable;
                }
                IOUtilities.closeInputStream(zis);
            }
        }
        IOUtilities.closeInputStream(zis);
    }

    private void setResourcesPaths() {
        String fileType = null;
        try {
            switch (this.pkgFormat) {
                case 3: {
                    fileType = APP_PACKAGE_EXT;
                    this.pkgName = PackageUtil.getMpkgFolderName(this.srcFilePath, MAC_FLAT_PACKAGE_FORMAT_REG);
                    this.configDirPath = TESLA_MAC_INI_PATH;
                    this.configDirPathAlt = JAGUAR_MAC_INI_PATH;
                    if (this.isAddResMovementRequired) {
                        this.relativeConfigDirPath = JAGUAR_BASE_MAC_INI_SEPARATOR;
                        this.configDirPathWithSeperator = JAGUAR_BASE_MAC_INI_SEPARATOR;
                    } else {
                        this.relativeConfigDirPath = TESLA_BASE_MAC_INI_SEPARATOR;
                        this.configDirPathWithSeperator = TESLA_BASE_MAC_INI_SEPARATOR;
                    }
                    this.virusDefsBase = this.configDirPath;
                    this.virusDefsPath = this.configDirPath + File.separator + JAGUAR_MAC_VIRUSDEFS;
                    this.packageExtention = APP_PACKAGE_EXT;
                    this.installArchiveName = this.pkgName;
                    this.pluginsBase = this.configDirPath;
                    this.plugins = this.configDirPath + File.separator + MAC_PLUGINS;
                    break;
                }
                case 1: {
                    fileType = FLAT_PACKAGE_EXT;
                    this.pkgName = PackageUtil.getMpkgFolderName(this.srcFilePath, MAC_FLAT_PACKAGE_FORMAT_REG);
                    this.configDirPathAlt = this.configDirPath = JAGUAR_MAC_INI_PATH;
                    this.relativeConfigDirPath = JAGUAR_BASE_MAC_INI_SEPARATOR;
                    this.configDirPathWithSeperator = JAGUAR_BASE_MAC_INI_SEPARATOR;
                    this.virusDefsBase = this.configDirPath;
                    this.virusDefsPath = this.configDirPath + File.separator + JAGUAR_MAC_VIRUSDEFS;
                    this.packageExtention = FLAT_PACKAGE_EXT;
                    this.installArchiveName = this.pkgName;
                    this.pluginsBase = this.configDirPath;
                    this.plugins = this.configDirPath + File.separator + MAC_PLUGINS;
                    break;
                }
                case 2: {
                    fileType = META_PACKAGE_EXT;
                    this.pkgName = PackageUtil.getMpkgFolderName(this.srcFilePath, MAC_META_PACKAGE_FORMAT_REG);
                    this.relativeConfigDirPath = MAC_INI_PATH;
                    this.configDirPathWithSeperator = MAC_INI_PATH_MAC_SEPARATOR;
                    this.configDirPath = this.pkgName + File.separator + MAC_INI_PATH;
                    this.configDirPathAlt = this.configDirPath;
                    this.virusDefsBase = null;
                    this.virusDefsPath = this.pkgName + File.separator + MAC_VIRUSDEFS_PATH + File.separator + "*:NOEXTRACT";
                    this.packageExtention = META_PACKAGE_EXT;
                    this.installArchiveName = this.pkgName.substring(0, this.pkgName.lastIndexOf(this.packageExtention));
                    this.pluginsBase = null;
                    this.plugins = this.pkgName + File.separator + MAC_PLUGINS_PATH + File.separator + "*:NOEXTRACT";
                    break;
                }
            }
        }
        catch (Exception e) {
            System.out.println("MacPackageFormatHelper.setResourcesPaths() :: Exception while reading the " + fileType + " file path in " + this.srcFilePath);
            LoggerUtilities.logException(e);
        }
    }

    public String getPackageName() {
        return this.pkgName;
    }

    public String getConfigDirPath(boolean isExtract) {
        if (isExtract && this.isAddResMovementRequired) {
            return this.configDirPathAlt;
        }
        return this.configDirPath;
    }

    public String getConfigFilePath(boolean isExtract) {
        return this.getConfigDirPath(isExtract) + File.separator + "sylink.xml";
    }

    public String getProfileFilePath(boolean isExtract) {
        return this.getConfigDirPath(isExtract) + File.separator + "serdef.dat";
    }

    public String getHiFile(boolean isExtract) {
        return this.getConfigDirPath(isExtract) + File.separator + "HIDefs.zip";
    }

    public String getSetAidIni(boolean isExtract) {
        return this.getConfigDirPath(isExtract) + File.separator + "setAid.ini";
    }

    public String getVirusDefsPath(boolean isExtract) {
        if (this.virusDefsBase == null) {
            return this.virusDefsPath;
        }
        return this.getConfigDirPath(isExtract) + File.separator + JAGUAR_MAC_VIRUSDEFS;
    }

    public String getPlugins(boolean isExtract) {
        if (this.pluginsBase == null) {
            return this.plugins;
        }
        return this.getConfigDirPath(isExtract) + File.separator + MAC_PLUGINS;
    }

    public String getPackageExtention() {
        return this.packageExtention;
    }

    public String getInstallationArchiveName() {
        return this.installArchiveName;
    }

    public String getConfigDirPathWithSeperator() {
        return this.configDirPathWithSeperator;
    }

    private void setPackageFormat(int pkgFormat) {
        this.pkgFormat = pkgFormat;
    }

    public int getPackageFormat() {
        return this.pkgFormat;
    }

    public boolean isInvalidPackage() {
        return this.isInvalidPackage;
    }

    private void setIsInvalidPackage(boolean isInvalidPackage) {
        this.isInvalidPackage = isInvalidPackage;
    }

    public String getRelativeConfigDirPath() {
        return this.relativeConfigDirPath;
    }

    public String[] getFilesToExtract(String[] filesToExtract) {
        if (this.isMacZipAppPackage()) {
            String[] arr = new String[]{this.getConfigDirPath(true) + File.separator + "*"};
            return arr;
        }
        return filesToExtract;
    }

    public String[] getFilesToAdd(String[] filesToAdd, String[] filesToExtract, String exportPath) {
        if (this.isMacZipAppPackage()) {
            String destDirStr = exportPath + File.separator + this.configDirPathAlt;
            String zipFileFilterPath = this.configDirPathAlt;
            if (!this.isAddResMovementRequired) {
                String srcDirStr = exportPath + File.separator + this.getConfigDirPath(true);
                Utility.moveDirectory(srcDirStr, destDirStr);
            }
            HashSet<CallSite> finalFileSet = new HashSet<CallSite>();
            Set<String> setFilesToFilterOut = this.getLeftOutFiles(filesToAdd, filesToExtract);
            String[] files = null;
            File destDir = new File(destDirStr);
            if (destDir.exists() && destDir.isDirectory()) {
                files = destDir.list();
                if (files != null) {
                    for (String file : files) {
                        if (this.isFilePresentInFileSet(setFilesToFilterOut, file)) continue;
                        finalFileSet.add((CallSite)((Object)(zipFileFilterPath + File.separator + file)));
                    }
                }
                System.out.println("No of files to be moved inside Additional Resources folder: " + finalFileSet.size());
                Object[] objArr = finalFileSet.toArray();
                if (objArr.length > 0) {
                    String[] arrFiles = new String[objArr.length];
                    System.arraycopy(objArr, 0, arrFiles, 0, objArr.length);
                    return arrFiles;
                }
            } else {
                System.out.println(" Warning: possible error in copying Additional Resources folder to inside SEP installer .app");
            }
        }
        return filesToAdd;
    }

    private Set<String> getLeftOutFiles(String[] filesToAdd, String[] filesToExtract) {
        HashSet setFilesToAdd = new HashSet();
        if (filesToAdd != null && filesToAdd.length > 0) {
            Collections.addAll(setFilesToAdd, filesToAdd);
        }
        HashSet<String> setFilesToFilterOut = new HashSet<String>();
        if (filesToExtract != null && filesToExtract.length > 0) {
            Collections.addAll(setFilesToFilterOut, filesToExtract);
        }
        setFilesToFilterOut.removeAll(setFilesToAdd);
        return setFilesToFilterOut;
    }

    private boolean isFilePresentInFileSet(Set<String> fileSet, String file) {
        boolean result = false;
        if (fileSet != null && fileSet.size() > 0) {
            for (String fileName : fileSet) {
                if (fileName == null || fileName.length() <= 0 || !fileName.toUpperCase().contains(file.toUpperCase())) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    public static String getPackageStructureForRemotePush(boolean isDotAppFormat) {
        String pkgStructure = PACKAGE_STRUCTURE_FOR_REMOTE_PUSH_APP;
        if (!isDotAppFormat) {
            pkgStructure = PACKAGE_STRUCTURE_FOR_REMOTE_PUSH_PKG;
        }
        return pkgStructure;
    }

    public String getPackageStructureForRemotePush() {
        String pkgStructure = "";
        if (this.getPackageFormat() == 3) {
            pkgStructure = PACKAGE_STRUCTURE_FOR_REMOTE_PUSH_APP;
        } else if (this.getPackageFormat() == 1) {
            pkgStructure = PACKAGE_STRUCTURE_FOR_REMOTE_PUSH_PKG;
        }
        return pkgStructure;
    }
}

