/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.util;

import com.sygate.scm.util.IOUtilities;
import com.sygate.scm.util.LoggerUtilities;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class LinuxPackageFormatHelper {
    private static final String LINUX_FOLDER_FORMAT_FLAT_CONFIGURATION = "^(Configuration[\\\\|/].*)";
    public static final String LINUX_PACKAGE_FORMAT_RPM_REG = "^(Repository[\\\\|/].*\\.rpm)";
    public static final String LINUX_PACKAGE_FORMAT_DEB_REG = "^(Repository[\\\\|/].*\\.deb)";
    public static final String LINUX_PACKAGE_FORMAT_STUB_REG = "^(LinuxInstaller)";
    public static final int RPM_PACKAGE_CONSTANT = 1;
    public static final int DEB_PACKAGE_CONSTANT = 2;
    public static final int STUB_PACKAGE_CONSTANT = 3;
    public static final int ERROR_PACKAGE_CONSTANT = -1;
    public static final String LINUX_RELATIVE_CONFIGURATION_PATH = "Configuration";
    public static final String LINUX_REPOSITORY_PATH = "Repository";
    private static final String[] supportedLinuxPackageFileTypes = new String[]{".rpm", ".deb"};
    private String srcFilePath = null;
    private int pkgFormat;
    private String relativeConfigDirPath = null;
    private static final String LINUX_FOLDER_FORMAT_FLAT_REPOSITORY = "^(Repository[\\\\|/].*)";
    private static final String PROFILE_FILE_NAME = "profile.xml";
    public static final String PROFILE_FILE_AND_SYLINK_FILE_DIR_PATH = "Configuration";
    public static final String FINAL_ARCHIVE_FILE_NAME = "SymantecEndpointProtection.zip";
    private String profileFilePath = null;
    private String sylinkFilePath = null;
    private boolean isInvalidPackage = true;

    public int getPkgFormat() {
        return this.pkgFormat;
    }

    public void setPkgFormat(int pkgFormat) {
        this.pkgFormat = pkgFormat;
    }

    public String getRelativeConfigDirPath() {
        return this.relativeConfigDirPath;
    }

    public void setRelativeConfigDirPath(String relativeConfigDirPath) {
        this.relativeConfigDirPath = relativeConfigDirPath;
    }

    public LinuxPackageFormatHelper(String srcFile) {
        if (srcFile == null) {
            return;
        }
        this.srcFilePath = srcFile;
        this.initialize();
    }

    public boolean isLinuxPackage() {
        return this.getPkgFormat() == 1 || this.getPkgFormat() == 2;
    }

    public static boolean isDirLinuxPackage(String srcFile) {
        if (srcFile == null) {
            return false;
        }
        File file = new File(srcFile);
        if (!file.exists() || !file.isDirectory()) {
            return false;
        }
        String insFileDir = srcFile + File.separator + LINUX_REPOSITORY_PATH;
        file = new File(insFileDir);
        if (!file.exists()) {
            return false;
        }
        File[] files = file.listFiles();
        if (null == files) {
            return false;
        }
        for (File f : files) {
            if (!LinuxPackageFormatHelper.isLinuxInstallFileName(f.getName())) continue;
            return true;
        }
        return false;
    }

    private static boolean isLinuxInstallFileName(String filename) {
        if (filename == null) {
            return false;
        }
        for (String s : supportedLinuxPackageFileTypes) {
            if (!filename.substring(filename.lastIndexOf(".")).equals(s)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int caculateLinuxPackageType(String srcFile) {
        if (srcFile == null) {
            return -1;
        }
        File zipFile = new File(srcFile);
        if (!zipFile.exists()) {
            System.out.println("LinuxPackageFormatHelper.caculateLinuxPackageType() :: zip File does not exist, file name is " + srcFile);
            return -1;
        }
        ZipInputStream zis = null;
        int linuxPackageType = -1;
        try {
            zis = new ZipInputStream(new BufferedInputStream(new FileInputStream(zipFile)));
            ZipEntry entry = null;
            Pattern pLinuxRPM = Pattern.compile(LINUX_PACKAGE_FORMAT_RPM_REG, 2);
            Pattern pLinuxDEB = Pattern.compile(LINUX_PACKAGE_FORMAT_DEB_REG, 2);
            Pattern pLinuxStub = Pattern.compile(LINUX_PACKAGE_FORMAT_STUB_REG, 2);
            Matcher mLinuxRPM = null;
            Matcher mLinuxDEB = null;
            Matcher mLinuxStub = null;
            while ((entry = zis.getNextEntry()) != null) {
                String entryName = entry.getName();
                mLinuxRPM = pLinuxRPM.matcher(entryName);
                mLinuxDEB = pLinuxDEB.matcher(entryName);
                mLinuxStub = pLinuxStub.matcher(entryName);
                if (mLinuxRPM.matches()) {
                    linuxPackageType = 1;
                    continue;
                }
                if (mLinuxDEB.matches()) {
                    linuxPackageType = 2;
                    continue;
                }
                if (!mLinuxStub.matches()) continue;
                linuxPackageType = 3;
            }
        }
        catch (IOException e) {
            try {
                System.out.println("LinuxPackageFormatHelper.caculateLinuxPackageType() :: Exception while caculate the file linux type, file path is " + srcFile);
                LoggerUtilities.logException(e);
            }
            catch (Throwable throwable) {
                IOUtilities.closeInputStream(zis);
                throw throwable;
            }
            IOUtilities.closeInputStream(zis);
        }
        IOUtilities.closeInputStream(zis);
        return linuxPackageType;
    }

    private void initialize() {
        int linuxPackageType = LinuxPackageFormatHelper.caculateLinuxPackageType(this.srcFilePath);
        if (linuxPackageType == 1 || linuxPackageType == 2 || linuxPackageType == 3) {
            this.setPkgFormat(linuxPackageType);
            this.setRelativeConfigDirPath("Configuration");
        }
        this.initializePackageFormat();
        this.setResourcesPaths();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializePackageFormat() {
        ZipInputStream zipInputStream = null;
        try {
            File linuxZipFile = new File(this.srcFilePath);
            zipInputStream = new ZipInputStream(new BufferedInputStream(new FileInputStream(linuxZipFile)));
            Pattern patternConfiguration = Pattern.compile(LINUX_FOLDER_FORMAT_FLAT_CONFIGURATION, 2);
            Pattern patternRepository = Pattern.compile(LINUX_FOLDER_FORMAT_FLAT_REPOSITORY, 2);
            boolean matchPatternConfiguration = false;
            boolean matchPatternRepository = false;
            ZipEntry zipEntry = null;
            while (!((zipEntry = zipInputStream.getNextEntry()) == null || matchPatternConfiguration && matchPatternRepository)) {
                String entryName = zipEntry.getName();
                if (!matchPatternConfiguration) {
                    if (!patternConfiguration.matcher(entryName).matches()) continue;
                    matchPatternConfiguration = true;
                    continue;
                }
                if (!patternRepository.matcher(entryName).matches()) continue;
                matchPatternRepository = true;
            }
            if (matchPatternConfiguration && matchPatternRepository || this.pkgFormat == 3) {
                this.isInvalidPackage = false;
            }
            IOUtilities.closeInputStream(zipInputStream);
        }
        catch (IOException e) {
            System.out.println("LinuxPackageFormatHelper.checkPackageFormat() :: Exception while reading the Configuration or Repository folder path in " + this.srcFilePath);
            LoggerUtilities.logException(e);
        }
        finally {
            IOUtilities.closeInputStream(zipInputStream);
        }
    }

    private void setResourcesPaths() {
        if (!this.isInvalidPackage) {
            this.sylinkFilePath = "Configuration" + File.separator + "sylink.xml";
            this.profileFilePath = "Configuration" + File.separator + PROFILE_FILE_NAME;
        }
        if (this.pkgFormat == 3) {
            this.sylinkFilePath = "sylink.xml";
            this.profileFilePath = PROFILE_FILE_NAME;
        }
    }

    public String getSrcFilePath() {
        return this.srcFilePath;
    }

    public void setSrcFilePath(String srcFilePath) {
        this.srcFilePath = srcFilePath;
    }

    public String getProfileFilePath() {
        return this.profileFilePath;
    }

    public void setProfileFilePath(String profileFilePath) {
        this.profileFilePath = profileFilePath;
    }

    public String getSylinkFilePath() {
        return this.sylinkFilePath;
    }

    public void setSylinkFilePath(String sylinkFilePath) {
        this.sylinkFilePath = sylinkFilePath;
    }

    public boolean isInvalidPackage() {
        return this.isInvalidPackage;
    }

    public void setInvalidPackage(boolean isInvalidPackage) {
        this.isInvalidPackage = isInvalidPackage;
    }
}

