/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.util;

import com.sygate.scm.util.ScmLicense;

public class LicenseCompliance {
    private ScmLicense license;
    private int workstationsAgentsCount;
    private int serversAgentsCount;
    private int enforcementAgentCount;
    private int siteCount;
    private int serverCount;
    private int gatewayEnforcerCount;
    private int lanEnforcerCount;
    private int dhcpEnforcerCount;

    public LicenseCompliance(ScmLicense license) {
        this.license = license;
    }

    public LicenseCompliance(ScmLicense license, int workstationsAgentsCount, int serversAgentsCount, int enforcementAgentCount, int siteCount, int serverCount, int gatewayEnforcerCount, int lanEnforcerCount, int dhcpEnforcerCount) {
        this.license = license;
        this.workstationsAgentsCount = workstationsAgentsCount;
        this.serversAgentsCount = serversAgentsCount;
        this.enforcementAgentCount = enforcementAgentCount;
        this.siteCount = siteCount;
        this.serverCount = serverCount;
        this.gatewayEnforcerCount = gatewayEnforcerCount;
        this.lanEnforcerCount = lanEnforcerCount;
        this.dhcpEnforcerCount = dhcpEnforcerCount;
    }

    public void setWorkstationsAgentsCount(int workstationAgentsCount) {
        this.workstationsAgentsCount = workstationAgentsCount;
    }

    public int getWorkstationsAgentsCount() {
        return this.workstationsAgentsCount;
    }

    public void setServersAgentsCount(int serverAgentsCount) {
        this.serversAgentsCount = serverAgentsCount;
    }

    public int getServersAgentsCount() {
        return this.serversAgentsCount;
    }

    public void setEnforcementAgentCount(int securityAgentCount) {
        this.enforcementAgentCount = securityAgentCount;
    }

    public int getEnforcementAgentCount() {
        return this.enforcementAgentCount;
    }

    public void setSiteCount(int siteCount) {
        this.siteCount = siteCount;
    }

    public int getSiteCount() {
        return this.siteCount;
    }

    public void setServerCount(int managementServerCount) {
        this.serverCount = managementServerCount;
    }

    public int getServerCount() {
        return this.serverCount;
    }

    public void setGatewayEnforcerCount(int gatewayEnforcerCount) {
        this.gatewayEnforcerCount = gatewayEnforcerCount;
    }

    public int getGatewayEnforcerCount() {
        return this.gatewayEnforcerCount;
    }

    public void setLanEnforcerCount(int lanEnforcerCount) {
        this.lanEnforcerCount = lanEnforcerCount;
    }

    public int getLanEnforcerCount() {
        return this.lanEnforcerCount;
    }

    public void setDhcpEnforcerCount(int dhcpEnforcerCount) {
        this.dhcpEnforcerCount = dhcpEnforcerCount;
    }

    public int getDhcpEnforcerCount() {
        return this.dhcpEnforcerCount;
    }

    public boolean isLicenseCompliance() {
        if (this.license.isLicenseExpired()) {
            return false;
        }
        return this.isWorkstationsAgentsCompliance() && this.isServersAgentsCompliance() && this.isEnforcementAgentCompliance() && this.isSiteCompliance() && this.isServerCompliance() && this.isGatewayEnforcerCompliance() && this.isLanEnforcerCompliance() && this.isDhcpEnforcerCompliance();
    }

    public boolean isWorkstationsAgentsCompliance() {
        return this.workstationsAgentsCount <= this.license.getWorkstationsAgentsCount() || this.license.getWorkstationsAgentsCount() == -1;
    }

    public boolean isServersAgentsCompliance() {
        return this.serversAgentsCount <= this.license.getServersAgentsCount() || this.license.getServersAgentsCount() == -1;
    }

    public boolean isEnforcementAgentCompliance() {
        return this.enforcementAgentCount <= this.license.getEnforcementAgentCount() || this.license.getEnforcementAgentCount() == -1;
    }

    public boolean isSiteCompliance() {
        return this.siteCount <= this.license.getSiteCount() || this.license.getSiteCount() == -1;
    }

    public boolean isServerCompliance() {
        return this.serverCount <= this.license.getServerCount() || this.license.getServerCount() == -1;
    }

    public boolean isGatewayEnforcerCompliance() {
        return this.license.isGatewayEnforcer() || this.gatewayEnforcerCount == 0;
    }

    public boolean isLanEnforcerCompliance() {
        return this.license.isLanEnforcer() || this.lanEnforcerCount == 0;
    }

    public boolean isDhcpEnforcerCompliance() {
        return this.license.isDhcpEnforcer() || this.dhcpEnforcerCount == 0;
    }

    public int getOverUsedWorkstationsAgentsCount() {
        return this.workstationsAgentsCount - this.license.getWorkstationsAgentsCount();
    }

    public int getOverUsedServersAgentsCount() {
        return this.serversAgentsCount - this.license.getServersAgentsCount();
    }

    public int getOverUsedEnforcementAgentCount() {
        return this.enforcementAgentCount - this.license.getEnforcementAgentCount();
    }

    public int getOverUsedSiteCount() {
        return this.siteCount - this.license.getSiteCount();
    }

    public int getOverUsedServerCount() {
        return this.serverCount - this.license.getServerCount();
    }

    public int getOverUsedGatewayEnforcerCount() {
        return this.gatewayEnforcerCount;
    }

    public int getOverUsedLanEnforcerCount() {
        return this.lanEnforcerCount;
    }

    public int getOverUsedDhcpEnforcerCount() {
        return this.dhcpEnforcerCount;
    }
}

