/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.util;

import com.sygate.scm.common.i18n.MessageResourcesFile;
import com.sygate.scm.util.BadFormatException;
import com.sygate.scm.util.IntegerRange;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;

public class IntegerSet {
    public static final String RANGE_SEPARATOR = "-";
    public static final String RANGES_SEPARATOR = ",";
    MessageResourcesFile res = new MessageResourcesFile("com.sygate.scm.util.util");
    private List<IntegerRange> m_listRanges = new ArrayList<IntegerRange>();

    public IntegerSet() {
    }

    public IntegerSet(String ranges) throws BadFormatException {
        this.init(ranges, 10);
    }

    public IntegerSet(String ranges, int radix) throws BadFormatException {
        this.init(ranges, radix);
    }

    public void init(String ranges) throws BadFormatException {
        this.init(ranges, 10);
    }

    public void init(String ranges, int radix) throws BadFormatException {
        if (ranges == null) {
            throw new BadFormatException(this.res.getString("IntegerSet.wrongFormat") + " null");
        }
        StringTokenizer sk = new StringTokenizer(ranges, RANGES_SEPARATOR);
        while (sk.hasMoreElements()) {
            String range = (String)sk.nextElement();
            IntegerRange item = IntegerRange.parseRange(range, radix);
            if (item != null) {
                this.add(item);
                continue;
            }
            throw new BadFormatException(this.res.getString("IntegerSet.wrongFormat"));
        }
    }

    public synchronized void addRange(String rangeStr) throws BadFormatException {
        this.addRange(rangeStr, 10);
    }

    public synchronized void addRange(String rangeStr, int radix) throws BadFormatException {
        IntegerSet set = new IntegerSet(rangeStr, radix);
        this.add(set);
    }

    public synchronized boolean add(int value) {
        IntegerRange range = new IntegerRange(value);
        return this.add(range);
    }

    public synchronized boolean add(String valueStr) {
        return this.add(valueStr, 10);
    }

    public synchronized boolean add(String valueStr, int radix) {
        IntegerRange range = new IntegerRange();
        if (!range.set(valueStr, radix)) {
            return false;
        }
        return this.add(range);
    }

    public synchronized boolean add(int value, boolean mergeFlag) {
        if (mergeFlag) {
            return this.add(value);
        }
        this.m_listRanges.add(new IntegerRange(value));
        return true;
    }

    public synchronized boolean add(IntegerRange range, boolean mergeFlag) {
        if (mergeFlag) {
            return this.add(range);
        }
        this.m_listRanges.add(range);
        return true;
    }

    public synchronized boolean add(IntegerRange range) {
        if (range == null) {
            return false;
        }
        int size = this.m_listRanges.size();
        if (size == 0) {
            this.m_listRanges.add(range);
            return true;
        }
        for (int i = 0; i < size; ++i) {
            IntegerRange item = this.m_listRanges.get(i);
            int result = item.getPositionOf(range);
            switch (result) {
                case 1: {
                    return true;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    IntegerRange new_item = item.merge(range);
                    this.m_listRanges.remove(item);
                    this.add(new_item);
                    return true;
                }
                case 11: {
                    this.m_listRanges.add(i, range);
                    return true;
                }
            }
            if (i != size - 1) continue;
            this.m_listRanges.add(range);
            break;
        }
        return true;
    }

    public ArrayList<IntegerRange> getRangeList() {
        return (ArrayList)this.m_listRanges;
    }

    public boolean hasRange() {
        return this.m_listRanges.size() != 0;
    }

    public boolean contains(int value) {
        int size = this.m_listRanges.size();
        for (int i = 0; i < size; ++i) {
            IntegerRange item = this.m_listRanges.get(i);
            if (!item.contains(value)) continue;
            return true;
        }
        return false;
    }

    public boolean contains(String strValue, int radix) {
        int size = this.m_listRanges.size();
        for (int i = 0; i < size; ++i) {
            IntegerRange item = this.m_listRanges.get(i);
            if (!item.contains(strValue, radix)) continue;
            return true;
        }
        return false;
    }

    public boolean contains(IntegerRange range) {
        int size = this.m_listRanges.size();
        for (int i = 0; i < size; ++i) {
            IntegerRange item = this.m_listRanges.get(i);
            if (!item.contains(range)) continue;
            return true;
        }
        return false;
    }

    public boolean contains(IntegerSet iSet) {
        boolean foundWrong = false;
        Iterator<IntegerRange> it = iSet.getRangeList().iterator();
        while (!foundWrong && it.hasNext()) {
            IntegerRange range = it.next();
            boolean foundThis = false;
            int size = this.m_listRanges.size();
            for (int i = 0; i < size; ++i) {
                IntegerRange item = this.m_listRanges.get(i);
                if (!item.contains(range)) continue;
                foundThis = true;
                break;
            }
            foundWrong = !foundThis;
        }
        return !foundWrong;
    }

    public boolean containsRange(String strRange, int radix) throws BadFormatException {
        IntegerSet iSet = new IntegerSet(strRange, radix);
        return this.contains(iSet);
    }

    public String toString() {
        return this.toString(10);
    }

    public String toString(int radix) {
        return this.toString(radix, false);
    }

    public String toString(int radix, boolean showAll) {
        StringBuffer buf = new StringBuffer();
        int size = this.m_listRanges.size();
        for (int i = 0; i < size; ++i) {
            IntegerRange item = this.m_listRanges.get(i);
            if (i != 0) {
                buf.append(RANGES_SEPARATOR);
            }
            buf.append(item.toString(radix, showAll));
        }
        return buf.toString();
    }

    public void add(IntegerSet newSet) {
        for (IntegerRange range : newSet.getRangeList()) {
            this.add(range);
        }
    }

    public void delete(IntegerRange subRange) {
        IntegerRange thisRange;
        int ret;
        Iterator<IntegerRange> it = this.m_listRanges.iterator();
        while (it.hasNext() && (ret = subRange.getPositionOf(thisRange = it.next())) != 10) {
            if (ret == 11) continue;
            if (ret == 1 || ret == 3) {
                this.m_listRanges.remove(thisRange);
                break;
            }
            List<IntegerRange> result = thisRange.delete(subRange);
            int index = this.m_listRanges.indexOf(thisRange);
            this.m_listRanges.remove(index);
            this.m_listRanges.addAll(index, result);
            break;
        }
    }

    public void delete(IntegerSet subSet) {
        for (IntegerRange subRange : subSet.getRangeList()) {
            this.delete(subRange);
        }
    }

    public List<Integer> toList() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        int size = this.m_listRanges.size();
        for (int i = 0; i < size; ++i) {
            IntegerRange item = this.m_listRanges.get(i);
            list.addAll(item.toList());
        }
        return list;
    }

    public int[] toArray() {
        List<Integer> list = this.toList();
        if (list == null || list.size() < 1) {
            return null;
        }
        int[] result = new int[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            Integer a = list.get(i);
            result[i] = a;
        }
        return result;
    }

    public boolean isEmpty() {
        return this.m_listRanges.isEmpty();
    }
}

