/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.util;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class IntegerRange
implements Comparable<Object> {
    public static final int POSITION_EQUAL = 1;
    public static final int POSITION_CONTAINED_SMALL = 2;
    public static final int POSITION_CONTAINED_LARGE = 3;
    public static final int POSITION_OVERLAPPED_LEFT = 4;
    public static final int POSITION_OVERLAPPED_RIGHT = 5;
    public static final int POSITION_CONNECTED_LEFT = 6;
    public static final int POSITION_CONNECTED_RIGHT = 7;
    public static final int POSITION_SEPARATED_JUSTLEFT = 8;
    public static final int POSITION_SEPARATED_JUSTRIGHT = 9;
    public static final int POSITION_SEPARATED_LEFT = 10;
    public static final int POSITION_SEPARATED_RIGHT = 11;
    private static final Logger logger = Logger.getLogger(IntegerRange.class.getName());
    private int m_iMax = 0;
    private int m_iMin = 0;

    public IntegerRange() {
    }

    public IntegerRange(int min, int max) {
        this.set(min, max);
    }

    public IntegerRange(String value, int radix) {
        this.set(value, radix);
    }

    public IntegerRange(String value) {
        this.set(value, 10);
    }

    public IntegerRange(int value) {
        this.set(value);
    }

    public boolean parse(String range) {
        return this.parse(range, 10);
    }

    public boolean parse(String range, int radix) {
        IntegerRange item = IntegerRange.parseRange(range, radix);
        if (item == null) {
            return false;
        }
        this.m_iMin = item.getMin();
        this.m_iMax = item.getMax();
        return true;
    }

    public static IntegerRange parseRange(String range) {
        return IntegerRange.parseRange(range, 10);
    }

    public static IntegerRange parseRange(String range, int radix) {
        String max;
        int index = range.indexOf("-");
        if (index == 0) {
            String findSeparator = range.substring(1);
            index = findSeparator.indexOf("-");
            index = index == -1 ? index : index + 1;
        }
        IntegerRange item = new IntegerRange();
        if (index == -1) {
            if (item.set(range, radix)) {
                return item;
            }
            return null;
        }
        String min = range.substring(0, index);
        if (item.set(min, max = range.substring(index + "-".length()), radix)) {
            return item;
        }
        return null;
    }

    public IntegerRange merge(int min, int max) {
        return this.merge(new IntegerRange(min, max));
    }

    public IntegerRange merge(IntegerRange range) {
        int min1 = this.getMin();
        int max1 = this.getMax();
        int min2 = range.getMin();
        int max2 = range.getMax();
        boolean ok = false;
        int min = 0;
        int max = 0;
        if (min1 == min2) {
            min = min1;
            max = max1 > max2 ? max1 : max2;
            ok = true;
        } else if (min1 < min2) {
            min = min1;
            if (max1 > min2) {
                max = max1 > max2 ? max1 : max2;
                ok = true;
            } else if (max1 == min2 || max1 == min2 - 1) {
                max = max2;
                ok = true;
            } else {
                ok = false;
            }
        } else if (min1 > min2) {
            min = min2;
            if (min1 < max2) {
                max = max1 > max2 ? max1 : max2;
                ok = true;
            } else if (min1 == max2 || min1 == max2 + 1) {
                max = max1;
                ok = true;
            } else {
                ok = false;
            }
        }
        return ok ? new IntegerRange(min, max) : null;
    }

    public static int prarseHexString(String hexString) throws Exception {
        String strValue = hexString;
        if (strValue.startsWith("0x") || strValue.startsWith("0X")) {
            strValue = strValue.substring(2);
        }
        int value = 0;
        try {
            value = Integer.parseInt(strValue, 16);
        }
        catch (Exception ex) {
            logger.log(Level.INFO, "ItegerSetItem>> prarseHexString: Error-> failed to parse value. hexString=" + hexString + "value=" + strValue);
            throw ex;
        }
        return value;
    }

    public List<IntegerRange> delete(IntegerRange subRange) {
        ArrayList<IntegerRange> result = new ArrayList<IntegerRange>();
        int low = subRange.getMin() - 1;
        int high = subRange.getMax() + 1;
        if (this.m_iMin <= low && low <= this.m_iMax) {
            int newLow = this.m_iMin;
            int newHigh = low;
            IntegerRange range = new IntegerRange(newLow, newHigh);
            result.add(range);
            if (high <= this.m_iMax) {
                newLow = high;
                newHigh = this.m_iMax;
                range = new IntegerRange(newLow, newHigh);
                result.add(range);
            }
        } else if (this.m_iMin <= high && high <= this.m_iMax) {
            int newHigh;
            int newLow;
            if (low >= this.m_iMin) {
                newLow = this.m_iMin;
                newHigh = low;
                result.add(new IntegerRange(newLow, newHigh));
            }
            newLow = high;
            newHigh = this.m_iMax;
            result.add(new IntegerRange(newLow, newHigh));
        }
        return result;
    }

    public int getMax() {
        return this.m_iMax;
    }

    public int getMin() {
        return this.m_iMin;
    }

    public boolean set(int min, int max) {
        if (min < max) {
            this.m_iMin = min;
            this.m_iMax = max;
        } else {
            this.m_iMin = max;
            this.m_iMax = min;
        }
        return true;
    }

    public boolean set(int min_max) {
        this.m_iMin = this.m_iMax = min_max;
        return true;
    }

    public boolean set(String strMin, String strMax, int radix) {
        int min = 0;
        int max = 0;
        try {
            min = radix == 16 ? IntegerRange.prarseHexString(strMin.trim()) : Integer.parseInt(strMin.trim(), radix);
        }
        catch (Exception ex) {
            logger.log(Level.INFO, "ItegerSetItem>> set: Error-> failed to parse min. min=" + strMin + ", max=" + strMax + ", radix=" + radix);
            return false;
        }
        try {
            max = radix == 16 ? IntegerRange.prarseHexString(strMax.trim()) : Integer.parseInt(strMax.trim(), radix);
        }
        catch (Exception ex) {
            logger.log(Level.INFO, "ItegerSetItem>> set: Error-> failed to parse max. min=" + strMin + ", max=" + strMax + ", radix=" + radix);
            return false;
        }
        return this.set(min, max);
    }

    public boolean set(String strValue, int radix) {
        int value = 0;
        try {
            value = radix == 16 ? IntegerRange.prarseHexString(strValue.trim()) : Integer.parseInt(strValue.trim(), radix);
        }
        catch (Exception ex) {
            logger.log(Level.INFO, "ItegerSetItem>> set: Error-> failed to parse value. value=" + strValue + ", radix=" + radix, ex);
            return false;
        }
        return this.set(value);
    }

    public int compare(int value) {
        if (value > this.m_iMax) {
            return 1;
        }
        if (value < this.m_iMin) {
            return -1;
        }
        return 0;
    }

    public int getPositionOf(IntegerRange range) {
        int min1 = this.getMin();
        int max1 = this.getMax();
        int min2 = range.getMin();
        int max2 = range.getMax();
        if (min1 == min2) {
            if (max1 == max2) {
                return 1;
            }
            if (max1 < max2) {
                return 2;
            }
            return 3;
        }
        if (min1 < min2) {
            if (max1 > min2) {
                return max1 >= max2 ? 3 : 4;
            }
            if (max1 == min2) {
                return 6;
            }
            if (max1 == min2 - 1) {
                return 8;
            }
            return 10;
        }
        if (min1 < max2) {
            return max1 > max2 ? 5 : 2;
        }
        if (min1 == max2) {
            return 7;
        }
        if (min1 == max2 + 1) {
            return 9;
        }
        return 11;
    }

    @Override
    public int compareTo(Object o) throws ClassCastException {
        if (!(o instanceof IntegerRange)) {
            ClassCastException ex = new ClassCastException("Failed to compare a non-IntegerRange object");
            throw ex;
        }
        IntegerRange range = (IntegerRange)o;
        int min1 = this.getMin();
        int max1 = this.getMax();
        int min2 = range.getMin();
        int max2 = range.getMax();
        if (min1 == min2) {
            return 0;
        }
        if (min1 < min2) {
            return max1 >= min2 ? 0 : 1;
        }
        return min1 <= max2 ? 0 : -1;
    }

    public boolean equals(IntegerRange range) {
        return this.getMin() == range.getMin() && this.getMax() == range.getMax();
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean contains(int value) {
        return this.getMin() <= value && this.getMax() >= value;
    }

    public boolean contains(String strValue, int radix) {
        int value = 0;
        try {
            value = radix == 16 ? IntegerRange.prarseHexString(strValue.trim()) : Integer.parseInt(strValue.trim(), radix);
        }
        catch (Exception ex) {
            logger.log(Level.INFO, "ItegerSetItem>> contains: Error-> failed to parse value. value=" + strValue + ", radix=" + radix);
            return false;
        }
        return this.contains(value);
    }

    public boolean contains(IntegerRange range) {
        return this.getMin() <= range.getMin() && this.getMax() >= range.getMax();
    }

    public String toString() {
        return this.toString(10);
    }

    public String toString(int radix) {
        return this.toString(radix, false);
    }

    public String toString(int radix, boolean showAll, String separator) {
        int min = this.getMin();
        int max = this.getMax();
        StringBuffer buf = new StringBuffer();
        if (min == max) {
            if (radix == 16) {
                buf.append("0x");
            }
            buf.append(Integer.toString(min, radix));
        } else if (showAll) {
            for (int i = min; i <= max; ++i) {
                if (radix == 16) {
                    buf.append("0x");
                }
                buf.append(Integer.toString(i, radix));
                if (i == max) continue;
                buf.append(separator);
            }
        } else {
            if (radix == 16) {
                buf.append("0x");
            }
            buf.append(Integer.toString(min, radix));
            buf.append("-");
            if (radix == 16) {
                buf.append("0x");
            }
            buf.append(Integer.toString(max, radix));
        }
        return buf.toString();
    }

    public String toString(int radix, boolean showAll) {
        return this.toString(radix, showAll, ",");
    }

    public int[] toArray() {
        int count = this.m_iMax - this.m_iMin + 1;
        int[] a = new int[count];
        for (int i = 0; i < count; ++i) {
            a[i] = this.m_iMin + i;
        }
        return a;
    }

    public List<Integer> toList() {
        int count = this.m_iMax - this.m_iMin + 1;
        ArrayList<Integer> list = new ArrayList<Integer>(count);
        for (int i = 0; i < count; ++i) {
            list.add(this.m_iMin + i);
        }
        return list;
    }
}

