/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.util;

import com.sygate.scm.common.configobject.schema.DnsDomain;
import com.sygate.scm.common.configobject.schema.DnsHost;
import com.sygate.scm.common.configobject.schema.FwHostContainer;
import com.sygate.scm.common.configobject.schema.FwUnregulatedHosts;
import com.sygate.scm.common.configobject.schema.IdsPolicy;
import com.sygate.scm.common.configobject.schema.MacAddress;

public class IdsUtility {
    public static void filterUnregulatedHosts(IdsPolicy idsPolicy) {
        FwHostContainer hostContainer;
        FwUnregulatedHosts unregulatedHosts = idsPolicy.getOptFwUnregulatedHosts();
        if (unregulatedHosts != null && (hostContainer = unregulatedHosts.getOptFwHostContainer()) != null) {
            int macAddrCount = hostContainer.getMacAddressCount();
            for (int i = macAddrCount - 1; i >= 0; --i) {
                MacAddress macAddr = hostContainer.getMacAddress(i);
                hostContainer.removeMacAddress(macAddr);
            }
            int dnsDomainCount = hostContainer.getDnsDomainCount();
            for (int i = dnsDomainCount - 1; i >= 0; --i) {
                DnsDomain dnsDomain = hostContainer.getDnsDomain(i);
                hostContainer.removeDnsDomain(dnsDomain);
            }
            int dnsHostCount = hostContainer.getDnsHostCount();
            for (int i = dnsHostCount - 1; i >= 0; --i) {
                DnsHost dnsHost = hostContainer.getDnsHost(i);
                hostContainer.removeDnsHost(dnsHost);
            }
        }
    }

    public static boolean isIPSInstalled(String majorVersion, String minorVersion, String fwOnOff, String cidsOnOff) {
        int major = Integer.parseInt(majorVersion);
        int minor = Integer.parseInt(minorVersion);
        int fw = Integer.parseInt(fwOnOff);
        int cids = Integer.parseInt(cidsOnOff);
        return IdsUtility.isIPSInstalled(major, minor, fw, cids);
    }

    public static boolean isIPSInstalled(int majorVersion, int minorVersion, int fwOnOff, int cidsOnOff) {
        if (majorVersion == 11) {
            return fwOnOff != 2 && fwOnOff != 127;
        }
        if (majorVersion == 12 && minorVersion == 0) {
            return fwOnOff != 2 && fwOnOff != 127;
        }
        if (majorVersion == 12 && minorVersion > 0) {
            return cidsOnOff != 2 && cidsOnOff != 127;
        }
        return cidsOnOff != 2 && cidsOnOff != 127;
    }
}

