/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.util;

import com.sygate.scm.util.AutoClose;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.StringUtilities;
import com.sygate.scm.util.SymantecMessageDigest;
import com.sygate.scm.util.Utility;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.Vector;

public class IOUtilities {
    public static final String VALID_PATH = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789~`!@#$%^&()-_+={}[]\\/:;,. ";

    public static <T extends OutputStream> AutoClose<T> getAutoCloseOutputStream(T object) {
        return new AutoClose<OutputStream>(object, IOUtilities::closeOutputStream);
    }

    public static <T extends InputStream> AutoClose<T> getAutoCloseInputStream(T object) {
        return new AutoClose<InputStream>(object, IOUtilities::closeInputStream);
    }

    public static <T extends Writer> AutoClose<T> getAutoCloseWriter(T object) {
        return new AutoClose<Writer>(object, IOUtilities::closeWriter);
    }

    public static <T extends Reader> AutoClose<T> getAutoCloseableReader(T object) {
        return new AutoClose<Reader>(object, IOUtilities::closeReader);
    }

    @Deprecated
    public static void closeOutputStream(OutputStream stream) {
        try {
            if (stream != null) {
                stream.flush();
                stream.close();
            }
        }
        catch (Exception ignore) {
            LoggerUtilities.logException(ignore);
        }
    }

    public static void closeInputStream(InputStream stream) {
        try {
            if (stream != null) {
                stream.close();
            }
        }
        catch (IOException ignore) {
            LoggerUtilities.logException(ignore);
        }
    }

    @Deprecated
    public static void closeWriter(Writer writer) {
        try {
            if (writer != null) {
                writer.close();
            }
        }
        catch (Exception ignore) {
            LoggerUtilities.logException(ignore);
        }
    }

    @Deprecated
    public static void closeReader(Reader reader) {
        try {
            if (reader != null) {
                reader.close();
            }
        }
        catch (Exception ignore) {
            LoggerUtilities.logException(ignore);
        }
    }

    public static void deleteFile(File file) {
        try {
            if (file.exists() && !file.delete()) {
                System.out.println("<fail to delete the file " + file.getAbsolutePath() + ">");
            }
        }
        catch (Exception ignore) {
            LoggerUtilities.logException(ignore);
        }
    }

    public static String readInputStream(InputStream is) throws IOException {
        int BUFFER = 4086;
        byte[] content = null;
        byte[] bytes = new byte[BUFFER];
        int total = 0;
        int count = -1;
        while ((count = is.read(bytes, 0, BUFFER)) != -1) {
            total += count;
            if (content == null) {
                content = new byte[count];
                System.arraycopy(bytes, 0, content, 0, count);
                continue;
            }
            byte[] newContent = new byte[total];
            System.arraycopy(content, 0, newContent, 0, content.length);
            System.arraycopy(bytes, 0, newContent, content.length, count);
            content = newContent;
        }
        if (content != null) {
            return new String(content, "UTF-8");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InputStream getCopiedInputStream(String filePath) throws IOException {
        ByteArrayInputStream byteArrayInputStream;
        FileInputStream is = null;
        ByteArrayOutputStream outStream = null;
        try {
            is = new FileInputStream(filePath);
            byte[] buff = new byte[2048];
            int count = 0;
            outStream = new ByteArrayOutputStream();
            while ((count = is.read(buff, 0, 2048)) != -1) {
                outStream.write(buff, 0, count);
            }
            byteArrayInputStream = new ByteArrayInputStream(outStream.toByteArray());
        }
        catch (Throwable throwable) {
            IOUtilities.closeOutputStream(outStream);
            IOUtilities.closeInputStream(is);
            throw throwable;
        }
        IOUtilities.closeOutputStream(outStream);
        IOUtilities.closeInputStream(is);
        return byteArrayInputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getFileCheckSum(String testPhysicalFile) throws IOException {
        MessageDigest digest = null;
        try {
            digest = SymantecMessageDigest.getInstance();
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException e) {
            LoggerUtilities.logException(e);
            return "";
        }
        DigestInputStream dis = new DigestInputStream(new BufferedInputStream(new FileInputStream(testPhysicalFile)), digest);
        try {
            byte[] buf = new byte[4096];
            while (dis.read(buf) > 0) {
            }
            String string = Utility.toHexString(digest.digest());
            return string;
        }
        finally {
            IOUtilities.closeInputStream(dis);
        }
    }

    public static boolean isValidPath(String path) {
        if (StringUtilities.isEmpty(path)) {
            return false;
        }
        char[] cpath = path.toCharArray();
        for (int i = 0; i < cpath.length; ++i) {
            if (VALID_PATH.indexOf(cpath[i]) != -1) continue;
            return false;
        }
        return true;
    }

    public static int isValidDir(String strDir, StringBuffer invalidDir) {
        int index;
        String tempString;
        int iResult = -2;
        if (invalidDir == null) {
            invalidDir = new StringBuffer("");
        }
        if (strDir == null || strDir.length() <= 0) {
            return -1;
        }
        if (strDir.endsWith(File.separator)) {
            strDir = strDir.substring(0, strDir.length() - 1);
        } else if (strDir.indexOf(":") > 0 && !strDir.trim().endsWith(":") && !(tempString = strDir.substring(0, (index = strDir.indexOf(":")) + 2)).endsWith(File.separator)) {
            return -2;
        }
        File f = new File(strDir);
        if (f.exists()) {
            iResult = f.isFile() ? 11 : (f.isDirectory() ? 0 : -1);
        } else {
            iResult = 12;
            Vector<String> vParents = new Vector<String>();
            vParents.addElement(strDir);
            File tempFile = new File(strDir);
            String strParent = tempFile.getParent();
            while (strParent != null) {
                tempFile = new File(strParent);
                if (tempFile.exists()) {
                    strParent = tempFile.getAbsolutePath();
                    iResult = 1;
                    break;
                }
                vParents.addElement(strParent);
                strParent = tempFile.getParent();
            }
            if (strParent == null) {
                strParent = "";
            }
            System.getProperties().setProperty("existing.parent.dir", strParent);
            System.out.println("<existing.parent.dir, " + System.getProperties().getProperty("existing.parent.dir") + " >");
            if (iResult == 1) {
                int i = 0;
                for (i = vParents.size() - 1; i > -1; --i) {
                    tempFile = new File((String)vParents.elementAt(i));
                    if (tempFile.mkdir()) continue;
                    invalidDir.append(tempFile.getAbsolutePath());
                    strParent = (String)vParents.elementAt(i);
                    iResult = 12;
                    ++i;
                    break;
                }
                if (iResult == 1) {
                    i = 0;
                }
                while (i < vParents.size()) {
                    tempFile = new File((String)vParents.elementAt(i));
                    if (!tempFile.delete()) {
                        System.out.println("<fail to delete the temp file >");
                    }
                    ++i;
                }
            } else {
                invalidDir.append(tempFile.getAbsolutePath());
                iResult = 13;
            }
        }
        return iResult;
    }

    public static boolean isValidFile(String strFile) {
        if (strFile == null || strFile.length() <= 0) {
            return false;
        }
        File file = new File(strFile);
        return file.exists() && file.isFile();
    }

    public static boolean deleteDir(File dir) {
        String[] children = dir.list();
        if (null != children) {
            for (int i = 0; i < children.length; ++i) {
                boolean success = IOUtilities.deleteDir(new File(dir, children[i]));
                if (success) continue;
                System.out.println("deleteDir: Fail to delete file " + children[i]);
                return false;
            }
        }
        return dir.delete();
    }

    public static boolean renameFile(File src, File dst, boolean deleteDst) {
        int RETRY_CNT = 5;
        int RETRY_INTERVAL = 2000;
        int i = 0;
        String srcPath = "";
        String dstPath = "";
        try {
            srcPath = src.getCanonicalPath();
            dstPath = dst.getCanonicalPath();
        }
        catch (IOException ignore) {
            LoggerUtilities.logException(ignore);
        }
        if (!src.exists()) {
            System.out.println("renameFile: Source file does not exist : " + srcPath);
            return false;
        }
        if (dst.exists()) {
            if (!deleteDst) {
                System.out.println("renameFile: Destinate file already exist : " + dstPath);
                return false;
            }
            for (i = 5; i > 0 && !IOUtilities.deleteDir(dst); --i) {
                System.out.println("Try#" + i + ":Fail to delete destinate file : " + dstPath);
                try {
                    Thread.sleep(2000L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (i <= 0) {
                System.out.println("renameFile:Fail to delete destinate file : " + dstPath);
                return false;
            }
        }
        for (i = 5; i > 0 && !src.renameTo(dst); --i) {
            System.out.println("Try#" + i + ":Fail to rename file from " + srcPath + " to " + dstPath);
            try {
                Thread.sleep(2000L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (i > 0) {
            System.out.println("renameFile:Succeed to rename file from " + srcPath + " to " + dstPath);
            return true;
        }
        System.out.println("renameFile:Fail to rename file from " + srcPath + " to " + dstPath);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static boolean cleanupFileContent(String filePath) {
        boolean fileContentCleaned;
        block9: {
            System.out.println(IOUtilities.class.getName() + ": IOUtilities> cleanupFileContent>> Cleaning up file content of " + filePath);
            BufferedOutputStream outputStream = null;
            fileContentCleaned = false;
            try {
                File file = new File(filePath);
                if (file.exists()) {
                    outputStream = new BufferedOutputStream(new FileOutputStream(file));
                    ((OutputStream)outputStream).write("".getBytes("UTF-8"));
                    ((OutputStream)outputStream).flush();
                    fileContentCleaned = true;
                    System.out.println(IOUtilities.class.getName() + ": IOUtilities> cleanupFileContent>> File content cleaned.");
                } else {
                    System.out.println(IOUtilities.class.getName() + ": IOUtilities> cleanupFileContent>> File [" + filePath + "] does not exist.");
                }
                IOUtilities.closeOutputStream(outputStream);
            }
            catch (IOException ioe) {
                System.out.println(IOUtilities.class.getName() + "IOUtilities> cleanupFileContent>> File [" + filePath + "] content cleanup failed. IOException message is " + ioe.getMessage());
                LoggerUtilities.logException(ioe);
            }
            catch (SecurityException se) {
                System.out.println(IOUtilities.class.getName() + ": IOUtilities> cleanupFileContent>> File [" + filePath + "] content cleanup failed. SecurityException message is " + se.getMessage());
                LoggerUtilities.logException(se);
                break block9;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                IOUtilities.closeOutputStream(outputStream);
            }
        }
        return fileContentCleaned;
    }

    public static String getCanonicalPath(String filePath) throws IOException {
        File f = new File(filePath);
        return f.getCanonicalPath();
    }

    public static boolean createNewFile(File file, int retryCount, long retryInterval) {
        boolean isFileCreated = false;
        for (int index = 1; index <= retryCount && !(isFileCreated = IOUtilities.createNewFile(file)); ++index) {
            try {
                Thread.sleep(retryInterval);
            }
            catch (InterruptedException ex) {
                LoggerUtilities.logException(ex);
            }
            if (index != retryCount) continue;
            StringBuffer buffer = new StringBuffer("Creation of new file failed with retry count of ");
            buffer.append(retryCount).append(" with an interval of ").append(retryInterval).append(". File:").append(file.getAbsolutePath());
            System.out.println(buffer.toString());
        }
        return isFileCreated;
    }

    public static boolean createNewFile(File file) {
        boolean result = false;
        try {
            if (file.createNewFile()) {
                result = true;
            }
        }
        catch (Exception ex) {
            System.out.println("Creation of file failed with exception: " + ex.getMessage());
            LoggerUtilities.logException(ex);
        }
        return result;
    }
}

