/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.util;

import com.sygate.scm.common.ui.UIColorUtilities;
import com.sygate.scm.common.ui.UIFontUtilities;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.StringUtilities;
import java.awt.Font;
import java.awt.font.TextAttribute;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;

public class HTMLUtilities {
    private static Map<String, String> STYLE_SHEET = new HashMap<String, String>();
    public static final String DEFAULT_CSS = "/com/sygate/scm/util/console";
    public static final String HTML_BEGIN = "<HTML>";
    public static final String HEAD_BEGIN = "<HEAD>";
    public static final String BODY_BEGIN = "<BODY>";
    public static final String BODY_END = "</BODY>";
    public static final String HEAD_END = "</HEAD>";
    public static final String HTML_END = "</HTML>";
    public static final String HTML_DOCUMENT_BEGIN;
    public static final String HTML_DOCUMENT_TRANSPARENT_BEGIN = "<HTML><HEAD><style type=\"text/css\">BODY {background-color:transparent; color: #000; margin:0px 0px 0px 0px}</style></HEAD><BODY>";
    public static final String HTML_DOCUMENT_END = "</BODY></HTML>";
    private static final String HTML_TITLE_FONT;
    public static final String HTML_TITLE_FONT_STYLE;
    public static final String HTML_FONT;
    public static final String HTML_FONT_STYLE;
    @Deprecated
    public static final String WIZARD_CONTENT_STYLE_STD;
    @Deprecated
    public static final String WIZARD_CONTENT_STYLE_STD_NEW;
    @Deprecated
    public static final String WIZARD_FOOT_CONTENT_STYLE;

    public static String filter(String input) {
        StringBuffer filtered = new StringBuffer(input.length());
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (c == '<') {
                filtered.append("&lt;");
                continue;
            }
            if (c == '>') {
                filtered.append("&gt;");
                continue;
            }
            if (c == '\"') {
                filtered.append("&quot;");
                continue;
            }
            if (c == '&') {
                filtered.append("&amp;");
                continue;
            }
            filtered.append(c);
        }
        return filtered.toString();
    }

    public static String filterAndConvertNewLines(String input) {
        StringBuffer filtered = new StringBuffer(input.length());
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (c == '<') {
                filtered.append("&lt;");
                continue;
            }
            if (c == '>') {
                filtered.append("&gt;");
                continue;
            }
            if (c == '\"') {
                filtered.append("&quot;");
                continue;
            }
            if (c == '&') {
                filtered.append("&amp;");
                continue;
            }
            if (c == ' ') {
                filtered.append("&nbsp;");
                continue;
            }
            filtered.append(c);
        }
        String text = filtered.toString();
        text = text.replaceAll("\n", "<br>");
        return text;
    }

    public static String img(URL url) {
        return "<img border='0' src='" + url + "'  align='middle' hspace='2' height='16' width='16'>";
    }

    private static String getTextFileContent(String fileName) {
        try {
            URL fileUrl = HTMLUtilities.class.getResource(fileName);
            if (fileUrl == null) {
                return null;
            }
            StringBuffer sb = new StringBuffer();
            BufferedInputStream src = new BufferedInputStream(fileUrl.openStream());
            byte[] buf = new byte[2048];
            int readNum = 0;
            while ((readNum = ((InputStream)src).read(buf)) != -1) {
                sb.append(new String(buf, 0, readNum, "UTF-8"));
            }
            ((InputStream)src).close();
            return sb.toString();
        }
        catch (NullPointerException ex) {
            if (fileName.equals("/com/sygate/scm/util/console.css")) {
                LoggerUtilities.logException(ex);
            }
        }
        catch (Exception ex) {
            LoggerUtilities.logException(ex);
        }
        return "";
    }

    public static String getStyleSheet() {
        String lang = System.getProperty("user.language");
        String styleSheet = STYLE_SHEET.get(lang);
        if (styleSheet != null && styleSheet.length() != 0) {
            return styleSheet;
        }
        return STYLE_SHEET.get("en");
    }

    private static void updateUnderline(JComponent component, Integer underline) {
        Font font = component.getFont();
        Map<TextAttribute, ?> attributes = font.getAttributes();
        HashMap newAttributes = new HashMap(attributes);
        newAttributes.put(TextAttribute.UNDERLINE, underline);
        component.setFont(font.deriveFont(newAttributes));
    }

    public static void highlightHyperLink(JComponent component) {
        component.setForeground(UIColorUtilities.LINK_HOVER_FOREGROUND);
        HTMLUtilities.updateUnderline(component, TextAttribute.UNDERLINE_ON);
    }

    public static void enableHyperLink(JComponent component) {
        component.setForeground(UIColorUtilities.LINK_FOREGROUND);
        HTMLUtilities.updateUnderline(component, -1);
    }

    static {
        String defaultStyleSheet = HTMLUtilities.getTextFileContent("/com/sygate/scm/util/console.css");
        if (defaultStyleSheet == null) {
            System.out.println("HTMLUtilities, defaultStyleSheet is null.");
            defaultStyleSheet = "";
        }
        STYLE_SHEET.put("en", defaultStyleSheet);
        String lang = System.getProperty("user.language");
        if (!"en".equals(lang)) {
            String localStyleSheetName = "/com/sygate/scm/util/console_" + lang + ".css";
            String localeStyleSheet = HTMLUtilities.getTextFileContent(localStyleSheetName);
            if (!StringUtilities.isEmpty(localeStyleSheet)) {
                STYLE_SHEET.put(lang, localeStyleSheet);
            } else {
                System.out.println("HTMLUtilities, " + localStyleSheetName + " is null or empty.");
            }
        }
        HTML_DOCUMENT_BEGIN = "<HTML><HEAD><style type=\"text/css\">" + HTMLUtilities.getStyleSheet() + "</style></HEAD><BODY>";
        HTML_TITLE_FONT = "font-family:" + UIFontUtilities.STANDARD_FONT_NAME + ";font-size:" + UIFontUtilities.STANDARD_FONT_SIZE_WITH_UNITS + ";font-weight:bold";
        HTML_TITLE_FONT_STYLE = "style=\"" + HTML_TITLE_FONT;
        HTML_FONT = "font-family:" + UIFontUtilities.STANDARD_FONT_NAME + ";font-size:" + UIFontUtilities.STANDARD_FONT_SIZE_WITH_UNITS;
        HTML_FONT_STYLE = "style=\"" + HTML_FONT;
        WIZARD_CONTENT_STYLE_STD = HTML_FONT_STYLE;
        WIZARD_CONTENT_STYLE_STD_NEW = HTML_FONT_STYLE;
        WIZARD_FOOT_CONTENT_STYLE = HTML_FONT_STYLE;
    }
}

