/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.util;

import com.sygate.scm.util.GUID;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.Utility;
import java.net.InetAddress;
import java.security.SecureRandom;
import java.util.Random;

public class GUIDGenerator {
    private static SecureRandom random = new SecureRandom();
    private static SecureRandom random1 = new SecureRandom();
    private int midPart1;
    private int midPart2;
    private static GUIDGenerator myGenerator;
    private static byte[] ip;

    public GUIDGenerator() {
        try {
            if (ip == null) {
                InetAddress localhost = InetAddress.getLocalHost();
                GUIDGenerator.setIpAddress(localhost.getAddress());
            }
            this.midPart1 = Utility.readInt(ip, 0);
        }
        catch (Exception e) {
            LoggerUtilities.logException(e);
            Random r = new Random();
            this.midPart1 = r.nextInt((int)Runtime.getRuntime().freeMemory());
            GUIDGenerator.setIpAddress(new byte[4]);
            Utility.writeInt(this.midPart1, ip, 0);
        }
        this.midPart2 = this.hashCode();
    }

    public byte[] getGUIDBytes() {
        try {
            int firstPart = random.nextInt();
            int lastPart = random1.nextInt();
            byte[] bytes = new byte[16];
            Utility.writeInt(firstPart, bytes, 0);
            Utility.writeInt(this.midPart1, bytes, 4);
            Utility.writeInt(this.midPart2, bytes, 8);
            Utility.writeInt(lastPart, bytes, 12);
            return bytes;
        }
        catch (Exception e) {
            LoggerUtilities.logException(e);
            return null;
        }
    }

    public GUID getNext() {
        return new GUID(this.getGUIDBytes());
    }

    public String getGUIDString() {
        byte[] guid = this.getGUIDBytes();
        return Utility.toHexString(guid);
    }

    public static String convertGUIDToHyphenFormat(String guidNoHyphen) {
        StringBuffer guidWithHyphenBuf = new StringBuffer();
        guidWithHyphenBuf.append(guidNoHyphen.substring(0, 8));
        guidWithHyphenBuf.append("-");
        guidWithHyphenBuf.append(guidNoHyphen.substring(8, 12));
        guidWithHyphenBuf.append("-");
        guidWithHyphenBuf.append(guidNoHyphen.substring(12, 16));
        guidWithHyphenBuf.append("-");
        guidWithHyphenBuf.append(guidNoHyphen.substring(16, 20));
        guidWithHyphenBuf.append("-");
        guidWithHyphenBuf.append(guidNoHyphen.substring(20, 32));
        String guidWithHyphen = guidWithHyphenBuf.toString();
        return guidWithHyphen.toLowerCase();
    }

    public static GUIDGenerator getInstance() {
        if (myGenerator == null) {
            myGenerator = new GUIDGenerator();
        }
        return myGenerator;
    }

    private static void setIpAddress(byte[] ipAddress) {
        ip = ipAddress;
    }

    static {
        ip = null;
    }
}

