/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.util;

import com.sygate.scm.util.Utility;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class GUID
implements Comparable<GUID> {
    public static final String CONFIG_ROOT_GUID = "B655E64D0A320801000000E164041B79";
    public static final String BUILD_IN_ADMIN_GUID = "AF3C39A10A320801000000DBF200C60A";
    public static final String LOCAL_SETTING_GUID = "5C407C0E0A32080101A5AF9FFD77D613";
    public static final String SYS_ADMINISTRATOR_ARRAY_GUID = "3396C0130AC860A001FABA46BDDD21E2";
    public static final String PROCESS_STATE_GUID = "9527897DAFAB481FBD4296DB76D05517";
    public static final String PROCESS_STATE_REP_AGGREGATING_GUID = "89C707960A214FD50B8336D6FB7B8E0F";
    public static final String PROCESS_STATE_DB_SHRINK_GUID = "004CE884252D4ADD1F4032FDD485BE4E";
    public static final String PROCESS_STATE_AGENTSWEEP_GUID = "T2AB32TAFYI216G1R4368OI76D972189";
    public static final String TELEMETRY_DATADICTIONARY_GUID = "68d95d43035c46dc8bf6e8b1e4e18c5b";
    public static final String SECURITY_MINING_GUID = "6AC4808D0AC82B0E00C58432481F2F27";
    public static final String TRUNCATE_TXN_LOG_GUID = "D3C338D68C84433495931DF518251B88";
    public static final String REBUILD_INDEXES_GUID = "EB57F253D04C4EE4840B7E46ED693598";
    public static final String LU_TASK_GUID = "E4AC0D830AC87A84010104351B00FC5D";
    public static final String COMMAND_RESULT_PROCESS_TASK_GUID = "635DE20668F94C57B44F6C1B84E5D2F3";
    public static final String AGENT_PACKET_LOG_1_GUID = "7325D75F0AC860D00033AA7B5DFC9C18";
    public static final String AGENT_PACKET_LOG_2_GUID = "956F713B0AC860D00033AA7BF9A9A5E6";
    public static final String AGENT_SECURITY_LOG_1_GUID = "2673FB160AC860D00033AA7B79B93FDF";
    public static final String AGENT_SECURITY_LOG_2_GUID = "0FB5E6CD0AC860D00033AA7BE8CF0726";
    public static final String AGENT_SYSTEM_LOG_1_GUID = "871F97460AC860D00033AA7B89FF2C7D";
    public static final String AGENT_SYSTEM_LOG_2_GUID = "9D1D01730AC860D00033AA7B786E8522";
    public static final String AGENT_TRAFFIC_LOG_1_GUID = "DE99A3020AC860D00033AA7B9B510E5C";
    public static final String AGENT_TRAFFIC_LOG_2_GUID = "2E6F0D7E0AC860D00033AA7B5913B274";
    public static final String AGENT_BEHAVIOR_LOG_1_GUID = "BB75E3910AC860D00033AA7B2AC3A61E";
    public static final String AGENT_BEHAVIOR_LOG_2_GUID = "A60563560AC860D00033AA7B16E5EE9B";
    public static final String SEM_APPLICATION_GUID = "92AB24560AC860D00033AA7B7061ED85";
    public static final String COMPUTER_APPLICATION_GUID = "9BAB24560AC860D00033AA7B7061ED86";
    public static final String ANOMALYREMEDIATIONS_GUID = "92AB24560AC860D00033AA7B7061ED85";
    public static final String ALERTS_GUID = "92AB2AAAAAC860D00033AA7B7061ED85";
    public static final String SEM_CONTENT_GUID = "92AB2BBBBAC860D00033AA7B7061ED85";
    public static final String SCANS_GUID = "92AB2CCCCAC860D00033AA7B7061ED85";
    public static final String FILE_REPLICAITON_DATA_GUID = "D5553837A7CF449F82E8EC4174209FFF";
    public static final String UI_ADDON_FEATURE_SET_GUID = "5eedd6f6cf20750d1460fcc1ab6dd68e";
    public static final String UI_ADDON_FEATURE_SET_SSC_GUID = "5ee0505f9a5149f492f399e91f93c95b";
    public static final String EPMP_CLOUD_ENROLLMENT_ID_ARRAY_GUID = "D5553837A7CF449F82E8EC4174209BD2";
    private byte[] bytes = new byte[16];
    private String hexString;

    public GUID(byte[] array) {
        System.arraycopy(array, 0, this.bytes, 0, 16);
        this.hexString = Utility.toHexString(this.bytes);
    }

    public GUID(String string) {
        if (string == null || string.length() != 32) {
            throw new NumberFormatException("Invalid GUID String");
        }
        this.hexString = string;
        this.bytes = Utility.toByteArray(string);
    }

    public byte[] getBytes() {
        return this.bytes == null ? null : (byte[])this.bytes.clone();
    }

    public static GUID parseGUID(String guid) {
        return new GUID(guid);
    }

    public static GUID[] parseGUIDs(List<String> ids) {
        return Optional.ofNullable(ids).orElse(List.of()).stream().map(GUID::new).collect(Collectors.toList()).toArray(new GUID[0]);
    }

    public String getStringRepresentation() {
        return this.hexString;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof GUID) {
            GUID other = (GUID)obj;
            return Utility.bytesCompare(this.getBytes(), other.getBytes());
        }
        return false;
    }

    public int hashCode() {
        return this.getStringRepresentation().hashCode();
    }

    public String toString() {
        return this.hexString;
    }

    public String getIpAddress() {
        byte[] b = new byte[]{this.bytes[4], this.bytes[5], this.bytes[6], this.bytes[7]};
        return Utility.getIPString(b);
    }

    public static String getIpAddress(String guid) {
        return new GUID(guid).getIpAddress();
    }

    @Override
    public int compareTo(GUID o) {
        return this.toString().compareTo(o.toString());
    }
}

