/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.util;

import com.sygate.scm.util.LoggerUtilities;
import java.security.Provider;
import java.security.Security;
import java.util.stream.Stream;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.jcajce.provider.BouncyCastleFipsProvider;

public class FipsUtil {
    public static final String BOUNCY_CASTLE_PROVIDER = "BCFIPS";

    private FipsUtil() {
        throw new IllegalStateException("FipsUtil class");
    }

    public static void loadBouncyCastleProvider() {
        Provider bcFipsProvider = Security.getProvider(BOUNCY_CASTLE_PROVIDER);
        if (bcFipsProvider == null) {
            LoggerUtilities.log("FipsUtil loadBouncyCastleProvider, adding BouncyCastle provider dynamically");
            int pos = 1;
            Security.insertProviderAt((Provider)new BouncyCastleFipsProvider(), pos);
            Stream.of(Security.getProviders()).forEach(provider -> LoggerUtilities.log("Loaded Providers: " + provider));
            Security.getAlgorithms("Cipher").forEach(algorithm -> LoggerUtilities.log("Supported Cipher Algorithms: " + algorithm));
            Security.getAlgorithms("MessageDigest").forEach(algorithm -> LoggerUtilities.log("Supported MessageDigest Algorithms: " + algorithm));
        }
    }

    public static boolean getApprovedOnlyMode() {
        boolean bcApprovedOnlyMode = CryptoServicesRegistrar.isInApprovedOnlyMode();
        LoggerUtilities.log("FipsUtil approved_only mode for BouncyCastle provider: " + bcApprovedOnlyMode);
        return bcApprovedOnlyMode;
    }
}

