/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.util;

import com.sygate.scm.util.IOUtilities;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;

public class FileUtils {
    public static final int FILE_PERMISSION_READ_WRITE_EXEC = 493;

    public static long sizeOf(File[] file) {
        if (file == null || file.length == 0) {
            return 0L;
        }
        long result = 0L;
        for (File f : file) {
            result += f.length();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getUncompressedSize(File zipFile) throws IOException {
        long sizeTotal = -1L;
        if (zipFile != null && zipFile.exists()) {
            ZipInputStream zis = null;
            try {
                zis = new ZipInputStream(new BufferedInputStream(new FileInputStream(zipFile.getAbsoluteFile())));
                sizeTotal = 0L;
                ZipEntry entry = null;
                while ((entry = zis.getNextEntry()) != null) {
                    if (entry.isDirectory()) continue;
                    sizeTotal += entry.getSize();
                }
            }
            catch (Throwable throwable) {
                IOUtilities.closeInputStream(zis);
                throw throwable;
            }
            IOUtilities.closeInputStream(zis);
        }
        return sizeTotal;
    }

    public static String readFileToString(Path filePath) throws IOException {
        if (filePath == null) {
            throw new IllegalArgumentException("<readFileToString> file argument is null");
        }
        File file = filePath.toFile();
        if (file.length() > 0xA00000L) {
            throw new UnsupportedOperationException("File too big, use buffered reader");
        }
        byte[] bytes = Files.readAllBytes(file.toPath());
        return new String(bytes, StandardCharsets.UTF_8);
    }

    @Deprecated(forRemoval=true)
    public static String readFileToString(String filePath) throws IOException {
        if (filePath == null) {
            throw new IllegalArgumentException("<readFileToString> file argument is null");
        }
        return FileUtils.readFileToString(Path.of(filePath, new String[0]));
    }

    public static void touch(File file) {
        boolean success;
        if (file == null) {
            throw new IllegalArgumentException("File object argument is null");
        }
        if (file.exists() && !(success = file.setLastModified(System.currentTimeMillis()))) {
            System.out.println(FileUtils.class.getName() + ": Unable to set the last modification time for " + file);
        }
    }

    public static void copyFolder(File sourceFolderPath, File targetFolderPath) throws IOException {
        if (sourceFolderPath == null || targetFolderPath == null) {
            throw new IllegalArgumentException("source / target folder path is null");
        }
        final Path sourcePath = sourceFolderPath.getCanonicalFile().toPath();
        final Path targetPath = targetFolderPath.getCanonicalFile().toPath();
        System.out.println(FileUtils.class.getName() + ": Copying folder: \"" + sourceFolderPath + "\" to: \"" + targetFolderPath + "\"");
        Files.walkFileTree(sourcePath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                System.out.println(FileUtils.class.getName() + ": Creating folder:" + dir.toString());
                try {
                    Files.createDirectories(targetPath.resolve(sourcePath.relativize(dir)), new FileAttribute[0]);
                }
                catch (FileAlreadyExistsException ex) {
                    System.out.println(FileUtils.class.getName() + ": Unable to create directory, it already exists:" + dir + "." + ex.getMessage());
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                System.out.println(FileUtils.class.getName() + ": Copying file:" + file.toString());
                try {
                    Files.copy(file, targetPath.resolve(sourcePath.relativize(file)), new CopyOption[0]);
                }
                catch (FileAlreadyExistsException ex) {
                    System.out.println(FileUtils.class.getName() + ": Unable to copy file, it already exists:" + file + "." + ex.getMessage());
                }
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public static boolean moveFileOrFolder(File source, File target, boolean isOverwritable) {
        boolean isMoved = false;
        if (source == null || target == null) {
            throw new IllegalArgumentException("One or more argument is null");
        }
        try {
            Path sourcePath = source.getCanonicalFile().toPath();
            Path targetPath = target.getCanonicalFile().toPath();
            if (isOverwritable) {
                Files.move(sourcePath, targetPath, StandardCopyOption.REPLACE_EXISTING);
            } else {
                Files.move(sourcePath, targetPath, new CopyOption[0]);
            }
            isMoved = true;
        }
        catch (IOException ex) {
            System.out.println(FileUtils.class.getName() + ": Unable to move file:" + ex.getMessage() + System.getProperty("line.separator") + source + "->" + target);
        }
        return isMoved;
    }

    public static long getUnZippedSize(String zipFileName) throws IOException {
        File file = new File(zipFileName);
        if (!file.isFile()) {
            return 0L;
        }
        long totalSize = 0L;
        try {
            ZipFile zipFile = new ZipFile(zipFileName);
            Enumeration<? extends ZipEntry> enu = zipFile.entries();
            while (enu.hasMoreElements()) {
                ZipEntry zipEntry = enu.nextElement();
                totalSize += zipEntry.getSize();
            }
            zipFile.close();
        }
        catch (IOException exception) {
            System.out.println(FileUtils.class.getName() + " getUnZippedSize(): " + exception.getMessage());
        }
        return totalSize;
    }

    public static boolean containsAnyFile(Path path) {
        if (path == null) {
            return false;
        }
        if (Files.isRegularFile(path, LinkOption.NOFOLLOW_LINKS)) {
            return true;
        }
        final AtomicBoolean contains = new AtomicBoolean(false);
        try {
            Files.walkFileTree(path, EnumSet.noneOf(FileVisitOption.class), 5, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    contains.set(true);
                    return FileVisitResult.TERMINATE;
                }

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException exception) {
            System.out.println(FileUtils.class.getName() + " containsFile(): Unable to check if file exist in Folder " + path);
        }
        return contains.get();
    }
}

