/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.util;

import com.sygate.scm.util.Utility;
import java.math.BigInteger;
import java.util.List;
import java.util.Locale;
import java.util.Optional;

public class ExceptionPolicyUtility {
    public static final List<String> LIST_KNOWN_RISK_FILTER = List.of("AGR", "HUNTER", "SONAR", "XONAR", "AGP");

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isValidKnownRisk(String knowRiskVid, String knowRiskVirusName) {
        BigInteger sigHex1 = new BigInteger("ffff6000", 16);
        BigInteger sigHex2 = new BigInteger("ffff7000", 16);
        BigInteger iVidAnd = BigInteger.valueOf(Utility.parseLong(knowRiskVid, 0L)).and(new BigInteger("fffff000", 16));
        if (iVidAnd.equals(sigHex1)) return true;
        if (iVidAnd.equals(sigHex2)) return true;
        if (!LIST_KNOWN_RISK_FILTER.stream().anyMatch(Optional.ofNullable(knowRiskVirusName).orElse("").toUpperCase(Locale.ROOT)::startsWith)) return false;
        return true;
    }
}

