/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.util;

import com.sygate.scm.common.configobject.agent.DynaCat;
import com.sygate.scm.common.configobject.schema.ApAction;
import com.sygate.scm.common.configobject.schema.ApActions;
import com.sygate.scm.common.configobject.schema.AvAutoProtect;
import com.sygate.scm.common.configobject.schema.AvFileAp;
import com.sygate.scm.common.configobject.schema.AvPolicy;
import com.sygate.scm.common.configobject.schema.LinuxAvAutoProtect;
import com.sygate.scm.common.configobject.schema.LotusNotesAp;
import com.sygate.scm.common.configobject.schema.MsftExchangeAp;
import com.sygate.scm.common.configobject.schema.SecurityRiskGroup;
import com.sygate.scm.common.configobject.schema.SecurityRiskItem;
import com.sygate.scm.common.configobject.schema.WebMailAp;
import com.sygate.scm.common.configobject.table.SemTable;
import com.sygate.scm.common.configobject.table.SemTableRow;
import com.sygate.scm.util.StringUtilities;
import java.util.HashMap;
import java.util.List;

public class DynaCatManipulationUtility {
    public static final String SECURITY_RISKS_ACTION = "SecurityRisksAction";
    public static final String MACRO_VIRUS_ACTION = "MacroVirusAction";
    public static final String NON_MACRO_VIRUS_ACTION = "NonMacroVirusAction";
    public static final String MALWARE_ACTION = "MalwareAction";
    public static final String HACKERS_TOOLS_ACTION = "HackerToolsAction";
    public static final String SPYWARE_ACTION = "SpywareAction";
    public static final String TRACKWARE_ACTION = "TrackwareAction";
    public static final String COOKIES_ACTION = "CookieAction";
    public static final String DIALERS_ACTION = "DialersAction";
    public static final String REMOTE_ACCESS_ACTION = "RemoteAccessAction";
    public static final String ADWARE_ACTION = "AdwareAction";
    public static final String JOKE_PROGRAMS_ACTION = "JokeProgramsAction";
    public static final String OTHER_ACTION = "OtherAction";
    public static final String DOWNLOAD_ACTION = "DownloadAction";
    public static final String DYNACAT_VIRUS_ACTION = "1:0";
    public static final String DYNACAT_HEURISTIC_VIRUS_ACTION = "1:3";
    public static final String DYNACAT_DOWNLOADS_ACTION = "1:18";
    public static final String DYNACAT_HACKERS_TOOLS_ACTION = "2:5";
    public static final String DYNACAT_SPYWARE_ACTION = "2:6";
    public static final String DYNACAT_TRACKWARE_ACTION = "2:7";
    public static final String DYNACAT_DIALERS_ACTION = "2:8";
    public static final String DYNACAT_REMOTE_ACCESS_ACTION = "2:9";
    public static final String DYNACAT_ADWARE_ACTION = "2:10";
    public static final String DYNACAT_JOKE_PROGRAMS_ACTION = "2:11";
    public static final String DYNACAT_COOKIES_ACTION = "2:15";
    public static final String MISLEADING_APPLICATION_ACTION = "MisleadingApplication";
    public static final String PARENTAL_CONTROL_ACTION = "ParentalControl";
    public static final String SECURITY_ASSESSMENT_TOOL_ACTION = "SecurityAssessment";
    public static final String SECURITY_RISK_ACTION = "SecurityRisk";
    public static final String DYNACAT_MISLEADING_APPLICATION_ACTION = "2:14";
    public static final String DYNACAT_PARENTAL_CONTROL_ACTION = "2:17";
    public static final String DYNACAT_SECURITY_ASSESSMENT_TOOL_ACTION = "2:13";
    public static final String DYNACAT_SECURITY_RISK_ACTION = "2:4";
    public static final String MALWARE = "Malware";
    public static final String SECURITY_RISKS = "SecurityRisks";
    public static final String ADVANCED_HEURISTICS = "AdvancedHeuristics";
    public static final String EXPERIMENTAL_HEURISTICS = "ExperimentalHeuristics";
    public static final String REPUTATION_BASED_ADVANCED_HEURISTICS = "ReputationBasedAdvancedHeuristics";
    public static final String UBER_CATEGORY_ERASER = "0";
    public static final String UBER_CATEGORY_MALWARE = "1";
    public static final String UBER_CATEGORY_SECURITY_RISK = "2";
    public static final String UBER_CATEGORY_EXPERIMENTAL_HEURISTICS = "4";
    public static final String UBER_CATEGORY_ADVANCED_HEURISTICS = "8";
    public static final String UBER_CATEGORY_REPUTATION_ADVANCED_HEURISTICS = "9";
    public static final String DYNACAT_VIRUS = "0";
    public static final String DYNACAT_HEURISTIC_VIRUS = "3";
    public static final String DYNACAT_DOWNLOAD = "18";
    public static final String DYNACAT_UBER_CATEGORY_EXPANDED_HIVE = "Expanded";
    public static final String DYNACAT_UBER_CATEGORY_MALWARE_HIVE = "Malware";

    public static String[] getDynaUberCategories() {
        return new String[]{UBER_CATEGORY_MALWARE, UBER_CATEGORY_SECURITY_RISK};
    }

    public static String getUberCategoryName(String uberCategoryId) {
        if (UBER_CATEGORY_MALWARE.equals(uberCategoryId)) {
            return "Malware";
        }
        if (UBER_CATEGORY_SECURITY_RISK.equals(uberCategoryId)) {
            return SECURITY_RISKS;
        }
        if (UBER_CATEGORY_ADVANCED_HEURISTICS.equals(uberCategoryId)) {
            return ADVANCED_HEURISTICS;
        }
        if (UBER_CATEGORY_EXPERIMENTAL_HEURISTICS.equals(uberCategoryId)) {
            return EXPERIMENTAL_HEURISTICS;
        }
        if (UBER_CATEGORY_REPUTATION_ADVANCED_HEURISTICS.equals(uberCategoryId)) {
            return REPUTATION_BASED_ADVANCED_HEURISTICS;
        }
        return null;
    }

    public static ApAction getApAction(SecurityRiskGroup group) {
        if (group == null) {
            return null;
        }
        ApAction apAction = new ApAction();
        if (UBER_CATEGORY_MALWARE.equals(group.getName())) {
            apAction.setFirstAction(ApAction.CLEAN);
            apAction.setSecondAction(ApAction.QUARANTINE);
        } else {
            apAction.setFirstAction(ApAction.QUARANTINE);
            apAction.setSecondAction(ApAction.LOG_ONLY);
        }
        return apAction;
    }

    public static ApAction getApAction(SecurityRiskItem item) {
        if (item == null) {
            return null;
        }
        ApAction apAction = new ApAction();
        if (DynaCatManipulationUtility.isMalwareCategory(item.getName()) && !DYNACAT_DOWNLOADS_ACTION.equals(item.getName())) {
            apAction.setFirstAction(ApAction.CLEAN);
            apAction.setSecondAction(ApAction.QUARANTINE);
        } else if (DYNACAT_COOKIES_ACTION.equals(item.getName())) {
            apAction.setFirstAction(ApAction.DELETE);
            apAction.setSecondAction(ApAction.LOG_ONLY);
        } else {
            apAction.setFirstAction(ApAction.QUARANTINE);
            apAction.setSecondAction(ApAction.LOG_ONLY);
        }
        return apAction;
    }

    public static String checkSecurityGroupLegacy(String groupName) {
        if (SECURITY_RISKS_ACTION.equals(groupName)) {
            return UBER_CATEGORY_SECURITY_RISK;
        }
        if ("Malware".equals(groupName) || MALWARE_ACTION.equals(groupName)) {
            return UBER_CATEGORY_MALWARE;
        }
        return null;
    }

    public static String checkMalWareSecurityGroup(String groupName) {
        if ("Malware".equals(groupName)) {
            return UBER_CATEGORY_MALWARE;
        }
        return null;
    }

    public static SecurityRiskItem getSecurityRiskItem(SecurityRiskGroup group, RiskSubCategory subCategory) {
        if (group == null || subCategory == null) {
            return null;
        }
        SecurityRiskItem otherActionItem = null;
        for (SecurityRiskItem riskItem : group.getSecurityRiskItem()) {
            if (riskItem == null) continue;
            if (subCategory.equals(riskItem.getName())) {
                return riskItem;
            }
            if (RiskCategory.SECURITY_RISK == subCategory.getRiskCategory() && OTHER_ACTION.equalsIgnoreCase(riskItem.getName())) {
                otherActionItem = riskItem;
                continue;
            }
            if (RiskCategory.MALWARE != subCategory.getRiskCategory() || !DOWNLOAD_ACTION.equalsIgnoreCase(riskItem.getName())) continue;
            otherActionItem = riskItem;
        }
        return otherActionItem;
    }

    public static boolean isSecurityItemAvaliable(String itemName, int platformType) {
        boolean avaliable = true;
        if (platformType == 3 && (DYNACAT_MISLEADING_APPLICATION_ACTION.equals(itemName) || DYNACAT_PARENTAL_CONTROL_ACTION.equals(itemName) || DYNACAT_SECURITY_ASSESSMENT_TOOL_ACTION.equals(itemName) || DYNACAT_SECURITY_RISK_ACTION.equals(itemName))) {
            avaliable = false;
        }
        return avaliable;
    }

    public static String checkSecurityItemLegacy(String itemName) {
        if (MACRO_VIRUS_ACTION.equals(itemName)) {
            return DYNACAT_VIRUS_ACTION;
        }
        if (NON_MACRO_VIRUS_ACTION.equals(itemName)) {
            return DYNACAT_HEURISTIC_VIRUS_ACTION;
        }
        if (HACKERS_TOOLS_ACTION.equals(itemName)) {
            return DYNACAT_HACKERS_TOOLS_ACTION;
        }
        if (SPYWARE_ACTION.equals(itemName)) {
            return DYNACAT_SPYWARE_ACTION;
        }
        if (TRACKWARE_ACTION.equals(itemName)) {
            return DYNACAT_TRACKWARE_ACTION;
        }
        if (DIALERS_ACTION.equals(itemName)) {
            return DYNACAT_DIALERS_ACTION;
        }
        if (REMOTE_ACCESS_ACTION.equals(itemName)) {
            return DYNACAT_REMOTE_ACCESS_ACTION;
        }
        if (ADWARE_ACTION.equals(itemName)) {
            return DYNACAT_ADWARE_ACTION;
        }
        if (JOKE_PROGRAMS_ACTION.equals(itemName)) {
            return DYNACAT_JOKE_PROGRAMS_ACTION;
        }
        if (DOWNLOAD_ACTION.equals(itemName)) {
            return DYNACAT_DOWNLOADS_ACTION;
        }
        if (MISLEADING_APPLICATION_ACTION.equals(itemName)) {
            return DYNACAT_MISLEADING_APPLICATION_ACTION;
        }
        if (PARENTAL_CONTROL_ACTION.equals(itemName)) {
            return DYNACAT_PARENTAL_CONTROL_ACTION;
        }
        if (SECURITY_ASSESSMENT_TOOL_ACTION.equals(itemName)) {
            return DYNACAT_SECURITY_ASSESSMENT_TOOL_ACTION;
        }
        if (SECURITY_RISK_ACTION.equals(itemName)) {
            return DYNACAT_SECURITY_RISK_ACTION;
        }
        if (COOKIES_ACTION.equals(itemName)) {
            return DYNACAT_COOKIES_ACTION;
        }
        return null;
    }

    public static boolean isMalwareCategory(String name) {
        if (name == null) {
            return false;
        }
        if (UBER_CATEGORY_MALWARE.equals(name)) {
            return true;
        }
        int colonIndex = name.indexOf(":");
        return colonIndex != -1 && UBER_CATEGORY_MALWARE.equals(name.substring(0, colonIndex));
    }

    public static String getSubCategoryId(String itemName) {
        if (itemName == null) {
            return null;
        }
        int colonIndex = itemName.indexOf(":");
        return itemName.substring(colonIndex + 1);
    }

    public static void adjustApActions(AvPolicy avPolicy, SemTable table) {
        if (avPolicy != null) {
            ApActions apActions;
            AvFileAp avFileAp;
            LinuxAvAutoProtect linuxAvAutoProtect;
            AvAutoProtect avAutoProtect = avPolicy.getOptAvAutoProtect();
            if (avAutoProtect != null) {
                ApActions apActions2;
                AvFileAp avFileAp2 = avAutoProtect.getOptAvFileAp();
                WebMailAp webMailAp = avAutoProtect.getOptWebMailAp();
                LotusNotesAp lotusNotesAp = avAutoProtect.getOptLotusNotesAp();
                MsftExchangeAp msftExchangeAp = avAutoProtect.getOptMsftExchangeAp();
                if (avFileAp2 != null && (apActions2 = avFileAp2.getOptApActions()) != null) {
                    DynaCatManipulationUtility.adjustRiskActions(apActions2, table);
                }
                if (webMailAp != null && (apActions2 = webMailAp.getOptApActions()) != null) {
                    DynaCatManipulationUtility.adjustRiskActions(apActions2, table);
                }
                if (lotusNotesAp != null && (apActions2 = lotusNotesAp.getOptApActions()) != null) {
                    DynaCatManipulationUtility.adjustRiskActions(apActions2, table);
                }
                if (msftExchangeAp != null && (apActions2 = msftExchangeAp.getOptApActions()) != null) {
                    DynaCatManipulationUtility.adjustRiskActions(apActions2, table);
                }
            }
            if ((linuxAvAutoProtect = avPolicy.getOptLinuxAvAutoProtect()) != null && (avFileAp = linuxAvAutoProtect.getOptAvFileAp()) != null && (apActions = avFileAp.getOptApActions()) != null) {
                DynaCatManipulationUtility.adjustRiskActions(apActions, table);
            }
        }
    }

    public static String generateItemKey(String groupKey, String riskKey) {
        return groupKey + ":" + riskKey;
    }

    private static void adjustRiskActions(ApActions apActions, SemTable semTable) {
        SecurityRiskGroup group;
        HashMap<String, SecurityRiskGroup> existingGroups = new HashMap<String, SecurityRiskGroup>();
        HashMap<String, SecurityRiskItem> existingItems = new HashMap<String, SecurityRiskItem>();
        SecurityRiskGroup nonMacroGroup = null;
        for (int i = 0; i < apActions.getSecurityRiskGroupCount(); ++i) {
            group = apActions.getSecurityRiskGroup(i);
            String groupKey = group.getName();
            String uberCatName = DynaCatManipulationUtility.checkSecurityGroupLegacy(groupKey);
            if (uberCatName != null) {
                group.setName(uberCatName);
                groupKey = uberCatName;
            }
            existingGroups.put(groupKey, group);
            if (group.getName().equals(NON_MACRO_VIRUS_ACTION)) {
                nonMacroGroup = group;
            }
            for (int j = 0; j < group.getSecurityRiskItemCount(); ++j) {
                SecurityRiskItem risk = group.getSecurityRiskItem(j);
                String riskKey = risk.getName();
                String dynaCatName = DynaCatManipulationUtility.checkSecurityItemLegacy(riskKey);
                if (dynaCatName != null) {
                    risk.setName(dynaCatName);
                    riskKey = dynaCatName;
                }
                existingItems.put(riskKey, risk);
            }
        }
        String oldGroupKey = null;
        group = null;
        int rowCount = semTable.getSemTableRowCount();
        int uberCategoryIndex = 0;
        String[] uberCategories = DynaCatManipulationUtility.getDynaUberCategories();
        for (int i = 0; i < rowCount; ++i) {
            SemTableRow virusCategoryRow = semTable.getSemTableRow(i);
            String groupKey = virusCategoryRow.getSemTableValue(0).getValue();
            if ("0".equals(groupKey)) continue;
            if (!groupKey.equals(oldGroupKey)) {
                while (uberCategoryIndex < uberCategories.length && Integer.parseInt(groupKey) > Integer.parseInt(uberCategories[uberCategoryIndex])) {
                    String tempGroupKey;
                    if (existingGroups.containsKey(tempGroupKey = uberCategories[uberCategoryIndex++])) continue;
                    group = DynaCatManipulationUtility.getSecurityGroup(tempGroupKey, nonMacroGroup);
                    apActions.addSecurityRiskGroup(group);
                    existingGroups.put(tempGroupKey, group);
                }
                if (uberCategoryIndex == uberCategories.length) break;
                oldGroupKey = groupKey;
                if (!existingGroups.containsKey(groupKey)) {
                    group = DynaCatManipulationUtility.getSecurityGroup(groupKey, nonMacroGroup);
                    apActions.addSecurityRiskGroup(group);
                    existingGroups.put(groupKey, group);
                } else {
                    group = (SecurityRiskGroup)existingGroups.get(groupKey);
                }
                ++uberCategoryIndex;
            }
            String riskKey = virusCategoryRow.getSemTableValue(1).getValue();
            System.out.println("DYNACAT: riskKey = " + riskKey);
            if (UBER_CATEGORY_MALWARE.equals(groupKey) && !"0".equals(riskKey)) {
                System.out.println("DYNACAT: skipping malware other than virus");
                continue;
            }
            String itemKey = DynaCatManipulationUtility.generateItemKey(groupKey, riskKey);
            System.out.println("DYNACAT: itemKey = " + itemKey);
            if (existingItems.containsKey(itemKey)) continue;
            SecurityRiskItem item = new SecurityRiskItem();
            item.setName(itemKey);
            item.setOptApAction(DynaCatManipulationUtility.getApAction(item));
            group.addSecurityRiskItem(item);
            existingItems.put(itemKey, item);
        }
    }

    private static SecurityRiskGroup getSecurityGroup(String tempGroupKey, SecurityRiskGroup nonMacroGroup) {
        SecurityRiskGroup group = new SecurityRiskGroup();
        group.setName(tempGroupKey);
        group.setApAction(DynaCatManipulationUtility.getApAction(group));
        if (tempGroupKey.equals(UBER_CATEGORY_MALWARE) && nonMacroGroup != null) {
            group.getApAction().setFirstAction(nonMacroGroup.getApAction().getFirstAction());
            group.getApAction().setSecondAction(nonMacroGroup.getApAction().getSecondAction());
        }
        return group;
    }

    public static enum RiskSubCategory {
        VIRUS("UNDIFINED", "0", RiskCategory.MALWARE),
        DOWNLOAD("DownloadAction", "18", RiskCategory.MALWARE),
        MALWARE_OTHERS("UNDIFINED", null, RiskCategory.MALWARE),
        ADWARE("AdwareAction", "10", RiskCategory.SECURITY_RISK),
        COOKIES("CookieAction", "15", RiskCategory.SECURITY_RISK),
        DIALERS("DialersAction", "8", RiskCategory.SECURITY_RISK),
        HACKERS_TOOLS("HackerToolsAction", "5", RiskCategory.SECURITY_RISK),
        JOKE_PROGRAMS("JokeProgramsAction", "11", RiskCategory.SECURITY_RISK),
        REMOTE_ACCESS("RemoteAccessAction", "9", RiskCategory.SECURITY_RISK),
        SPYWARE("SpywareAction", "6", RiskCategory.SECURITY_RISK),
        TRACKWARE("TrackwareAction", "7", RiskCategory.SECURITY_RISK),
        SECURITY_RISK_OTHERS("UNDIFINED", null, RiskCategory.SECURITY_RISK);

        private final String actionName;
        private final String riskKey;
        private final RiskCategory parent;

        public static RiskSubCategory getInstance(String itemkey) {
            for (RiskSubCategory category : RiskSubCategory.values()) {
                if (!category.getItemKey().equals(itemkey) && !category.getActionName().equalsIgnoreCase(itemkey)) continue;
                return category;
            }
            return null;
        }

        public static RiskSubCategory getInstance(String groupKey, String riskKey) {
            RiskSubCategory result = RiskSubCategory.getInstance(DynaCatManipulationUtility.generateItemKey(groupKey, riskKey));
            if (result != null) {
                return result;
            }
            return RiskCategory.MALWARE == RiskCategory.getInstance(groupKey) ? MALWARE_OTHERS : SECURITY_RISK_OTHERS;
        }

        public static boolean contains(List<DynaCat> dynacats, RiskSubCategory subCategory) {
            if (dynacats == null || subCategory == null) {
                return false;
            }
            for (DynaCat dynacat : dynacats) {
                if (dynacat == null || dynacat.getPVID() == null || !subCategory.getRiskKey().equals(dynacat.getPVID().toString())) continue;
                return true;
            }
            return false;
        }

        private RiskSubCategory(String actionName, String riskKey, RiskCategory category) {
            this.actionName = actionName;
            this.riskKey = riskKey;
            this.parent = category;
        }

        public String getActionName() {
            return this.actionName;
        }

        public String getRiskKey() {
            return this.riskKey;
        }

        public RiskCategory getRiskCategory() {
            return this.parent;
        }

        public String getItemKey() {
            if (this.parent == null) {
                throw new IllegalStateException("The RiskCategory cannot be null!");
            }
            return DynaCatManipulationUtility.generateItemKey(this.parent.getIndex(), this.riskKey);
        }

        public boolean equals(String itemName) {
            if (StringUtilities.isEmpty(itemName)) {
                return false;
            }
            return itemName.equalsIgnoreCase(this.actionName) || itemName.equals(this.getItemKey());
        }
    }

    public static enum RiskCategory {
        MALWARE("1", "Malware"),
        SECURITY_RISK("2", "Expanded");

        private final String index;
        private final String hive;

        public static RiskCategory getInstance(String index) {
            for (RiskCategory category : RiskCategory.values()) {
                if (!category.getIndex().equals(index)) continue;
                return category;
            }
            return null;
        }

        public String getIndex() {
            return this.index;
        }

        public String getHive() {
            return this.hive;
        }

        private RiskCategory(String index, String hive) {
            this.index = index;
            this.hive = hive;
        }
    }
}

