/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.util;

import com.sygate.scm.util.DownLoadUpdateEntry;
import com.sygate.scm.util.IntegerRange;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;

public class DownLoadUpdateInfo {
    ArrayList<DownLoadUpdateEntry> updateinfoList = new ArrayList();

    public DownLoadUpdateInfo(InputStream inputStream) {
        try {
            this.updateinfoList = this.generateUpdateInfoList(inputStream);
        }
        catch (Exception ex) {
            System.err.println("ERROR:DownLoadUpdateInfo:generateUpdateInfoList");
        }
    }

    public DownLoadUpdateEntry findMaxVersion(int buildNum) {
        Iterator<DownLoadUpdateEntry> it = this.updateinfoList.iterator();
        HashMap<String, DownLoadUpdateEntry> hashMap = new HashMap<String, DownLoadUpdateEntry>();
        String maxVersion = "";
        while (it.hasNext()) {
            DownLoadUpdateEntry updateEntry = it.next();
            if (buildNum != -1 && !updateEntry.getCompatibleBuildRange().contains(buildNum) || DownLoadUpdateInfo.compareVersion(updateEntry.getVersion(), maxVersion) <= 0) continue;
            maxVersion = updateEntry.getVersion();
            hashMap.put(maxVersion, updateEntry);
        }
        Object obj = hashMap.get(maxVersion);
        return obj != null ? (DownLoadUpdateEntry)obj : null;
    }

    public static int compareVersion(String version1, String version2) {
        if (version1 == null && version2 == null) {
            return 0;
        }
        if (version1 == null && version2 != null) {
            return -1;
        }
        if (version1 != null && version2 == null) {
            return 1;
        }
        StringTokenizer st1 = new StringTokenizer(version1, ".");
        StringTokenizer st2 = new StringTokenizer(version2, ".");
        while (st1.hasMoreTokens() && st2.hasMoreTokens()) {
            int ret;
            int v1 = 0;
            int v2 = 0;
            try {
                v1 = Integer.parseInt(st1.nextToken());
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                v2 = Integer.parseInt(st2.nextToken());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if ((ret = v1 > v2 ? 1 : (v1 < v2 ? -1 : 0)) == 0) continue;
            return ret;
        }
        if (st1.hasMoreTokens()) {
            return 1;
        }
        if (st2.hasMoreTokens()) {
            return -1;
        }
        return 0;
    }

    private ArrayList<DownLoadUpdateEntry> generateUpdateInfoList(InputStream inputStream) {
        BufferedReader in = new BufferedReader(new InputStreamReader(inputStream, Charset.defaultCharset()));
        String anEntry = null;
        try {
            while ((anEntry = in.readLine()) != null) {
                DownLoadUpdateEntry updateEntry;
                if ((anEntry = anEntry.trim()).equals("") || anEntry.startsWith("'") || (updateEntry = this.parseAnEntry(anEntry)) == null) continue;
                this.updateinfoList.add(updateEntry);
            }
        }
        catch (IOException ex) {
            System.err.println("IOERROR:DownLoadUpdateInfo:getUpdateInfoList");
        }
        return this.updateinfoList;
    }

    private DownLoadUpdateEntry parseAnEntry(String line) {
        StringTokenizer tokenLine = new StringTokenizer(line, "\t");
        String[] items = new String[tokenLine.countTokens()];
        int i = 0;
        while (tokenLine.hasMoreTokens()) {
            items[i] = tokenLine.nextToken().trim();
            ++i;
        }
        StringBuilder descBuf = new StringBuilder();
        if (items.length >= 7) {
            descBuf.append(items[6]);
            for (int i2 = 7; i2 < items.length; ++i2) {
                descBuf.append("\t");
                descBuf.append(items[i2]);
            }
        }
        String description = descBuf.toString();
        DownLoadUpdateEntry downLoadEntry = null;
        if (items.length >= 6) {
            IntegerRange intRange = new IntegerRange();
            intRange.parse(items[1]);
            downLoadEntry = new DownLoadUpdateEntry(items[0], intRange, items[2], items[3], items[4], items[5], description);
        }
        return downLoadEntry;
    }
}

