/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.util;

import com.sygate.scm.util.StringUtilities;
import java.io.File;
import java.io.FileNotFoundException;

public class DiskSizeUtil {
    public static final long DISK_SIZE_MB = 0x100000L;
    public static final long DISK_SIZE_COMPARE_DELTA = 0x3200000L;

    public static long getTotalDiskSize(String path) throws FileNotFoundException {
        if (StringUtilities.isEmpty(path)) {
            throw new IllegalArgumentException();
        }
        File file = new File(path);
        return DiskSizeUtil.getTotalDiskSize(file);
    }

    public static long getTotalDiskSize(File file) throws FileNotFoundException {
        if (file == null) {
            throw new IllegalArgumentException();
        }
        if (!file.exists()) {
            throw new FileNotFoundException(file.getAbsolutePath());
        }
        return file.getTotalSpace();
    }

    public static long getUsableDiskSize(String path) throws FileNotFoundException {
        if (StringUtilities.isEmpty(path)) {
            throw new IllegalArgumentException();
        }
        File file = new File(path);
        return DiskSizeUtil.getUsableDiskSize(file);
    }

    public static long getUsableDiskSize(File file) throws FileNotFoundException {
        if (file == null) {
            throw new IllegalArgumentException();
        }
        if (!file.exists()) {
            throw new FileNotFoundException(file.getAbsolutePath());
        }
        return file.getUsableSpace();
    }
}

