/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.util;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.NamedObject;
import com.sygate.scm.common.configobject.TopLevelObject;
import com.sygate.scm.common.configobject.schema.AdminDefinedScan;
import com.sygate.scm.common.configobject.schema.AdminDefinedScanDetails;
import com.sygate.scm.common.configobject.schema.AdvancedScanOptions;
import com.sygate.scm.common.configobject.schema.ApAction;
import com.sygate.scm.common.configobject.schema.ApActions;
import com.sygate.scm.common.configobject.schema.ApAdvancedScanSettings;
import com.sygate.scm.common.configobject.schema.ApFileAdvancedOptions;
import com.sygate.scm.common.configobject.schema.ApFileNotifications;
import com.sygate.scm.common.configobject.schema.ApFileScanDetails;
import com.sygate.scm.common.configobject.schema.ApMailNotifications;
import com.sygate.scm.common.configobject.schema.ApMailScanDetails;
import com.sygate.scm.common.configobject.schema.ApWebMailAdvancedOptions;
import com.sygate.scm.common.configobject.schema.AvAutoProtect;
import com.sygate.scm.common.configobject.schema.AvFileAp;
import com.sygate.scm.common.configobject.schema.AvGeneral;
import com.sygate.scm.common.configobject.schema.AvPolicy;
import com.sygate.scm.common.configobject.schema.AvQuarantine;
import com.sygate.scm.common.configobject.schema.AvScanPolicy;
import com.sygate.scm.common.configobject.schema.AvScanSettings;
import com.sygate.scm.common.configobject.schema.AvSubmission;
import com.sygate.scm.common.configobject.schema.AvVirusDefOptions;
import com.sygate.scm.common.configobject.schema.BPEEnhancementsRule;
import com.sygate.scm.common.configobject.schema.BPEEnhancementsRulesList;
import com.sygate.scm.common.configobject.schema.CentralLuServer;
import com.sygate.scm.common.configobject.schema.CleanupOptions;
import com.sygate.scm.common.configobject.schema.ClientDeltaSupport;
import com.sygate.scm.common.configobject.schema.ClientFeature;
import com.sygate.scm.common.configobject.schema.ClientInstallationFeatures;
import com.sygate.scm.common.configobject.schema.ClientInstallationSettings;
import com.sygate.scm.common.configobject.schema.CommandScan;
import com.sygate.scm.common.configobject.schema.CommonImageExclusion;
import com.sygate.scm.common.configobject.schema.CommunicationOption;
import com.sygate.scm.common.configobject.schema.CompressParams;
import com.sygate.scm.common.configobject.schema.CompressedFiles;
import com.sygate.scm.common.configobject.schema.ContentVersionInfo;
import com.sygate.scm.common.configobject.schema.DecompressParams;
import com.sygate.scm.common.configobject.schema.DeltaOptions;
import com.sygate.scm.common.configobject.schema.DeltaParameters;
import com.sygate.scm.common.configobject.schema.DeltaParams;
import com.sygate.scm.common.configobject.schema.DriveTypes;
import com.sygate.scm.common.configobject.schema.EmailServerConfig;
import com.sygate.scm.common.configobject.schema.EnabledClientFeatures;
import com.sygate.scm.common.configobject.schema.FileCache;
import com.sygate.scm.common.configobject.schema.FileScanningOptions;
import com.sygate.scm.common.configobject.schema.FileTypes;
import com.sygate.scm.common.configobject.schema.FloppySettings;
import com.sygate.scm.common.configobject.schema.ForwardedEvent;
import com.sygate.scm.common.configobject.schema.GeneralInfo;
import com.sygate.scm.common.configobject.schema.HeuristicsOptions;
import com.sygate.scm.common.configobject.schema.HidPolicy;
import com.sygate.scm.common.configobject.schema.HppNotifications;
import com.sygate.scm.common.configobject.schema.HppPolicy;
import com.sygate.scm.common.configobject.schema.InfectionInfo;
import com.sygate.scm.common.configobject.schema.InstallationOption;
import com.sygate.scm.common.configobject.schema.LegacyMoniker;
import com.sygate.scm.common.configobject.schema.LinuxAdminDefinedScan;
import com.sygate.scm.common.configobject.schema.LinuxAvAutoProtect;
import com.sygate.scm.common.configobject.schema.LinuxAvGeneral;
import com.sygate.scm.common.configobject.schema.LinuxAvScanPolicy;
import com.sygate.scm.common.configobject.schema.LocalizedStrings;
import com.sygate.scm.common.configobject.schema.LogHandling;
import com.sygate.scm.common.configobject.schema.LotusNotesAp;
import com.sygate.scm.common.configobject.schema.LuAppliedContent;
import com.sygate.scm.common.configobject.schema.LuClientRegistration;
import com.sygate.scm.common.configobject.schema.LuContentCategory;
import com.sygate.scm.common.configobject.schema.LuContentCategoryGroup;
import com.sygate.scm.common.configobject.schema.LuContentPolicy;
import com.sygate.scm.common.configobject.schema.LuPolicy;
import com.sygate.scm.common.configobject.schema.LuRegistration;
import com.sygate.scm.common.configobject.schema.LuServerRegistration;
import com.sygate.scm.common.configobject.schema.LuSesmContentCatalog;
import com.sygate.scm.common.configobject.schema.LuSupportLanguage;
import com.sygate.scm.common.configobject.schema.LuSupportLanguageList;
import com.sygate.scm.common.configobject.schema.MacAdminDefinedScan;
import com.sygate.scm.common.configobject.schema.MacAvAutoProtect;
import com.sygate.scm.common.configobject.schema.MacAvGeneral;
import com.sygate.scm.common.configobject.schema.MacAvScanPolicy;
import com.sygate.scm.common.configobject.schema.MacCommandScan;
import com.sygate.scm.common.configobject.schema.MacGeneralScanSettings;
import com.sygate.scm.common.configobject.schema.MacScanNotification;
import com.sygate.scm.common.configobject.schema.MailContent;
import com.sygate.scm.common.configobject.schema.MailToOthers;
import com.sygate.scm.common.configobject.schema.MailToSender;
import com.sygate.scm.common.configobject.schema.MemPolicy;
import com.sygate.scm.common.configobject.schema.MessageBody;
import com.sygate.scm.common.configobject.schema.MissingDefMessageToDisplay;
import com.sygate.scm.common.configobject.schema.MsftExchangeAp;
import com.sygate.scm.common.configobject.schema.NetworkSettings;
import com.sygate.scm.common.configobject.schema.NotificationMessage;
import com.sygate.scm.common.configobject.schema.NtrPolicy;
import com.sygate.scm.common.configobject.schema.ObjReference;
import com.sygate.scm.common.configobject.schema.PackageInfo;
import com.sygate.scm.common.configobject.schema.PackageLuFile;
import com.sygate.scm.common.configobject.schema.PackageLuInfo;
import com.sygate.scm.common.configobject.schema.PatternWarningMessage;
import com.sygate.scm.common.configobject.schema.PauseOptions;
import com.sygate.scm.common.configobject.schema.PhysicalFile;
import com.sygate.scm.common.configobject.schema.RiskTracer;
import com.sygate.scm.common.configobject.schema.ScanProgressOptions;
import com.sygate.scm.common.configobject.schema.ScanSchedule;
import com.sygate.scm.common.configobject.schema.Schedule;
import com.sygate.scm.common.configobject.schema.SecurityRiskGroup;
import com.sygate.scm.common.configobject.schema.SecurityRiskItem;
import com.sygate.scm.common.configobject.schema.SemDomain;
import com.sygate.scm.common.configobject.schema.SharedInsightCache;
import com.sygate.scm.common.configobject.schema.SoftwarePackage;
import com.sygate.scm.common.configobject.schema.StorageMigration;
import com.sygate.scm.common.configobject.schema.SubmitProcess;
import com.sygate.scm.common.configobject.schema.SubmitRates;
import com.sygate.scm.common.configobject.schema.SubmitToSRServer;
import com.sygate.scm.common.configobject.schema.SymantecAdaptiveRules;
import com.sygate.scm.common.configobject.schema.TamperFileSettings;
import com.sygate.scm.common.configobject.schema.TamperNamedObjectSettings;
import com.sygate.scm.common.configobject.schema.TamperProcessSettings;
import com.sygate.scm.common.configobject.schema.TamperProtection;
import com.sygate.scm.common.configobject.schema.TamperProtectionPolicy;
import com.sygate.scm.common.configobject.schema.TamperProtectionSettings;
import com.sygate.scm.common.configobject.schema.TamperRegistrySettings;
import com.sygate.scm.common.configobject.schema.TdadPolicy;
import com.sygate.scm.common.configobject.schema.VirusLikeActivityOptions;
import com.sygate.scm.common.configobject.schema.WarningMessage;
import com.sygate.scm.common.configobject.schema.WebMailAp;
import com.sygate.scm.common.util.Cast;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.Utility;
import com.sygate.scm.util.XPathSchemaUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.xml.transform.TransformerException;

public class DeterministicIdWasher {
    private HashMap<String, String> resetIdMap = new HashMap();

    public static void resetTamperProtectionPolicyIDs(TamperProtectionPolicy topObj, String seed) {
        String objID = Utility.calculateHash(seed + topObj.getObjectTypeName());
        topObj.setId(objID);
        topObj.setI(Utility.calculateHash(objID + "_i"));
        TamperProtection tamperProtection = topObj.getOptTamperProtection();
        if (tamperProtection != null) {
            NotificationMessage notificationMessage;
            TamperFileSettings tamperFileSettings;
            TamperRegistrySettings tamperRegistrySettings;
            TamperNamedObjectSettings tamperNamedObjectSettings;
            tamperProtection.setI(Utility.calculateHash(objID + tamperProtection.getObjectTypeName()));
            TamperProcessSettings tamperProcessSettings = tamperProtection.getOptTamperProcessSettings();
            if (tamperProcessSettings != null) {
                tamperProcessSettings.setI(Utility.calculateHash(objID + tamperProcessSettings.getObjectTypeName()));
                TamperProtectionSettings tamperProtectionSettings = tamperProcessSettings.getOptTamperProtectionSettings();
                if (tamperProtectionSettings != null) {
                    tamperProtectionSettings.setI(Utility.calculateHash(objID + tamperProcessSettings.getObjectTypeName() + tamperProtectionSettings.getObjectTypeName()));
                }
            }
            if ((tamperNamedObjectSettings = tamperProtection.getOptTamperNamedObjectSettings()) != null) {
                tamperNamedObjectSettings.setI(Utility.calculateHash(objID + tamperNamedObjectSettings.getObjectTypeName()));
                TamperProtectionSettings tamperProtectionSettings = tamperNamedObjectSettings.getOptTamperProtectionSettings();
                if (tamperProtectionSettings != null) {
                    tamperProtectionSettings.setI(Utility.calculateHash(objID + tamperNamedObjectSettings.getObjectTypeName() + tamperProtectionSettings.getObjectTypeName()));
                }
            }
            if ((tamperRegistrySettings = tamperProtection.getOptTamperRegistrySettings()) != null) {
                tamperRegistrySettings.setI(Utility.calculateHash(objID + tamperRegistrySettings.getObjectTypeName()));
                TamperProtectionSettings tamperProtectionSettings = tamperRegistrySettings.getOptTamperProtectionSettings();
                if (tamperProtectionSettings != null) {
                    tamperProtectionSettings.setI(Utility.calculateHash(objID + tamperRegistrySettings.getObjectTypeName() + tamperProtectionSettings.getObjectTypeName()));
                }
            }
            if ((tamperFileSettings = tamperProtection.getOptTamperFileSettings()) != null) {
                tamperFileSettings.setI(Utility.calculateHash(objID + tamperFileSettings.getObjectTypeName()));
                TamperProtectionSettings tamperProtectionSettings = tamperFileSettings.getOptTamperProtectionSettings();
                if (tamperProtectionSettings != null) {
                    tamperProtectionSettings.setI(Utility.calculateHash(objID + tamperFileSettings.getObjectTypeName() + tamperProtectionSettings.getObjectTypeName()));
                }
            }
            if ((notificationMessage = tamperProtection.getOptNotificationMessage()) != null) {
                notificationMessage.setI(Utility.calculateHash(objID + notificationMessage.getObjectTypeName()));
            }
        }
    }

    public static String resetLinuxAdminDefinedScanIDs(LinuxAdminDefinedScan topObj, String seed) {
        String objID = Utility.calculateHash(Utility.calculateHash(seed + "AvPolicy") + topObj.getName() + topObj.getObjectTypeName());
        topObj.setId(objID);
        topObj.setI(Utility.calculateHash(objID + "_i"));
        HashMap<String, Integer> objIndexMap = new HashMap<String, Integer>();
        List children = (List)Cast.cast(topObj.getChildren());
        for (ConfigObject cObj : children) {
            DeterministicIdWasher.resetAdminDefinedScanChildrenIDs(objID, cObj, objIndexMap);
        }
        return objID;
    }

    public static String resetAdminDefinedScanIDs(AdminDefinedScan topObj, String seed) {
        String objID = Utility.calculateHash(Utility.calculateHash(seed + "AvPolicy") + topObj.getName());
        topObj.setId(objID);
        topObj.setI(Utility.calculateHash(objID + "_i"));
        HashMap<String, Integer> objIndexMap = new HashMap<String, Integer>();
        List children = (List)Cast.cast(topObj.getChildren());
        for (ConfigObject cObj : children) {
            DeterministicIdWasher.resetAdminDefinedScanChildrenIDs(objID, cObj, objIndexMap);
        }
        return objID;
    }

    private static void resetAdminDefinedScanChildrenIDs(String objID, ConfigObject cObj, Map<String, Integer> objIndexMap) {
        if (cObj instanceof ApActions) {
            ApActions apActions = (ApActions)cObj;
            String cObjID = Utility.calculateHash(objID + cObj.getObjectTypeName() + apActions.getParent().getObjectTypeName());
            DeterministicIdWasher.resetApActionsChildrenIDs(cObjID, apActions, objIndexMap);
        } else if (cObj instanceof AdminDefinedScanDetails || cObj instanceof AdvancedScanOptions || cObj instanceof FileTypes || cObj instanceof CompressedFiles || cObj instanceof StorageMigration || cObj instanceof ScanSchedule || cObj instanceof Schedule || cObj instanceof NotificationMessage) {
            cObj.setI(DeterministicIdWasher.getI(objID + cObj.getObjectTypeName(), objIndexMap));
        }
        List children = (List)Cast.cast(cObj.getChildren());
        for (ConfigObject childConfigObj : children) {
            DeterministicIdWasher.resetAdminDefinedScanChildrenIDs(objID, childConfigObj, objIndexMap);
        }
    }

    private static void resetApActionsChildrenIDs(String cObjID, ConfigObject cObj, Map<String, Integer> objIndexMap) {
        cObj.setI(DeterministicIdWasher.getI(cObjID + cObj.getObjectTypeName(), objIndexMap));
        List children = (List)Cast.cast(cObj.getChildren());
        for (ConfigObject childConfigObj : children) {
            if (childConfigObj instanceof SecurityRiskGroup) {
                SecurityRiskGroup securityRiskGroup = (SecurityRiskGroup)childConfigObj;
                childConfigObj.setI(DeterministicIdWasher.getI(cObjID + securityRiskGroup.getObjectTypeName() + securityRiskGroup.getName(), objIndexMap));
                ApAction apAction = securityRiskGroup.getApAction();
                apAction.setI(DeterministicIdWasher.getI(cObjID + securityRiskGroup.getName() + apAction.getObjectTypeName(), objIndexMap));
                for (int i = 0; i < securityRiskGroup.getSecurityRiskItemCount(); ++i) {
                    SecurityRiskItem securityRiskItem = securityRiskGroup.getSecurityRiskItem(i);
                    securityRiskItem.setI(DeterministicIdWasher.getI(cObjID + securityRiskGroup.getName() + securityRiskItem.getObjectTypeName() + securityRiskItem.getName(), objIndexMap));
                    ApAction apActionItem = securityRiskItem.getOptApAction();
                    if (apActionItem == null) continue;
                    apActionItem.setI(DeterministicIdWasher.getI(cObjID + securityRiskGroup.getName() + securityRiskItem.getObjectTypeName() + securityRiskItem.getName() + apActionItem.getObjectTypeName(), objIndexMap));
                }
                continue;
            }
            childConfigObj.setI(DeterministicIdWasher.getI(cObjID + childConfigObj.getObjectTypeName(), objIndexMap));
        }
    }

    public static String resetMacAdminDefinedScanIDs(MacAdminDefinedScan topObj, String seed) {
        String objID = Utility.calculateHash(Utility.calculateHash(seed + "AvPolicy") + topObj.getName() + topObj.getObjectTypeName());
        topObj.setId(objID);
        topObj.setI(Utility.calculateHash(objID + "_i"));
        HashMap<String, Integer> objIndexMap = new HashMap<String, Integer>();
        List children = (List)Cast.cast(topObj.getChildren());
        for (ConfigObject cObj : children) {
            DeterministicIdWasher.resetMacAdminDefinedScanChildrenIDs(objID, cObj, objIndexMap);
        }
        return objID;
    }

    private static void resetMacAdminDefinedScanChildrenIDs(String objID, ConfigObject cObj, Map<String, Integer> objIndexMap) {
        cObj.setI(DeterministicIdWasher.getI(objID + cObj.getObjectTypeName(), objIndexMap));
        List children = (List)Cast.cast(cObj.getChildren());
        for (ConfigObject childConfigObj : children) {
            DeterministicIdWasher.resetMacAdminDefinedScanChildrenIDs(objID, childConfigObj, objIndexMap);
        }
    }

    public static String resetAvPolicyIDs(AvPolicy topObj, String seed) {
        String objID = Utility.calculateHash(seed + topObj.getObjectTypeName() + topObj.getName());
        topObj.setId(objID);
        topObj.setI(Utility.calculateHash(objID + "_i"));
        HashMap<String, Integer> objIndexMap = new HashMap<String, Integer>();
        List children = (List)Cast.cast(topObj.getChildren());
        for (ConfigObject cObj : children) {
            DeterministicIdWasher.resetAvPolicyChildrenIDs(objID, cObj, objIndexMap);
        }
        return objID;
    }

    public static String resetNotificationIDs(String notificationType, String notificationName) {
        return Utility.calculateHash(notificationType + notificationName);
    }

    private static void resetAvPolicyChildrenIDs(String objID, ConfigObject cObj, Map<String, Integer> objIndexMap) {
        ObjReference objRef;
        ConfigObject commandScan;
        PauseOptions pauseOptions;
        ScanProgressOptions scanProgressOptions;
        AvScanSettings avScanSettings;
        ObjReference objRef2;
        ConfigObject avScanPolicy;
        if (cObj instanceof AvGeneral || cObj instanceof LinuxAvGeneral || cObj instanceof MacAvGeneral || cObj instanceof GeneralInfo || cObj instanceof LogHandling || cObj instanceof AvVirusDefOptions || cObj instanceof PatternWarningMessage || cObj instanceof MissingDefMessageToDisplay || cObj instanceof AvQuarantine || cObj instanceof CleanupOptions || cObj instanceof AvSubmission || cObj instanceof SubmitToSRServer || cObj instanceof SubmitProcess || cObj instanceof SubmitRates || cObj instanceof HppPolicy || cObj instanceof HppNotifications || cObj instanceof AvAutoProtect || cObj instanceof MacAvAutoProtect || cObj instanceof LinuxAvAutoProtect || cObj instanceof AvFileAp || cObj instanceof ApFileScanDetails || cObj instanceof ApAdvancedScanSettings || cObj instanceof FileScanningOptions || cObj instanceof HeuristicsOptions || cObj instanceof VirusLikeActivityOptions || cObj instanceof DriveTypes || cObj instanceof FloppySettings || cObj instanceof NetworkSettings || cObj instanceof SharedInsightCache || cObj instanceof CommonImageExclusion || cObj instanceof ApFileNotifications || cObj instanceof ApFileAdvancedOptions || cObj instanceof FileCache || cObj instanceof RiskTracer || cObj instanceof WebMailAp || cObj instanceof LotusNotesAp || cObj instanceof MsftExchangeAp) {
            cObj.setI(DeterministicIdWasher.getI(objID + cObj.getObjectTypeName(), objIndexMap));
        } else if (cObj instanceof FileTypes || cObj instanceof NotificationMessage || cObj instanceof ApMailScanDetails || cObj instanceof CompressedFiles || cObj instanceof ApMailNotifications || cObj instanceof WarningMessage || cObj instanceof MailContent || cObj instanceof WarningMessage || cObj instanceof MessageBody || cObj instanceof InfectionInfo || cObj instanceof MailToSender || cObj instanceof EmailServerConfig || cObj instanceof MailToOthers || cObj instanceof ApWebMailAdvancedOptions) {
            cObj.setI(DeterministicIdWasher.getI(objID + cObj.getObjectTypeName() + cObj.getParent().getObjectTypeName() + cObj.getParent().getParent().getObjectTypeName(), objIndexMap));
        } else if (cObj instanceof ForwardedEvent) {
            ForwardedEvent forwardedEvent = (ForwardedEvent)cObj;
            forwardedEvent.setI(DeterministicIdWasher.getI(objID + forwardedEvent.getObjectTypeName() + forwardedEvent.getEventID(), objIndexMap));
        } else if (cObj instanceof ApActions) {
            ApActions apActions = (ApActions)cObj;
            String cObjID = Utility.calculateHash(objID + apActions.getParent().getObjectTypeName());
            DeterministicIdWasher.resetApActionsChildrenIDs(cObjID, apActions, objIndexMap);
        } else if (cObj instanceof AvScanPolicy) {
            avScanPolicy = (AvScanPolicy)cObj;
            cObj.setI(DeterministicIdWasher.getI(objID + cObj.getObjectTypeName(), objIndexMap));
            for (int i = 0; i < ((AvScanPolicy)avScanPolicy).getObjReferenceCount(); ++i) {
                objRef2 = ((AvScanPolicy)avScanPolicy).getObjReference(i);
                objRef2.setTargetId(Utility.calculateHash(objID + objRef2.getName()));
                objRef2.setI(DeterministicIdWasher.getI(objID + objRef2.getName() + "_i", objIndexMap));
            }
            avScanSettings = ((AvScanPolicy)avScanPolicy).getOptAvScanSettings();
            if (avScanSettings != null) {
                avScanSettings.setI(DeterministicIdWasher.getI(objID + avScanSettings.getObjectTypeName(), objIndexMap));
                scanProgressOptions = avScanSettings.getScanProgressOptions();
                scanProgressOptions.setI(DeterministicIdWasher.getI(objID + scanProgressOptions.getObjectTypeName(), objIndexMap));
                pauseOptions = scanProgressOptions.getOptPauseOptions();
                if (pauseOptions != null) {
                    pauseOptions.setI(DeterministicIdWasher.getI(objID + pauseOptions.getObjectTypeName(), objIndexMap));
                }
            }
            commandScan = ((AvScanPolicy)avScanPolicy).getCommandScan();
            commandScan.setI(DeterministicIdWasher.getI(objID + ((CommandScan)commandScan).getObjectTypeName(), objIndexMap));
            objRef = ((CommandScan)commandScan).getObjReference();
            objRef.setTargetId(Utility.calculateHash(objID + objRef.getName()));
            objRef.setI(DeterministicIdWasher.getI(objID + objRef.getName() + "_i", objIndexMap));
        } else if (cObj instanceof LinuxAvScanPolicy) {
            avScanPolicy = (LinuxAvScanPolicy)cObj;
            cObj.setI(DeterministicIdWasher.getI(objID + cObj.getObjectTypeName(), objIndexMap));
            for (int i = 0; i < ((LinuxAvScanPolicy)avScanPolicy).getObjReferenceCount(); ++i) {
                objRef2 = ((LinuxAvScanPolicy)avScanPolicy).getObjReference(i);
                objRef2.setTargetId(Utility.calculateHash(objID + objRef2.getName()));
                objRef2.setI(DeterministicIdWasher.getI(objID + objRef2.getName() + "_i", objIndexMap));
            }
            avScanSettings = ((LinuxAvScanPolicy)avScanPolicy).getOptAvScanSettings();
            if (avScanSettings != null) {
                avScanSettings.setI(DeterministicIdWasher.getI(objID + avScanSettings.getObjectTypeName(), objIndexMap));
                scanProgressOptions = avScanSettings.getScanProgressOptions();
                scanProgressOptions.setI(DeterministicIdWasher.getI(objID + scanProgressOptions.getObjectTypeName(), objIndexMap));
                pauseOptions = scanProgressOptions.getOptPauseOptions();
                if (pauseOptions != null) {
                    pauseOptions.setI(DeterministicIdWasher.getI(objID + pauseOptions.getObjectTypeName(), objIndexMap));
                }
            }
            commandScan = ((LinuxAvScanPolicy)avScanPolicy).getOptCommandScan();
            commandScan.setI(DeterministicIdWasher.getI(objID + ((CommandScan)commandScan).getObjectTypeName(), objIndexMap));
            objRef = ((CommandScan)commandScan).getObjReference();
            objRef.setTargetId(Utility.calculateHash(objID + objRef.getName()));
            objRef.setI(DeterministicIdWasher.getI(objID + objRef.getName() + "_i", objIndexMap));
        } else if (cObj instanceof MacAvScanPolicy) {
            MacScanNotification scanNotification;
            avScanPolicy = (MacAvScanPolicy)cObj;
            cObj.setI(DeterministicIdWasher.getI(objID + cObj.getObjectTypeName(), objIndexMap));
            for (int i = 0; i < ((MacAvScanPolicy)avScanPolicy).getObjReferenceCount(); ++i) {
                objRef2 = ((MacAvScanPolicy)avScanPolicy).getObjReference(i);
                objRef2.setTargetId(Utility.calculateHash(objID + objRef2.getName()));
                objRef2.setI(DeterministicIdWasher.getI(objID + objRef2.getName() + "_i", objIndexMap));
            }
            MacGeneralScanSettings scanSettings = ((MacAvScanPolicy)avScanPolicy).getOptMacGeneralScanSettings();
            if (scanSettings != null) {
                DeterministicIdWasher.resetMacintoshGeneralScanSettingsIDs(objID, scanSettings, objIndexMap);
            }
            commandScan = ((MacAvScanPolicy)avScanPolicy).getOptMacCommandScan();
            commandScan.setI(DeterministicIdWasher.getI(objID + ((MacCommandScan)commandScan).getObjectTypeName(), objIndexMap));
            objRef = ((MacCommandScan)commandScan).getOptObjReference();
            objRef.setTargetId(Utility.calculateHash(objID + objRef.getName()));
            objRef.setI(DeterministicIdWasher.getI(objID + objRef.getName() + "_i", objIndexMap));
            scanSettings = ((MacCommandScan)commandScan).getOptMacGeneralScanSettings();
            if (scanSettings != null) {
                DeterministicIdWasher.resetMacintoshGeneralScanSettingsIDs(objID, scanSettings, objIndexMap);
            }
            if ((scanNotification = ((MacAvScanPolicy)avScanPolicy).getOptMacScanNotification()) != null) {
                scanNotification.setI(DeterministicIdWasher.getI(objID + scanNotification.getObjectTypeName(), objIndexMap));
                NotificationMessage message = scanNotification.getOptNotificationMessage();
                if (message != null) {
                    DeterministicIdWasher.resetAvPolicyChildrenIDs(objID, message, objIndexMap);
                }
            }
        }
        List children = (List)Cast.cast(cObj.getChildren());
        for (ConfigObject childConfigObj : children) {
            DeterministicIdWasher.resetAvPolicyChildrenIDs(objID, childConfigObj, objIndexMap);
        }
    }

    private static void resetMacintoshGeneralScanSettingsIDs(String objID, MacGeneralScanSettings scanSettings, Map<String, Integer> objIndexMap) {
        scanSettings.setI(DeterministicIdWasher.getI(objID + scanSettings.getObjectTypeName() + scanSettings.getParent().getObjectTypeName(), objIndexMap));
        CompressedFiles compressedFiles = scanSettings.getOptCompressedFiles();
        DeterministicIdWasher.resetAvPolicyChildrenIDs(objID, compressedFiles, objIndexMap);
    }

    public static void resetLuContentPolicyIDs(LuContentPolicy topObj, String seed) {
        String objID = Utility.calculateHash(seed + topObj.getObjectTypeName());
        topObj.setId(objID);
        topObj.setI(Utility.calculateHash(objID + "_i"));
        for (int i = 0; i < topObj.getLuAppliedContentCount(); ++i) {
            LuAppliedContent appliedContent = topObj.getLuAppliedContent(i);
            appliedContent.setI(Utility.calculateHash(objID + appliedContent.getObjectTypeName() + appliedContent.getContentCategory()));
            for (int j = 0; j < appliedContent.getContentVersionInfoCount(); ++j) {
                ContentVersionInfo versionInfo = appliedContent.getContentVersionInfo(j);
                versionInfo.setI(Utility.calculateHash(appliedContent.getI() + versionInfo.getMoniker()));
            }
        }
    }

    public static void resetHidPolicyIDs(HidPolicy topObj, String seed) {
        String objID = Utility.calculateHash(seed + topObj.getObjectTypeName());
        topObj.setId(objID);
        topObj.setI(Utility.calculateHash(objID + "_i"));
    }

    public static void resetTdadPolicyIDs(TdadPolicy topObj, String seed) {
        String objID = Utility.calculateHash(seed + topObj.getObjectTypeName());
        topObj.setId(objID);
        topObj.setI(Utility.calculateHash(objID + "_i"));
    }

    public static void resetMemPolicyIDs(MemPolicy topObj, String seed) {
        String objId = Utility.calculateHash(seed + topObj.getObjectTypeName());
        topObj.setId(objId);
        topObj.setI(Utility.calculateHash(objId + "_i"));
    }

    public static void resetNtrPolicyIDs(NtrPolicy topObj, String seed) {
        String objId = Utility.calculateHash(seed + topObj.getObjectTypeName());
        topObj.setId(objId);
        topObj.setI(Utility.calculateHash(objId + "_i"));
    }

    public static void resetLuPolicyIDs(LuPolicy topObj, String seed) {
        String objID = Utility.calculateHash(seed + topObj.getObjectTypeName());
        topObj.setId(objID);
        topObj.setI(Utility.calculateHash(objID + "_i"));
        HashMap<String, Integer> objIndexMap = new HashMap<String, Integer>();
        List children = (List)Cast.cast(topObj.getChildren());
        for (ConfigObject cObj : children) {
            DeterministicIdWasher.resetLuPolicyChildrenIDs(objID, cObj, objIndexMap);
        }
    }

    private static void resetLuPolicyChildrenIDs(String objID, ConfigObject cObj, Map<String, Integer> objIndexMap) {
        if (cObj instanceof CentralLuServer) {
            CentralLuServer cLuServer = (CentralLuServer)cObj;
            cObj.setI(DeterministicIdWasher.getI(objID + cObj.getObjectTypeName() + cLuServer.getName(), objIndexMap));
        } else {
            cObj.setI(DeterministicIdWasher.getI(objID + cObj.getObjectTypeName(), objIndexMap));
        }
        List children = (List)Cast.cast(cObj.getChildren());
        for (ConfigObject childConfigObj : children) {
            DeterministicIdWasher.resetLuPolicyChildrenIDs(objID, childConfigObj, objIndexMap);
        }
    }

    private static String getI(String key, Map<String, Integer> objIndexMap) {
        return Utility.calculateHash(key + DeterministicIdWasher.getNextIndex(key, objIndexMap));
    }

    private static Integer getNextIndex(String objectTypeName, Map<String, Integer> objIndexMap) {
        Integer currentIndex = objIndexMap.get(objectTypeName);
        currentIndex = currentIndex == null ? Integer.valueOf(0) : Integer.valueOf(currentIndex + 1);
        objIndexMap.put(objectTypeName, currentIndex);
        return currentIndex;
    }

    public static void resetClientInstallationFeaturesIDs(ClientInstallationFeatures topObj, String seed) {
        String objID = Utility.calculateHash(seed + topObj.getObjectTypeName() + topObj.getName());
        topObj.setId(objID);
        topObj.setI(Utility.calculateHash(objID + "_i"));
        Vector<EnabledClientFeatures> cFeatureList = topObj.getEnabledClientFeatures();
        if (cFeatureList != null && cFeatureList.size() > 0) {
            for (EnabledClientFeatures ecf : cFeatureList) {
                if (ecf == null) continue;
                for (int i = 0; i < ecf.getClientFeatureCount(); ++i) {
                    ClientFeature cFeature = ecf.getClientFeature(i);
                    cFeature.setI(Utility.calculateHash(objID + cFeature.getObjectTypeName() + cFeature.getFeatureName()));
                }
            }
        }
    }

    public static void resetEnabledClientFeaturesIDs(ConfigObject cObj, String seed) {
        if (cObj instanceof ClientFeature) {
            ClientFeature cFeature = (ClientFeature)cObj;
            cObj.setI(Utility.calculateHash(seed + cFeature.getObjectTypeName() + cFeature.getFeatureName()));
        } else {
            cObj.setI(Utility.calculateHash(seed + cObj.getObjectTypeName()));
        }
        List children = (List)Cast.cast(cObj.getChildren());
        for (ConfigObject childConfigObj : children) {
            DeterministicIdWasher.resetEnabledClientFeaturesIDs(childConfigObj, seed);
        }
    }

    public static void resetClientFeatureID(ClientFeature obj, String seed) {
        obj.setI(Utility.calculateHash(seed + obj.getObjectTypeName() + obj.getFeatureName()));
    }

    public void resetAdaptiveObjectIDs(SymantecAdaptiveRules adaptiveRules, String seed) {
        if (adaptiveRules == null) {
            return;
        }
        String objID = Utility.calculateHash(seed + adaptiveRules.getObjectTypeName() + adaptiveRules.getName());
        adaptiveRules.setId(objID);
        adaptiveRules.setI(Utility.calculateHash(objID + "_i"));
        this.resetBPERuleIDs(adaptiveRules.getOptBPEEnhancementsRulesList(), seed);
    }

    public void resetBPERuleIDs(BPEEnhancementsRulesList bpeList, String seed) {
        if (bpeList == null) {
            return;
        }
        String objID = Utility.calculateHash(seed + bpeList.getObjectTypeName());
        bpeList.setI(Utility.calculateHash(objID + "_i"));
        Vector<BPEEnhancementsRule> bpeRules = bpeList.getBPEEnhancementsRule();
        HashMap<String, Integer> objIndexMap = new HashMap<String, Integer>();
        for (BPEEnhancementsRule rule : bpeRules) {
            String key = seed + rule.getObjectTypeName() + rule.getOptVirusId();
            rule.setI(DeterministicIdWasher.getI(key, objIndexMap));
        }
    }

    public String resetTopLevelObjectIDs(TopLevelObject tObj, String domainId) {
        String objID = null;
        if (tObj instanceof NamedObject) {
            NamedObject namedObject = (NamedObject)((Object)tObj);
            objID = Utility.calculateHash(domainId + tObj.getObjectTypeName() + namedObject.getName());
        } else {
            objID = Utility.calculateHash(domainId + tObj.getObjectTypeName());
        }
        this.resetIdMap.put(tObj.getId(), objID);
        tObj.setId(objID);
        tObj.setI(Utility.calculateHash(objID + "_i"));
        HashMap<String, Integer> objIndexMap = new HashMap<String, Integer>();
        List children = (List)Cast.cast(tObj.getChildren());
        for (ConfigObject cObj : children) {
            this.resetChildrenIDs(objID, cObj, domainId, objIndexMap);
        }
        return objID;
    }

    public String resetTopLevelObjectIDs(TopLevelObject tObj, SemDomain domain) {
        return this.resetTopLevelObjectIDs(tObj, domain.getId());
    }

    private void resetChildrenIDs(String objID, ConfigObject cObj, String domainId, Map<String, Integer> objIndexMap) {
        if (cObj instanceof NamedObject) {
            NamedObject namedObject = (NamedObject)((Object)cObj);
            cObj.setI(DeterministicIdWasher.getI(objID + cObj.getObjectTypeName() + namedObject.getName(), objIndexMap));
        } else {
            cObj.setI(DeterministicIdWasher.getI(objID + cObj.getObjectTypeName(), objIndexMap));
        }
        if (cObj instanceof ObjReference) {
            ObjReference objRef = (ObjReference)cObj;
            String preTargetId = objRef.getTargetId();
            String targetType = objRef.getTargetType();
            String xpath = "//" + targetType + "[@Id=\"" + preTargetId + "\"]";
            try {
                TopLevelObject targetTopLevelObject = (TopLevelObject)XPathSchemaUtil.xpath((AbstractSchema)cObj, xpath);
                if (targetTopLevelObject != null) {
                    if (!targetTopLevelObject.isDirty()) {
                        String newId = this.resetTopLevelObjectIDs(targetTopLevelObject, domainId);
                        objRef.setTargetId(newId);
                        this.resetIdMap.put(preTargetId, newId);
                    }
                } else {
                    String resetId = this.resetIdMap.get(preTargetId);
                    if (resetId != null) {
                        objRef.setTargetId(resetId);
                    }
                }
            }
            catch (TransformerException e) {
                LoggerUtilities.logException(e);
            }
        }
        List children = (List)Cast.cast(cObj.getChildren());
        for (ConfigObject childConfigObj : children) {
            this.resetChildrenIDs(objID, childConfigObj, domainId, objIndexMap);
        }
    }

    public static void resetClientInstallationSettingsIDs(ClientInstallationSettings topObj, String seed) {
        String objID = Utility.calculateHash(seed + topObj.getObjectTypeName() + topObj.getName());
        topObj.setId(objID);
        topObj.setI(Utility.calculateHash(objID + "_i"));
        InstallationOption iOption = topObj.getInstallationOption();
        iOption.setI(Utility.calculateHash(objID + iOption.getObjectTypeName()));
        CommunicationOption cOption = topObj.getCommunicationOption();
        cOption.setI(Utility.calculateHash(objID + cOption.getObjectTypeName()));
    }

    public static void resetConsistantIDs(ConfigObject pObj, String seed) {
        String _i = Utility.calculateHash(seed + pObj.getClass().getName());
        pObj.setI(_i);
        List children = (List)Cast.cast(pObj.getChildren());
        int cnt = 0;
        for (ConfigObject cObj : children) {
            DeterministicIdWasher.resetConsistantIDs(cObj, _i + cnt++);
        }
    }

    public static void resetLuSesmContentCatalogIDs(LuSesmContentCatalog topObj) {
        List children = (List)Cast.cast(topObj.getChildren());
        for (ConfigObject cObj : children) {
            DeterministicIdWasher.resetLuSesmContentCatalogChildrenIDs(cObj);
        }
    }

    public static void resetConsistantIDs(TopLevelObject topObj, String seed) {
        String tId = Utility.calculateHash(seed + topObj.getClass().getName());
        try {
            Method method = topObj.getClass().getMethod("setId", String.class);
            method.invoke((Object)topObj, tId);
        }
        catch (SecurityException e) {
            LoggerUtilities.logException(e);
        }
        catch (NoSuchMethodException e) {
            LoggerUtilities.logException(e);
        }
        catch (IllegalArgumentException e) {
            LoggerUtilities.logException(e);
        }
        catch (IllegalAccessException e) {
            LoggerUtilities.logException(e);
        }
        catch (InvocationTargetException e) {
            LoggerUtilities.logException(e);
        }
        String _i = Utility.calculateHash(tId);
        topObj.setI(_i);
        List children = (List)Cast.cast(topObj.getChildren());
        int cnt = 0;
        for (ConfigObject cObj : children) {
            DeterministicIdWasher.resetConsistantIDs(cObj, _i + cnt++);
        }
    }

    private static void resetLuSesmContentCatalogChildrenIDs(ConfigObject cObj) {
        String parentKey;
        ClientDeltaSupport clientDeltaSupport;
        if (cObj instanceof LuContentCategoryGroup) {
            LuContentCategoryGroup contentCategoryGroup = (LuContentCategoryGroup)cObj;
            cObj.setI(Utility.calculateHash(contentCategoryGroup.getClass().getName() + contentCategoryGroup.getName()));
        } else if (cObj instanceof LocalizedStrings) {
            LocalizedStrings localizedStrings = (LocalizedStrings)cObj;
            cObj.setI(Utility.calculateHash(localizedStrings.getClass().getName() + localizedStrings.getParent().getClass().getName() + localizedStrings.getLocale()));
        } else if (cObj instanceof LuContentCategory) {
            LuContentCategory luContentCategory = (LuContentCategory)cObj;
            cObj.setI(Utility.calculateHash(luContentCategory.getClass().getName() + luContentCategory.getName()));
        } else if (cObj instanceof LuRegistration) {
            LuRegistration luRegistration = (LuRegistration)cObj;
            String childsMoniker = luRegistration.getLuServerRegistration().getMoniker();
            cObj.setI(Utility.calculateHash(luRegistration.getClass().getName() + childsMoniker));
        } else if (cObj instanceof LuServerRegistration) {
            LuServerRegistration luServerRegistration = (LuServerRegistration)cObj;
            cObj.setI(Utility.calculateHash(luServerRegistration.getClass().getName() + luServerRegistration.getMoniker()));
        } else if (cObj instanceof LuClientRegistration) {
            LuClientRegistration luClientRegistration = (LuClientRegistration)cObj;
            cObj.setI(Utility.calculateHash(luClientRegistration.getClass().getName() + luClientRegistration.getMoniker()));
        } else if (cObj instanceof ClientDeltaSupport) {
            cObj.setI(Utility.calculateHash(DeterministicIdWasher.getClientDeltaSupportKey((ClientDeltaSupport)cObj)));
        } else if (cObj instanceof DeltaParameters) {
            DeltaParameters deltaParameters = (DeltaParameters)cObj;
            clientDeltaSupport = (ClientDeltaSupport)deltaParameters.getParent();
            parentKey = DeterministicIdWasher.getClientDeltaSupportKey(clientDeltaSupport);
            cObj.setI(Utility.calculateHash(deltaParameters.getClass().getName() + parentKey));
        } else if (cObj instanceof DeltaOptions) {
            DeltaOptions deltaOptions = (DeltaOptions)cObj;
            clientDeltaSupport = (ClientDeltaSupport)deltaOptions.getParent();
            parentKey = DeterministicIdWasher.getClientDeltaSupportKey(clientDeltaSupport);
            cObj.setI(Utility.calculateHash(deltaOptions.getClass().getName() + parentKey));
        } else if (cObj instanceof DeltaParams) {
            cObj.setI(Utility.calculateHash(DeterministicIdWasher.getDeltaParamsKey((DeltaParams)cObj)));
        } else if (cObj instanceof CompressParams) {
            cObj.setI(Utility.calculateHash(DeterministicIdWasher.getCompressParamsKey((CompressParams)cObj)));
        } else if (cObj instanceof DecompressParams) {
            cObj.setI(Utility.calculateHash(DeterministicIdWasher.getDecompressParamsKey((DecompressParams)cObj)));
        } else if (cObj instanceof LuSupportLanguageList) {
            LuSupportLanguageList luSupportLanguageList = (LuSupportLanguageList)cObj;
            cObj.setI(Utility.calculateHash(luSupportLanguageList.getClass().getName()));
        } else if (cObj instanceof LuSupportLanguage) {
            LuSupportLanguage luSupportLanguage = (LuSupportLanguage)cObj;
            cObj.setI(Utility.calculateHash(luSupportLanguage.getClass().getName() + luSupportLanguage.getContent()));
        } else if (cObj instanceof LegacyMoniker) {
            LegacyMoniker legacyMoniker = (LegacyMoniker)cObj;
            cObj.setI(Utility.calculateHash(legacyMoniker.getClass().getName() + legacyMoniker.getMoniker()));
        }
        List children = (List)Cast.cast(cObj.getChildren());
        for (ConfigObject childConfigObj : children) {
            DeterministicIdWasher.resetLuSesmContentCatalogChildrenIDs(childConfigObj);
        }
    }

    private static String getClientDeltaSupportKey(ClientDeltaSupport clientDeltaSupport) {
        return clientDeltaSupport.getClass().getName() + ((LuClientRegistration)clientDeltaSupport.getParent()).getMoniker();
    }

    private static String getDeltaParamsKey(DeltaParams deltaParams) {
        ClientDeltaSupport clientDeltaSupport = (ClientDeltaSupport)deltaParams.getParent();
        String parentKey = DeterministicIdWasher.getClientDeltaSupportKey(clientDeltaSupport);
        return deltaParams.getClass().getName() + deltaParams.getType() + parentKey;
    }

    private static String getCompressParamsKey(CompressParams compressParams) {
        DeltaParams deltaParams = (DeltaParams)compressParams.getParent();
        String parentKey = DeterministicIdWasher.getDeltaParamsKey(deltaParams);
        return compressParams.getClass().getName() + parentKey;
    }

    private static String getDecompressParamsKey(DecompressParams decompressParams) {
        DeltaParams deltaParams = (DeltaParams)decompressParams.getParent();
        String parentKey = DeterministicIdWasher.getDeltaParamsKey(deltaParams);
        return decompressParams.getClass().getName() + parentKey;
    }

    public static void resetSoftwarePackageIDs(SoftwarePackage topObj) {
        DeterministicIdWasher.resetSoftwarePackageIDs(topObj, false);
    }

    public static void resetSoftwarePackageIDs(SoftwarePackage topObj, boolean isSecurityFix) {
        if (topObj == null) {
            return;
        }
        PackageLuInfo packageLuInfo = topObj.getPackageInfo().getOptPackageLuInfo();
        if (packageLuInfo == null) {
            return;
        }
        String objID = Utility.calculateHash(packageLuInfo.getClientMoniker() + (isSecurityFix ? packageLuInfo.getServerVersion() : packageLuInfo.getSequenceNumber()) + topObj.getClass().getName());
        topObj.setId(objID);
        topObj.setI(Utility.calculateHash(objID + "_i"));
        List children = (List)Cast.cast(topObj.getChildren());
        for (ConfigObject cObj : children) {
            DeterministicIdWasher.resetSoftwarePackageChildrenIDs(objID, cObj);
        }
    }

    private static void resetSoftwarePackageChildrenIDs(String spkgID, ConfigObject cObj) {
        String className;
        if (cObj instanceof PackageInfo) {
            PackageInfo pkgInfo = (PackageInfo)cObj;
            className = pkgInfo.getClass().getName();
            cObj.setI(Utility.calculateHash(spkgID + className));
            for (int i = 0; i < pkgInfo.getObjReferenceCount(); ++i) {
                ObjReference objRef = pkgInfo.getObjReference(i);
                if (objRef == null) continue;
                objRef.setI(Utility.calculateHash(spkgID + className + objRef.getTargetId()));
            }
        } else if (cObj instanceof PackageLuInfo) {
            PackageLuInfo luInfo = (PackageLuInfo)cObj;
            cObj.setI(Utility.calculateHash(spkgID + luInfo.getClass().getName() + luInfo.getServerMoniker()));
        } else if (cObj instanceof PackageLuFile) {
            PackageLuFile luFile = (PackageLuFile)cObj;
            cObj.setI(Utility.calculateHash(spkgID + luFile.getClass().getName() + luFile.getFileName().toUpperCase()));
        } else if (cObj instanceof InstallationOption) {
            InstallationOption installOption = (InstallationOption)cObj;
            cObj.setI(Utility.calculateHash(spkgID + installOption.getClass().getName()));
        } else if (cObj instanceof CommunicationOption) {
            CommunicationOption communicationOption = (CommunicationOption)cObj;
            className = communicationOption.getClass().getName();
            cObj.setI(Utility.calculateHash(spkgID + className));
            ObjReference objRef = communicationOption.getOptObjReference();
            if (objRef != null) {
                objRef.setI(Utility.calculateHash(spkgID + className + objRef.getTargetId()));
            }
        }
        List children = (List)Cast.cast(cObj.getChildren());
        for (ConfigObject childConfigObj : children) {
            DeterministicIdWasher.resetSoftwarePackageChildrenIDs(spkgID, childConfigObj);
        }
    }

    public static void resetPhysicalFileIDs(PhysicalFile topObj) {
        ObjReference objRef = topObj.getObjReference();
        String binaryFileID = "";
        if (objRef != null) {
            binaryFileID = objRef.getTargetId();
            objRef.setI(Utility.calculateHash(binaryFileID + "_i"));
        }
        String objID = Utility.calculateHash(binaryFileID + topObj.getClass().getName());
        topObj.setId(objID);
        topObj.setI(Utility.calculateHash(objID + "_i"));
    }
}

