/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.util;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.SchemaContainer;
import com.sygate.scm.common.configobject.schema.AdaptivePolicy;
import com.sygate.scm.common.configobject.schema.AdminDefinedScan;
import com.sygate.scm.common.configobject.schema.AvPolicy;
import com.sygate.scm.common.configobject.schema.FwFirewallPolicy;
import com.sygate.scm.common.configobject.schema.FwIdsLibrary;
import com.sygate.scm.common.configobject.schema.HiHostIntegrityPolicy;
import com.sygate.scm.common.configobject.schema.HidPolicy;
import com.sygate.scm.common.configobject.schema.IdsPolicy;
import com.sygate.scm.common.configobject.schema.LinuxAdminDefinedScan;
import com.sygate.scm.common.configobject.schema.LuContentPolicy;
import com.sygate.scm.common.configobject.schema.LuPolicy;
import com.sygate.scm.common.configobject.schema.MacAdminDefinedScan;
import com.sygate.scm.common.configobject.schema.MemPolicy;
import com.sygate.scm.common.configobject.schema.NtrPolicy;
import com.sygate.scm.common.configobject.schema.OpAppProtectionPolicy;
import com.sygate.scm.common.configobject.schema.PolicyOverride;
import com.sygate.scm.common.configobject.schema.SemLocationConfig;
import com.sygate.scm.common.exception.CommonException;
import com.sygate.scm.common.i18n.MessageResourcesFile;
import com.sygate.scm.hi.library.HiParm_EnforceAsw;
import com.sygate.scm.hi.library.HiParm_EnforceAv;
import com.sygate.scm.hi.library.HiParm_EnforceFw;
import com.sygate.scm.hi.library.HiParm_EnforcePatch;
import com.sygate.scm.hi.library.HiParm_EnforceServicePack;
import com.sygate.scm.hi.library.HiParm_Popup;
import com.sygate.scm.util.template.Template;
import com.sygate.scm.util.template.TemplateManager;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Vector;

public class DefaultSchemaObject {
    private static final MessageResourcesFile TEMPLATE_RES = new MessageResourcesFile("com.sygate.scm.util.template.template_displayname");
    private static final String DEFAULT_DESC = "";
    private final Map<String, AdminDefinedScan> avAdminDefinedScanMap = new HashMap<String, AdminDefinedScan>();
    private final Map<String, MacAdminDefinedScan> avMacintoshAdminDefinedScanMap = new HashMap<String, MacAdminDefinedScan>();
    private final Map<String, LinuxAdminDefinedScan> avLinuxAdminDefinedScanMap = new HashMap<String, LinuxAdminDefinedScan>();
    private SemLocationConfig semLocationConfig;
    private AvPolicy avPolicy;
    private LuPolicy luPolicy;
    private HidPolicy hidPolicy;
    private MemPolicy memPolicy;
    private NtrPolicy ntrPolicy;
    private LuContentPolicy luContentPolicy;
    private PolicyOverride policyOverride;
    private FwFirewallPolicy firewallPolicy;
    private HiHostIntegrityPolicy hostintegrityPolicy;
    private FwIdsLibrary idsLibrary;
    private OpAppProtectionPolicy osProtectionPolicy;
    private IdsPolicy idsPolicy;
    private AdaptivePolicy adaptivePolicy;
    private HiParm_EnforceAv enforceAv;
    private HiParm_EnforceServicePack enforceServicePack;
    private HiParm_EnforcePatch enforcePatch;
    private HiParm_EnforceFw enforceFw;
    private HiParm_EnforceAsw enforceAsw;
    private HiParm_Popup popup;

    public DefaultSchemaObject(String creator) throws CommonException {
        this.init(creator);
    }

    private void init(String adminName) throws CommonException {
        try {
            Template temp = TemplateManager.getDefaultSharedPolicyTemplate(false);
            SchemaContainer container = temp.getSchemaContainer();
            for (AbstractSchema abstractSchema : container.getChildren()) {
                SchemaContainer con = (SchemaContainer)abstractSchema;
                Vector<AbstractSchema> children = con.getChildren();
                assert (!children.isEmpty());
                ConfigObject conObj = (ConfigObject)children.get(0);
                this.initConfigObject(conObj, adminName);
                this.initPolicy(conObj, adminName);
                this.initAdminDefinedScanMap(conObj);
            }
        }
        catch (Exception exc) {
            throw new CommonException("DefaultSchemaObject init failed", exc);
        }
    }

    private void initConfigObject(ConfigObject conObj, String adminName) {
        if (conObj instanceof SemLocationConfig) {
            this.semLocationConfig = (SemLocationConfig)conObj;
            this.semLocationConfig.setOptDescription(DEFAULT_DESC);
        } else if (conObj instanceof HiParm_EnforceAv) {
            this.enforceAv = (HiParm_EnforceAv)conObj;
        } else if (conObj instanceof HiParm_EnforceServicePack) {
            this.enforceServicePack = (HiParm_EnforceServicePack)conObj;
        } else if (conObj instanceof HiParm_EnforcePatch) {
            this.enforcePatch = (HiParm_EnforcePatch)conObj;
        } else if (conObj instanceof HiParm_EnforceFw) {
            this.enforceFw = (HiParm_EnforceFw)conObj;
        } else if (conObj instanceof HiParm_EnforceAsw) {
            this.enforceAsw = (HiParm_EnforceAsw)conObj;
        } else if (conObj instanceof HiParm_Popup) {
            this.popup = (HiParm_Popup)conObj;
        } else if (conObj instanceof FwIdsLibrary) {
            this.idsLibrary = (FwIdsLibrary)conObj;
            this.idsLibrary.setOptCreator(adminName);
        }
    }

    private void initAdminDefinedScanMap(ConfigObject conObj) {
        if (conObj instanceof AdminDefinedScan) {
            AdminDefinedScan adminDefinedScan = (AdminDefinedScan)conObj;
            String objRef = adminDefinedScan.getId();
            this.avAdminDefinedScanMap.put(objRef, adminDefinedScan);
        } else if (conObj instanceof MacAdminDefinedScan) {
            MacAdminDefinedScan macAdminDefinedScan = (MacAdminDefinedScan)conObj;
            String objRef = macAdminDefinedScan.getId();
            this.avMacintoshAdminDefinedScanMap.put(objRef, macAdminDefinedScan);
        } else if (conObj instanceof LinuxAdminDefinedScan) {
            LinuxAdminDefinedScan adminDefinedScan = (LinuxAdminDefinedScan)conObj;
            String objRef = adminDefinedScan.getId();
            this.avLinuxAdminDefinedScanMap.put(objRef, adminDefinedScan);
        }
    }

    private void initPolicy(ConfigObject conObj, String adminName) {
        if (conObj instanceof FwFirewallPolicy) {
            Optional.ofNullable(this.firewallPolicy).ifPresentOrElse(v -> {}, () -> {
                this.firewallPolicy = (FwFirewallPolicy)conObj;
            });
            this.firewallPolicy.setOptCreator(adminName);
            this.firewallPolicy.setName(TEMPLATE_RES.getString("$$I18N.DefaultSPlcyTp.NEW.FIREWALL.POLICY$$"));
            this.firewallPolicy.setOptDescription(DEFAULT_DESC);
        } else if (conObj instanceof HiHostIntegrityPolicy) {
            this.hostintegrityPolicy = (HiHostIntegrityPolicy)conObj;
            this.hostintegrityPolicy.setOptCreator(adminName);
            this.hostintegrityPolicy.setName(TEMPLATE_RES.getString("$$I18N.DefaultSPlcyTp.NEW.HOST.INTEGRITY.POLICY$$"));
            this.hostintegrityPolicy.setOptDescription(DEFAULT_DESC);
        } else if (conObj instanceof OpAppProtectionPolicy) {
            this.osProtectionPolicy = (OpAppProtectionPolicy)conObj;
            this.osProtectionPolicy.setOptCreator(adminName);
            this.osProtectionPolicy.setName(TEMPLATE_RES.getString("$$I18N.DefaultSPlcyTp.NEW.OS.PROTECTION.POLICY$$"));
            this.osProtectionPolicy.setOptDescription(DEFAULT_DESC);
        } else if (conObj instanceof IdsPolicy) {
            this.idsPolicy = (IdsPolicy)conObj;
            this.idsPolicy.setOptCreator(adminName);
            this.idsPolicy.setName(TEMPLATE_RES.getString("$$I18N.DefaultSPlcyTp.NEW.IPS.LIBRARY$$"));
            this.idsPolicy.setOptDescription(DEFAULT_DESC);
        } else if (conObj instanceof HidPolicy) {
            this.hidPolicy = (HidPolicy)conObj;
            this.hidPolicy.setName(TEMPLATE_RES.getString("$$I18N.DefaultSPlcyTp.NEW.HID.POLICY$$"));
            this.hidPolicy.setOptDescription(DEFAULT_DESC);
        } else if (conObj instanceof MemPolicy) {
            this.memPolicy = (MemPolicy)conObj;
            this.memPolicy.setOptCreator(adminName);
            this.memPolicy.setName(TEMPLATE_RES.getString("$$I18n.DefaultSPlcyTp.NEW.MEM.POLICY$$"));
            this.memPolicy.setOptDescription(DEFAULT_DESC);
        } else if (conObj instanceof NtrPolicy) {
            this.ntrPolicy = (NtrPolicy)conObj;
            this.ntrPolicy.setOptCreator(adminName);
            this.ntrPolicy.setName(TEMPLATE_RES.getString("$$I18n.DefaultSPlcyTp.NEW.NTR.POLICY$$"));
            this.ntrPolicy.setOptDescription(DEFAULT_DESC);
        } else if (conObj instanceof LuPolicy) {
            this.luPolicy = (LuPolicy)conObj;
            this.luPolicy.setOptCreator(adminName);
            this.luPolicy.setName(TEMPLATE_RES.getString("$$I18N.DefaultSPlcyTp.NEW.LUP.POLICY$$"));
            this.luPolicy.setOptDescription(DEFAULT_DESC);
        } else if (conObj instanceof LuContentPolicy) {
            this.luContentPolicy = (LuContentPolicy)conObj;
            this.luContentPolicy.setOptCreator(adminName);
            this.luContentPolicy.setName(TEMPLATE_RES.getString("$$I18N.DefaultSPlcyTp.NEW.LUCP.POLICY$$"));
            this.luContentPolicy.setOptDescription(DEFAULT_DESC);
        } else if (conObj instanceof AvPolicy) {
            Optional.ofNullable(this.avPolicy).ifPresentOrElse(v -> {}, () -> {
                this.avPolicy = (AvPolicy)conObj;
            });
            this.avPolicy.setOptCreator(adminName);
            this.avPolicy.setName(TEMPLATE_RES.getString("$$I18N.DefaultSPlcyTp.NEW.AV.POLICY$$"));
            this.avPolicy.setOptDescription(DEFAULT_DESC);
        } else if (conObj instanceof PolicyOverride) {
            this.policyOverride = (PolicyOverride)conObj;
            this.policyOverride.setOptCreator(adminName);
            this.policyOverride.setName(TEMPLATE_RES.getString("$$I18N.DefaultSPlcyTp.NEW.POLICYOVERRIDE.POLICY$$"));
            this.policyOverride.setOptDescription(DEFAULT_DESC);
        } else if (conObj instanceof AdaptivePolicy) {
            this.adaptivePolicy = (AdaptivePolicy)conObj;
            this.adaptivePolicy.setOptCreator(adminName);
            this.adaptivePolicy.setName(TEMPLATE_RES.getString("$$I18N.DefaultSPlcyTp.NEW.ADAPTIVE.POLICY$$"));
            this.adaptivePolicy.setOptDescription(DEFAULT_DESC);
        }
    }

    public Map<String, AdminDefinedScan> getAvAdminDefinedScanMap() {
        HashMap<String, AdminDefinedScan> cloneMap = new HashMap<String, AdminDefinedScan>();
        this.avAdminDefinedScanMap.forEach((k, v) -> cloneMap.put((String)k, (AdminDefinedScan)v.clone()));
        return cloneMap;
    }

    public Map<String, MacAdminDefinedScan> getAvMacintoshAdminDefinedScanMap() {
        HashMap<String, MacAdminDefinedScan> cloneMap = new HashMap<String, MacAdminDefinedScan>();
        this.avMacintoshAdminDefinedScanMap.forEach((k, v) -> cloneMap.put((String)k, (MacAdminDefinedScan)v.clone()));
        return cloneMap;
    }

    public Map<String, LinuxAdminDefinedScan> getAvLinuxAdminDefinedScanMap() {
        HashMap<String, LinuxAdminDefinedScan> cloneMap = new HashMap<String, LinuxAdminDefinedScan>();
        this.avLinuxAdminDefinedScanMap.forEach((k, v) -> cloneMap.put((String)k, (LinuxAdminDefinedScan)v.clone()));
        return cloneMap;
    }

    public SemLocationConfig getDefaultSemLocationConfig() {
        return (SemLocationConfig)this.semLocationConfig.clone();
    }

    public FwFirewallPolicy getDefaultFirewallPolicy() {
        return (FwFirewallPolicy)this.firewallPolicy.clone();
    }

    public AvPolicy getDefaultAvPolicy() {
        return (AvPolicy)this.getClone(this.avPolicy);
    }

    public HidPolicy getDefaultHidPolicy() {
        return (HidPolicy)this.getClone(this.hidPolicy);
    }

    public MemPolicy getDefaultMemPolicy() {
        return (MemPolicy)this.getClone(this.memPolicy);
    }

    public NtrPolicy getDefaultNtrPolicy() {
        return (NtrPolicy)this.getClone(this.ntrPolicy);
    }

    public LuPolicy getDefaultLiveUpdatePolicy() {
        return (LuPolicy)this.getClone(this.luPolicy);
    }

    public LuContentPolicy getDefaultLiveUpdateContentPolicy() {
        return (LuContentPolicy)this.getClone(this.luContentPolicy);
    }

    public PolicyOverride getDefaultPolicyOverride() {
        return (PolicyOverride)this.getClone(this.policyOverride);
    }

    public HiHostIntegrityPolicy getDefaultHostIntegrityPolicy() {
        return (HiHostIntegrityPolicy)this.getClone(this.hostintegrityPolicy);
    }

    public AdaptivePolicy getDefaultAdaptivePolicy() {
        return (AdaptivePolicy)this.getClone(this.adaptivePolicy);
    }

    public HiParm_EnforceAv getEnforceAv() {
        return (HiParm_EnforceAv)this.getClone(this.enforceAv);
    }

    public HiParm_EnforceServicePack getEnforceServicePack() {
        return (HiParm_EnforceServicePack)this.getClone(this.enforceServicePack);
    }

    public HiParm_EnforcePatch getEnforcePatch() {
        return (HiParm_EnforcePatch)this.getClone(this.enforcePatch);
    }

    public HiParm_EnforceFw getEnforceFw() {
        return (HiParm_EnforceFw)this.getClone(this.enforceFw);
    }

    public HiParm_EnforceAsw getEnforceAsw() {
        return (HiParm_EnforceAsw)this.getClone(this.enforceAsw);
    }

    public HiParm_Popup getPopup() {
        return (HiParm_Popup)this.getClone(this.popup);
    }

    public FwIdsLibrary getDefaultFwIdsLibrary() {
        return (FwIdsLibrary)this.getClone(this.idsLibrary);
    }

    public OpAppProtectionPolicy getDefaultOSProtectionPolicy() {
        return (OpAppProtectionPolicy)this.getClone(this.osProtectionPolicy);
    }

    public IdsPolicy getIdsPolicy() {
        return (IdsPolicy)this.getClone(this.idsPolicy);
    }

    ConfigObject getClone(ConfigObject obj) {
        return obj == null ? null : (ConfigObject)obj.clone();
    }
}

